/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.api;

import java.util.Comparator;

public class EnergyStack
implements Comparable<EnergyStack> {
    public static final String VANILLA_SMELTING_ENERGY_NAME = "vanillaFuelValueUnits";
    public static final int VANILLA_SMELTING_ENERGY_THRESHOLD = 200;
    public String energyName;
    public int stackSize;
    public static Comparator<EnergyStack> comparator = new Comparator<EnergyStack>(){

        @Override
        public int compare(EnergyStack energyStack1, EnergyStack energyStack2) {
            if (energyStack1 != null) {
                if (energyStack2 != null) {
                    if (energyStack1.energyName.equalsIgnoreCase(energyStack2.energyName)) {
                        return energyStack1.stackSize - energyStack2.stackSize;
                    }
                    return energyStack1.energyName.compareToIgnoreCase(energyStack2.energyName);
                }
                return -1;
            }
            if (energyStack2 != null) {
                return 1;
            }
            return 0;
        }
    };

    public EnergyStack(String energyName, int stackSize) {
        this.energyName = energyName;
        this.stackSize = stackSize;
    }

    public EnergyStack(String energyName) {
        this(energyName, 1);
    }

    public String toString() {
        return String.format("%dxenergyStack.%s", this.stackSize, this.energyName);
    }

    public boolean equals(Object object) {
        return object instanceof EnergyStack && this.compareTo((EnergyStack)object) == 0;
    }

    public static boolean compareEnergyNames(EnergyStack energyStack1, EnergyStack energyStack2) {
        if (energyStack1 != null && energyStack2 != null && energyStack1.energyName != null && energyStack2.energyName != null) {
            return energyStack1.energyName.equalsIgnoreCase(energyStack2.energyName);
        }
        return false;
    }

    @Override
    public int compareTo(EnergyStack energyStack) {
        return comparator.compare(this, energyStack);
    }

    public static int compare(EnergyStack energyStack1, EnergyStack energyStack2) {
        return comparator.compare(energyStack1, energyStack2);
    }
}

