/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.api;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.pahimar.ee3.helper.LogHelper;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreStack
implements Comparable<OreStack> {
    private static final Gson gsonSerializer = new Gson();
    private static final int ORE_DICTIONARY_NOT_FOUND = -1;
    public String oreName;
    public int stackSize;
    public static Comparator<OreStack> comparator = new Comparator<OreStack>(){

        @Override
        public int compare(OreStack oreStack1, OreStack oreStack2) {
            if (oreStack1 != null) {
                if (oreStack2 != null) {
                    if (oreStack1.oreName.equalsIgnoreCase(oreStack2.oreName)) {
                        return oreStack1.stackSize - oreStack2.stackSize;
                    }
                    return oreStack1.oreName.compareToIgnoreCase(oreStack2.oreName);
                }
                return -1;
            }
            if (oreStack2 != null) {
                return 1;
            }
            return 0;
        }
    };

    public OreStack(String oreName, int stackSize) {
        this.oreName = oreName;
        this.stackSize = stackSize;
    }

    public OreStack(String oreName) {
        this(oreName, 1);
    }

    public OreStack(ItemStack itemStack) {
        this(OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemStack)), itemStack.field_77994_a);
    }

    public String toString() {
        return String.format("%sxoreStack.%s", this.stackSize, this.oreName);
    }

    public boolean equals(Object object) {
        return object instanceof OreStack && comparator.compare(this, (OreStack)object) == 0;
    }

    public static boolean compareOreNames(OreStack oreStack1, OreStack oreStack2) {
        if (oreStack1 != null && oreStack2 != null && oreStack1.oreName != null && oreStack2.oreName != null) {
            return oreStack1.oreName.equalsIgnoreCase(oreStack2.oreName);
        }
        return false;
    }

    @Override
    public int compareTo(OreStack oreStack) {
        return comparator.compare(this, oreStack);
    }

    public static OreStack createFromJson(String jsonOreStack) {
        try {
            return (OreStack)gsonSerializer.fromJson(jsonOreStack, OreStack.class);
        }
        catch (JsonSyntaxException exception) {
            LogHelper.severe(exception.getMessage());
        }
        catch (JsonParseException exception) {
            LogHelper.severe(exception.getMessage());
        }
        return null;
    }

    public String toJson() {
        return gsonSerializer.toJson((Object)this);
    }

    public static OreStack getOreStackFromList(Object ... objects) {
        return OreStack.getOreStackFromList(Arrays.asList(objects));
    }

    public static OreStack getOreStackFromList(List<?> objectList) {
        for (Object listElement : objectList) {
            ItemStack stack;
            if (!(listElement instanceof ItemStack) || OreDictionary.getOreID((ItemStack)(stack = (ItemStack)listElement)) == -1) continue;
            return new OreStack(stack);
        }
        return null;
    }

    public static int compare(OreStack oreStack1, OreStack oreStack2) {
        return comparator.compare(oreStack1, oreStack2);
    }
}

