/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.pahimar.ee3.api.WrappedStack;
import com.pahimar.ee3.helper.LogHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class RecipeMapping
implements JsonSerializer<RecipeMapping>,
JsonDeserializer<RecipeMapping> {
    private static final Gson gsonSerializer = new GsonBuilder().registerTypeAdapter(RecipeMapping.class, (Object)new RecipeMapping()).create();
    public final WrappedStack outputWrappedStack;
    public final List<WrappedStack> inputWrappedStacks;

    private RecipeMapping() {
        this.outputWrappedStack = null;
        this.inputWrappedStacks = null;
    }

    public RecipeMapping(Object outputStack, List<?> inputStacks) {
        this.outputWrappedStack = new WrappedStack(outputStack);
        ArrayList<WrappedStack> wrappedStacks = new ArrayList<WrappedStack>();
        for (Object object : inputStacks) {
            WrappedStack wrappedStack = new WrappedStack(object);
            if (wrappedStack.getWrappedStack() != null) {
                wrappedStacks.add(wrappedStack);
                continue;
            }
            LogHelper.warning(String.format("RecipeMapping with output: %s is containing a null WrappedStack input that will not be added to the input list.", this.outputWrappedStack.toString()));
        }
        this.inputWrappedStacks = wrappedStacks;
    }

    public static RecipeMapping createFromJson(String jsonRecipeMapping) {
        try {
            return (RecipeMapping)gsonSerializer.fromJson(jsonRecipeMapping, RecipeMapping.class);
        }
        catch (JsonSyntaxException exception) {
            LogHelper.severe(exception.getMessage());
        }
        catch (JsonParseException exception) {
            LogHelper.severe(exception.getMessage());
        }
        return null;
    }

    public String toJson() {
        return gsonSerializer.toJson((Object)this);
    }

    public RecipeMapping deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (!jsonElement.isJsonPrimitive()) {
            JsonObject jsonRecipeMapping = (JsonObject)jsonElement;
            WrappedStack outputStack = null;
            ArrayList<WrappedStack> inputStacks = new ArrayList<WrappedStack>();
            if (jsonRecipeMapping.get("outputWrappedStack") != null) {
                outputStack = new WrappedStack().deserialize((JsonElement)jsonRecipeMapping.get("outputWrappedStack").getAsJsonObject(), (Type)((Object)WrappedStack.class), context);
            }
            if (jsonRecipeMapping.get("inputWrappedStacks") != null) {
                JsonArray jsonInputStacks = jsonRecipeMapping.get("inputWrappedStacks").getAsJsonArray();
                for (int i = 0; i < jsonInputStacks.size(); ++i) {
                    WrappedStack inputStack = new WrappedStack().deserialize((JsonElement)jsonInputStacks.get(i).getAsJsonObject(), (Type)((Object)WrappedStack.class), context);
                    inputStacks.add(inputStack);
                }
            }
            return new RecipeMapping(outputStack, inputStacks);
        }
        return null;
    }

    public JsonElement serialize(RecipeMapping recipeMapping, Type type, JsonSerializationContext context) {
        JsonObject jsonRecipeMapping = new JsonObject();
        Gson gsonWrappedStack = new Gson();
        JsonArray jsonArray = new JsonArray();
        for (WrappedStack inputStack : recipeMapping.inputWrappedStacks) {
            jsonArray.add(gsonWrappedStack.toJsonTree((Object)inputStack, WrappedStack.class));
        }
        jsonRecipeMapping.add("outputWrappedStack", gsonWrappedStack.toJsonTree((Object)recipeMapping.outputWrappedStack, WrappedStack.class));
        jsonRecipeMapping.add("inputWrappedStacks", (JsonElement)jsonArray);
        return jsonRecipeMapping;
    }

    public String toString() {
        return String.format("RecipeMapping[Output: %s, Input: %s]", this.outputWrappedStack, this.inputWrappedStacks);
    }
}

