/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.pahimar.ee3.api.EnergyStack;
import com.pahimar.ee3.api.JsonItemStack;
import com.pahimar.ee3.api.OreStack;
import com.pahimar.ee3.helper.FluidHelper;
import com.pahimar.ee3.helper.ItemHelper;
import com.pahimar.ee3.helper.LogHelper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class WrappedStack
implements Comparable<WrappedStack>,
JsonDeserializer<WrappedStack>,
JsonSerializer<WrappedStack> {
    private static final Gson gsonSerializer = new GsonBuilder().registerTypeAdapter(WrappedStack.class, (Object)new WrappedStack()).create();
    private final String className;
    private int stackSize;
    private final Object wrappedStack;
    public static Comparator<WrappedStack> comparator = new Comparator<WrappedStack>(){

        @Override
        public int compare(WrappedStack wrappedStack1, WrappedStack wrappedStack2) {
            if (wrappedStack1.wrappedStack instanceof ItemStack) {
                if (wrappedStack2.wrappedStack instanceof ItemStack) {
                    return ItemHelper.compare((ItemStack)wrappedStack1.wrappedStack, (ItemStack)wrappedStack2.wrappedStack);
                }
                return 1;
            }
            if (wrappedStack1.wrappedStack instanceof OreStack) {
                if (wrappedStack2.wrappedStack instanceof ItemStack) {
                    return -1;
                }
                if (wrappedStack2.wrappedStack instanceof OreStack) {
                    return OreStack.compare((OreStack)wrappedStack1.wrappedStack, (OreStack)wrappedStack2.wrappedStack);
                }
                return 1;
            }
            if (wrappedStack1.wrappedStack instanceof EnergyStack) {
                if (wrappedStack2.wrappedStack instanceof ItemStack || wrappedStack2.wrappedStack instanceof OreStack) {
                    return -1;
                }
                if (wrappedStack2.wrappedStack instanceof EnergyStack) {
                    return EnergyStack.compare((EnergyStack)wrappedStack1.wrappedStack, (EnergyStack)wrappedStack2.wrappedStack);
                }
                return 1;
            }
            if (wrappedStack1.wrappedStack instanceof FluidStack) {
                if (wrappedStack2.wrappedStack instanceof ItemStack || wrappedStack2.wrappedStack instanceof OreStack || wrappedStack2.wrappedStack instanceof EnergyStack) {
                    return -1;
                }
                if (wrappedStack2.wrappedStack instanceof FluidStack) {
                    return FluidHelper.compare((FluidStack)wrappedStack1.wrappedStack, (FluidStack)wrappedStack2.wrappedStack);
                }
                return 1;
            }
            if (wrappedStack1.wrappedStack == null) {
                if (wrappedStack2.wrappedStack != null) {
                    return -1;
                }
                return 0;
            }
            return 0;
        }
    };

    public WrappedStack() {
        this.className = null;
        this.stackSize = -1;
        this.wrappedStack = null;
    }

    public WrappedStack(Object object) {
        if (object instanceof Item) {
            object = new ItemStack((Item)object);
        } else if (object instanceof Block) {
            object = new ItemStack((Block)object);
        } else if (object instanceof Fluid) {
            object = new FluidStack((Fluid)object, 1000);
        }
        if (object instanceof ItemStack) {
            ItemStack itemStack = ((ItemStack)object).func_77946_l();
            this.className = ItemStack.class.getSimpleName();
            this.stackSize = itemStack.field_77994_a;
            itemStack.field_77994_a = 1;
            this.wrappedStack = itemStack;
        } else if (object instanceof OreStack) {
            OreStack oreStack = (OreStack)object;
            this.className = OreStack.class.getSimpleName();
            this.stackSize = oreStack.stackSize;
            oreStack.stackSize = 1;
            this.wrappedStack = oreStack;
        } else if (object instanceof ArrayList) {
            ArrayList objectList = (ArrayList)object;
            OreStack possibleOreStack = OreStack.getOreStackFromList(objectList);
            if (possibleOreStack != null) {
                this.className = OreStack.class.getSimpleName();
                this.stackSize = possibleOreStack.stackSize;
                possibleOreStack.stackSize = 1;
                this.wrappedStack = possibleOreStack;
            } else {
                this.stackSize = -1;
                this.className = null;
                this.wrappedStack = null;
            }
        } else if (object instanceof EnergyStack) {
            EnergyStack energyStack = (EnergyStack)object;
            this.className = EnergyStack.class.getSimpleName();
            this.stackSize = energyStack.stackSize;
            energyStack.stackSize = 1;
            this.wrappedStack = energyStack;
        } else if (object instanceof FluidStack) {
            FluidStack fluidStack = ((FluidStack)object).copy();
            this.className = FluidStack.class.getSimpleName();
            this.stackSize = fluidStack.amount;
            fluidStack.amount = 1;
            this.wrappedStack = fluidStack;
        } else if (object instanceof WrappedStack) {
            WrappedStack wrappedStackObject = (WrappedStack)object;
            if (wrappedStackObject.getWrappedStack() != null) {
                this.className = wrappedStackObject.wrappedStack.getClass().getSimpleName();
                this.stackSize = wrappedStackObject.stackSize;
                this.wrappedStack = wrappedStackObject.wrappedStack;
            } else {
                this.className = null;
                this.stackSize = -1;
                this.wrappedStack = null;
            }
        } else if (object instanceof String) {
            WrappedStack wrappedStack = WrappedStack.createFromJson((String)object);
            if (wrappedStack != null && wrappedStack.getWrappedStack() != null) {
                this.className = wrappedStack.getWrappedStack().getClass().getSimpleName();
                this.stackSize = wrappedStack.stackSize;
                this.wrappedStack = wrappedStack.wrappedStack;
            } else {
                this.className = null;
                this.stackSize = -1;
                this.wrappedStack = null;
            }
        } else {
            this.className = null;
            this.stackSize = -1;
            this.wrappedStack = null;
        }
    }

    public WrappedStack(Object object, int stackSize) {
        if (object instanceof Item) {
            object = new ItemStack((Item)object);
        } else if (object instanceof Block) {
            object = new ItemStack((Block)object);
        } else if (object instanceof Fluid) {
            object = new FluidStack((Fluid)object, 1000);
        }
        if (object instanceof ItemStack) {
            ItemStack itemStack = ((ItemStack)object).func_77946_l();
            this.className = ItemStack.class.getSimpleName();
            this.stackSize = stackSize;
            itemStack.field_77994_a = 1;
            this.wrappedStack = itemStack;
        } else if (object instanceof OreStack) {
            OreStack oreStack = (OreStack)object;
            this.className = OreStack.class.getSimpleName();
            this.stackSize = stackSize;
            oreStack.stackSize = 1;
            this.wrappedStack = oreStack;
        } else if (object instanceof ArrayList) {
            ArrayList objectList = (ArrayList)object;
            OreStack possibleOreStack = OreStack.getOreStackFromList(objectList);
            if (possibleOreStack != null) {
                this.className = OreStack.class.getSimpleName();
                this.stackSize = stackSize;
                possibleOreStack.stackSize = 1;
                this.wrappedStack = possibleOreStack;
            } else {
                this.stackSize = -1;
                this.className = null;
                this.wrappedStack = null;
            }
        } else if (object instanceof EnergyStack) {
            EnergyStack energyStack = (EnergyStack)object;
            this.className = EnergyStack.class.getSimpleName();
            this.stackSize = stackSize;
            energyStack.stackSize = 1;
            this.wrappedStack = energyStack;
        } else if (object instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)object;
            this.className = FluidStack.class.getSimpleName();
            this.stackSize = stackSize;
            fluidStack.amount = 1;
            this.wrappedStack = fluidStack;
        } else if (object instanceof WrappedStack) {
            WrappedStack wrappedStackObject = (WrappedStack)object;
            if (wrappedStackObject.getWrappedStack() != null) {
                this.className = wrappedStackObject.wrappedStack.getClass().getSimpleName();
                this.stackSize = stackSize;
                this.wrappedStack = wrappedStackObject.wrappedStack;
            } else {
                this.className = null;
                this.stackSize = -1;
                this.wrappedStack = null;
            }
        } else if (object instanceof String) {
            WrappedStack wrappedStack = WrappedStack.createFromJson((String)object);
            if (wrappedStack != null && wrappedStack.getWrappedStack() != null) {
                this.className = wrappedStack.wrappedStack.getClass().getSimpleName();
                this.stackSize = stackSize;
                this.wrappedStack = wrappedStack.wrappedStack;
            } else {
                this.className = null;
                this.stackSize = -1;
                this.wrappedStack = null;
            }
        } else {
            this.className = null;
            this.stackSize = -1;
            this.wrappedStack = null;
        }
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void setStackSize(int stackSize) {
        this.stackSize = stackSize;
    }

    public Object getWrappedStack() {
        return this.wrappedStack;
    }

    public static WrappedStack createFromJson(String jsonWrappedObject) throws JsonParseException {
        try {
            return (WrappedStack)gsonSerializer.fromJson(jsonWrappedObject, WrappedStack.class);
        }
        catch (JsonSyntaxException exception) {
            LogHelper.severe(exception.getMessage());
        }
        catch (JsonParseException exception) {
            LogHelper.severe(exception.getMessage());
        }
        return null;
    }

    public String toJson() {
        return gsonSerializer.toJson((Object)this);
    }

    @Override
    public int compareTo(WrappedStack wrappedStack) {
        return comparator.compare(this, wrappedStack);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 37 * hashCode + this.stackSize;
        if (this.wrappedStack instanceof ItemStack) {
            hashCode = 37 * hashCode + ((ItemStack)this.wrappedStack).field_77993_c;
            hashCode = 37 * hashCode + ((ItemStack)this.wrappedStack).func_77960_j();
            if (((ItemStack)this.wrappedStack).func_77978_p() != null) {
                hashCode = 37 * hashCode + ((ItemStack)this.wrappedStack).func_77978_p().hashCode();
            }
        } else if (this.wrappedStack instanceof OreStack) {
            if (((OreStack)this.wrappedStack).oreName != null) {
                hashCode = 37 * hashCode + ((OreStack)this.wrappedStack).oreName.hashCode();
            }
        } else if (this.wrappedStack instanceof EnergyStack) {
            if (((EnergyStack)this.wrappedStack).energyName != null) {
                hashCode = 37 * hashCode + ((EnergyStack)this.wrappedStack).energyName.hashCode();
            }
        } else if (this.wrappedStack instanceof FluidStack) {
            hashCode = 37 * hashCode + this.wrappedStack.hashCode();
            if (((FluidStack)this.wrappedStack).tag != null) {
                hashCode = 37 * hashCode + ((FluidStack)this.wrappedStack).tag.hashCode();
            }
        }
        return hashCode;
    }

    public boolean equals(Object object) {
        return object instanceof WrappedStack && this.compareTo((WrappedStack)object) == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.wrappedStack instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)this.wrappedStack;
            try {
                stringBuilder.append(String.format("%sxitemStack[%s:%s:%s:%s]", this.stackSize, itemStack.field_77993_c, itemStack.func_77960_j(), itemStack.func_77977_a(), itemStack.func_77973_b().getClass().getCanonicalName()));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        } else if (this.wrappedStack instanceof OreStack) {
            OreStack oreStack = (OreStack)this.wrappedStack;
            stringBuilder.append(String.format("%sxoreStack.%s", this.stackSize, oreStack.oreName));
        } else if (this.wrappedStack instanceof EnergyStack) {
            EnergyStack energyStack = (EnergyStack)this.wrappedStack;
            stringBuilder.append(String.format("%sxenergyStack.%s", this.stackSize, energyStack.energyName));
        } else if (this.wrappedStack instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)this.wrappedStack;
            stringBuilder.append(String.format("%sxfluidStack.%s", this.stackSize, fluidStack.getFluid().getName()));
        } else {
            stringBuilder.append("null");
        }
        return stringBuilder.toString();
    }

    public static boolean canBeWrapped(Object object) {
        if (object instanceof WrappedStack) {
            return true;
        }
        if (object instanceof Item || object instanceof Block || object instanceof ItemStack) {
            return true;
        }
        if (object instanceof OreStack) {
            return true;
        }
        if (object instanceof List) {
            if (OreStack.getOreStackFromList((List)object) != null) {
                return true;
            }
        } else {
            if (object instanceof EnergyStack) {
                return true;
            }
            if (object instanceof Fluid || object instanceof FluidStack) {
                return true;
            }
        }
        return false;
    }

    public JsonElement serialize(WrappedStack wrappedStack, Type type, JsonSerializationContext context) {
        JsonObject jsonWrappedStack = new JsonObject();
        Gson gsonWrappedStack = new Gson();
        jsonWrappedStack.addProperty("className", wrappedStack.className);
        jsonWrappedStack.addProperty("stackSize", (Number)wrappedStack.stackSize);
        if (wrappedStack.wrappedStack instanceof ItemStack) {
            JsonItemStack jsonItemStack = new JsonItemStack();
            jsonItemStack.itemID = ((ItemStack)wrappedStack.wrappedStack).field_77993_c;
            jsonItemStack.itemDamage = ((ItemStack)wrappedStack.wrappedStack).func_77960_j();
            jsonItemStack.stackSize = ((ItemStack)wrappedStack.wrappedStack).field_77994_a;
            if (((ItemStack)wrappedStack.wrappedStack).field_77990_d != null) {
                try {
                    jsonItemStack.compressedStackTagCompound = CompressedStreamTools.func_74798_a((NBTTagCompound)((ItemStack)wrappedStack.wrappedStack).field_77990_d);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            jsonWrappedStack.add("wrappedStack", gsonWrappedStack.toJsonTree((Object)jsonItemStack, JsonItemStack.class));
        } else if (wrappedStack.wrappedStack instanceof OreStack) {
            jsonWrappedStack.add("wrappedStack", gsonWrappedStack.toJsonTree(wrappedStack.wrappedStack, OreStack.class));
        } else if (wrappedStack.wrappedStack instanceof EnergyStack) {
            jsonWrappedStack.add("wrappedStack", gsonWrappedStack.toJsonTree(wrappedStack.wrappedStack, EnergyStack.class));
        } else if (wrappedStack.wrappedStack instanceof FluidStack) {
            jsonWrappedStack.add("wrappedStack", gsonWrappedStack.toJsonTree(wrappedStack.wrappedStack, FluidStack.class));
        }
        return jsonWrappedStack;
    }

    public WrappedStack deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (!jsonElement.isJsonPrimitive()) {
            JsonObject jsonWrappedStack = (JsonObject)jsonElement;
            int stackSize = -1;
            String className = null;
            Comparable<OreStack> stackObject = null;
            if (jsonWrappedStack.get("className") != null) {
                className = jsonWrappedStack.get("className").getAsString();
            }
            if (jsonWrappedStack.get("stackSize") != null) {
                stackSize = jsonWrappedStack.get("stackSize").getAsInt();
            }
            if (jsonWrappedStack.get("wrappedStack") != null && !jsonWrappedStack.get("wrappedStack").isJsonPrimitive() && className != null) {
                if (className.equalsIgnoreCase(ItemStack.class.getSimpleName())) {
                    JsonItemStack jsonItemStack = (JsonItemStack)gsonSerializer.fromJson(jsonWrappedStack.get("wrappedStack"), JsonItemStack.class);
                    OreStack itemStack = null;
                    if (stackSize > 0) {
                        itemStack = new ItemStack(jsonItemStack.itemID, stackSize, jsonItemStack.itemDamage);
                        if (jsonItemStack.compressedStackTagCompound != null) {
                            try {
                                ((ItemStack)itemStack).field_77990_d = CompressedStreamTools.func_74792_a((byte[])jsonItemStack.compressedStackTagCompound);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    stackObject = itemStack;
                } else if (className.equalsIgnoreCase(OreStack.class.getSimpleName())) {
                    OreStack oreStack = (OreStack)gsonSerializer.fromJson(jsonWrappedStack.get("wrappedStack"), OreStack.class);
                    if (stackSize > 0) {
                        oreStack.stackSize = stackSize;
                    }
                    stackObject = oreStack;
                } else if (className.equalsIgnoreCase(EnergyStack.class.getSimpleName())) {
                    EnergyStack energyStack = (EnergyStack)gsonSerializer.fromJson(jsonWrappedStack.get("wrappedStack"), EnergyStack.class);
                    if (stackSize > 0) {
                        energyStack.stackSize = stackSize;
                    }
                    stackObject = energyStack;
                } else if (className.equalsIgnoreCase(FluidStack.class.getSimpleName())) {
                    FluidStack fluidStack = (FluidStack)gsonSerializer.fromJson(jsonWrappedStack.get("wrappedStack"), FluidStack.class);
                    if (stackSize > 0) {
                        fluidStack.amount = stackSize;
                    }
                    stackObject = fluidStack;
                }
            }
            if (stackObject != null) {
                return new WrappedStack(stackObject);
            }
            throw new JsonParseException(String.format("Unable to parse a wrappable stack object from the provided json: %s", jsonElement.toString()));
        }
        throw new JsonParseException(String.format("Unable to parse a wrappable stack object from the provided json: %s", jsonElement.toString()));
    }
}

