/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.block;

import com.pahimar.ee3.lib.Strings;
import com.pahimar.ee3.tileentity.TileEE;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockEE
extends Block {
    public BlockEE(int id) {
        this(id, Material.field_76246_e);
    }

    public BlockEE(int id, Material material) {
        super(id, material);
    }

    public String func_71917_a() {
        return String.format("tile.%s%s", Strings.RESOURCE_PREFIX, this.getUnwrappedUnlocalizedName(super.func_71917_a()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.field_94336_cN = iconRegister.func_94245_a(String.format("%s", this.getUnwrappedUnlocalizedName(this.func_71917_a())));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    public void func_71852_a(World world, int x, int y, int z, int id, int meta) {
        this.dropInventory(world, x, y, z);
        super.func_71852_a(world, x, y, z, id, meta);
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        if (world.func_72796_p(x, y, z) instanceof TileEE) {
            int direction = 0;
            int facing = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            if (facing == 0) {
                direction = ForgeDirection.NORTH.ordinal();
            } else if (facing == 1) {
                direction = ForgeDirection.EAST.ordinal();
            } else if (facing == 2) {
                direction = ForgeDirection.SOUTH.ordinal();
            } else if (facing == 3) {
                direction = ForgeDirection.WEST.ordinal();
            }
            if (itemStack.func_82837_s()) {
                ((TileEE)world.func_72796_p(x, y, z)).setCustomName(itemStack.func_82833_r());
            }
            ((TileEE)world.func_72796_p(x, y, z)).setOrientation(direction);
        }
    }

    protected void dropInventory(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            Random rand = new Random();
            float dX = rand.nextFloat() * 0.8f + 0.1f;
            float dY = rand.nextFloat() * 0.8f + 0.1f;
            float dZ = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + dX), (double)((float)y + dY), (double)((float)z + dZ), new ItemStack(itemStack.field_77993_c, itemStack.field_77994_a, itemStack.func_77960_j()));
            if (itemStack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            itemStack.field_77994_a = 0;
        }
    }
}

