/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.client.renderer.tileentity;

import com.pahimar.ee3.client.model.ModelAludel;
import com.pahimar.ee3.lib.Textures;
import com.pahimar.ee3.tileentity.TileAludel;
import com.pahimar.ee3.tileentity.TileGlassBell;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityAludelRenderer
extends TileEntitySpecialRenderer {
    private final ModelAludel modelAludel = new ModelAludel();
    private final RenderItem customRenderItem = new RenderItem(){

        public boolean shouldBob() {
            return false;
        }
    };

    public TileEntityAludelRenderer() {
        this.customRenderItem.func_76976_a(RenderManager.field_78727_a);
    }

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float tick) {
        if (tileEntity instanceof TileAludel) {
            TileAludel tileAludel = (TileAludel)tileEntity;
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            this.scaleTranslateRotate(x, y, z, tileAludel.getOrientation());
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Textures.MODEL_ALUDEL);
            this.modelAludel.render();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            TileEntity tileGlassBell = tileAludel.field_70331_k.func_72796_p(tileAludel.field_70329_l, tileAludel.field_70330_m + 1, tileAludel.field_70327_n);
            if (tileGlassBell instanceof TileGlassBell && tileAludel.outputItemStack != null) {
                float scaleFactor = this.getGhostItemScaleFactor(tileAludel.outputItemStack);
                float rotationAngle = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
                EntityItem ghostEntityItem = new EntityItem(tileAludel.field_70331_k);
                ghostEntityItem.field_70290_d = 0.0f;
                ghostEntityItem.func_92058_a(tileAludel.outputItemStack);
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.25f), (float)((float)z + 0.5f));
                GL11.glScalef((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
                GL11.glRotatef((float)rotationAngle, (float)0.0f, (float)1.0f, (float)0.0f);
                this.customRenderItem.func_77014_a(ghostEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            }
            GL11.glPopMatrix();
            GL11.glEnable((int)2896);
        }
    }

    private void scaleTranslateRotate(double x, double y, double z, ForgeDirection orientation) {
        if (orientation == ForgeDirection.NORTH) {
            GL11.glTranslated((double)(x + 1.0), (double)y, (double)z);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == ForgeDirection.EAST) {
            GL11.glTranslated((double)(x + 1.0), (double)y, (double)(z + 1.0));
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == ForgeDirection.SOUTH) {
            GL11.glTranslated((double)x, (double)y, (double)(z + 1.0));
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == ForgeDirection.WEST) {
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private float getGhostItemScaleFactor(ItemStack itemStack) {
        float scaleFactor = 1.0f;
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof ItemBlock) {
                switch (this.customRenderItem.getMiniBlockCount(itemStack)) {
                    case 1: {
                        return 0.9f;
                    }
                    case 2: {
                        return 0.9f;
                    }
                    case 3: {
                        return 0.9f;
                    }
                    case 4: {
                        return 0.9f;
                    }
                    case 5: {
                        return 0.8f;
                    }
                }
                return 0.9f;
            }
            switch (this.customRenderItem.getMiniItemCount(itemStack)) {
                case 1: {
                    return 0.65f;
                }
                case 2: {
                    return 0.65f;
                }
                case 3: {
                    return 0.65f;
                }
                case 4: {
                    return 0.65f;
                }
            }
            return 0.65f;
        }
        return scaleFactor;
    }
}

