/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.command;

import com.pahimar.ee3.configuration.ConfigurationSettings;
import com.pahimar.ee3.configuration.GeneralConfiguration;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatMessageComponent;

public class CommandOverlay {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void processCommand(ICommandSender commandSender, String[] args) {
        if (args.length <= 0) throw new WrongUsageException("ee3 overlay [ on | off | position | scale | opacity ]", new Object[0]);
        String subCommand = args[0];
        if (subCommand.equalsIgnoreCase("on")) {
            CommandOverlay.processOnCommand(commandSender);
            return;
        } else if (subCommand.equalsIgnoreCase("off")) {
            CommandOverlay.processOffCommand(commandSender);
            return;
        } else if (subCommand.equalsIgnoreCase("opacity")) {
            CommandOverlay.processOpacityCommand(commandSender, args);
            return;
        } else if (subCommand.equalsIgnoreCase("scale")) {
            CommandOverlay.processScaleCommand(commandSender, args);
            return;
        } else {
            if (!subCommand.equalsIgnoreCase("position")) throw new WrongUsageException("ee3 overlay [ on | off | position | scale | opacity ]", new Object[0]);
            CommandOverlay.processPositionCommand(commandSender, args);
        }
    }

    private static void processOnCommand(ICommandSender commandSender) {
        ConfigurationSettings.ENABLE_OVERLAY_WORLD_TRANSMUTATION = true;
        GeneralConfiguration.set("graphics", "world_transmutation_overlay.enabled", "true");
        commandSender.func_70006_a(ChatMessageComponent.func_111077_e((String)"command.ee3:overlay.turned_on"));
    }

    private static void processOffCommand(ICommandSender commandSender) {
        ConfigurationSettings.ENABLE_OVERLAY_WORLD_TRANSMUTATION = false;
        GeneralConfiguration.set("graphics", "world_transmutation_overlay.enabled", "false");
        commandSender.func_70006_a(ChatMessageComponent.func_111077_e((String)"command.ee3:overlay.turned_off"));
    }

    private static void processScaleCommand(ICommandSender commandSender, String[] args) {
        if (args.length > 2 && args.length < 4) {
            try {
                float scale = Float.parseFloat(args[1]);
                if (scale <= 0.0f) {
                    throw new WrongUsageException("command.ee3:overlay.scale.usage.additional_text", new Object[]{"ee3 overlay scale ### "});
                }
                ConfigurationSettings.TARGET_BLOCK_OVERLAY_SCALE = scale;
                GeneralConfiguration.set("graphics", "block_overlay_scale", args[1]);
                commandSender.func_70006_a(ChatMessageComponent.func_111077_e((String)"command.ee3:overlay.scale.updated"));
            }
            catch (Exception e) {
                throw new WrongUsageException("command.ee3:overlay.scale.usage.additional_text", new Object[]{"ee3 overlay scale ### "});
            }
        } else {
            throw new WrongUsageException("command.ee3:overlay.scale.usage.additional_text", new Object[]{"ee3 overlay scale ### "});
        }
    }

    private static void processOpacityCommand(ICommandSender commandSender, String[] args) {
        if (args.length > 2 && args.length < 4) {
            try {
                float opacity = Float.parseFloat(args[1]);
                if (opacity < 0.0f || opacity > 1.0f) {
                    throw new WrongUsageException("command.ee3:overlay.opacity.usage.additional_text", new Object[]{"ee3 overlay opacity ### "});
                }
                ConfigurationSettings.TARGET_BLOCK_OVERLAY_OPACITY = opacity;
                GeneralConfiguration.set("graphics", "block_overlay_opacity", args[1]);
                commandSender.func_70006_a(ChatMessageComponent.func_111077_e((String)"command.ee3:overlay.opacity.updated"));
            }
            catch (Exception e) {
                throw new WrongUsageException("command.ee3:overlay.opacity.usage.additional_text", new Object[]{"ee3 overlay opacity ### "});
            }
        } else {
            throw new WrongUsageException("command.ee3:overlay.opacity.usage.additional_text", new Object[]{"ee3 overlay opacity ### "});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processPositionCommand(ICommandSender commandSender, String[] args) {
        if (args.length <= 2 || args.length >= 5) throw new WrongUsageException("ee3 overlay position [ top | bottom ] [ left | right ]", new Object[0]);
        String yPosition = args[1];
        String xPosition = args[2];
        if (yPosition.equalsIgnoreCase("top") && xPosition.equalsIgnoreCase("left")) {
            ConfigurationSettings.TARGET_BLOCK_OVERLAY_POSITION = 0;
            GeneralConfiguration.set("graphics", "block_overlay_position", "0");
            commandSender.func_70006_a(ChatMessageComponent.func_111077_e((String)"command.ee3:overlay.position.top_left"));
            return;
        } else if (yPosition.equalsIgnoreCase("top") && xPosition.equalsIgnoreCase("right")) {
            ConfigurationSettings.TARGET_BLOCK_OVERLAY_POSITION = 1;
            GeneralConfiguration.set("graphics", "block_overlay_position", "1");
            commandSender.func_70006_a(ChatMessageComponent.func_111077_e((String)"command.ee3:overlay.position.top_right"));
            return;
        } else if (yPosition.equalsIgnoreCase("bottom") && xPosition.equalsIgnoreCase("left")) {
            ConfigurationSettings.TARGET_BLOCK_OVERLAY_POSITION = 2;
            GeneralConfiguration.set("graphics", "block_overlay_position", "2");
            commandSender.func_70006_a(ChatMessageComponent.func_111077_e((String)"command.ee3:overlay.position.bottom_left"));
            return;
        } else {
            if (!yPosition.equalsIgnoreCase("bottom") || !xPosition.equalsIgnoreCase("right")) throw new WrongUsageException("ee3 overlay position [ top | bottom ] [ left | right ]", new Object[0]);
            ConfigurationSettings.TARGET_BLOCK_OVERLAY_POSITION = 3;
            GeneralConfiguration.set("graphics", "block_overlay_position", "3");
            commandSender.func_70006_a(ChatMessageComponent.func_111077_e((String)"command.ee3:overlay.position.bottom_right"));
        }
    }
}

