/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.command;

import com.pahimar.ee3.configuration.ConfigurationSettings;
import com.pahimar.ee3.configuration.GeneralConfiguration;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatMessageComponent;

public class CommandSounds {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void processCommand(ICommandSender commandSender, String[] args) {
        if (args.length <= 0) throw new WrongUsageException("ee3 sounds [ all | self | off ]", new Object[0]);
        String subCommand = args[0];
        if (subCommand.toLowerCase().equals("all")) {
            CommandSounds.processAllCommand(commandSender);
            return;
        } else if (subCommand.toLowerCase().equals("self")) {
            CommandSounds.processSelfCommand(commandSender);
            return;
        } else {
            if (!subCommand.toLowerCase().equals("off")) throw new WrongUsageException("ee3 sounds [ all | self | off ]", new Object[0]);
            CommandSounds.processOffCommand(commandSender);
        }
    }

    private static void processAllCommand(ICommandSender commandSender) {
        ConfigurationSettings.ENABLE_SOUNDS = "all";
        GeneralConfiguration.set("audio", "sounds.enabled", "all");
        commandSender.func_70006_a(ChatMessageComponent.func_111077_e((String)"command.ee3:sounds.set_to_all"));
    }

    private static void processSelfCommand(ICommandSender commandSender) {
        ConfigurationSettings.ENABLE_SOUNDS = "self";
        GeneralConfiguration.set("audio", "sounds.enabled", "self");
        commandSender.func_70006_a(ChatMessageComponent.func_111077_e((String)"command.ee3:sounds.set_to_self"));
    }

    private static void processOffCommand(ICommandSender commandSender) {
        ConfigurationSettings.ENABLE_SOUNDS = "off";
        GeneralConfiguration.set("audio", "sounds.enabled", "off");
        commandSender.func_70006_a(ChatMessageComponent.func_111077_e((String)"command.ee3:sounds.turned_off"));
    }
}

