/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.configuration;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.configuration.ConfigurationSettings;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.logging.Level;
import net.minecraftforge.common.Configuration;

public class GeneralConfiguration {
    private static Configuration generalConfiguration;
    public static final String CATEGORY_KEYBIND = "keybindings";
    public static final String CATEGORY_GRAPHICS = "graphics";
    public static final String CATEGORY_AUDIO = "audio";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void init(File configFile) {
        generalConfiguration = new Configuration(configFile);
        try {
            generalConfiguration.load();
            ConfigurationSettings.DISPLAY_VERSION_RESULT = generalConfiguration.get("general", "version_check.display_results", true).getBoolean(true);
            ConfigurationSettings.LAST_DISCOVERED_VERSION = generalConfiguration.get("general", "version_check.last_discovered_version", "").getString();
            ConfigurationSettings.LAST_DISCOVERED_VERSION_TYPE = generalConfiguration.get("general", "version_check.last_discovered_version_type", "").getString();
            ConfigurationSettings.ENABLE_PARTICLE_FX = generalConfiguration.get(CATEGORY_GRAPHICS, "particle_fx.enabled", true).getBoolean(true);
            ConfigurationSettings.ENABLE_OVERLAY_WORLD_TRANSMUTATION = generalConfiguration.get(CATEGORY_GRAPHICS, "world_transmutation_overlay.enabled", true).getBoolean(true);
            ConfigurationSettings.TARGET_BLOCK_OVERLAY_POSITION = generalConfiguration.get(CATEGORY_GRAPHICS, "block_overlay_position", 3).getInt(3);
            try {
                ConfigurationSettings.TARGET_BLOCK_OVERLAY_SCALE = Float.parseFloat(generalConfiguration.get(CATEGORY_GRAPHICS, "block_overlay_scale", 2.5).getString());
                if (ConfigurationSettings.TARGET_BLOCK_OVERLAY_SCALE <= 0.0f) {
                    ConfigurationSettings.TARGET_BLOCK_OVERLAY_SCALE = 2.5f;
                }
            }
            catch (Exception e) {
                ConfigurationSettings.TARGET_BLOCK_OVERLAY_SCALE = 2.5f;
            }
            try {
                ConfigurationSettings.TARGET_BLOCK_OVERLAY_OPACITY = Float.parseFloat(generalConfiguration.get(CATEGORY_GRAPHICS, "block_overlay_opacity", 0.75).getString());
                if (ConfigurationSettings.TARGET_BLOCK_OVERLAY_OPACITY < 0.0f || ConfigurationSettings.TARGET_BLOCK_OVERLAY_OPACITY > 1.0f) {
                    ConfigurationSettings.TARGET_BLOCK_OVERLAY_OPACITY = 0.75f;
                }
            }
            catch (Exception e) {
                ConfigurationSettings.TARGET_BLOCK_OVERLAY_OPACITY = 0.75f;
            }
            ConfigurationSettings.ENABLE_SOUNDS = generalConfiguration.get(CATEGORY_AUDIO, "sounds.enabled", "all").getString();
            generalConfiguration.addCustomCategoryComment(CATEGORY_KEYBIND, "Keybindings for Equivalent Exchange 3. See http://www.minecraftwiki.net/wiki/Key_codes for mapping of key codes to keyboard keys");
            EquivalentExchange3.proxy.setKeyBinding("key.extra", generalConfiguration.get(CATEGORY_KEYBIND, "key.extra", 46).getInt(46));
            EquivalentExchange3.proxy.setKeyBinding("key.charge", generalConfiguration.get(CATEGORY_KEYBIND, "key.charge", 47).getInt(47));
            EquivalentExchange3.proxy.setKeyBinding("key.toggle", generalConfiguration.get(CATEGORY_KEYBIND, "key.toggle", 34).getInt(34));
            EquivalentExchange3.proxy.setKeyBinding("key.release", generalConfiguration.get(CATEGORY_KEYBIND, "key.release", 19).getInt(19));
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"Equivalent Exchange 3 has had a problem loading its general configuration", (Object[])new Object[0]);
        }
        finally {
            generalConfiguration.save();
        }
    }

    public static void set(String categoryName, String propertyName, String newValue) {
        generalConfiguration.load();
        if (generalConfiguration.getCategoryNames().contains(categoryName) && generalConfiguration.getCategory(categoryName).containsKey(propertyName)) {
            generalConfiguration.getCategory(categoryName).get(propertyName).set(newValue);
        }
        generalConfiguration.save();
    }
}

