/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.emc;

import com.pahimar.ee3.emc.EmcType;

public class EmcComponent
implements Comparable<EmcComponent> {
    public final EmcType type;
    public final int weight;

    public EmcComponent(EmcType type, int weight) {
        this.type = type;
        this.weight = weight > 0 ? weight : -1;
    }

    public EmcComponent(EmcType type) {
        this(type, 1);
    }

    public boolean equals(Object object) {
        if (!(object instanceof EmcComponent)) {
            return false;
        }
        EmcComponent emcComponent = (EmcComponent)object;
        return this.type == emcComponent.type && this.weight == emcComponent.weight;
    }

    public String toString() {
        return String.format("<EMC Type: %s, Weight: %s>", new Object[]{this.type, this.weight});
    }

    @Override
    public int compareTo(EmcComponent emcComponent) {
        if (emcComponent != null) {
            if (this.type == emcComponent.type) {
                return this.weight - emcComponent.weight;
            }
            return this.type.compareTo(emcComponent.type);
        }
        return 1;
    }
}

