/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.emc;

import com.google.common.collect.ImmutableSortedMap;
import com.pahimar.ee3.api.OreStack;
import com.pahimar.ee3.api.WrappedStack;
import com.pahimar.ee3.emc.EmcValue;
import com.pahimar.ee3.emc.EmcValuesDefault;
import com.pahimar.ee3.emc.EmcValuesIMC;
import com.pahimar.ee3.helper.EmcHelper;
import com.pahimar.ee3.recipe.RecipeRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class EmcRegistry {
    private static EmcRegistry emcRegistry = null;
    private ImmutableSortedMap<WrappedStack, EmcValue> stackMappings;
    private ImmutableSortedMap<EmcValue, List<WrappedStack>> valueMappings;

    private EmcRegistry() {
    }

    public static EmcRegistry getInstance() {
        if (emcRegistry == null) {
            emcRegistry = new EmcRegistry();
            emcRegistry.init();
        }
        return emcRegistry;
    }

    private void init() {
        HashMap<WrappedStack, EmcValue> stackValueMap = new HashMap<WrappedStack, EmcValue>();
        Map<WrappedStack, EmcValue> defaultValuesMap = EmcValuesDefault.getDefaultValueMap();
        for (WrappedStack keyStack : defaultValuesMap.keySet()) {
            EmcValue factoredEmcValue = null;
            WrappedStack factoredKeyStack = null;
            if (keyStack != null && keyStack.getWrappedStack() != null && keyStack.getStackSize() > 0 && defaultValuesMap.get(keyStack) != null && Float.compare(defaultValuesMap.get(keyStack).getValue(), 0.0f) > 0) {
                factoredEmcValue = EmcHelper.factorEmcValue(defaultValuesMap.get(keyStack), keyStack.getStackSize());
                factoredKeyStack = new WrappedStack(keyStack, 1);
            }
            if (factoredEmcValue == null) continue;
            if (stackValueMap.containsKey(factoredKeyStack)) {
                if (factoredEmcValue.compareTo((EmcValue)stackValueMap.get(factoredKeyStack)) != -1) continue;
                stackValueMap.put(factoredKeyStack, factoredEmcValue);
                continue;
            }
            stackValueMap.put(factoredKeyStack, factoredEmcValue);
        }
        Map<WrappedStack, EmcValue> preAssignedValuesMap = EmcValuesIMC.getPreAssignedValues();
        for (WrappedStack keyStack : preAssignedValuesMap.keySet()) {
            EmcValue factoredEmcValue = null;
            WrappedStack factoredKeyStack = null;
            if (keyStack != null && keyStack.getWrappedStack() != null && keyStack.getStackSize() > 0 && preAssignedValuesMap.get(keyStack) != null && Float.compare(preAssignedValuesMap.get(keyStack).getValue(), 0.0f) > 0) {
                factoredEmcValue = EmcHelper.factorEmcValue(preAssignedValuesMap.get(keyStack), keyStack.getStackSize());
                factoredKeyStack = new WrappedStack(keyStack, 1);
            }
            if (factoredEmcValue == null) continue;
            if (stackValueMap.containsKey(factoredKeyStack)) {
                if (factoredEmcValue.compareTo((EmcValue)stackValueMap.get(factoredKeyStack)) != -1) continue;
                stackValueMap.put(factoredKeyStack, factoredEmcValue);
                continue;
            }
            stackValueMap.put(factoredKeyStack, factoredEmcValue);
        }
        ImmutableSortedMap.Builder stackMappingsBuilder = ImmutableSortedMap.naturalOrder();
        stackMappingsBuilder.putAll(stackValueMap);
        this.stackMappings = stackMappingsBuilder.build();
        Map<WrappedStack, EmcValue> computedStackValues = this.computeStackMappings();
        int passNumber = 0;
        while (computedStackValues.size() > 0 && passNumber < 16) {
            ++passNumber;
            stackMappingsBuilder = ImmutableSortedMap.naturalOrder();
            stackMappingsBuilder.putAll(stackValueMap);
            this.stackMappings = stackMappingsBuilder.build();
            computedStackValues = this.computeStackMappings();
            for (WrappedStack keyStack : computedStackValues.keySet()) {
                EmcValue factoredEmcValue = null;
                WrappedStack factoredKeyStack = null;
                if (keyStack != null && keyStack.getWrappedStack() != null && keyStack.getStackSize() > 0 && computedStackValues.get(keyStack) != null && Float.compare(computedStackValues.get(keyStack).getValue(), 0.0f) > 0) {
                    factoredEmcValue = EmcHelper.factorEmcValue(computedStackValues.get(keyStack), keyStack.getStackSize());
                    factoredKeyStack = new WrappedStack(keyStack, 1);
                }
                if (factoredEmcValue == null) continue;
                if (stackValueMap.containsKey(factoredKeyStack)) {
                    if (factoredEmcValue.compareTo((EmcValue)stackValueMap.get(factoredKeyStack)) != -1) continue;
                    stackValueMap.put(factoredKeyStack, factoredEmcValue);
                    continue;
                }
                stackValueMap.put(factoredKeyStack, factoredEmcValue);
            }
        }
        Map<WrappedStack, EmcValue> postAssignedValuesMap = EmcValuesIMC.getPostAssignedValues();
        for (WrappedStack keyStack : postAssignedValuesMap.keySet()) {
            EmcValue factoredEmcValue = null;
            WrappedStack factoredKeyStack = null;
            if (keyStack != null && keyStack.getWrappedStack() != null && keyStack.getStackSize() > 0 && postAssignedValuesMap.get(keyStack) != null && Float.compare(postAssignedValuesMap.get(keyStack).getValue(), 0.0f) > 0) {
                factoredEmcValue = EmcHelper.factorEmcValue(postAssignedValuesMap.get(keyStack), keyStack.getStackSize());
                factoredKeyStack = new WrappedStack(keyStack, 1);
            }
            if (factoredEmcValue == null) continue;
            stackValueMap.put(factoredKeyStack, factoredEmcValue);
        }
        stackMappingsBuilder = ImmutableSortedMap.naturalOrder();
        stackMappingsBuilder.putAll(stackValueMap);
        this.stackMappings = stackMappingsBuilder.build();
        TreeMap<EmcValue, ArrayList<WrappedStack>> tempValueMappings = new TreeMap<EmcValue, ArrayList<WrappedStack>>();
        for (WrappedStack stack : this.stackMappings.keySet()) {
            EmcValue value;
            if (stack == null || (value = (EmcValue)this.stackMappings.get((Object)stack)) == null) continue;
            if (tempValueMappings.containsKey(value)) {
                if (((List)tempValueMappings.get(value)).contains(stack)) continue;
                ((List)tempValueMappings.get(value)).add(stack);
                continue;
            }
            tempValueMappings.put(value, new ArrayList<WrappedStack>(Arrays.asList(stack)));
        }
        this.valueMappings = ImmutableSortedMap.copyOf(tempValueMappings);
    }

    private Map<WrappedStack, EmcValue> computeStackMappings() {
        HashMap<WrappedStack, EmcValue> computedStackMap = new HashMap<WrappedStack, EmcValue>();
        for (WrappedStack recipeOutput : RecipeRegistry.getInstance().getRecipeMappings().keySet()) {
            if (this.hasEmcValue(recipeOutput.getWrappedStack(), false) || computedStackMap.containsKey(recipeOutput)) continue;
            EmcValue lowestValue = null;
            for (List recipeInputs : RecipeRegistry.getInstance().getRecipeMappings().get((Object)recipeOutput)) {
                EmcValue computedValue = EmcHelper.computeEmcValueFromList(recipeInputs);
                if ((computedValue = EmcHelper.factorEmcValue(computedValue, recipeOutput.getStackSize())) == null || computedValue.compareTo(lowestValue) >= 0) continue;
                lowestValue = computedValue;
            }
            if (lowestValue == null || !(lowestValue.getValue() > 0.0f)) continue;
            computedStackMap.put(new WrappedStack(recipeOutput.getWrappedStack()), lowestValue);
        }
        return computedStackMap;
    }

    public boolean hasEmcValue(Object object, boolean strict) {
        block12: {
            if (!WrappedStack.canBeWrapped(object)) break block12;
            WrappedStack stack = new WrappedStack(object);
            if (EmcRegistry.emcRegistry.stackMappings.containsKey((Object)new WrappedStack(stack.getWrappedStack()))) {
                return true;
            }
            if (!strict) {
                if (stack.getWrappedStack() instanceof ItemStack) {
                    ItemStack wrappedItemStack = (ItemStack)stack.getWrappedStack();
                    if (OreDictionary.getOreID((ItemStack)wrappedItemStack) != -1) {
                        OreStack oreStack = new OreStack(wrappedItemStack);
                        if (EmcRegistry.emcRegistry.stackMappings.containsKey((Object)new WrappedStack(oreStack))) {
                            return true;
                        }
                        for (ItemStack itemStack : OreDictionary.getOres((Integer)OreDictionary.getOreID((ItemStack)wrappedItemStack))) {
                            if (!EmcRegistry.emcRegistry.stackMappings.containsKey((Object)new WrappedStack(itemStack))) continue;
                            return true;
                        }
                    } else {
                        for (WrappedStack valuedStack : EmcRegistry.emcRegistry.stackMappings.keySet()) {
                            if (!(valuedStack.getWrappedStack() instanceof ItemStack)) continue;
                            ItemStack valuedItemStack = (ItemStack)valuedStack.getWrappedStack();
                            if (valuedItemStack.field_77993_c != wrappedItemStack.field_77993_c) continue;
                            if (valuedItemStack.func_77960_j() == Short.MAX_VALUE || wrappedItemStack.func_77960_j() == Short.MAX_VALUE) {
                                return true;
                            }
                            if (!wrappedItemStack.func_77973_b().func_77645_m() || !wrappedItemStack.func_77951_h()) continue;
                            return true;
                        }
                    }
                } else if (stack.getWrappedStack() instanceof OreStack) {
                    OreStack oreStack = (OreStack)stack.getWrappedStack();
                    for (ItemStack oreItemStack : OreDictionary.getOres((String)oreStack.oreName)) {
                        if (!EmcRegistry.emcRegistry.stackMappings.containsKey((Object)new WrappedStack(oreItemStack))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean hasEmcValue(Object object) {
        return this.hasEmcValue(object, false);
    }

    public EmcValue getEmcValue(Object object, boolean strict) {
        if (WrappedStack.canBeWrapped(object)) {
            WrappedStack stack = new WrappedStack(object);
            if (EmcRegistry.emcRegistry.stackMappings.containsKey((Object)new WrappedStack(stack.getWrappedStack()))) {
                return (EmcValue)EmcRegistry.emcRegistry.stackMappings.get((Object)new WrappedStack(stack.getWrappedStack()));
            }
            if (!strict) {
                if (stack.getWrappedStack() instanceof ItemStack) {
                    EmcValue lowestValue = null;
                    ItemStack wrappedItemStack = (ItemStack)stack.getWrappedStack();
                    if (OreDictionary.getOreID((ItemStack)wrappedItemStack) != -1) {
                        OreStack oreStack = new OreStack(wrappedItemStack);
                        if (EmcRegistry.emcRegistry.stackMappings.containsKey((Object)new WrappedStack(oreStack))) {
                            return (EmcValue)EmcRegistry.emcRegistry.stackMappings.get((Object)new WrappedStack(oreStack));
                        }
                        for (ItemStack itemStack : OreDictionary.getOres((Integer)OreDictionary.getOreID((ItemStack)wrappedItemStack))) {
                            if (!EmcRegistry.emcRegistry.stackMappings.containsKey((Object)new WrappedStack(itemStack))) continue;
                            if (lowestValue == null) {
                                lowestValue = (EmcValue)EmcRegistry.emcRegistry.stackMappings.get((Object)new WrappedStack(itemStack));
                                continue;
                            }
                            EmcValue itemValue = (EmcValue)EmcRegistry.emcRegistry.stackMappings.get((Object)new WrappedStack(itemStack));
                            if (itemValue.compareTo(lowestValue) >= 0) continue;
                            lowestValue = itemValue;
                        }
                        return lowestValue;
                    }
                    for (WrappedStack valuedStack : EmcRegistry.emcRegistry.stackMappings.keySet()) {
                        EmcValue stackValue;
                        if (!(valuedStack.getWrappedStack() instanceof ItemStack)) continue;
                        ItemStack valuedItemStack = (ItemStack)valuedStack.getWrappedStack();
                        if (valuedItemStack.field_77993_c != wrappedItemStack.field_77993_c) continue;
                        if (valuedItemStack.func_77960_j() == Short.MAX_VALUE || wrappedItemStack.func_77960_j() == Short.MAX_VALUE) {
                            stackValue = (EmcValue)EmcRegistry.emcRegistry.stackMappings.get((Object)valuedStack);
                            if (stackValue.compareTo(lowestValue) >= 0) continue;
                            lowestValue = stackValue;
                            continue;
                        }
                        if (!wrappedItemStack.func_77973_b().func_77645_m() || !wrappedItemStack.func_77951_h() || (stackValue = new EmcValue(((EmcValue)EmcRegistry.emcRegistry.stackMappings.get((Object)valuedStack)).getValue() * (1.0f - (float)wrappedItemStack.func_77960_j() * 1.0f / (float)wrappedItemStack.func_77958_k()))).compareTo(lowestValue) >= 0) continue;
                        lowestValue = stackValue;
                    }
                    return lowestValue;
                }
                if (stack.getWrappedStack() instanceof OreStack) {
                    OreStack oreStack = (OreStack)stack.getWrappedStack();
                    for (ItemStack oreItemStack : OreDictionary.getOres((String)oreStack.oreName)) {
                        if (!EmcRegistry.emcRegistry.stackMappings.containsKey((Object)new WrappedStack(oreItemStack))) continue;
                        return (EmcValue)EmcRegistry.emcRegistry.stackMappings.get((Object)new WrappedStack(oreItemStack));
                    }
                }
            }
        }
        return null;
    }

    public EmcValue getEmcValue(Object object) {
        return this.getEmcValue(object, false);
    }

    public List<WrappedStack> getStacksInRange(int start, int finish) {
        return this.getStacksInRange(new EmcValue(start), new EmcValue(finish));
    }

    public List<WrappedStack> getStacksInRange(float start, float finish) {
        return this.getStacksInRange(new EmcValue(start), new EmcValue(finish));
    }

    public List<WrappedStack> getStacksInRange(EmcValue start, EmcValue finish) {
        ArrayList<WrappedStack> stacksInRange = new ArrayList<WrappedStack>();
        ImmutableSortedMap tailMap = EmcRegistry.emcRegistry.valueMappings.tailMap((Object)start);
        ImmutableSortedMap headMap = EmcRegistry.emcRegistry.valueMappings.headMap((Object)finish);
        if (!tailMap.isEmpty() && !headMap.isEmpty()) {
            ImmutableSortedMap biggerMap;
            ImmutableSortedMap smallerMap;
            if (tailMap.size() <= headMap.size()) {
                smallerMap = tailMap;
                biggerMap = headMap;
            } else {
                smallerMap = headMap;
                biggerMap = tailMap;
            }
            for (EmcValue value : smallerMap.keySet()) {
                if (!biggerMap.containsKey(value)) continue;
                stacksInRange.addAll((Collection)EmcRegistry.emcRegistry.valueMappings.get((Object)value));
            }
        }
        return stacksInRange;
    }

    public ImmutableSortedMap<WrappedStack, EmcValue> getStackToEmcValueMap() {
        return this.stackMappings;
    }

    public ImmutableSortedMap<EmcValue, List<WrappedStack>> getEmcValueToStackMap() {
        return this.valueMappings;
    }
}

