/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.emc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.pahimar.ee3.emc.EmcComponent;
import com.pahimar.ee3.emc.EmcType;
import com.pahimar.ee3.helper.LogHelper;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class EmcValue
implements Comparable<EmcValue>,
JsonDeserializer<EmcValue>,
JsonSerializer<EmcValue> {
    private static final Gson gsonSerializer = new GsonBuilder().registerTypeAdapter(EmcValue.class, (Object)new EmcValue()).create();
    private static final int PRECISION = 4;
    public final float[] components;

    public EmcValue() {
        this(new float[EmcType.TYPES.length]);
    }

    public EmcValue(int value) {
        this((float)value);
    }

    public EmcValue(float value) {
        this(value, EmcType.DEFAULT);
    }

    public EmcValue(float value, EmcComponent component) {
        this(value, component.type);
    }

    public EmcValue(int value, EmcType emcType) {
        this((float)value, emcType);
    }

    public EmcValue(float value, EmcType emcType) {
        this(value, Arrays.asList(new EmcComponent(emcType)));
    }

    public EmcValue(float[] components) {
        if (components.length == EmcType.TYPES.length) {
            this.components = new float[components.length];
            for (int i = 0; i < this.components.length; ++i) {
                BigDecimal bigComponent = BigDecimal.valueOf(components[i]).setScale(4, 5);
                this.components[i] = bigComponent.floatValue();
            }
        } else {
            this.components = null;
        }
    }

    public EmcValue(int value, List<EmcComponent> componentList) {
        this((float)value, componentList);
    }

    public EmcValue(float value, List<EmcComponent> componentList) {
        this.components = new float[EmcType.TYPES.length];
        List<EmcComponent> collatedComponents = EmcValue.collateComponents(componentList);
        int totalComponents = 0;
        for (EmcComponent component : collatedComponents) {
            if (component.weight <= 0) continue;
            totalComponents += component.weight;
        }
        if (totalComponents > 0) {
            for (EmcComponent component : collatedComponents) {
                if (component.weight <= 0) continue;
                this.components[component.type.ordinal()] = value * ((float)component.weight * 1.0f / (float)totalComponents);
            }
        } else {
            this.components[EmcType.DEFAULT.ordinal()] = value;
        }
        for (int i = 0; i < this.components.length; ++i) {
            BigDecimal bigComponent = BigDecimal.valueOf(this.components[i]).setScale(4, 5);
            this.components[i] = bigComponent.floatValue();
        }
    }

    public float getValue() {
        float sumSubValues = 0.0f;
        for (float subValue : this.components) {
            if (!(subValue > 0.0f)) continue;
            sumSubValues += subValue;
        }
        return sumSubValues;
    }

    public boolean equals(Object object) {
        return object instanceof EmcValue && this.compareTo((EmcValue)object) == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (EmcType emcType : EmcType.TYPES) {
            if (!(this.components[emcType.ordinal()] > 0.0f)) continue;
            stringBuilder.append(String.format(" %s:%s ", new Object[]{emcType, Float.valueOf(this.components[emcType.ordinal()])}));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 37 * hashCode + Float.floatToIntBits(this.getValue());
        for (float subValue : this.components) {
            hashCode = 37 * hashCode + Float.floatToIntBits(subValue);
        }
        return hashCode;
    }

    @Override
    public int compareTo(EmcValue emcValue) {
        if (emcValue != null) {
            return EmcValue.compareComponents(this.components, emcValue.components);
        }
        return -1;
    }

    public static EmcValue createFromJson(String jsonEmcValue) {
        try {
            return (EmcValue)gsonSerializer.fromJson(jsonEmcValue, EmcValue.class);
        }
        catch (JsonSyntaxException exception) {
            LogHelper.severe(exception.getMessage());
        }
        catch (JsonParseException exception) {
            LogHelper.severe(exception.getMessage());
        }
        return null;
    }

    public String toJson() {
        return gsonSerializer.toJson((Object)this);
    }

    private static List<EmcComponent> collateComponents(List<EmcComponent> uncollatedComponents) {
        Integer[] componentCount = new Integer[EmcType.TYPES.length];
        for (EmcComponent emcComponent : uncollatedComponents) {
            if (componentCount[emcComponent.type.ordinal()] == null) {
                componentCount[emcComponent.type.ordinal()] = 0;
            }
            if (emcComponent.weight < 0) continue;
            componentCount[emcComponent.type.ordinal()] = componentCount[emcComponent.type.ordinal()] + emcComponent.weight;
        }
        ArrayList<EmcComponent> collatedComponents = new ArrayList<EmcComponent>();
        for (int i = 0; i < EmcType.TYPES.length; ++i) {
            if (componentCount[i] == null) continue;
            collatedComponents.add(new EmcComponent(EmcType.TYPES[i], componentCount[i]));
        }
        Collections.sort(collatedComponents);
        return collatedComponents;
    }

    private static int compareComponents(float[] first, float[] second) {
        if (first.length == EmcType.TYPES.length && second.length == EmcType.TYPES.length) {
            for (EmcType emcType : EmcType.TYPES) {
                if (Float.compare(first[emcType.ordinal()], second[emcType.ordinal()]) == 0) continue;
                return Float.compare(first[emcType.ordinal()], second[emcType.ordinal()]);
            }
            return 0;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public JsonElement serialize(EmcValue emcValue, Type type, JsonSerializationContext context) {
        JsonObject jsonEmcValue = new JsonObject();
        for (EmcType emcType : EmcType.TYPES) {
            jsonEmcValue.addProperty(emcType.toString(), (Number)Float.valueOf(emcValue.components[emcType.ordinal()]));
        }
        return jsonEmcValue;
    }

    public EmcValue deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        float[] emcValueComponents = new float[EmcType.TYPES.length];
        JsonObject jsonEmcValue = (JsonObject)jsonElement;
        for (EmcType emcType : EmcType.TYPES) {
            if (jsonEmcValue.get(emcType.toString()) == null || !jsonEmcValue.get(emcType.toString()).isJsonPrimitive()) continue;
            try {
                emcValueComponents[emcType.ordinal()] = jsonEmcValue.get(emcType.toString()).getAsFloat();
            }
            catch (UnsupportedOperationException exception) {
                LogHelper.severe(exception.getMessage());
            }
        }
        EmcValue emcValue = new EmcValue(emcValueComponents);
        if (emcValue.getValue() > 0.0f) {
            return emcValue;
        }
        return null;
    }
}

