/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.handler;

import com.pahimar.ee3.configuration.ConfigurationSettings;
import com.pahimar.ee3.event.ActionEvent;
import com.pahimar.ee3.event.ActionRequestEvent;
import com.pahimar.ee3.event.WorldTransmutationEvent;
import com.pahimar.ee3.handler.EquivalencyHandler;
import com.pahimar.ee3.helper.TransmutationHelper;
import com.pahimar.ee3.lib.Sounds;
import com.pahimar.ee3.network.PacketTypeHandler;
import com.pahimar.ee3.network.packet.PacketItemUpdate;
import com.pahimar.ee3.network.packet.PacketSoundEvent;
import com.pahimar.ee3.network.packet.PacketSpawnParticle;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;

public class WorldTransmutationHandler {
    public static void handleWorldTransmutation(EntityPlayer thePlayer, int originX, int originY, int originZ, byte rangeX, byte rangeY, byte rangeZ, byte sideHit, String data) {
        int lowerBoundX = -1 * rangeX / 2;
        int upperBoundX = -1 * lowerBoundX;
        int lowerBoundY = -1 * rangeY / 2;
        int upperBoundY = -1 * lowerBoundY;
        int lowerBoundZ = -1 * rangeZ / 2;
        int upperBoundZ = -1 * lowerBoundZ;
        boolean anySuccess = false;
        double xShift = 0.0;
        double yShift = 0.0;
        double zShift = 0.0;
        int xSign = 1;
        int ySign = 1;
        int zSign = 1;
        switch (ForgeDirection.getOrientation((int)sideHit)) {
            case UP: {
                yShift = 1.5;
                break;
            }
            case DOWN: {
                yShift = 0.1;
                ySign = -1;
                break;
            }
            case NORTH: {
                zShift = 1.0;
                zSign = -1;
                break;
            }
            case SOUTH: {
                zShift = 1.0;
                break;
            }
            case EAST: {
                xShift = 1.0;
                break;
            }
            case WEST: {
                xShift = 1.0;
                xSign = -1;
                break;
            }
            case UNKNOWN: {
                break;
            }
        }
        for (int x = lowerBoundX; x <= upperBoundX; ++x) {
            for (int y = lowerBoundY; y <= upperBoundY; ++y) {
                for (int z = lowerBoundZ; z <= upperBoundZ; ++z) {
                    WorldTransmutationEvent actionEvent = new WorldTransmutationEvent(0, thePlayer.func_71045_bC(), thePlayer, thePlayer.field_70170_p, originX + x, originY + y, originZ + z, false, data);
                    if (actionEvent == null) continue;
                    ActionRequestEvent actionRequestEvent = new ActionRequestEvent(thePlayer, actionEvent, originX + x, originY + y, originZ + z, sideHit);
                    MinecraftForge.EVENT_BUS.post((Event)actionRequestEvent);
                    if (actionRequestEvent.allowEvent != Event.Result.DENY) {
                        MinecraftForge.EVENT_BUS.post((Event)actionEvent);
                    }
                    if (actionEvent.actionResult == ActionEvent.ActionResult.SUCCESS) {
                        if (!anySuccess) {
                            anySuccess = true;
                        }
                        PacketDispatcher.sendPacketToAllAround((double)(originX + x), (double)(originY + y), (double)(originZ + z), (double)64.0, (int)thePlayer.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketTypeHandler.populatePacket(new PacketSpawnParticle("largesmoke", (double)(originX + x) + xShift * (double)xSign, (double)(originY + y) + yShift * (double)ySign, (double)(originZ + z) + zShift * (double)zSign, 0.0 * (double)xSign, 0.05 * (double)ySign, 0.0 * (double)zSign)));
                        PacketDispatcher.sendPacketToAllAround((double)(originX + x), (double)(originY + y), (double)(originZ + z), (double)64.0, (int)thePlayer.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketTypeHandler.populatePacket(new PacketSpawnParticle("largeexplode", (double)(originX + x) + xShift * (double)xSign, (double)(originY + y) + yShift * (double)ySign, (double)(originZ + z) + zShift * (double)zSign, 0.0 * (double)xSign, 0.15 * (double)ySign, 0.0 * (double)zSign)));
                        continue;
                    }
                    if (actionEvent.actionResult != ActionEvent.ActionResult.FAILURE || actionEvent.world.func_72798_a(originX + x, originY + y, originZ + z) == 0) continue;
                    PacketDispatcher.sendPacketToAllAround((double)(originX + x), (double)(originY + y), (double)(originZ + z), (double)64.0, (int)thePlayer.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketTypeHandler.populatePacket(new PacketSpawnParticle("reddust", (double)(originX + x) + xShift * (double)xSign, (double)(originY + y) + yShift * (double)ySign, (double)(originZ + z) + zShift * (double)zSign, 0.0 * (double)xSign, 0.05 * (double)ySign, 0.0 * (double)zSign)));
                    PacketDispatcher.sendPacketToAllAround((double)(originX + x), (double)(originY + y), (double)(originZ + z), (double)64.0, (int)thePlayer.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketTypeHandler.populatePacket(new PacketSpawnParticle("witchMagic", (double)(originX + x) + xShift * (double)xSign, (double)(originY + y) + yShift * (double)ySign, (double)(originZ + z) + zShift * (double)zSign, 0.0 * (double)xSign, 0.05 * (double)ySign, 0.0 * (double)zSign)));
                }
            }
        }
        if (anySuccess) {
            PacketDispatcher.sendPacketToAllAround((double)originX, (double)originY, (double)originZ, (double)64.0, (int)thePlayer.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketTypeHandler.populatePacket(new PacketSoundEvent(thePlayer.field_71092_bJ, Sounds.TRANSMUTE, originX, originY, originZ, 0.5f, 1.0f)));
        } else {
            PacketDispatcher.sendPacketToAllAround((double)originX, (double)originY, (double)originZ, (double)64.0, (int)thePlayer.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketTypeHandler.populatePacket(new PacketSoundEvent(thePlayer.field_71092_bJ, Sounds.FAIL, originX, originY, originZ, 1.5f, 1.5f)));
        }
    }

    @ForgeSubscribe
    public void onWorldTransmutationEvent(WorldTransmutationEvent event) {
        ItemStack targetStack;
        ItemStack worldStack;
        int id = event.world.func_72798_a(event.x, event.y, event.z);
        int meta = event.world.func_72805_g(event.x, event.y, event.z);
        boolean result = false;
        Block currentBlock = Block.field_71973_m[id];
        if (currentBlock != null) {
            meta = currentBlock.func_71899_b(meta);
        }
        if (!(worldStack = new ItemStack(id, 1, meta)).func_77969_a(targetStack = new ItemStack(event.targetID, 1, event.targetMeta)) && EquivalencyHandler.instance().areWorldEquivalent(worldStack, targetStack) && event.itemStack != null && event.itemStack.func_77960_j() <= event.itemStack.func_77958_k()) {
            result = TransmutationHelper.transmuteInWorld(event.world, event.player, event.player.func_71045_bC(), event.x, event.y, event.z, event.targetID, event.targetMeta);
        }
        if (result) {
            event.actionResult = ActionEvent.ActionResult.SUCCESS;
            int currentSlot = event.player.field_71071_by.field_70461_c;
            event.itemStack.func_77972_a(ConfigurationSettings.TRANSMUTE_COST_BLOCK, (EntityLivingBase)event.player);
            if (event.itemStack.field_77994_a < 1) {
                event.player.field_71071_by.func_70299_a(currentSlot, null);
                PacketDispatcher.sendPacketToPlayer((Packet)PacketTypeHandler.populatePacket(new PacketItemUpdate((byte)currentSlot, 0)), (Player)((Player)event.player));
                event.player.field_70170_p.func_72956_a((Entity)event.player, "random.break", 0.8f, 0.8f + event.player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        } else {
            event.actionResult = ActionEvent.ActionResult.FAILURE;
        }
    }
}

