/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.helper;

import com.pahimar.ee3.api.OreStack;
import com.pahimar.ee3.api.WrappedStack;
import com.pahimar.ee3.emc.EmcRegistry;
import com.pahimar.ee3.emc.EmcValue;
import com.pahimar.ee3.helper.ItemHelper;
import com.pahimar.ee3.helper.LogHelper;
import com.pahimar.ee3.recipe.RecipeRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class DebugHelper {
    public static void printOreDictionaryContents() {
        List<String> oreNames = Arrays.asList(OreDictionary.getOreNames());
        Collections.sort(oreNames);
        for (String oreName : oreNames) {
            for (ItemStack itemStack : OreDictionary.getOres((String)oreName)) {
                LogHelper.debug(String.format("%s: %s", oreName, ItemHelper.toString(itemStack)));
            }
        }
    }

    public static void printOreStacksWithoutEmcValues() {
        List<String> oreNames = Arrays.asList(OreDictionary.getOreNames());
        Collections.sort(oreNames);
        for (String oreName : oreNames) {
            if (EmcRegistry.getInstance().hasEmcValue(new OreStack(oreName))) continue;
            LogHelper.debug(String.format("OreStack '%s' requires an EmcValue", oreName));
        }
    }

    public static void printRecipeRegistryContents() {
        ArrayList outputStacks = new ArrayList(RecipeRegistry.getInstance().getRecipeMappings().keySet());
        Collections.sort(outputStacks);
        for (WrappedStack outputStack : outputStacks) {
            for (List inputStacks : RecipeRegistry.getInstance().getRecipeMappings().get((Object)outputStack)) {
                LogHelper.debug(String.format("%s <--- %s", outputStack, inputStacks));
            }
        }
    }

    public static void printItemsWithoutEmcValues() {
        DebugHelper.printItemsWithoutEmcValues(null);
    }

    public static void printItemsWithoutEmcValues(String modid) {
        for (WrappedStack wrappedStack : RecipeRegistry.getInstance().getDiscoveredStacks()) {
            ItemStack itemStack;
            GameRegistry.UniqueIdentifier uniqueIdentifier;
            if (EmcRegistry.getInstance().hasEmcValue(wrappedStack) || !(wrappedStack.getWrappedStack() instanceof ItemStack) || (uniqueIdentifier = GameRegistry.findUniqueIdentifierFor((Item)(itemStack = (ItemStack)wrappedStack.getWrappedStack()).func_77973_b())) == null) continue;
            if (modid != null) {
                if (!uniqueIdentifier.modId.equalsIgnoreCase(modid)) continue;
                LogHelper.debug(String.format("Mod '%s': Object '%s' is lacking an EmcValue", uniqueIdentifier.modId, wrappedStack));
                continue;
            }
            LogHelper.debug(String.format("Mod '%s': Object '%s' is lacking an EmcValue", uniqueIdentifier.modId, wrappedStack));
        }
    }

    public static void printStackToEmcValueMappings() {
        LogHelper.debug(String.format("There are %s entries in the Stack to EmcValue map", EmcRegistry.getInstance().getStackToEmcValueMap().keySet().size()));
        for (WrappedStack wrappedStack : EmcRegistry.getInstance().getStackToEmcValueMap().keySet()) {
            LogHelper.debug(String.format("EmcValue for stack '%s': %s", wrappedStack, EmcRegistry.getInstance().getStackToEmcValueMap().get((Object)wrappedStack)));
        }
    }

    public static void printEmcValueToStackMappings() {
        LogHelper.debug(String.format("There are %s entries in the EmcValue to Stack map", EmcRegistry.getInstance().getEmcValueToStackMap().keySet().size()));
        for (EmcValue emcValue : EmcRegistry.getInstance().getEmcValueToStackMap().keySet()) {
            LogHelper.debug(String.format("Stacks(s) for EmcValue '%s': %s", emcValue, EmcRegistry.getInstance().getEmcValueToStackMap().get((Object)emcValue)));
        }
    }
}

