/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.helper;

import com.pahimar.ee3.api.WrappedStack;
import com.pahimar.ee3.emc.EmcRegistry;
import com.pahimar.ee3.emc.EmcType;
import com.pahimar.ee3.emc.EmcValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class EmcHelper {
    public static List<WrappedStack> filterStacksByEmc(List<WrappedStack> unfilteredStacks, EmcValue filterValue) {
        ArrayList<WrappedStack> filteredStacks = new ArrayList<WrappedStack>();
        for (WrappedStack stack : unfilteredStacks) {
            if (!EmcRegistry.getInstance().hasEmcValue(stack)) continue;
            EmcValue value = EmcRegistry.getInstance().getEmcValue(stack);
            boolean satisfiesFilter = true;
            float[] valueSubValues = value.components;
            float[] filterValueSubValues = filterValue.components;
            for (int i = 0; i < valueSubValues.length; ++i) {
                if (Float.compare(valueSubValues[i], filterValueSubValues[i]) >= 0) continue;
                satisfiesFilter = false;
            }
            if (!satisfiesFilter) continue;
            filteredStacks.add(stack);
        }
        return filteredStacks;
    }

    public static List<WrappedStack> filterStacksByEmcAndRange(float start, float end, EmcValue filterValue) {
        return EmcHelper.filterStacksByEmc(EmcRegistry.getInstance().getStacksInRange(start, end), filterValue);
    }

    public static EmcValue computeEmcValueFromList(List<WrappedStack> wrappedStacks) {
        float[] computedSubValues = new float[EmcType.TYPES.length];
        for (WrappedStack wrappedStack : wrappedStacks) {
            EmcValue wrappedStackValue;
            int stackSize = -1;
            if (wrappedStack.getWrappedStack() instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)wrappedStack.getWrappedStack();
                if (FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack) != null) {
                    if (itemStack.func_77973_b().getContainerItemStack(itemStack) != null) {
                        stackSize = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack).amount;
                        wrappedStackValue = EmcRegistry.getInstance().getEmcValue(FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack));
                    } else {
                        wrappedStackValue = EmcRegistry.getInstance().getEmcValue(wrappedStack);
                    }
                } else {
                    wrappedStackValue = itemStack.func_77973_b() != null && itemStack.func_77973_b().getContainerItemStack(itemStack) != null ? new EmcValue(0) : EmcRegistry.getInstance().getEmcValue(wrappedStack);
                }
            } else {
                wrappedStackValue = EmcRegistry.getInstance().getEmcValue(wrappedStack);
            }
            if (wrappedStackValue != null) {
                if (stackSize == -1) {
                    stackSize = wrappedStack.getStackSize();
                }
                for (EmcType emcType : EmcType.TYPES) {
                    int n = emcType.ordinal();
                    computedSubValues[n] = computedSubValues[n] + wrappedStackValue.components[emcType.ordinal()] * (float)stackSize;
                }
                continue;
            }
            return null;
        }
        return new EmcValue(computedSubValues);
    }

    public static EmcValue factorEmcValue(EmcValue emcValue, int factor) {
        return EmcHelper.factorEmcValue(emcValue, (float)factor);
    }

    public static EmcValue factorEmcValue(EmcValue emcValue, float factor) {
        if (Float.compare(factor, 0.0f) != 0 && emcValue != null) {
            float[] factorSubValues = emcValue.components;
            for (int i = 0; i < factorSubValues.length; ++i) {
                factorSubValues[i] = factorSubValues[i] * 1.0f / factor;
            }
            return new EmcValue(factorSubValues);
        }
        return emcValue;
    }
}

