/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.helper;

import java.util.Comparator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidHelper {
    public static Comparator<FluidStack> comparator = new Comparator<FluidStack>(){

        @Override
        public int compare(FluidStack fluidStack1, FluidStack fluidStack2) {
            if (fluidStack1 != null) {
                if (fluidStack2 != null) {
                    if (fluidStack1.fluidID == fluidStack2.fluidID) {
                        if (fluidStack1.amount == fluidStack2.amount) {
                            if (fluidStack1.tag != null) {
                                if (fluidStack2.tag != null) {
                                    return fluidStack1.tag.hashCode() - fluidStack2.tag.hashCode();
                                }
                                return -1;
                            }
                            if (fluidStack2.tag != null) {
                                return 1;
                            }
                            return 0;
                        }
                        return fluidStack1.amount - fluidStack2.amount;
                    }
                    return fluidStack1.fluidID - fluidStack2.fluidID;
                }
                return -1;
            }
            if (fluidStack2 != null) {
                return 1;
            }
            return 0;
        }
    };

    public static void registerFluids() {
        if (!FluidRegistry.isFluidRegistered((String)"milk")) {
            Fluid milk = new Fluid("milk"){

                public String getLocalizedName() {
                    return StatCollector.func_74838_a((String)"item.milk.name");
                }
            }.setUnlocalizedName(Item.field_77771_aG.func_77658_a());
            FluidRegistry.registerFluid((Fluid)milk);
            FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(milk, 1000), (ItemStack)new ItemStack(Item.field_77771_aG), (ItemStack)new ItemStack(Item.field_77788_aw));
        }
    }

    public static int compare(FluidStack fluidStack1, FluidStack fluidStack2) {
        return comparator.compare(fluidStack1, fluidStack2);
    }

    public static String toString(FluidStack fluidStack) {
        if (fluidStack != null) {
            return String.format("%sxfluidStack.%s", fluidStack.amount, fluidStack.getFluid().getName());
        }
        return "fluidStack[null]";
    }
}

