/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.helper;

import com.pahimar.ee3.configuration.ConfigurationSettings;
import com.pahimar.ee3.configuration.GeneralConfiguration;
import com.pahimar.ee3.helper.LogHelper;
import com.pahimar.ee3.lib.Reference;
import cpw.mods.fml.common.Loader;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import net.minecraft.util.StatCollector;

public class VersionHelper
implements Runnable {
    private static VersionHelper instance = new VersionHelper();
    private static final String REMOTE_VERSION_XML_FILE = "https://raw.github.com/pahimar/Equivalent-Exchange-3/master/version.xml";
    public static Properties remoteVersionProperties = new Properties();
    public static final byte UNINITIALIZED = 0;
    public static final byte CURRENT = 1;
    public static final byte OUTDATED = 2;
    public static final byte ERROR = 3;
    public static final byte FINAL_ERROR = 4;
    public static final byte MC_VERSION_NOT_FOUND = 5;
    private static byte result = 0;
    public static String remoteVersion = null;
    public static String remoteUpdateLocation = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkVersion() {
        InputStream remoteVersionRepoStream = null;
        result = 0;
        try {
            URL remoteVersionURL = new URL(REMOTE_VERSION_XML_FILE);
            remoteVersionRepoStream = remoteVersionURL.openStream();
            remoteVersionProperties.loadFromXML(remoteVersionRepoStream);
            String remoteVersionProperty = remoteVersionProperties.getProperty(Loader.instance().getMCVersionString());
            if (remoteVersionProperty != null) {
                String[] remoteVersionTokens = remoteVersionProperty.split("\\|");
                if (remoteVersionTokens.length >= 2) {
                    remoteVersion = remoteVersionTokens[0];
                    remoteUpdateLocation = remoteVersionTokens[1];
                } else {
                    result = (byte)3;
                }
                if (remoteVersion != null) {
                    if (!ConfigurationSettings.LAST_DISCOVERED_VERSION.equalsIgnoreCase(remoteVersion)) {
                        GeneralConfiguration.set("general", "version_check.last_discovered_version", remoteVersion);
                    }
                    result = remoteVersion.equalsIgnoreCase(VersionHelper.getVersionForCheck()) ? (byte)1 : (byte)2;
                }
            } else {
                result = (byte)5;
            }
        }
        catch (Exception e) {
        }
        finally {
            if (result == 0) {
                result = (byte)3;
            }
            try {
                if (remoteVersionRepoStream != null) {
                    remoteVersionRepoStream.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    private static String getVersionForCheck() {
        String[] versionTokens = Reference.VERSION_NUMBER.split(" ");
        if (versionTokens.length >= 1) {
            return versionTokens[0];
        }
        return Reference.VERSION_NUMBER;
    }

    public static void logResult() {
        if (result == 1 || result == 2) {
            LogHelper.info(VersionHelper.getResultMessage());
        } else {
            LogHelper.warning(VersionHelper.getResultMessage());
        }
    }

    public static String getResultMessage() {
        if (result == 0) {
            return StatCollector.func_74838_a((String)"version.ee3:uninitialized");
        }
        if (result == 1) {
            return StatCollector.func_74837_a((String)"version.ee3:current", (Object[])new Object[]{"Equivalent Exchange 3", Loader.instance().getMCVersionString()});
        }
        if (result == 2 && remoteVersion != null && remoteUpdateLocation != null) {
            return StatCollector.func_74837_a((String)"version.ee3:outdated", (Object[])new Object[]{"Equivalent Exchange 3", remoteVersion, Loader.instance().getMCVersionString(), remoteUpdateLocation});
        }
        if (result == 3) {
            return StatCollector.func_74838_a((String)"version.ee3:general_error");
        }
        if (result == 4) {
            return StatCollector.func_74838_a((String)"version.ee3:final_error");
        }
        if (result == 5) {
            return StatCollector.func_74837_a((String)"version.ee3:mc_version_not_found", (Object[])new Object[]{"Equivalent Exchange 3", Loader.instance().getMCVersionString()});
        }
        result = (byte)3;
        return StatCollector.func_74838_a((String)"version.ee3:general_error");
    }

    public static String getResultMessageForClient() {
        return StatCollector.func_74837_a((String)"version.ee3:outdated", (Object[])new Object[]{"\u00a7eEquivalent Exchange 3\u00a7f", "\u00a7e" + remoteVersion + "\u00a7f", "\u00a7e" + Loader.instance().getMCVersionString() + "\u00a7f", "\u00a7e" + remoteUpdateLocation + "\u00a7f"});
    }

    public static byte getResult() {
        return result;
    }

    @Override
    public void run() {
        LogHelper.info(StatCollector.func_74837_a((String)"version.ee3:init_log_message", (Object[])new Object[]{REMOTE_VERSION_XML_FILE}));
        try {
            for (int count = 0; count < 2 && (result == 0 || result == 3); ++count) {
                VersionHelper.checkVersion();
                VersionHelper.logResult();
                if (result != 0 && result != 3) continue;
                Thread.sleep(10000L);
            }
            if (result == 3) {
                result = (byte)4;
                VersionHelper.logResult();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void execute() {
        new Thread(instance).start();
    }
}

