/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.imc;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.api.OreStack;
import com.pahimar.ee3.api.RecipeMapping;
import com.pahimar.ee3.api.StackValueMapping;
import com.pahimar.ee3.api.WrappedStack;
import com.pahimar.ee3.emc.EmcRegistry;
import com.pahimar.ee3.emc.EmcValue;
import com.pahimar.ee3.emc.EmcValuesIMC;
import com.pahimar.ee3.recipe.RecipesIMC;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class InterModCommsHandler
implements ITickHandler,
IScheduledTickHandler {
    private static Gson gson = new Gson();

    public static void processIMCMessages(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            InterModCommsHandler.processIMCMessage(imcMessage);
        }
    }

    public static void processIMCMessage(FMLInterModComms.IMCMessage imcMessage) {
        String requestedOperation = imcMessage.key;
        if (requestedOperation.equalsIgnoreCase("recipe-add")) {
            InterModCommsHandler.processAddRecipeMessage(imcMessage);
        } else if (requestedOperation.equalsIgnoreCase("emc-assign-value-pre")) {
            InterModCommsHandler.processPreAssignEmcValueMessage(imcMessage);
        } else if (requestedOperation.equalsIgnoreCase("emc-assign-value-post")) {
            InterModCommsHandler.processPostAssignEmcValueMessage(imcMessage);
        } else if (requestedOperation.equalsIgnoreCase("emc-has-value")) {
            InterModCommsHandler.processHasEmcValueMessage(imcMessage);
        } else if (requestedOperation.equalsIgnoreCase("emc-get-value")) {
            InterModCommsHandler.processGetEmcValueMessage(imcMessage);
        } else if (requestedOperation.equalsIgnoreCase("emc-simple-assign-value-pre")) {
            InterModCommsHandler.processSimplePreAssignEmcValueMessage(imcMessage);
        } else if (requestedOperation.equalsIgnoreCase("emc-simple-assign-value-post")) {
            InterModCommsHandler.processSimplePostAssignEmcValueMessage(imcMessage);
        }
    }

    private static void processAddRecipeMessage(FMLInterModComms.IMCMessage imcMessage) {
        RecipeMapping recipeMapping;
        if (imcMessage.getMessageType() == String.class && (recipeMapping = RecipeMapping.createFromJson(imcMessage.getStringValue())) != null) {
            WrappedStack outputWrappedStack = recipeMapping.outputWrappedStack;
            List<WrappedStack> inputWrappedStacks = recipeMapping.inputWrappedStacks;
            RecipesIMC.addRecipe(outputWrappedStack, inputWrappedStacks);
        }
    }

    private static void processPreAssignEmcValueMessage(FMLInterModComms.IMCMessage imcMessage) {
        StackValueMapping stackValueMapping;
        if (imcMessage.getMessageType() == String.class && (stackValueMapping = StackValueMapping.createFromJson(imcMessage.getStringValue())) != null) {
            WrappedStack wrappedStack = stackValueMapping.wrappedStack;
            EmcValue emcValue = new EmcValue(stackValueMapping.emcValue.getValue());
            EmcValuesIMC.addPreAssignedValued(wrappedStack, emcValue);
        }
    }

    private static void processPostAssignEmcValueMessage(FMLInterModComms.IMCMessage imcMessage) {
        StackValueMapping stackValueMapping;
        if (imcMessage.getMessageType() == String.class && (stackValueMapping = StackValueMapping.createFromJson(imcMessage.getStringValue())) != null) {
            WrappedStack wrappedStack = stackValueMapping.wrappedStack;
            EmcValue emcValue = new EmcValue(stackValueMapping.emcValue.getValue());
            EmcValuesIMC.addPostAssignedValued(wrappedStack, emcValue);
        }
    }

    private static void processHasEmcValueMessage(FMLInterModComms.IMCMessage imcMessage) {
        ItemStack itemStack;
        if (imcMessage.getMessageType() == String.class) {
            WrappedStack wrappedStack = WrappedStack.createFromJson(imcMessage.getStringValue());
            if (wrappedStack != null) {
                FMLInterModComms.sendRuntimeMessage((Object)EquivalentExchange3.instance, (String)imcMessage.getSender(), (String)"emc-return-has-value", (String)String.format("%s==%s", imcMessage.getStringValue(), String.valueOf(EmcRegistry.getInstance().hasEmcValue(wrappedStack))));
            }
        } else if (imcMessage.getMessageType() == ItemStack.class && (itemStack = imcMessage.getItemStackValue()) != null) {
            FMLInterModComms.sendRuntimeMessage((Object)EquivalentExchange3.instance, (String)imcMessage.getSender(), (String)"emc-return-has-value", (String)String.format("%s==%s", gson.toJson((Object)itemStack), String.valueOf(EmcRegistry.getInstance().hasEmcValue(itemStack))));
        }
    }

    private static void processGetEmcValueMessage(FMLInterModComms.IMCMessage imcMessage) {
        if (imcMessage.getMessageType() == String.class) {
            WrappedStack wrappedStack = WrappedStack.createFromJson(imcMessage.getStringValue());
            if (wrappedStack != null) {
                FMLInterModComms.sendRuntimeMessage((Object)EquivalentExchange3.instance, (String)imcMessage.getSender(), (String)"emc-return-get-value", (String)String.format("%s==%s", imcMessage.getStringValue(), EmcRegistry.getInstance().getEmcValue(wrappedStack).toJson()));
            }
        } else if (imcMessage.getMessageType() == ItemStack.class) {
            ItemStack itemStack = imcMessage.getItemStackValue();
            FMLInterModComms.sendRuntimeMessage((Object)EquivalentExchange3.instance, (String)imcMessage.getSender(), (String)"emc-return-get-value", (String)String.format("%s==%s", gson.toJson((Object)itemStack), EmcRegistry.getInstance().getEmcValue(itemStack).toJson()));
        }
    }

    private static void processSimplePreAssignEmcValueMessage(FMLInterModComms.IMCMessage imcMessage) {
        NBTTagCompound tagCompound = imcMessage.getNBTValue();
        if (tagCompound.func_74764_b("emcValue")) {
            WrappedStack wrappedStack;
            EmcValue emcValue = new EmcValue(tagCompound.func_74760_g("emcValue"));
            if (tagCompound.func_74764_b("itemStack")) {
                wrappedStack = new WrappedStack(ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("itemStack")));
            } else if (tagCompound.func_74764_b("oreName")) {
                wrappedStack = new WrappedStack(new OreStack(tagCompound.func_74779_i("oreName")));
            } else {
                return;
            }
            EmcValuesIMC.addPreAssignedValued(wrappedStack, emcValue);
        }
    }

    private static void processSimplePostAssignEmcValueMessage(FMLInterModComms.IMCMessage imcMessage) {
        NBTTagCompound tagCompound = imcMessage.getNBTValue();
        if (tagCompound.func_74764_b("emcValue")) {
            WrappedStack wrappedStack;
            EmcValue emcValue = new EmcValue(tagCompound.func_74760_g("emcValue"));
            if (tagCompound.func_74764_b("itemStack")) {
                wrappedStack = new WrappedStack(ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("itemStack")));
            } else if (tagCompound.func_74764_b("oreName")) {
                wrappedStack = new WrappedStack(new OreStack(tagCompound.func_74779_i("oreName")));
            } else {
                return;
            }
            EmcValuesIMC.addPostAssignedValued(wrappedStack, emcValue);
        }
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        for (TickType tickType : type) {
            if (tickType != TickType.SERVER) continue;
            ImmutableList runtimeIMCMessages = FMLInterModComms.fetchRuntimeMessages((Object)EquivalentExchange3.instance);
            for (FMLInterModComms.IMCMessage imcMessage : runtimeIMCMessages) {
                InterModCommsHandler.processIMCMessage(imcMessage);
            }
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.SERVER);
    }

    public String getLabel() {
        return "Equivalent Exchange 3: " + this.getClass().getSimpleName();
    }

    public int nextTickSpacing() {
        return 20;
    }
}

