/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.inventory;

import com.pahimar.ee3.helper.ItemStackNBTHelper;
import com.pahimar.ee3.inventory.INBTTaggable;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryAlchemicalBag
implements IInventory,
INBTTaggable {
    public ItemStack parentItemStack;
    protected ItemStack[] inventory;
    protected String customName;

    public InventoryAlchemicalBag(ItemStack itemStack) {
        this.parentItemStack = itemStack;
        int size = itemStack.func_77960_j() == 1 ? 84 : (itemStack.func_77960_j() == 2 ? 117 : 48);
        this.inventory = new ItemStack[size];
        this.readFromNBT(itemStack.func_77978_p());
    }

    public void onGuiSaved(EntityPlayer entityPlayer) {
        this.parentItemStack = this.findParentItemStack(entityPlayer);
        if (this.parentItemStack != null) {
            this.save();
        }
    }

    public ItemStack findParentItemStack(EntityPlayer entityPlayer) {
        if (ItemStackNBTHelper.hasUUID(this.parentItemStack)) {
            UUID parentItemStackUUID = new UUID(this.parentItemStack.func_77978_p().func_74763_f("itemUUIDMostSig"), this.parentItemStack.func_77978_p().func_74763_f("itemUUIDLeastSig"));
            for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = entityPlayer.field_71071_by.func_70301_a(i);
                if (!ItemStackNBTHelper.hasUUID(itemStack) || itemStack.func_77978_p().func_74763_f("itemUUIDMostSig") != parentItemStackUUID.getMostSignificantBits() || itemStack.func_77978_p().func_74763_f("itemUUIDLeastSig") != parentItemStackUUID.getLeastSignificantBits()) continue;
                return itemStack;
            }
        }
        return null;
    }

    public boolean matchesUUID(UUID uuid) {
        return ItemStackNBTHelper.hasUUID(this.parentItemStack) && this.parentItemStack.func_77978_p().func_74763_f("itemUUIDLeastSig") == uuid.getLeastSignificantBits() && this.parentItemStack.func_77978_p().func_74763_f("itemUUIDMostSig") == uuid.getMostSignificantBits();
    }

    public void save() {
        NBTTagCompound nbtTagCompound = this.parentItemStack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            UUID uuid = UUID.randomUUID();
            nbtTagCompound.func_74772_a("itemUUIDMostSig", uuid.getMostSignificantBits());
            nbtTagCompound.func_74772_a("itemUUIDLeastSig", uuid.getLeastSignificantBits());
        }
        this.writeToNBT(nbtTagCompound);
        this.parentItemStack.func_77982_d(nbtTagCompound);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.inventory[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= decrementAmount) {
                this.func_70299_a(slotIndex, null);
            } else {
                itemStack = itemStack.func_77979_a(decrementAmount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (this.inventory[slotIndex] != null) {
            ItemStack itemStack = this.inventory[slotIndex];
            this.inventory[slotIndex] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        this.inventory[slotIndex] = itemStack;
    }

    public String func_70303_b() {
        return this.hasCustomName() ? this.getCustomName() : "container.ee3:alchemicalBag";
    }

    public boolean func_94042_c() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("Items")) {
            if (nbtTagCompound.func_74764_b("Items")) {
                NBTTagList tagList = nbtTagCompound.func_74761_m("Items");
                this.inventory = new ItemStack[this.func_70302_i_()];
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound tagCompound = (NBTTagCompound)tagList.func_74743_b(i);
                    byte slotIndex = tagCompound.func_74771_c("Slot");
                    if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
                    this.inventory[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
                }
            }
            if (nbtTagCompound.func_74764_b("display") && nbtTagCompound.func_74781_a("display").getClass().equals(NBTTagCompound.class) && nbtTagCompound.func_74775_l("display").func_74764_b("Name")) {
                this.customName = nbtTagCompound.func_74775_l("display").func_74779_i("Name");
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
    }

    public boolean hasCustomName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public String getCustomName() {
        return this.customName;
    }
}

