/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.helper.ItemHelper;
import com.pahimar.ee3.helper.ItemStackNBTHelper;
import com.pahimar.ee3.item.IDyeable;
import com.pahimar.ee3.item.ItemEE;
import com.pahimar.ee3.lib.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemAlchemicalBag
extends ItemEE
implements IDyeable {
    private static final String[] ALCHEMICAL_BAG_ICONS = new String[]{"open", "closed", "symbolTier1", "symbolTier2", "symbolTier3"};
    @SideOnly(value=Side.CLIENT)
    private Icon[] icons;

    public ItemAlchemicalBag(int id) {
        super(id);
        this.func_77627_a(true);
        this.func_77655_b("alchemicalBag");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int id, CreativeTabs creativeTab, List list) {
        for (int meta = 0; meta < 3; ++meta) {
            list.add(new ItemStack(id, 1, meta));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.icons = new Icon[ALCHEMICAL_BAG_ICONS.length];
        for (int i = 0; i < ALCHEMICAL_BAG_ICONS.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a(Strings.RESOURCE_PREFIX + "alchemicalBag" + "." + ALCHEMICAL_BAG_ICONS[i]);
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (!world.field_72995_K) {
            ItemStackNBTHelper.setUUID(itemStack);
            ItemStackNBTHelper.setBoolean(itemStack, "itemAlchemicalBagGuiOpen", true);
            entityPlayer.openGui((Object)EquivalentExchange3.instance, 4, entityPlayer.field_70170_p, (int)entityPlayer.field_70165_t, (int)entityPlayer.field_70163_u, (int)entityPlayer.field_70161_v);
        }
        return itemStack;
    }

    public boolean func_77651_p() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public Icon getIcon(ItemStack itemStack, int renderPass) {
        if (renderPass == 0) {
            if (ItemStackNBTHelper.hasTag(itemStack, "itemAlchemicalBagGuiOpen")) {
                return this.icons[0];
            }
            return this.icons[1];
        }
        return this.icons[2 + MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)3)];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int renderPass) {
        int bagColor = this.getColor(itemStack);
        if (bagColor < 0) {
            bagColor = Integer.parseInt("ffffff", 16);
        }
        return bagColor;
    }

    @Override
    public boolean hasColor(ItemStack itemStack) {
        return ItemHelper.hasColor(itemStack);
    }

    @Override
    public int getColor(ItemStack itemStack) {
        return ItemHelper.getColor(itemStack);
    }

    @Override
    public void setColor(ItemStack itemStack, int color) {
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemAlchemicalBag) {
            ItemHelper.setColor(itemStack, color);
        }
    }

    @Override
    public void removeColor(ItemStack itemStack) {
        NBTTagCompound displayTagCompound;
        NBTTagCompound nbtTagCompound;
        if (itemStack != null && (nbtTagCompound = itemStack.func_77978_p()) != null && (displayTagCompound = nbtTagCompound.func_74775_l("display")).func_74764_b("color")) {
            displayTagCompound.func_82580_o("color");
        }
    }
}

