/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.network.packet;

import com.pahimar.ee3.configuration.ConfigurationSettings;
import com.pahimar.ee3.network.PacketTypeHandler;
import com.pahimar.ee3.network.packet.PacketEE;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.Player;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;

public class PacketSoundEvent
extends PacketEE {
    public String playerName;
    public String soundName;
    public double x;
    public double y;
    public double z;
    public float volume;
    public float pitch;

    public PacketSoundEvent() {
        super(PacketTypeHandler.SOUND_EVENT, false);
    }

    public PacketSoundEvent(String playerName, String soundName, double x, double y, double z, float volume, float pitch) {
        super(PacketTypeHandler.SOUND_EVENT, false);
        this.playerName = playerName;
        this.soundName = soundName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.volume = volume;
        this.pitch = pitch;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeUTF(this.playerName);
        data.writeUTF(this.soundName);
        data.writeDouble(this.x);
        data.writeDouble(this.y);
        data.writeDouble(this.z);
        data.writeFloat(this.volume);
        data.writeFloat(this.pitch);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.playerName = data.readUTF();
        this.soundName = data.readUTF();
        this.x = data.readDouble();
        this.y = data.readDouble();
        this.z = data.readDouble();
        this.volume = data.readFloat();
        this.pitch = data.readFloat();
    }

    @Override
    public void execute(INetworkManager manager, Player player) {
        EntityPlayer thePlayer = (EntityPlayer)player;
        if (ConfigurationSettings.ENABLE_SOUNDS.equalsIgnoreCase("all")) {
            FMLClientHandler.instance().getClient().field_71416_A.func_77364_b(this.soundName, (float)this.x, (float)this.y, (float)this.z, this.volume, this.pitch);
        } else if (ConfigurationSettings.ENABLE_SOUNDS.equalsIgnoreCase("self") && thePlayer.field_71092_bJ.equalsIgnoreCase(this.playerName)) {
            FMLClientHandler.instance().getClient().field_71416_A.func_77364_b(this.soundName, (float)this.x, (float)this.y, (float)this.z, this.volume, this.pitch);
        }
    }
}

