/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.recipe;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.pahimar.ee3.api.WrappedStack;
import com.pahimar.ee3.item.crafting.RecipeAludel;
import com.pahimar.ee3.recipe.RecipesAludel;
import com.pahimar.ee3.recipe.RecipesFluidContainers;
import com.pahimar.ee3.recipe.RecipesIMC;
import com.pahimar.ee3.recipe.RecipesPotions;
import com.pahimar.ee3.recipe.RecipesVanilla;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RecipeRegistry {
    private static RecipeRegistry recipeRegistry = null;
    private Multimap<WrappedStack, List<WrappedStack>> recipeMap = HashMultimap.create();
    private List<WrappedStack> discoveredStacks = new ArrayList<WrappedStack>();

    private RecipeRegistry() {
        this.init();
    }

    public static RecipeRegistry getInstance() {
        if (recipeRegistry == null) {
            recipeRegistry = new RecipeRegistry();
        }
        return recipeRegistry;
    }

    private void init() {
        for (WrappedStack outputStack : RecipesVanilla.getVanillaRecipes().keySet()) {
            for (List inputStacks : RecipesVanilla.getVanillaRecipes().get((Object)outputStack)) {
                if (this.recipeMap.get((Object)outputStack).contains(inputStacks)) continue;
                this.recipeMap.put((Object)outputStack, (Object)inputStacks);
            }
        }
        for (WrappedStack outputStack : RecipesFluidContainers.getFluidContainerRecipes().keySet()) {
            for (List inputStacks : RecipesFluidContainers.getFluidContainerRecipes().get((Object)outputStack)) {
                if (this.recipeMap.get((Object)outputStack).contains(inputStacks)) continue;
                this.recipeMap.put((Object)outputStack, (Object)inputStacks);
            }
        }
        for (WrappedStack outputStack : RecipesPotions.getPotionRecipes().keySet()) {
            for (List inputStacks : RecipesPotions.getPotionRecipes().get((Object)outputStack)) {
                if (this.recipeMap.get((Object)outputStack).contains(inputStacks)) continue;
                this.recipeMap.put((Object)outputStack, (Object)inputStacks);
            }
        }
        for (RecipeAludel recipeAludel : RecipesAludel.getInstance().getRecipes()) {
            WrappedStack recipeOutput = new WrappedStack(recipeAludel.getRecipeOutput());
            List<WrappedStack> recipeInputs = recipeAludel.getRecipeInputsAsWrappedStacks();
            if (this.recipeMap.get((Object)recipeOutput).contains(recipeInputs)) continue;
            this.recipeMap.put((Object)recipeOutput, recipeInputs);
        }
        for (WrappedStack outputStack : RecipesIMC.getIMCRecipes().keySet()) {
            for (List inputStacks : RecipesIMC.getIMCRecipes().get((Object)outputStack)) {
                if (this.recipeMap.get((Object)outputStack).contains(inputStacks)) continue;
                this.recipeMap.put((Object)outputStack, (Object)inputStacks);
            }
        }
        this.discoverStacks();
    }

    public Multimap<WrappedStack, List<WrappedStack>> getRecipeMappings() {
        return RecipeRegistry.recipeRegistry.recipeMap;
    }

    public List<WrappedStack> getDiscoveredStacks() {
        return Collections.unmodifiableList(RecipeRegistry.recipeRegistry.discoveredStacks);
    }

    private void discoverStacks() {
        this.discoveredStacks = new ArrayList<WrappedStack>();
        for (WrappedStack recipeOutput : this.recipeMap.keySet()) {
            if (!this.discoveredStacks.contains(new WrappedStack(recipeOutput.getWrappedStack()))) {
                this.discoveredStacks.add(new WrappedStack(recipeOutput.getWrappedStack()));
            }
            for (List recipeInputList : this.recipeMap.get((Object)recipeOutput)) {
                for (WrappedStack recipeInput : recipeInputList) {
                    if (this.discoveredStacks.contains(new WrappedStack(recipeInput.getWrappedStack()))) continue;
                    this.discoveredStacks.add(new WrappedStack(recipeInput.getWrappedStack()));
                }
            }
        }
        for (int i = 0; i < Item.field_77698_e.length; ++i) {
            if (Item.field_77698_e[i] == null) continue;
            if (Item.field_77698_e[i].func_77614_k()) {
                for (int meta = 0; meta < 16; ++meta) {
                    WrappedStack wrappedItemStack = new WrappedStack(new ItemStack(Item.field_77698_e[i].field_77779_bT, 1, meta));
                    if (this.discoveredStacks.contains(wrappedItemStack)) continue;
                    this.discoveredStacks.add(wrappedItemStack);
                }
                continue;
            }
            WrappedStack wrappedItemStack = new WrappedStack(Item.field_77698_e[i]);
            if (this.discoveredStacks.contains(wrappedItemStack)) continue;
            this.discoveredStacks.add(wrappedItemStack);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        TreeSet set = new TreeSet();
        set.addAll(this.recipeMap.keySet());
        for (WrappedStack key : set) {
            Collection recipeMappings = this.recipeMap.get((Object)key);
            for (List recipeList : recipeMappings) {
                stringBuilder.append(String.format("Recipe Output: %s, Recipe Input: %s\n", key.toString(), recipeList.toString()));
            }
        }
        return stringBuilder.toString();
    }
}

