/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.tileentity;

import com.pahimar.ee3.helper.ItemHelper;
import com.pahimar.ee3.item.ItemAlchemicalDust;
import com.pahimar.ee3.item.crafting.RecipeAludel;
import com.pahimar.ee3.network.PacketTypeHandler;
import com.pahimar.ee3.network.packet.PacketTileWithItemUpdate;
import com.pahimar.ee3.recipe.RecipesAludel;
import com.pahimar.ee3.tileentity.TileEE;
import com.pahimar.ee3.tileentity.TileGlassBell;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.ForgeDirection;

public class TileAludel
extends TileEE
implements ISidedInventory {
    private ItemStack[] inventory = new ItemStack[4];
    public static final int INVENTORY_SIZE = 4;
    public static final int FUEL_INVENTORY_INDEX = 0;
    public static final int INPUT_INVENTORY_INDEX = 1;
    public static final int DUST_INVENTORY_INDEX = 2;
    public static final int OUTPUT_INVENTORY_INDEX = 3;
    public int deviceCookTime;
    public int fuelBurnTime;
    public int itemCookTime;
    public ItemStack outputItemStack;
    public boolean hasGlassBell = false;

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.inventory[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= decrementAmount) {
                this.func_70299_a(slotIndex, null);
            } else {
                itemStack = itemStack.func_77979_a(decrementAmount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slotIndex) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            this.func_70299_a(slotIndex, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        this.inventory[slotIndex] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return this.hasCustomName() ? this.getCustomName() : "container.ee3:aludel";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70315_b(int eventId, int eventData) {
        if (eventId == 1) {
            this.state = (byte)eventData;
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return true;
        }
        return super.func_70315_b(eventId, eventData);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTagCompound) {
        super.func_70307_a(nbtTagCompound);
        NBTTagList tagList = nbtTagCompound.func_74761_m("Items");
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = (NBTTagCompound)tagList.func_74743_b(i);
            byte slotIndex = tagCompound.func_74771_c("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        this.deviceCookTime = nbtTagCompound.func_74762_e("deviceCookTime");
        this.fuelBurnTime = nbtTagCompound.func_74762_e("fuelBurnTime");
        this.itemCookTime = nbtTagCompound.func_74762_e("itemCookTime");
        this.hasGlassBell = nbtTagCompound.func_74767_n("hasGlassBell");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTagCompound) {
        super.func_70310_b(nbtTagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
        nbtTagCompound.func_74768_a("deviceCookTime", this.deviceCookTime);
        nbtTagCompound.func_74768_a("fuelBurnTime", this.fuelBurnTime);
        nbtTagCompound.func_74768_a("itemCookTime", this.itemCookTime);
        nbtTagCompound.func_74757_a("hasGlassBell", this.hasGlassBell);
    }

    public boolean func_94042_c() {
        return this.hasCustomName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        switch (slotIndex) {
            case 0: {
                return TileEntityFurnace.func_70401_b((ItemStack)itemStack);
            }
            case 1: {
                return true;
            }
            case 2: {
                return itemStack.func_77973_b() instanceof ItemAlchemicalDust;
            }
        }
        return false;
    }

    public void func_70316_g() {
        boolean isBurning = this.deviceCookTime > 0;
        boolean sendUpdate = false;
        if (this.deviceCookTime > 0) {
            --this.deviceCookTime;
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.deviceCookTime == 0 && this.canInfuse()) {
                this.fuelBurnTime = this.deviceCookTime = TileEntityFurnace.func_70398_a((ItemStack)this.inventory[0]);
                if (this.deviceCookTime > 0) {
                    sendUpdate = true;
                    if (this.inventory[0] != null) {
                        --this.inventory[0].field_77994_a;
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = this.inventory[0].func_77973_b().getContainerItemStack(this.inventory[0]);
                        }
                    }
                }
            }
            if (this.deviceCookTime > 0 && this.canInfuse()) {
                ++this.itemCookTime;
                if (this.itemCookTime == 200) {
                    this.itemCookTime = 0;
                    this.infuseItem();
                    sendUpdate = true;
                }
            } else {
                this.itemCookTime = 0;
            }
            if (isBurning != this.deviceCookTime > 0) {
                sendUpdate = true;
            }
        }
        if (sendUpdate) {
            this.func_70296_d();
            this.state = this.deviceCookTime > 0 ? (byte)1 : 0;
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca, 1, (int)this.state);
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)128.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)this.func_70319_e());
            this.field_70331_k.func_72851_f(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int scale) {
        return this.itemCookTime * scale / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int scale) {
        if (this.fuelBurnTime > 0) {
            return this.deviceCookTime * scale / this.fuelBurnTime;
        }
        return 0;
    }

    private boolean canInfuse() {
        if (!this.hasGlassBell || this.inventory[1] == null || this.inventory[2] == null) {
            return false;
        }
        ItemStack infusedItemStack = RecipesAludel.getInstance().getResult(this.inventory[1], this.inventory[2]);
        if (infusedItemStack == null) {
            return false;
        }
        if (this.inventory[3] == null) {
            return true;
        }
        boolean outputEquals = this.inventory[3].func_77969_a(infusedItemStack);
        int mergedOutputStackSize = this.inventory[3].field_77994_a + infusedItemStack.field_77994_a;
        if (outputEquals) {
            return mergedOutputStackSize <= this.func_70297_j_() && mergedOutputStackSize <= infusedItemStack.func_77976_d();
        }
        return false;
    }

    public void infuseItem() {
        if (this.canInfuse()) {
            RecipeAludel recipe = RecipesAludel.getInstance().getRecipe(this.inventory[1], this.inventory[2]);
            if (this.inventory[3] == null) {
                this.inventory[3] = recipe.getRecipeOutput().func_77946_l();
            } else if (this.inventory[3].func_77969_a(recipe.getRecipeOutput())) {
                this.inventory[3].field_77994_a += recipe.getRecipeOutput().field_77994_a;
            }
            this.func_70298_a(1, recipe.getRecipeInputs()[0].getStackSize());
            this.func_70298_a(2, recipe.getRecipeInputs()[1].getStackSize());
        }
    }

    @Override
    public Packet func_70319_e() {
        ItemStack itemStack = this.inventory[3];
        if (itemStack != null && itemStack.field_77994_a > 0) {
            return PacketTypeHandler.populatePacket(new PacketTileWithItemUpdate(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.orientation, this.state, this.customName, itemStack.field_77993_c, itemStack.func_77960_j(), itemStack.field_77994_a, ItemHelper.getColor(itemStack)));
        }
        return PacketTypeHandler.populatePacket(new PacketTileWithItemUpdate(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.orientation, this.state, this.customName, -1, 0, 0, 0));
    }

    public void func_70296_d() {
        PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)128.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)this.func_70319_e());
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (this.hasGlassBell) {
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("TileAludel Data - ");
        for (int i = 0; i < this.inventory.length; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            if (this.inventory[i] != null) {
                stringBuilder.append(String.format("inventory[%d]: %s", i, this.inventory[i].toString()));
                continue;
            }
            stringBuilder.append(String.format("inventory[%d]: empty", i));
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == ForgeDirection.DOWN.ordinal()) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 3;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 1;
            nArray3[1] = 2;
            nArray = nArray3;
            nArray3[2] = 3;
        }
        return nArray;
    }

    public boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) instanceof TileGlassBell) {
            return this.func_94041_b(slotIndex, itemStack);
        }
        return false;
    }

    public boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        return slotIndex == 3;
    }
}

