/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.tileentity;

import com.pahimar.ee3.network.PacketTypeHandler;
import com.pahimar.ee3.network.packet.PacketTileCalcinator;
import com.pahimar.ee3.recipe.CalcinationManager;
import com.pahimar.ee3.tileentity.TileEE;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileCalcinator
extends TileEE
implements ISidedInventory {
    private ItemStack[] inventory = new ItemStack[4];
    public static final int INVENTORY_SIZE = 4;
    public static final int FUEL_INVENTORY_INDEX = 0;
    public static final int INPUT_INVENTORY_INDEX = 1;
    public static final int OUTPUT_LEFT_INVENTORY_INDEX = 2;
    public static final int OUTPUT_RIGHT_INVENTORY_INDEX = 3;
    public int deviceCookTime;
    public int fuelBurnTime;
    public int itemCookTime;
    public byte leftStackSize;
    public byte leftStackMeta;
    public byte rightStackSize;
    public byte rightStackMeta;
    public int itemSuckCoolDown = 0;
    private static final int DEFAULT_ITEM_SUCK_COOL_DOWN = 20;

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotIndex) {
        this.sendDustPileData();
        return this.inventory[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= decrementAmount) {
                this.func_70299_a(slotIndex, null);
            } else {
                itemStack = itemStack.func_77979_a(decrementAmount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slotIndex) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            this.func_70299_a(slotIndex, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        this.inventory[slotIndex] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return this.hasCustomName() ? this.getCustomName() : "container.ee3:calcinator";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public boolean func_70315_b(int eventId, int eventData) {
        if (eventId == 1) {
            this.state = (byte)eventData;
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return true;
        }
        if (eventId == 2) {
            this.leftStackSize = (byte)eventData;
            return true;
        }
        if (eventId == 3) {
            this.leftStackMeta = (byte)eventData;
            return true;
        }
        if (eventId == 4) {
            this.rightStackSize = (byte)eventData;
            return true;
        }
        if (eventId == 5) {
            this.rightStackMeta = (byte)eventData;
            return true;
        }
        return super.func_70315_b(eventId, eventData);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTagCompound) {
        super.func_70307_a(nbtTagCompound);
        NBTTagList tagList = nbtTagCompound.func_74761_m("Items");
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = (NBTTagCompound)tagList.func_74743_b(i);
            byte slotIndex = tagCompound.func_74771_c("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        this.deviceCookTime = nbtTagCompound.func_74762_e("deviceCookTime");
        this.fuelBurnTime = nbtTagCompound.func_74762_e("fuelBurnTime");
        this.itemCookTime = nbtTagCompound.func_74762_e("itemCookTime");
        this.itemSuckCoolDown = nbtTagCompound.func_74762_e("itemSuckCoolDown");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTagCompound) {
        super.func_70310_b(nbtTagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
        nbtTagCompound.func_74768_a("deviceCookTime", this.deviceCookTime);
        nbtTagCompound.func_74768_a("fuelBurnTime", this.fuelBurnTime);
        nbtTagCompound.func_74768_a("itemCookTime", this.itemCookTime);
        nbtTagCompound.func_74768_a("itemSuckCoolDown", this.itemSuckCoolDown);
    }

    public boolean func_94042_c() {
        return this.hasCustomName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        switch (slotIndex) {
            case 0: {
                return TileEntityFurnace.func_70401_b((ItemStack)itemStack);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void func_70316_g() {
        boolean isBurning = this.deviceCookTime > 0;
        boolean sendUpdate = false;
        if (this.deviceCookTime > 0) {
            --this.deviceCookTime;
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.deviceCookTime == 0 && this.canCalcinate()) {
                this.fuelBurnTime = this.deviceCookTime = TileEntityFurnace.func_70398_a((ItemStack)this.inventory[0]);
                if (this.deviceCookTime > 0) {
                    sendUpdate = true;
                    if (this.inventory[0] != null) {
                        --this.inventory[0].field_77994_a;
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = this.inventory[0].func_77973_b().getContainerItemStack(this.inventory[0]);
                        }
                    }
                }
            }
            if (this.deviceCookTime > 0 && this.canCalcinate()) {
                ++this.itemCookTime;
                if (this.itemCookTime == 200) {
                    this.itemCookTime = 0;
                    this.calcinateItem();
                    sendUpdate = true;
                }
            } else {
                this.itemCookTime = 0;
            }
            if (isBurning != this.deviceCookTime > 0) {
                sendUpdate = true;
            }
            if (this.itemSuckCoolDown > 0) {
                --this.itemSuckCoolDown;
            } else {
                if (TileCalcinator.suckItemsIntoCalcinator(this)) {
                    this.func_70296_d();
                }
                this.itemSuckCoolDown = 20;
            }
        }
        if (sendUpdate) {
            this.func_70296_d();
            this.state = this.deviceCookTime > 0 ? (byte)1 : 0;
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca, 1, (int)this.state);
            this.sendDustPileData();
            this.field_70331_k.func_72851_f(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int scale) {
        return this.itemCookTime * scale / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int scale) {
        if (this.fuelBurnTime > 0) {
            return this.deviceCookTime * scale / this.fuelBurnTime;
        }
        return 0;
    }

    private boolean canCalcinate() {
        if (this.inventory[1] == null) {
            return false;
        }
        ItemStack alchemicalDustStack = CalcinationManager.getCalcinationResult(this.inventory[1]);
        if (alchemicalDustStack == null) {
            return false;
        }
        if (this.inventory[2] == null || this.inventory[3] == null) {
            return true;
        }
        boolean leftEquals = this.inventory[2].func_77969_a(alchemicalDustStack);
        int leftResult = this.inventory[2].field_77994_a + alchemicalDustStack.field_77994_a;
        boolean rightEquals = this.inventory[3].func_77969_a(alchemicalDustStack);
        int rightResult = this.inventory[3].field_77994_a + alchemicalDustStack.field_77994_a;
        if (!leftEquals && !rightEquals) {
            return false;
        }
        if (leftEquals && !rightEquals) {
            return leftResult <= this.func_70297_j_() && leftResult <= alchemicalDustStack.func_77976_d();
        }
        if (!leftEquals) {
            return rightResult <= this.func_70297_j_() && rightResult <= alchemicalDustStack.func_77976_d();
        }
        return leftResult <= this.func_70297_j_() && leftResult <= alchemicalDustStack.func_77976_d() || rightResult <= this.func_70297_j_() && rightResult <= alchemicalDustStack.func_77976_d();
    }

    public void calcinateItem() {
        if (this.canCalcinate()) {
            ItemStack alchemicalDustStack = CalcinationManager.getCalcinationResult(this.inventory[1]);
            this.addItemStackToOutput(alchemicalDustStack.func_77946_l());
            --this.inventory[1].field_77994_a;
            if (this.inventory[1].field_77994_a <= 0) {
                this.inventory[1] = null;
            }
        }
    }

    private void addItemStackToOutput(ItemStack alchemicalDustStack) {
        int addedSize;
        int maxStackSize = Math.min(this.func_70297_j_(), alchemicalDustStack.func_77976_d());
        if (this.inventory[2] == null) {
            this.inventory[2] = alchemicalDustStack;
            return;
        }
        if (this.inventory[2].func_77969_a(alchemicalDustStack) && this.inventory[2].field_77994_a < maxStackSize) {
            addedSize = Math.min(alchemicalDustStack.field_77994_a, maxStackSize - this.inventory[2].field_77994_a);
            alchemicalDustStack.field_77994_a -= addedSize;
            this.inventory[2].field_77994_a += addedSize;
            if (alchemicalDustStack == null || alchemicalDustStack.field_77994_a == 0) {
                return;
            }
        }
        if (this.inventory[3] == null) {
            this.inventory[3] = alchemicalDustStack;
            return;
        }
        if (this.inventory[3].func_77969_a(alchemicalDustStack) && this.inventory[3].field_77994_a < maxStackSize) {
            addedSize = Math.min(alchemicalDustStack.field_77994_a, maxStackSize - this.inventory[3].field_77994_a);
            alchemicalDustStack.field_77994_a -= addedSize;
            this.inventory[3].field_77994_a += addedSize;
        }
    }

    public static boolean suckItemsIntoCalcinator(TileCalcinator calcinator) {
        EntityItem entityitem = TileEntityHopper.func_96119_a((World)calcinator.func_70314_l(), (double)calcinator.field_70329_l, (double)((double)calcinator.field_70330_m + 1.0), (double)calcinator.field_70327_n);
        return entityitem != null && TileEntityHopper.func_96114_a((IInventory)calcinator, (EntityItem)entityitem);
    }

    @Override
    public Packet func_70319_e() {
        return PacketTypeHandler.populatePacket(new PacketTileCalcinator(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.orientation, this.state, this.customName, (byte)this.getLeftStackSize(), (byte)this.getLeftStackMeta(), (byte)this.getRightStackSize(), (byte)this.getRightStackMeta()));
    }

    private int getLeftStackSize() {
        if (this.inventory[2] != null) {
            return this.inventory[2].field_77994_a;
        }
        return 0;
    }

    private int getLeftStackMeta() {
        if (this.inventory[2] != null) {
            return this.inventory[2].func_77960_j();
        }
        return 0;
    }

    private int getRightStackSize() {
        if (this.inventory[3] != null) {
            return this.inventory[3].field_77994_a;
        }
        return 0;
    }

    private int getRightStackMeta() {
        if (this.inventory[3] != null) {
            return this.inventory[3].func_77960_j();
        }
        return 0;
    }

    private void sendDustPileData() {
        if (this.func_70311_o() != null) {
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca, 2, this.getLeftStackSize());
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca, 3, this.getLeftStackMeta());
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca, 4, this.getRightStackSize());
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca, 5, this.getRightStackMeta());
        }
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == ForgeDirection.DOWN.ordinal()) {
            int[] nArray2 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 2;
            nArray = nArray2;
            nArray2[2] = 3;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 1;
            nArray3[1] = 2;
            nArray = nArray3;
            nArray3[2] = 3;
        }
        return nArray;
    }

    public boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        return this.func_94041_b(slotIndex, itemStack);
    }

    public boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        return slotIndex == 2 || slotIndex == 3;
    }
}

