/*
 * Decompiled with CFR 0.152.
 */
package universalcoins;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import universalcoins.UniversalCoins;

public class UCItemPricer {
    private static String itemsList = GameData.getItemRegistry().func_148742_b().toString();
    private static String blocksList = GameData.getBlockRegistry().func_148742_b().toString();
    private static Map<String, Integer> ucPriceMap = new HashMap<String, Integer>(0);
    private static String configPath = "config/universalcoins/";

    public static void initializeConfigs() {
        if (!new File(configPath).exists()) {
            UCItemPricer.buildInitialPricelistHashMap();
            try {
                UCItemPricer.loadDefaults();
            }
            catch (IOException e) {
                FMLLog.warning((String)"Universal Coins: Failed to load default configs", (Object[])new Object[0]);
                e.printStackTrace();
            }
            UCItemPricer.writePriceLists();
        }
    }

    public static void loadConfigs() {
        try {
            UCItemPricer.loadPricelists();
        }
        catch (IOException e) {
            FMLLog.warning((String)"Universal Coins: Failed to load config files", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public static void loadDefaults() throws IOException {
        String[] configList = new String[]{"defaultConfigs/minecraft.cfg", "defaultConfigs/universalcoins.cfg"};
        for (int i = 0; i < configList.length; ++i) {
            InputStream priceResource = UCItemPricer.class.getResourceAsStream(configList[i]);
            if (priceResource == null) {
                return;
            }
            String priceString = UCItemPricer.convertStreamToString(priceResource);
            UCItemPricer.updateInitialPricelistHashMap(priceString);
        }
    }

    private static String convertStreamToString(InputStream is) {
        Scanner scanner = new Scanner(is);
        Scanner s = scanner.useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        scanner.close();
        return result;
    }

    private static void updateInitialPricelistHashMap(String priceString) {
        StringTokenizer tokenizer = new StringTokenizer(priceString, "\n\r", false);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            String[] tempData = token.split("=");
            ucPriceMap.put(tempData[0], Integer.valueOf(tempData[1]));
        }
    }

    public static void buildInitialPricelistHashMap() {
        StringTokenizer tokenizer = new StringTokenizer(itemsList, ", ", false);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            token = token.replaceAll("\\]", "").replaceAll("\\[", "");
            ucPriceMap.put(token, new Integer(-1));
        }
        StringTokenizer tokenizer1 = new StringTokenizer(blocksList, ", ", false);
        while (tokenizer1.hasMoreElements()) {
            String token = tokenizer1.nextToken();
            token = token.replaceAll("\\]", "").replaceAll("\\[", "");
            ucPriceMap.put(token, new Integer(-1));
        }
    }

    public static void loadPricelists() throws IOException {
        File folder = new File(configPath);
        File[] configList = folder.listFiles();
        for (int i = 0; i < configList.length; ++i) {
            if (!configList[i].isFile()) continue;
            BufferedReader br = new BufferedReader(new FileReader(configList[i]));
            String tempString = "";
            while ((tempString = br.readLine()) != null) {
                String[] tempData = tempString.split("=");
                ucPriceMap.put(tempData[0], Integer.valueOf(tempData[1]));
            }
            br.close();
        }
    }

    public static void writePriceLists() {
        Set<Map.Entry<String, Integer>> set = ucPriceMap.entrySet();
        for (Map.Entry<String, Integer> me : set) {
            String keyname = me.getKey();
            String[] tempmodname = keyname.split("\\W", 2);
            String modname = tempmodname[0] + ".cfg";
            Path pathToFile = Paths.get(configPath + modname, new String[0]);
            try {
                Files.createDirectories(pathToFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                FMLLog.warning((String)"Universal Coins: Failed to create config file folders", (Object[])new Object[0]);
            }
            File modconfigfile = new File(configPath + modname);
            if (!modconfigfile.exists()) {
                try {
                    modconfigfile.createNewFile();
                }
                catch (IOException e) {
                    FMLLog.warning((String)"Universal Coins: Failed to create config file", (Object[])new Object[0]);
                }
            }
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(modconfigfile, true)));
                out.println(me.getKey() + "=" + me.getValue());
                out.close();
            }
            catch (IOException e) {
                FMLLog.warning((String)"Universal Coins: Failed to append to config file", (Object[])new Object[0]);
            }
        }
    }

    public static int getItemPrice(ItemStack itemStack) {
        if (itemStack == null) {
            return -1;
        }
        return UCItemPricer.getItemPrice(itemStack.func_77973_b());
    }

    private static int getItemPrice(Item item) {
        Integer ItemPrice = -1;
        String itemName = GameData.getItemRegistry().func_148750_c((Object)item);
        if (ucPriceMap.get(itemName) != null) {
            ItemPrice = ucPriceMap.get(itemName);
        }
        return ItemPrice;
    }

    public static ItemStack getRevenueStack(int itemPrice) {
        if (itemPrice <= 64) {
            return new ItemStack(UniversalCoins.itemCoin, itemPrice);
        }
        if (itemPrice <= 576) {
            return new ItemStack(UniversalCoins.itemSmallCoinStack, itemPrice / 9);
        }
        if (itemPrice <= 5184) {
            return new ItemStack(UniversalCoins.itemLargeCoinStack, itemPrice / 81);
        }
        return new ItemStack(UniversalCoins.itemCoinHeap, Math.min(itemPrice / 729, 64));
    }
}

