/*
 * Decompiled with CFR 0.152.
 */
package universalcoins;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import universalcoins.UCItemPricer;
import universalcoins.UniversalCoins;
import universalcoins.net.PacketTradingStation;

public class UCTileEntity
extends TileEntity
implements IInventory {
    private ItemStack[] inventory = new ItemStack[5];
    private final int invSize = 5;
    public static final int revenueSlot = 2;
    public static final int tradedItemSlot = 3;
    public static final int boughtItemsSlot = 4;
    public static final int coinInputSlot = 0;
    public static final int coinOutputSlot = 1;
    private static final int[] multiplier = new int[]{1, 9, 81, 729};
    private static final Item[] coins = new Item[]{UniversalCoins.itemCoin, UniversalCoins.itemSmallCoinStack, UniversalCoins.itemLargeCoinStack, UniversalCoins.itemCoinHeap};
    public int coinSum = 0;
    public int itemPrice;
    public boolean buyButtonActive = false;
    public boolean sellButtonActive = false;
    public boolean coinButtonActive = false;
    public boolean sStackButtonActive = false;
    public boolean isStackButtonActive = false;
    public boolean heapButtonActive = false;
    public boolean shiftPressed = false;
    public boolean bypassActive = false;

    public int func_70302_i_() {
        return 5;
    }

    public ItemStack func_70301_a(int i) {
        if (i >= 5) {
            return null;
        }
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] == null) {
            return null;
        }
        if (this.inventory[i].field_77994_a <= j) {
            ItemStack newStack = this.inventory[i];
            this.inventory[i] = null;
            return newStack;
        }
        ItemStack newStack = ItemStack.func_77944_b((ItemStack)this.inventory[i]);
        newStack.field_77994_a = j;
        this.inventory[i].field_77994_a -= j;
        return newStack;
    }

    public ItemStack func_70304_b(int i) {
        return this.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        int coinType;
        this.inventory[i] = itemStack;
        if (itemStack != null && i == 0 && (coinType = this.getCoinType(itemStack.func_77973_b())) != -1) {
            this.coinSum += itemStack.field_77994_a * multiplier[coinType];
            this.inventory[i] = null;
        }
    }

    private int getCoinType(Item item) {
        for (int i = 0; i < 4; ++i) {
            if (item != coins[i]) continue;
            return i;
        }
        return -1;
    }

    public String func_145825_b() {
        return "Universal Trade Station";
    }

    public boolean isInventoryNameLocalized() {
        return false;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        Item stackItem = itemstack.func_77973_b();
        if (i == 0) {
            return stackItem == UniversalCoins.itemCoin || stackItem == UniversalCoins.itemSmallCoinStack || stackItem == UniversalCoins.itemLargeCoinStack || stackItem == UniversalCoins.itemCoinHeap;
        }
        return i == 3;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        try {
            this.coinSum = tagCompound.func_74762_e("CoinsLeft");
        }
        catch (Throwable ex2) {
            this.coinSum = 0;
        }
        try {
            this.bypassActive = tagCompound.func_74767_n("Bypass");
        }
        catch (Throwable ex) {
            this.bypassActive = false;
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_82580_o("CoinsLeft");
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        tagCompound.func_74768_a("CoinsLeft", this.coinSum);
        tagCompound.func_74757_a("Bypass", this.bypassActive);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.activateBuySellButtons();
        this.activateRetrieveButtons();
    }

    private void activateBuySellButtons() {
        if (this.inventory[3] == null) {
            this.itemPrice = 0;
            this.buyButtonActive = false;
            this.sellButtonActive = false;
        } else {
            this.itemPrice = UCItemPricer.getItemPrice(this.inventory[3]);
            if (this.itemPrice == -1) {
                this.itemPrice = 0;
                this.buyButtonActive = false;
                this.sellButtonActive = false;
            } else {
                ItemStack revenueStack = UCItemPricer.getRevenueStack(this.itemPrice);
                this.sellButtonActive = this.bypassActive || this.inventory[2] == null || this.inventory[2].func_77973_b() == revenueStack.func_77973_b() && this.inventory[2].field_77994_a + revenueStack.field_77994_a <= 64;
                this.buyButtonActive = (this.inventory[4] == null || this.inventory[4].func_77973_b() == this.inventory[3].func_77973_b() && this.inventory[4].field_77994_a < this.inventory[3].func_77973_b().func_77639_j()) && this.coinSum >= this.itemPrice;
            }
        }
    }

    private void activateRetrieveButtons() {
        this.coinButtonActive = false;
        this.sStackButtonActive = false;
        this.isStackButtonActive = false;
        this.heapButtonActive = false;
        if (this.coinSum > 0) {
            boolean bl = this.coinButtonActive = this.inventory[1] == null || this.inventory[1].func_77973_b() == UniversalCoins.itemCoin && this.inventory[1].field_77994_a != 64;
        }
        if (this.coinSum >= 9) {
            boolean bl = this.sStackButtonActive = this.inventory[1] == null || this.inventory[1].func_77973_b() == UniversalCoins.itemSmallCoinStack && this.inventory[1].field_77994_a != 64;
        }
        if (this.coinSum >= 81) {
            boolean bl = this.isStackButtonActive = this.inventory[1] == null || this.inventory[1].func_77973_b() == UniversalCoins.itemLargeCoinStack && this.inventory[1].field_77994_a != 64;
        }
        if (this.coinSum >= 729) {
            this.heapButtonActive = this.inventory[1] == null || this.inventory[1].func_77973_b() == UniversalCoins.itemCoinHeap && this.inventory[1].field_77994_a != 64;
        }
    }

    public void setBypass(boolean newValue) {
        this.bypassActive = newValue;
        this.activateBuySellButtons();
    }

    public void onSellPressed() {
        this.onSellPressed(1);
    }

    public void onSellPressed(int amount) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            // empty if block
        }
        if (this.inventory[3] == null) {
            this.sellButtonActive = false;
            return;
        }
        if (amount > this.inventory[3].field_77994_a) {
            return;
        }
        this.itemPrice = UCItemPricer.getItemPrice(this.inventory[3]);
        if (this.itemPrice == -1) {
            this.sellButtonActive = false;
            return;
        }
        ItemStack revenueStack = UCItemPricer.getRevenueStack(this.itemPrice * amount);
        if (!this.bypassActive) {
            if (this.inventory[2] == null) {
                this.inventory[2] = revenueStack;
                this.inventory[3].field_77994_a -= amount;
                if (this.inventory[3].field_77994_a <= 0) {
                    this.inventory[3] = null;
                }
            } else if (this.inventory[2].func_77973_b() == revenueStack.func_77973_b() && this.inventory[2].field_77994_a + revenueStack.field_77994_a <= revenueStack.func_77976_d()) {
                this.inventory[2].field_77994_a += revenueStack.field_77994_a;
                this.inventory[3].field_77994_a -= amount;
                if (this.inventory[3].field_77994_a <= 0) {
                    this.inventory[3] = null;
                }
            } else {
                this.sellButtonActive = false;
            }
        } else {
            this.inventory[3].field_77994_a -= amount;
            if (this.inventory[3].field_77994_a <= 0) {
                this.inventory[3] = null;
            }
            this.coinSum += this.itemPrice * amount;
        }
    }

    public void onSellMaxPressed() {
        int amount = 0;
        if (this.inventory[3] == null && this.inventory[3] == null) {
            this.sellButtonActive = false;
            return;
        }
        this.itemPrice = UCItemPricer.getItemPrice(this.inventory[3]);
        if (this.itemPrice == -1) {
            this.sellButtonActive = false;
            return;
        }
        if (!this.bypassActive) {
            if (this.inventory[2] == null) {
                Integer totalRevenue = this.inventory[3].field_77994_a * this.itemPrice;
                ItemStack revenueStack = UCItemPricer.getRevenueStack(this.inventory[3].field_77994_a * this.itemPrice);
                amount = totalRevenue <= 46656 ? this.inventory[3].field_77994_a : 46656 / this.itemPrice;
            } else if (this.inventory[2].field_77994_a < 64) {
                int lastOK = 0;
                for (int i = 1; i <= this.inventory[3].field_77994_a; ++i) {
                    ItemStack revenueStack = UCItemPricer.getRevenueStack(i * this.itemPrice);
                    if (revenueStack.func_77973_b() != this.inventory[2].func_77973_b() || this.inventory[2].field_77994_a + revenueStack.field_77994_a > 64) continue;
                    lastOK = i;
                }
                amount = lastOK;
            }
        } else {
            amount = this.inventory[3].field_77994_a;
        }
        if (amount != 0) {
            this.onSellPressed(amount);
        }
    }

    public void onBuyPressed() {
        this.onBuyPressed(1);
    }

    public void onBuyPressed(int amount) {
        if (this.inventory[3] == null) {
            this.buyButtonActive = false;
            return;
        }
        this.itemPrice = UCItemPricer.getItemPrice(this.inventory[3]);
        if (this.itemPrice == -1 || this.coinSum < this.itemPrice * amount) {
            this.buyButtonActive = false;
            return;
        }
        if (this.inventory[4] == null && this.inventory[3].func_77976_d() >= amount) {
            this.coinSum -= this.itemPrice * amount;
            this.inventory[4] = ItemStack.func_77944_b((ItemStack)this.inventory[3]);
            this.inventory[4].field_77994_a = amount;
        } else if (this.inventory[4].func_77973_b() == this.inventory[3].func_77973_b() && this.inventory[4].func_77960_j() == this.inventory[3].func_77960_j() && this.inventory[4].field_77994_a + amount <= this.inventory[3].func_77976_d()) {
            this.coinSum -= this.itemPrice * amount;
            this.inventory[4].field_77994_a += amount;
        } else {
            this.buyButtonActive = false;
        }
    }

    public void onBuyMaxPressed() {
        int amount = 0;
        if (this.inventory[3] == null) {
            this.buyButtonActive = false;
            return;
        }
        this.itemPrice = UCItemPricer.getItemPrice(this.inventory[3]);
        if (this.itemPrice == -1 || this.coinSum < this.itemPrice) {
            this.buyButtonActive = false;
            return;
        }
        if (this.inventory[4] == null) {
            amount = this.inventory[3].func_77976_d() * this.itemPrice <= this.coinSum ? this.inventory[3].func_77976_d() : this.coinSum / this.itemPrice;
        } else if (this.inventory[4].func_77973_b() == this.inventory[3].func_77973_b() && this.inventory[4].func_77960_j() == this.inventory[3].func_77960_j() && this.inventory[4].field_77994_a < this.inventory[3].func_77973_b().func_77639_j()) {
            amount = (this.inventory[4].func_77976_d() - this.inventory[4].field_77994_a) * this.itemPrice <= this.coinSum ? this.inventory[4].func_77976_d() - this.inventory[4].field_77994_a : this.coinSum / this.itemPrice;
        } else {
            this.buyButtonActive = false;
        }
        this.onBuyPressed(amount);
    }

    public void onRetrieveButtonsPressed(int buttonClickedID, boolean shiftPressed) {
        int absoluteButton = buttonClickedID - 2;
        int multiplier = 1;
        for (int i = 0; i < absoluteButton; ++i) {
            multiplier *= 9;
        }
        Item itemOnButton = coins[absoluteButton];
        if (this.coinSum < multiplier || this.inventory[1] != null && this.inventory[1].func_77973_b() != itemOnButton || this.inventory[1] != null && this.inventory[1].field_77994_a == 64) {
            return;
        }
        if (shiftPressed) {
            if (this.inventory[1] == null) {
                int amount = this.coinSum / multiplier;
                if (amount >= 64) {
                    this.coinSum -= multiplier * 64;
                    this.inventory[1] = new ItemStack(itemOnButton);
                    this.inventory[1].field_77994_a = 64;
                } else {
                    this.coinSum -= multiplier * amount;
                    this.inventory[1] = new ItemStack(itemOnButton);
                    this.inventory[1].field_77994_a = amount;
                }
            }
        } else {
            this.coinSum -= multiplier;
            if (this.inventory[1] == null) {
                this.inventory[1] = new ItemStack(itemOnButton);
            } else {
                ++this.inventory[1].field_77994_a;
            }
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void sendPacket(int button, boolean shiftPressed) {
        PacketTradingStation packet = new PacketTradingStation(this.field_145851_c, this.field_145848_d, this.field_145849_e, button, shiftPressed, this.bypassActive);
        UniversalCoins.packetPipeline.sendToServer(packet);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void onInventoryChanged() {
    }
}

