/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns.boxes;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.boxes.GunBoxType;
import com.flansmod.common.guns.boxes.ItemGunBox;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockGunBox
extends Block {
    public GunBoxType type;

    public BlockGunBox(GunBoxType t) {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(4.0f);
        this.type = t;
        this.type.block = this;
        GameRegistry.registerBlock((Block)this, ItemGunBox.class, (String)("gunBox." + this.type.shortName));
        this.func_149647_a(FlansMod.tabFlanGuns);
    }

    public void buyGun(int i, InventoryPlayer inventory, GunBoxType type) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            FlansMod.proxy.buyGun(type, i);
        }
        if (i <= type.numGuns && type.guns[i] != null) {
            ItemStack stack;
            int j;
            boolean canBuy = true;
            for (ItemStack check : type.gunParts[i]) {
                int numMatchingStuff = 0;
                for (j = 0; j < inventory.func_70302_i_(); ++j) {
                    stack = inventory.func_70301_a(j);
                    if (stack == null || stack.func_77973_b() != check.func_77973_b() || stack.func_77960_j() != check.func_77960_j()) continue;
                    numMatchingStuff += stack.field_77994_a;
                }
                if (numMatchingStuff >= check.field_77994_a) continue;
                canBuy = false;
            }
            if (canBuy) {
                for (ItemStack remove : type.gunParts[i]) {
                    int amountLeft = remove.field_77994_a;
                    for (j = 0; j < inventory.func_70302_i_(); ++j) {
                        stack = inventory.func_70301_a(j);
                        if (amountLeft <= 0 || stack == null || stack.func_77973_b() != remove.func_77973_b() || stack.func_77960_j() != remove.func_77960_j()) continue;
                        amountLeft -= inventory.func_70298_a((int)j, (int)amountLeft).field_77994_a;
                    }
                }
                ItemStack gunStack = new ItemStack(type.guns[i].getItem());
                if (type.guns[i] instanceof GunType) {
                    GunType gunType = (GunType)type.guns[i];
                    NBTTagCompound tags = new NBTTagCompound();
                    tags.func_74778_a("Paint", gunType.defaultPaintjob.iconName);
                    gunStack.field_77990_d = tags;
                }
                if (!inventory.func_70441_a(gunStack)) {
                    inventory.field_70458_d.func_71019_a(gunStack, false);
                }
            }
        }
    }

    public void buyAmmo(int i, InventoryPlayer inventory, GunBoxType type) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            FlansMod.proxy.buyAmmo(type, i, 1);
        }
        if (i <= type.numGuns && type.bulletParts[i] != null) {
            ItemStack stack;
            int j;
            boolean canBuy = true;
            for (ItemStack check : type.bulletParts[i]) {
                int numMatchingStuff = 0;
                for (j = 0; j < inventory.func_70302_i_(); ++j) {
                    stack = inventory.func_70301_a(j);
                    if (stack == null || stack.func_77973_b() != check.func_77973_b() || stack.func_77960_j() != check.func_77960_j()) continue;
                    numMatchingStuff += stack.field_77994_a;
                }
                if (numMatchingStuff >= check.field_77994_a) continue;
                canBuy = false;
            }
            if (canBuy) {
                for (ItemStack remove : type.bulletParts[i]) {
                    int amountLeft = remove.field_77994_a;
                    for (j = 0; j < inventory.func_70302_i_(); ++j) {
                        stack = inventory.func_70301_a(j);
                        if (amountLeft <= 0 || stack == null || stack.func_77973_b() != remove.func_77973_b() || stack.func_77960_j() != remove.func_77960_j()) continue;
                        amountLeft -= inventory.func_70298_a((int)j, (int)amountLeft).field_77994_a;
                    }
                }
                if (!inventory.func_70441_a(new ItemStack(type.bullets[i].getItem()))) {
                    // empty if block
                }
            }
        }
    }

    public void buyAltAmmo(int i, InventoryPlayer inventory, GunBoxType type) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            FlansMod.proxy.buyAmmo(type, i, 2);
        }
        if (i <= type.numGuns && type.altBulletParts[i] != null) {
            ItemStack stack;
            int j;
            boolean canBuy = true;
            for (ItemStack check : type.altBulletParts[i]) {
                int numMatchingStuff = 0;
                for (j = 0; j < inventory.func_70302_i_(); ++j) {
                    stack = inventory.func_70301_a(j);
                    if (stack == null || stack.func_77973_b() != check.func_77973_b() || stack.func_77960_j() != check.func_77960_j()) continue;
                    numMatchingStuff += stack.field_77994_a;
                }
                if (numMatchingStuff >= check.field_77994_a) continue;
                canBuy = false;
            }
            if (canBuy) {
                for (ItemStack remove : type.altBulletParts[i]) {
                    int amountLeft = remove.field_77994_a;
                    for (j = 0; j < inventory.func_70302_i_(); ++j) {
                        stack = inventory.func_70301_a(j);
                        if (amountLeft <= 0 || stack == null || stack.func_77973_b() != remove.func_77973_b() || stack.func_77960_j() != remove.func_77960_j()) continue;
                        amountLeft -= inventory.func_70298_a((int)j, (int)amountLeft).field_77994_a;
                    }
                }
                if (!inventory.func_70441_a(new ItemStack(type.altBullets[i].getItem()))) {
                    // empty if block
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (this.type == null) {
            return null;
        }
        if (side == 1) {
            return this.type.top;
        }
        if (side == 0) {
            return this.type.bottom;
        }
        return this.type.side;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        if (entityplayer.func_70093_af()) {
            return false;
        }
        entityplayer.openGui((Object)FlansMod.INSTANCE, 5, world, i, j, k);
        return true;
    }

    public Block purchaseItem(int i, int id, InventoryPlayer inventory, GunBoxType type) {
        switch (i) {
            case 0: {
                this.buyGun(id, inventory, type);
                break;
            }
            case 1: {
                this.buyAmmo(id, inventory, type);
                break;
            }
            case 2: {
                this.buyAltAmmo(id, inventory, type);
            }
        }
        return this;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, 0));
        return ret;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.type.top = register.func_94245_a("FlansMod:" + this.type.topTexturePath);
        this.type.side = register.func_94245_a("FlansMod:" + this.type.sideTexturePath);
        this.type.bottom = register.func_94245_a("FlansMod:" + this.type.bottomTexturePath);
    }
}

