/*
 * Decompiled with CFR 0.152.
 */
package jinngine.collision;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jinngine.collision.BroadphaseCollisionDetection;
import jinngine.geometry.BoundingBox;
import jinngine.geometry.Geometry;
import jinngine.math.Vector3;
import jinngine.util.Pair;

public class ExhaustiveSearch
implements BroadphaseCollisionDetection {
    private final Set<Pair<Geometry>> existingPairs = new LinkedHashSet<Pair<Geometry>>();
    private final Set<Pair<Geometry>> leavingPairs = new LinkedHashSet<Pair<Geometry>>();
    private final List<Geometry> geometries = new ArrayList<Geometry>();
    private final List<BroadphaseCollisionDetection.Handler> handlers = new ArrayList<BroadphaseCollisionDetection.Handler>();

    public ExhaustiveSearch() {
    }

    public ExhaustiveSearch(BroadphaseCollisionDetection.Handler handler) {
        this.handlers.add(handler);
    }

    @Override
    public void run() {
        this.leavingPairs.addAll(this.existingPairs);
        int size = this.geometries.size();
        for (int i = 0; i < size; ++i) {
            Geometry c1 = this.geometries.get(i);
            for (int j = i + 1; j < size; ++j) {
                Geometry c2 = this.geometries.get(j);
                if (c1 == c2 || !ExhaustiveSearch.overlap(c1, c2)) continue;
                Pair<Geometry> pair = new Pair<Geometry>(c1, c2);
                if (!this.existingPairs.contains(pair)) {
                    this.existingPairs.add(pair);
                    for (BroadphaseCollisionDetection.Handler handler : this.handlers) {
                        handler.overlap(pair);
                    }
                }
                this.leavingPairs.remove(pair);
            }
        }
        for (Pair<Geometry> pair : this.leavingPairs) {
            for (BroadphaseCollisionDetection.Handler handler : this.handlers) {
                handler.separation(pair);
            }
            this.existingPairs.remove(pair);
        }
        this.leavingPairs.clear();
    }

    private static final boolean overlap(BoundingBox i, BoundingBox j) {
        Vector3 bi = i.getMinBounds();
        Vector3 ei = i.getMaxBounds();
        Vector3 bj = j.getMinBounds();
        Vector3 ej = j.getMaxBounds();
        double bix = bi.x;
        double biy = bi.y;
        double biz = bi.z;
        double eix = ei.x;
        double eiy = ei.y;
        double eiz = ei.z;
        double bjx = bj.x;
        double bjy = bj.y;
        double bjz = bj.z;
        double ejx = ej.x;
        double ejy = ej.y;
        double ejz = ej.z;
        return (bjx < bix && bix <= ejx || bix <= bjx && bjx < eix) && (bjy < biy && biy <= ejy || biy <= bjy && bjy < eiy) && (bjz < biz && biz <= ejz || biz <= bjz && bjz < eiz);
    }

    @Override
    public void add(Geometry a) {
        this.geometries.add(a);
    }

    @Override
    public void remove(Geometry a) {
        this.geometries.remove(a);
    }

    @Override
    public void addHandler(BroadphaseCollisionDetection.Handler h) {
        this.handlers.add(h);
    }

    @Override
    public void removeHandler(BroadphaseCollisionDetection.Handler h) {
        this.handlers.remove(h);
    }

    @Override
    public Set<Pair<Geometry>> getOverlappingPairs() {
        return new LinkedHashSet<Pair<Geometry>>(this.existingPairs);
    }
}

