/*
 * Decompiled with CFR 0.152.
 */
package jinngine.collision;

import jinngine.geometry.SupportMap3;
import jinngine.math.Vector3;

public class GJK {
    private final State state = new State();

    public State getState() {
        return this.state;
    }

    public void run(SupportMap3 Sa, SupportMap3 Sb, Vector3 va, Vector3 vb, double envelope, double epsilon, int maxiter) {
        if (this.state.v.norm() <= envelope) {
            this.state.v.assign(1.0, 1.0, 1.0);
        }
        this.state.iterations = 0;
        Vector3 v = this.state.v;
        Vector3 w = this.state.w;
        Vector3 sa = new Vector3();
        Vector3 sb = new Vector3();
        sa.assign(Sa.supportPoint(this.state.v.multiply(-1.0)));
        sb.assign(Sb.supportPoint(this.state.v.multiply(1.0)));
        w.assign(sa.minus(sb));
        if (v.normalize().dot(w) > envelope) {
            va.assign(sa);
            vb.assign(sb);
            this.state.intersection = false;
            return;
        }
        if (this.state.simplexSize > 0) {
            this.updateSimplex(this.state, Sa, Sb);
        }
        do {
            ++this.state.iterations;
            sa.assign(Sa.supportPoint(this.state.v.multiply(-1.0)));
            sb.assign(Sb.supportPoint(this.state.v.multiply(1.0)));
            w.assign(sa.minus(sb));
            if (Math.abs(v.dot(v) - v.dot(w)) < epsilon * epsilon || this.state.iterations > maxiter || this.state.simplexSize > 3) break;
            if (v.normalize().dot(w) > envelope) {
                this.state.intersection = false;
                break;
            }
            Vector3[] row = this.state.simplices[this.state.permutation[this.state.simplexSize]];
            row[0] = w.copy();
            row[1] = sa.copy();
            row[2] = sb.copy();
            row[3] = v.copy();
            ++this.state.simplexSize;
            if (!this.reduceSimplex(this.state)) break;
            v.assignZero();
            for (int i = 0; i < this.state.simplexSize; ++i) {
                Vector3.add(v, this.state.simplices[this.state.permutation[i]][0].multiply(this.state.lambda[this.state.permutation[i]]));
            }
        } while (!v.cutOff(epsilon).equals(Vector3.zero) && this.state.simplexSize <= 3);
        this.state.v.assignZero();
        this.state.p.assignZero();
        this.state.q.assignZero();
        for (int i = 0; i < this.state.simplexSize; ++i) {
            Vector3.add(this.state.v, this.state.simplices[this.state.permutation[i]][0].multiply(this.state.lambda[this.state.permutation[i]]));
            Vector3.add(this.state.p, this.state.simplices[this.state.permutation[i]][1].multiply(this.state.lambda[this.state.permutation[i]]));
            Vector3.add(this.state.q, this.state.simplices[this.state.permutation[i]][2].multiply(this.state.lambda[this.state.permutation[i]]));
        }
        va.assign(this.state.p);
        vb.assign(this.state.q);
        if (va.minus(vb).norm() < epsilon || this.state.simplexSize > 3) {
            this.state.intersection = true;
        }
    }

    private final void updateSimplex(State state, SupportMap3 Sa, SupportMap3 Sb) {
        int i;
        for (i = 0; i < state.simplexSize; ++i) {
            Vector3[] row = state.simplices[state.permutation[i]];
            row[1] = Sa.supportPoint(state.simplices[i][3].multiply(-1.0));
            row[2] = Sb.supportPoint(state.simplices[i][3].multiply(1.0));
            row[0] = row[1].minus(row[2]);
        }
        this.reduceSimplex(state);
        state.v.assign(Vector3.zero);
        for (i = 0; i < state.simplexSize; ++i) {
            Vector3.add(state.v, state.simplices[state.permutation[i]][0].multiply(state.lambda[state.permutation[i]]));
        }
    }

    private final Vector3 support(SupportMap3 Sa, SupportMap3 Sb, Vector3 v) {
        Vector3 sva = Sa.supportPoint(v);
        Vector3 svb = Sb.supportPoint(v.multiply(-1.0));
        return sva.minus(svb);
    }

    private final void swap(int i, int j, int[] permutation) {
        int temp = permutation[i];
        permutation[i] = permutation[j];
        permutation[j] = temp;
    }

    private final boolean reduceSimplex(State state) {
        Vector3[][] matrix = state.simplices;
        double[] lambda = state.lambda;
        int[] perm = state.permutation;
        double epsilon = 1.0E-15;
        if (state.simplexSize == 1) {
            lambda[perm[0]] = 1.0;
            state.simplexSize = 1;
            return true;
        }
        if (state.simplexSize == 2) {
            Vector3[] row0 = matrix[perm[0]];
            Vector3[] row1 = matrix[perm[1]];
            Vector3 y1 = row0[0];
            Vector3 y2 = row1[0];
            double d12_1 = y2.minus(y1).dot(y2);
            double d12_2 = y1.minus(y2).dot(y1);
            if (d12_2 <= 0.0) {
                lambda[perm[0]] = 1.0;
                state.simplexSize = 1;
                return false;
            }
            if (d12_1 <= 0.0) {
                this.swap(1, 0, perm);
                lambda[perm[0]] = 1.0;
                state.simplexSize = 1;
                return true;
            }
            double d12 = d12_1 + d12_2;
            if (Math.abs(d12) <= 1.0E-15) {
                state.simplexSize = 1;
                return false;
            }
            if (d12_1 > 0.0 && d12_2 > 0.0) {
                lambda[perm[0]] = d12_1 / d12;
                lambda[perm[1]] = d12_2 / d12;
                return true;
            }
            state.simplexSize = 1;
            return false;
        }
        if (state.simplexSize == 3) {
            Vector3[] row0 = matrix[perm[0]];
            Vector3[] row1 = matrix[perm[1]];
            Vector3[] row2 = matrix[perm[2]];
            Vector3 y1 = row0[0];
            Vector3 y2 = row1[0];
            Vector3 y3 = row2[0];
            double d13_3 = y1.minus(y3).dot(y1);
            double d12_2 = y1.minus(y2).dot(y1);
            if (d12_2 <= 0.0 && d13_3 <= 0.0) {
                lambda[perm[0]] = 1.0;
                state.simplexSize = 1;
                return true;
            }
            double d12_1 = y2.minus(y1).dot(y2);
            double d23_3 = y2.minus(y3).dot(y2);
            if (d12_1 <= 0.0 && d23_3 <= 0.0) {
                this.swap(1, 0, perm);
                lambda[perm[0]] = 1.0;
                state.simplexSize = 1;
                return true;
            }
            double d13_1 = y3.minus(y1).dot(y3);
            double d23_2 = y3.minus(y2).dot(y3);
            if (d23_2 <= 0.0 && d13_1 <= 0.0) {
                this.swap(2, 0, perm);
                lambda[perm[0]] = 1.0;
                state.simplexSize = 1;
                return true;
            }
            double d23 = d23_2 + d23_3;
            double d13 = d13_1 + d13_3;
            double d12 = d12_1 + d12_2;
            double d123_1 = d23_2 * y2.minus(y1).dot(y2) + d23_3 * y2.minus(y1).dot(y3);
            if (d123_1 <= 0.0 && d23_2 > 0.0 && d23_3 > 0.0) {
                this.swap(1, 0, perm);
                this.swap(2, 1, perm);
                lambda[perm[0]] = d23_2 / d23;
                lambda[perm[1]] = d23_3 / d23;
                state.simplexSize = 2;
                return true;
            }
            double d123_2 = d13_1 * y1.minus(y2).dot(y1) + d13_3 * y1.minus(y2).dot(y3);
            if (d123_2 <= 0.0 && d13_1 > 0.0 && d13_3 > 0.0) {
                this.swap(2, 1, perm);
                lambda[perm[0]] = d13_1 / d13;
                lambda[perm[1]] = d13_3 / d13;
                state.simplexSize = 2;
                return true;
            }
            double d123_3 = d12_1 * y1.minus(y3).dot(y1) + d12_2 * y1.minus(y3).dot(y2);
            if (d123_3 <= 0.0 && d12_1 > 0.0 && d12_2 > 0.0) {
                lambda[perm[0]] = d12_1 / d12;
                lambda[perm[1]] = d12_2 / d12;
                state.simplexSize = 2;
                return false;
            }
            double d123 = d123_1 + d123_2 + d123_3;
            if (d123_1 > 0.0 && d123_2 > 0.0 && d123_3 > 0.0) {
                lambda[perm[0]] = d123_1 / d123;
                lambda[perm[1]] = d123_2 / d123;
                lambda[perm[2]] = d123_3 / d123;
                state.simplexSize = 3;
                return true;
            }
            lambda[perm[0]] = d12_1 / d12;
            lambda[perm[1]] = d12_2 / d12;
            state.simplexSize = 2;
            return false;
        }
        if (state.simplexSize == 4) {
            Vector3[] row0 = matrix[perm[0]];
            Vector3[] row1 = matrix[perm[1]];
            Vector3[] row2 = matrix[perm[2]];
            Vector3[] row3 = matrix[perm[3]];
            Vector3 y1 = row0[0];
            Vector3 y2 = row1[0];
            Vector3 y3 = row2[0];
            Vector3 y4 = row3[0];
            double d13_3 = y1.minus(y3).dot(y1);
            double d12_2 = y1.minus(y2).dot(y1);
            double d14_4 = y1.minus(y4).dot(y1);
            if (d12_2 <= 0.0 && d13_3 <= 0.0 && d14_4 <= 0.0) {
                lambda[perm[0]] = 1.0;
                state.simplexSize = 1;
                return true;
            }
            double d12_1 = y2.minus(y1).dot(y2);
            double d23_3 = y2.minus(y3).dot(y2);
            double d24_4 = y2.minus(y4).dot(y2);
            if (d12_1 <= 0.0 && d23_3 <= 0.0 && d24_4 <= 0.0) {
                this.swap(1, 0, perm);
                lambda[perm[0]] = 1.0;
                state.simplexSize = 1;
                return true;
            }
            double d13_1 = y3.minus(y1).dot(y3);
            double d23_2 = y3.minus(y2).dot(y3);
            double d34_4 = y3.minus(y4).dot(y3);
            if (d23_2 <= 0.0 && d13_1 <= 0.0 && d34_4 <= 0.0) {
                this.swap(2, 0, perm);
                lambda[perm[0]] = 1.0;
                state.simplexSize = 1;
                return true;
            }
            double d14_1 = y4.minus(y1).dot(y4);
            double d24_2 = y4.minus(y2).dot(y4);
            double d34_3 = y4.minus(y3).dot(y4);
            if (d14_1 <= 0.0 && d24_2 <= 0.0 && d34_3 <= 0.0) {
                this.swap(3, 0, perm);
                lambda[perm[0]] = 1.0;
                state.simplexSize = 1;
                return true;
            }
            double d12 = d12_1 + d12_2;
            double d13 = d13_1 + d13_3;
            double d14 = d14_1 + d14_4;
            double d23 = d23_2 + d23_3;
            double d24 = d24_2 + d24_4;
            double d34 = d34_3 + d34_4;
            double d123_3 = d12_1 * y1.minus(y3).dot(y1) + d12_2 * y1.minus(y3).dot(y2);
            double d124_4 = d12_1 * y1.minus(y4).dot(y1) + d12_2 * y1.minus(y4).dot(y2);
            if (d12_1 > 0.0 && d12_2 > 0.0 && d123_3 <= 0.0 && d124_4 <= 0.0) {
                lambda[perm[0]] = d12_1 / d12;
                lambda[perm[1]] = d12_2 / d12;
                state.simplexSize = 2;
                return true;
            }
            double d123_2 = d13_1 * y1.minus(y2).dot(y1) + d13_3 * y1.minus(y2).dot(y3);
            double d134_4 = d13_1 * y1.minus(y4).dot(y1) + d13_3 * y1.minus(y4).dot(y3);
            if (d13_1 > 0.0 && d13_3 > 0.0 && d123_2 <= 0.0 && d134_4 <= 0.0) {
                this.swap(2, 1, perm);
                lambda[perm[0]] = d13_1 / d13;
                lambda[perm[1]] = d13_3 / d13;
                state.simplexSize = 2;
                return true;
            }
            double d124_2 = d14_1 * y1.minus(y2).dot(y1) + d14_4 * y1.minus(y2).dot(y4);
            double d134_3 = d14_1 * y1.minus(y3).dot(y1) + d14_4 * y1.minus(y3).dot(y4);
            if (d14_1 > 0.0 && d14_4 > 0.0 && d124_2 <= 0.0 && d134_3 <= 0.0) {
                this.swap(3, 1, perm);
                lambda[perm[0]] = d14_1 / d14;
                lambda[perm[1]] = d14_4 / d14;
                state.simplexSize = 2;
                return true;
            }
            double d123_1 = d23_2 * y2.minus(y1).dot(y2) + d23_3 * y2.minus(y1).dot(y3);
            double d234_4 = d23_2 * y2.minus(y4).dot(y2) + d23_3 * y2.minus(y4).dot(y3);
            if (d23_2 > 0.0 && d23_3 > 0.0 && d123_1 <= 0.0 && d234_4 <= 0.0) {
                this.swap(1, 0, perm);
                this.swap(3, 1, perm);
                lambda[perm[0]] = d23_2 / d23;
                lambda[perm[1]] = d23_3 / d23;
                state.simplexSize = 2;
                return true;
            }
            double d124_1 = d24_2 * y2.minus(y1).dot(y2) + d24_4 * y2.minus(y1).dot(y4);
            double d234_3 = d24_2 * y2.minus(y3).dot(y2) + d24_4 * y2.minus(y3).dot(y4);
            if (d24_2 > 0.0 && d24_4 > 0.0 && d124_1 <= 0.0 && d234_3 <= 0.0) {
                this.swap(1, 0, perm);
                this.swap(3, 1, perm);
                lambda[perm[0]] = d24_2 / d24;
                lambda[perm[1]] = d24_4 / d24;
                state.simplexSize = 2;
                return true;
            }
            double d134_1 = d34_3 * y3.minus(y1).dot(y3) + d34_4 * y3.minus(y1).dot(y4);
            double d234_2 = d34_3 * y3.minus(y2).dot(y3) + d34_4 * y3.minus(y2).dot(y4);
            if (d34_3 > 0.0 && d34_4 > 0.0 && d134_1 <= 0.0 && d234_2 <= 0.0) {
                this.swap(2, 0, perm);
                this.swap(1, 3, perm);
                lambda[perm[0]] = d34_3 / d34;
                lambda[perm[1]] = d34_4 / d34;
                state.simplexSize = 2;
                return true;
            }
            double d1234_4 = d123_1 * y1.minus(y4).dot(y1) + d123_2 * y1.minus(y4).dot(y2) + d123_3 * y1.minus(y4).dot(y3);
            if (d123_1 > 0.0 && d123_2 > 0.0 && d123_3 > 0.0 && d1234_4 <= 0.0) {
                double d123 = d123_1 + d123_2 + d123_3;
                lambda[perm[0]] = d123_1 / d123;
                lambda[perm[1]] = d123_2 / d123;
                lambda[perm[2]] = d123_3 / d123;
                state.simplexSize = 3;
                return false;
            }
            double d1234_3 = d124_1 * y1.minus(y3).dot(y1) + d124_2 * y1.minus(y3).dot(y2) + d124_4 * y1.minus(y3).dot(y4);
            if (d124_1 > 0.0 && d124_2 > 0.0 && d124_4 > 0.0 && d1234_3 <= 0.0) {
                double d124 = d124_1 + d124_2 + d124_4;
                this.swap(3, 2, perm);
                lambda[perm[0]] = d124_1 / d124;
                lambda[perm[1]] = d124_2 / d124;
                lambda[perm[2]] = d124_4 / d124;
                state.simplexSize = 3;
                return true;
            }
            double d1234_2 = d134_1 * y1.minus(y2).dot(y1) + d134_3 * y1.minus(y2).dot(y3) + d134_4 * y1.minus(y2).dot(y4);
            if (d134_1 > 0.0 && d134_3 > 0.0 && d134_4 > 0.0 && d1234_2 <= 0.0) {
                double d134 = d134_1 + d134_3 + d134_4;
                this.swap(2, 1, perm);
                this.swap(3, 2, perm);
                lambda[perm[0]] = d134_1 / d134;
                lambda[perm[1]] = d134_3 / d134;
                lambda[perm[2]] = d134_4 / d134;
                state.simplexSize = 3;
                return true;
            }
            double d1234_1 = d234_2 * y2.minus(y1).dot(y2) + d234_3 * y2.minus(y1).dot(y3) + d234_4 * y2.minus(y1).dot(y4);
            if (d234_2 > 0.0 && d234_3 > 0.0 && d234_4 > 0.0 && d1234_1 <= 0.0) {
                double d234 = d234_2 + d234_3 + d234_4;
                this.swap(1, 0, perm);
                this.swap(2, 1, perm);
                this.swap(3, 2, perm);
                lambda[perm[0]] = d234_2 / d234;
                lambda[perm[1]] = d234_3 / d234;
                lambda[perm[2]] = d234_4 / d234;
                state.simplexSize = 3;
                return true;
            }
            double d1234 = d1234_1 + d1234_2 + d1234_3 + d1234_4;
            if (d1234_1 > 0.0 && d1234_2 > 0.0 && d1234_3 > 0.0 && d1234_4 > 0.0) {
                if (y1.multiply(d1234_1 / d1234).add(y2.multiply(d1234_2 / d1234)).add(y3.multiply(d1234_3 / d1234)).add(y4.multiply(d1234_4 / d1234)).norm() > 1.0) {
                    state.simplexSize = 3;
                    return false;
                }
                lambda[perm[0]] = d1234_1 / d1234;
                lambda[perm[1]] = d1234_2 / d1234;
                lambda[perm[2]] = d1234_3 / d1234;
                lambda[perm[3]] = d1234_4 / d1234;
                state.simplexSize = 4;
                return true;
            }
            double d123 = d123_1 + d123_2 + d123_3;
            lambda[perm[0]] = d123_1 / d123;
            lambda[perm[1]] = d123_2 / d123;
            lambda[perm[2]] = d123_3 / d123;
            state.simplexSize = 3;
            return false;
        }
        return false;
    }

    public final class State {
        public final Vector3 v = new Vector3(1.0, 1.0, 1.0);
        public final Vector3 w = new Vector3();
        public final Vector3 p = new Vector3();
        public final Vector3 q = new Vector3();
        public final Vector3[][] simplices = new Vector3[4][4];
        public final double[] lambda = new double[]{1.0, 0.0, 0.0, 0.0};
        public final int[] permutation = new int[]{0, 1, 2, 3};
        public int simplexSize;
        public int iterations = 0;
        public boolean intersection = false;
    }
}

