/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jinngine.geometry.Geometry;
import jinngine.math.InertiaMatrix;
import jinngine.math.Matrix3;
import jinngine.math.Matrix4;
import jinngine.math.Quaternion;
import jinngine.math.Transforms;
import jinngine.math.Vector3;
import jinngine.physics.State;

public final class Body {
    public final String identifier;
    public final Vector3 deltavelocity = new Vector3(0.0, 0.0, 0.0);
    public final Vector3 deltaomega = new Vector3(0.0, 0.0, 0.0);
    public final Vector3 externaldeltavelocity = new Vector3();
    public final Vector3 externaldeltaomega = new Vector3();
    public boolean deactivated = false;
    public final Vector3 deactivatedexternalforce = new Vector3();
    public final Vector3 deactivatedexternaltorque = new Vector3();
    public final Vector3 auxDeltav = new Vector3();
    public final Vector3 auxDeltaOmega = new Vector3();
    public final Vector3 auxDeltav2 = new Vector3();
    public final Vector3 auxDeltaOmega2 = new Vector3();
    public final State state = new State();
    private final List<Geometry> geometries = new ArrayList<Geometry>();
    private boolean fixed = false;

    public Body(String identifier) {
        this.identifier = new String(identifier);
        Matrix4.identity(this.state.transform);
        Matrix3.identity(this.state.rotation);
        this.updateTransformations();
        this.state.mass = 0.0;
        Matrix3.set(new Matrix3(), (Matrix3)this.state.inertia);
    }

    public Body(String identifier, Geometry g) {
        this.identifier = new String(identifier);
        Matrix4.identity(this.state.transform);
        Matrix3.identity(this.state.rotation);
        this.updateTransformations();
        this.state.mass = 1.0;
        Matrix3.set(new Matrix3(), (Matrix3)this.state.inertia);
        Matrix3.set(new Matrix3(), this.state.inverseinertia);
        this.addGeometry(g);
        this.finalize();
    }

    public Body(String identifier, Iterator<Geometry> i) {
        this.identifier = new String(identifier);
        Matrix4.identity(this.state.transform);
        Matrix3.identity(this.state.rotation);
        this.updateTransformations();
        this.state.mass = 1.0;
        Matrix3.set(new Matrix3(), (Matrix3)this.state.inertia);
        Matrix3.set(new Matrix3(), this.state.inverseinertia);
        while (i.hasNext()) {
            this.addGeometry(i.next());
        }
        this.finalize();
    }

    public void addGeometry(Geometry g) {
        this.geometries.add(g);
    }

    public final void finalize() {
        Vector3 cm = this.state.centreofmass;
        this.state.mass = 0.0;
        Matrix3.set(new Matrix3(), (Matrix3)this.state.inertia);
        Matrix3.set(new Matrix3(), this.state.inverseinertia);
        if (this.geometries.size() > 0) {
            Vector3 b;
            Matrix3 R;
            cm.assignZero();
            double totalMass = 0.0;
            for (Geometry g : this.geometries) {
                g.setBody(this);
                totalMass += g.getMass();
                R = new Matrix3();
                b = new Vector3();
                g.getLocalTransform(R, b);
                cm.assign(cm.add(b.multiply(g.getMass())));
            }
            if (Math.abs(totalMass) < 1.0E-14) {
                totalMass = 1.0;
            }
            cm.assign(cm.multiply(1.0 / totalMass));
            this.state.mass = totalMass;
            for (Geometry g : this.geometries) {
                R = new Matrix3();
                b = new Vector3();
                g.getLocalTransform(R, b);
                b.assign(b.minus(cm));
                InertiaMatrix Im = InertiaMatrix.rotate(g.getInertialMatrix(), R).translate(g.getMass(), b);
                Matrix3.add(this.state.inertia, Im, this.state.inertia);
                g.setLocalTransform(R, b);
            }
            Matrix3.inverse(this.state.inertia, this.state.inverseinertia);
        } else {
            this.state.mass = 1.0;
            this.state.inertia.assign(InertiaMatrix.identity());
        }
    }

    public Iterator<Geometry> getGeometries() {
        return this.geometries.iterator();
    }

    public final void applyImpulseToMomentums(Vector3 r, Vector3 J) {
        if (!this.isFixed()) {
            Vector3.add(this.state.P, J);
            Vector3.add(this.state.L, r.cross(J));
            Matrix3.multiply(this.state.inverseinertia, this.state.L, this.state.omega);
            this.state.velocity.assign(this.state.P.multiply(1.0 / this.state.mass));
        }
    }

    public void updateMomentums() {
        Matrix3.multiply((Matrix3)this.state.inertia, this.state.omega, this.state.L);
        this.state.P.assign(this.state.velocity.multiply(this.state.mass));
    }

    public final boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean value) {
        this.fixed = value;
    }

    public final void setVelocity(Vector3 v) {
        this.state.velocity.assign(v);
        this.state.P.assign(this.state.velocity.multiply(this.state.mass));
    }

    public final void setVelocity(double x, double y, double z) {
        this.state.velocity.assign(x, y, z);
        this.state.P.assign(this.state.velocity.multiply(this.state.mass));
    }

    public final Vector3 getVelocity() {
        return new Vector3(this.state.velocity);
    }

    public final void setPosition(Vector3 r) {
        this.state.position.assign(r);
        this.updateTransformations();
    }

    public final void setPosition(double x, double y, double z) {
        this.state.position.x = x;
        this.state.position.y = y;
        this.state.position.z = z;
        this.updateTransformations();
    }

    public final void setOrientation(Matrix3 orientation) {
        this.state.orientation.assign(orientation);
        this.updateTransformations();
    }

    public final Matrix3 getOrientation() {
        return new Matrix3(this.state.rotation);
    }

    public final Vector3 getPosition() {
        return new Vector3(this.state.position);
    }

    public final void updateTransformations() {
        Matrix3.identity(this.state.rotation);
        Matrix4.identity(this.state.transform);
        Matrix3.set(this.state.orientation.toRotationMatrix3(), this.state.rotation);
        Matrix4.multiply(Transforms.rotateAndTranslate4(this.state.orientation, this.state.position), this.state.transform, this.state.transform);
        Matrix3.inverse(this.state.rotation, this.state.inverserotation);
    }

    public final Matrix4 getTransform() {
        return this.state.transform;
    }

    public final void setAngularVelocity(Vector3 omega) {
        this.state.omega.assign(omega);
        Matrix3.multiply((Matrix3)this.state.inertia, this.state.omega, this.state.L);
    }

    public final void setAngularVelocity(double x, double y, double z) {
        this.state.omega.assign(x, y, z);
        Matrix3.multiply((Matrix3)this.state.inertia, this.state.omega, this.state.L);
    }

    public final Vector3 getAngularVelocity() {
        return new Vector3(this.state.omega);
    }

    public final double getMass() {
        return this.state.mass;
    }

    public final void clearForces() {
        this.state.force.assign(new Vector3(0.0, 0.0, 0.0));
        this.state.torque.assign(new Vector3(0.0, 0.0, 0.0));
    }

    public final void applyForce(Vector3 point, Vector3 F, double dt) {
        if (!this.isFixed()) {
            Vector3.add(this.state.torque, point.cross(F));
            Vector3.add(this.state.force, F);
            Vector3.multiply(this.state.force, 1.0 / this.state.mass, this.state.acceleration);
            Vector3.add(this.externaldeltavelocity, F.multiply(dt / this.state.mass));
            Vector3.add(this.externaldeltaomega, this.state.inverseinertia.multiply(point.cross(F)).multiply(dt));
        }
    }

    public final double totalKinetic() {
        Vector3 res = new Vector3();
        Matrix3.multiply(this.state.inverseinertia, this.state.L, this.state.omega);
        res = Matrix3.transposeVectorAndMultiply(this.state.omega, this.state.inertia, res);
        double eKin = res.dot(this.state.omega) * 0.5;
        Vector3.multiply(this.state.P, 1.0 / this.state.mass, this.state.velocity);
        return Math.abs(eKin += this.state.velocity.dot(this.state.velocity) * this.state.mass * 0.5);
    }

    public final void advanceVelocities(double dt) {
        Vector3.add(this.state.P, this.state.force.multiply(dt));
        Vector3.multiply(this.state.P, 1.0 / this.state.mass, this.state.velocity);
        Vector3.add(this.state.L, this.state.torque.multiply(dt));
        Matrix3.multiply(this.state.inverseinertia, this.state.L, this.state.omega);
    }

    public final void advancePositions(double dt) {
        Vector3.add(this.state.position, this.state.velocity.multiply(dt));
        this.state.orientationderivative.assign(0.0, this.state.omega.multiply(0.5));
        Quaternion.sMultiply(this.state.orientationderivative, this.state.orientation);
        Quaternion.add(this.state.orientation, this.state.orientationderivative.multiply(dt));
        this.state.orientation.normalize();
        this.updateTransformations();
    }

    public final Vector3 toModel(Vector3 v) {
        return this.state.rotation.transpose().multiply(v.minus(this.state.position));
    }

    public final Vector3 toModelNoTranslation(Vector3 v) {
        return Matrix3.multiply(this.state.inverserotation, v, new Vector3());
    }

    public final Vector3 toWorld(Vector3 v) {
        return this.state.rotation.multiply(v).add(this.state.position);
    }

    public final Vector3 toWorldNoTranslation(Vector3 v) {
        return Matrix3.multiply(this.state.rotation, v, new Vector3());
    }

    public final Vector3 translate(Vector3 v) {
        return v.add(this.state.position);
    }

    public String toString() {
        return this.identifier + ":" + super.toString();
    }
}

