/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import jinngine.physics.Body;
import jinngine.physics.Scene;
import jinngine.physics.Trigger;
import jinngine.physics.constraint.Constraint;
import jinngine.physics.constraint.contact.ContactConstraint;
import jinngine.physics.constraint.contact.ContactConstraintManager;
import jinngine.physics.solver.Solver;
import jinngine.util.Pair;

public class ContactTrigger
implements Trigger {
    private final Body body;
    private final double impulsethreshold;
    private final Callback callback;
    private double totalforce = 0.0;
    private int numberOfNcpConstraints = 0;
    private ContactConstraintManager.Handler contactConstraintHandler;
    private final List<ContactConstraint> monitoredconstraints = new ArrayList<ContactConstraint>();
    private final List<ContactConstraint> triggeredconstraints = new ArrayList<ContactConstraint>();

    public ContactTrigger(Body body, double impulsethreshold, Callback callback) {
        this.body = body;
        this.impulsethreshold = impulsethreshold;
        this.callback = callback;
    }

    @Override
    public void update(Scene s) {
        ListIterator<ContactConstraint> monitored = this.monitoredconstraints.listIterator();
        while (monitored.hasNext()) {
            ContactConstraint constraint = monitored.next();
            this.totalforce = 0.0;
            this.numberOfNcpConstraints = 0;
            Iterator<Solver.NCPConstraint> ncps = constraint.getNcpConstraints();
            while (ncps.hasNext()) {
                Solver.NCPConstraint ncp = ncps.next();
                this.totalforce += ncp.lambda;
                ++this.numberOfNcpConstraints;
            }
            if (!(this.totalforce > this.impulsethreshold)) continue;
            monitored.remove();
            this.triggeredconstraints.add(constraint);
            Pair<Body> bodies = constraint.getBodies();
            Body interacting = bodies.getFirst() == this.body ? bodies.getSecond() : bodies.getFirst();
            this.callback.contactAboveThreshold(interacting, constraint);
        }
        ListIterator<ContactConstraint> triggered = this.triggeredconstraints.listIterator();
        while (triggered.hasNext()) {
            ContactConstraint constraint = triggered.next();
            this.totalforce = 0.0;
            this.numberOfNcpConstraints = 0;
            Iterator<Solver.NCPConstraint> ncps = constraint.getNcpConstraints();
            while (ncps.hasNext()) {
                Solver.NCPConstraint ncp = ncps.next();
                this.totalforce += ncp.lambda;
                ++this.numberOfNcpConstraints;
            }
            if (!(this.totalforce < this.impulsethreshold)) continue;
            triggered.remove();
            this.monitoredconstraints.add(constraint);
            Pair<Body> bodies = constraint.getBodies();
            Body interacting = bodies.getFirst() == this.body ? bodies.getSecond() : bodies.getFirst();
            this.callback.contactBelowThreshold(interacting, constraint);
        }
    }

    @Override
    public void cleanup(Scene scene) {
        ContactConstraintManager manager = scene.getContactConstraintManager();
        manager.removeHandler(this.contactConstraintHandler);
    }

    @Override
    public void setup(Scene scene) {
        Iterator<Constraint> iter = scene.getConstraints(this.body);
        while (iter.hasNext()) {
            Constraint constraint = iter.next();
            if (!(constraint instanceof ContactConstraint)) continue;
            this.monitoredconstraints.add((ContactConstraint)constraint);
        }
        this.contactConstraintHandler = new ContactConstraintManager.Handler(){

            @Override
            public void contactConstraintCreated(Pair<Body> bodies, ContactConstraint contact) {
                if (bodies.contains(ContactTrigger.this.body)) {
                    ContactTrigger.this.monitoredconstraints.add(contact);
                }
            }

            @Override
            public void contactConstraintRemoved(Pair<Body> bodies, ContactConstraint contact) {
                if (bodies.contains(ContactTrigger.this.body)) {
                    if (ContactTrigger.this.triggeredconstraints.contains(contact)) {
                        Body interacting = bodies.getFirst() == ContactTrigger.this.body ? bodies.getSecond() : bodies.getFirst();
                        ContactTrigger.this.callback.contactBelowThreshold(interacting, contact);
                        ContactTrigger.this.triggeredconstraints.remove(contact);
                    }
                    if (ContactTrigger.this.monitoredconstraints.contains(contact)) {
                        ContactTrigger.this.monitoredconstraints.remove(contact);
                    }
                }
            }
        };
        ContactConstraintManager manager = scene.getContactConstraintManager();
        manager.addHandler(this.contactConstraintHandler);
    }

    public static interface Callback {
        public void contactAboveThreshold(Body var1, ContactConstraint var2);

        public void contactBelowThreshold(Body var1, ContactConstraint var2);
    }
}

