/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics.solver.experimental;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import jinngine.physics.Body;
import jinngine.physics.solver.ConjugateGradients;
import jinngine.physics.solver.ProjectedGaussSeidel;
import jinngine.physics.solver.Solver;
import jinngine.physics.solver.experimental.FischerNewton;
import jinngine.physics.solver.experimental.Projection;

public class SubspaceMinimization
implements Solver {
    private final Solver cg = new ConjugateGradients();
    private final Solver projection = new Projection();
    private final List<Solver.NCPConstraint> inactive = new ArrayList<Solver.NCPConstraint>();
    private final List<Solver.NCPConstraint> normals = new ArrayList<Solver.NCPConstraint>();
    private final double epsilon = 1.0E-6;
    private int pgsmin = 25;
    private final ProjectedGaussSeidel pgs = new ProjectedGaussSeidel();
    private double phi;
    private final boolean debug;
    private final PrintStream stream;

    public SubspaceMinimization(boolean debug, PrintStream stream) {
        this.debug = debug;
        this.stream = stream;
    }

    @Override
    public void setMaximumIterations(int n) {
    }

    @Override
    public double solve(List<Solver.NCPConstraint> constraints, List<Body> bodies, double epsilon) {
        this.solveMLCP(constraints, bodies);
        return 0.0;
    }

    private double solveMLCP(List<Solver.NCPConstraint> constraints, List<Body> bodies) {
        this.normals.clear();
        for (Solver.NCPConstraint ci : constraints) {
            if (ci.coupling != null) continue;
            this.normals.add(ci);
        }
        for (Solver.NCPConstraint ci : constraints) {
            if (ci.coupling == null) continue;
            ci.lower = -Math.abs(ci.coupling.lambda) * ci.coupling.mu;
            ci.upper = Math.abs(ci.coupling.lambda) * ci.coupling.mu;
        }
        this.solveInternal(constraints, bodies, true);
        return 0.0;
    }

    public double solveInternal(List<Solver.NCPConstraint> constraints, List<Body> bodies, boolean bounds) {
        int productcount = 0;
        for (Solver.NCPConstraint ci : constraints) {
            if (ci.coupling != null) {
                ci.damper = 0.0;
                continue;
            }
            ci.damper = 0.0;
        }
        if (this.debug) {
            this.stream.println(productcount + "  " + FischerNewton.fischerMerit(constraints, bodies));
        }
        this.phi = FischerNewton.fischerMerit(constraints, bodies);
        for (Solver.NCPConstraint ci : constraints) {
            if (ci.coupling != null) {
                ci.damper = 0.0;
                continue;
            }
            ci.damper = 0.0 * this.phi;
        }
        int i = -1;
        block2: while (true) {
            ++i;
            this.pgsmin = 15;
            this.pgs.setMaximumIterations(this.pgsmin);
            productcount = (int)((double)productcount + this.pgs.solve(constraints, bodies, 0.0));
            this.inactive.clear();
            for (Solver.NCPConstraint ci : constraints) {
                if (ci.lower < ci.lambda && ci.lambda < ci.upper) {
                    this.inactive.add(ci);
                }
                if (ci.coupling == null || !bounds) continue;
                double lower = -Math.abs(ci.coupling.lambda) * ci.coupling.mu;
                ci.lower = lower < ci.lower ? lower : ci.lower;
                double upper = Math.abs(ci.coupling.lambda) * ci.coupling.mu;
                ci.upper = upper > ci.upper ? upper : ci.upper;
            }
            int k = 0;
            block4: while (true) {
                ++k;
                double cgiter = this.cg.solve(this.inactive, bodies, 1.0E-15);
                productcount = (int)((double)productcount + cgiter * ((double)this.inactive.size() / (double)constraints.size()));
                if (bounds) {
                    for (Solver.NCPConstraint ci : this.inactive) {
                        if (ci.coupling == null) continue;
                        double lower = -Math.abs(ci.coupling.lambda) * ci.coupling.mu;
                        ci.lower = lower < ci.lower ? lower : ci.lower;
                        double upper = Math.abs(ci.coupling.lambda) * ci.coupling.mu;
                        ci.upper = upper > ci.upper ? upper : ci.upper;
                    }
                }
                double p = this.projection.solve(this.inactive, bodies, 0.0);
                if (this.debug) {
                    this.stream.println(productcount + "  " + FischerNewton.fischerMerit(constraints, bodies) + ";");
                }
                if (p == 0.0) {
                    if (k != 1) break;
                    break;
                }
                ListIterator<Solver.NCPConstraint> j = this.inactive.listIterator();
                while (true) {
                    if (!j.hasNext()) continue block4;
                    Solver.NCPConstraint ci = j.next();
                    if (ci.lower < ci.lambda && ci.lambda < ci.upper) continue;
                    j.remove();
                }
                break;
            }
            this.phi = FischerNewton.fischerMerit(constraints, bodies);
            if (this.phi < 1.0E-6 || i == 2 || productcount > 1200) break;
            Iterator<Solver.NCPConstraint> i$ = constraints.iterator();
            while (true) {
                if (!i$.hasNext()) continue block2;
                Solver.NCPConstraint ci = i$.next();
                if (ci.coupling != null) {
                    ci.damper += 1.0 * Math.abs(FischerNewton.fischer(ci));
                    continue;
                }
                ci.damper = 0.0;
            }
            break;
        }
        System.out.println("**) pgs-sm iteration " + i + " error=" + this.phi + " pgs equivalent " + productcount);
        if (this.phi > 0.1) {
            // empty if block
        }
        return 0.0;
    }
}

