/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.api.IControllable;
import com.flansmod.client.FlansModClient;
import com.flansmod.common.FlansMod;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.Seat;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.network.PacketDriveableKey;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.network.PacketSeatUpdates;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.tools.ItemTool;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySeat
extends Entity
implements IControllable,
IEntityAdditionalSpawnData {
    @SideOnly(value=Side.CLIENT)
    public boolean foundDriveable;
    private int driveableID;
    private int seatID;
    public EntityDriveable driveable;
    @SideOnly(value=Side.CLIENT)
    public float playerRoll;
    public Seat seatInfo;
    public boolean driver;
    public RotatedAxes looking;
    public RotatedAxes prevLooking;
    public int gunDelay;
    public int soundDelay;
    private double playerPosX;
    private double playerPosY;
    private double playerPosZ;
    private float playerYaw;
    private float playerPitch;
    private double prevPlayerPosX;
    private double prevPlayerPosY;
    private double prevPlayerPosZ;
    private float prevPlayerYaw;
    private float prevPlayerPitch;

    public EntitySeat(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.prevLooking = new RotatedAxes();
        this.looking = new RotatedAxes();
    }

    public EntitySeat(World world, EntityDriveable d, int id) {
        this(world);
        this.driveable = d;
        this.driveableID = d.func_145782_y();
        this.seatInfo = this.driveable.getDriveableType().seats[id];
        this.driver = id == 0;
        this.func_70107_b(d.field_70165_t, d.field_70163_u, d.field_70161_v);
        this.playerPosX = this.prevPlayerPosX = this.field_70165_t;
        this.playerPosY = this.prevPlayerPosY = this.field_70163_u;
        this.playerPosZ = this.prevPlayerPosZ = this.field_70161_v;
        this.looking.setAngles((this.seatInfo.minYaw + this.seatInfo.maxYaw) / 2.0f, 0.0f, 0.0f);
    }

    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int i) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && !this.foundDriveable) {
            this.driveable = (EntityDriveable)this.field_70170_p.func_73045_a(this.driveableID);
            if (this.driveable == null) {
                return;
            }
            this.foundDriveable = true;
            this.driveable.seats[this.seatID] = this;
            this.seatInfo = this.driveable.getDriveableType().seats[this.seatID];
            this.looking.setAngles((this.seatInfo.minYaw + this.seatInfo.maxYaw) / 2.0f, 0.0f, 0.0f);
            this.prevPlayerPosX = this.field_70165_t = this.driveable.field_70165_t;
            this.playerPosX = this.field_70165_t;
            this.prevPlayerPosY = this.field_70163_u = this.driveable.field_70163_u;
            this.playerPosY = this.field_70163_u;
            this.prevPlayerPosZ = this.field_70161_v = this.driveable.field_70161_v;
            this.playerPosZ = this.field_70161_v;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (this.gunDelay > 0) {
            --this.gunDelay;
        }
        if (this.soundDelay > 0) {
            --this.soundDelay;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.driver && this.field_70153_n == Minecraft.func_71410_x().field_71439_g && FlansModClient.controlModeMouse && this.driveable.hasMouseControlMode()) {
                this.looking = new RotatedAxes();
            }
            Vector3f xAxis = this.driveable.axes.findLocalAxesGlobally(this.looking).getXAxis();
            Vector3f yAxis = this.driveable.axes.findLocalAxesGlobally(this.looking).getYAxis();
            Vector3f zAxis = this.driveable.axes.findLocalAxesGlobally(this.looking).getZAxis();
            Vector3f yOffset = this.driveable.axes.findLocalVectorGlobally(new Vector3f(0.0f, this.field_70153_n == null ? 0.0f : (float)this.field_70153_n.func_70033_W(), 0.0f));
            for (int i = 0; i < 10; ++i) {
            }
        }
    }

    public void updatePosition() {
        if (this.field_70170_p.field_72995_K && !this.foundDriveable) {
            return;
        }
        this.prevPlayerPosX = this.playerPosX;
        this.prevPlayerPosY = this.playerPosY;
        this.prevPlayerPosZ = this.playerPosZ;
        this.prevPlayerYaw = this.playerYaw;
        this.prevPlayerPitch = this.playerPitch;
        Vector3f localPosition = new Vector3f((float)this.seatInfo.x / 16.0f, (float)this.seatInfo.y / 16.0f, (float)this.seatInfo.z / 16.0f);
        if (this.driver) {
            RotatedAxes yawOnlyLooking = new RotatedAxes(this.looking.getYaw(), 0.0f, 0.0f);
            Vector3f rotatedOffset = yawOnlyLooking.findLocalVectorGlobally(this.driveable.getDriveableType().rotatedDriverOffset);
            Vector3f.add(localPosition, new Vector3f(rotatedOffset.x, 0.0f, rotatedOffset.z), localPosition);
        }
        Vector3f relativePosition = this.driveable.axes.findLocalVectorGlobally(localPosition);
        this.func_70107_b(this.driveable.field_70165_t + (double)relativePosition.x, this.driveable.field_70163_u + (double)relativePosition.y, this.driveable.field_70161_v + (double)relativePosition.z);
        if (this.field_70153_n != null) {
            DriveableType type = this.driveable.getDriveableType();
            Vec3 yOffset = this.driveable.rotate(0.0, this.field_70153_n.func_70033_W(), 0.0).toVec3();
            this.playerPosX = this.field_70165_t + yOffset.field_72450_a;
            this.playerPosY = this.field_70163_u + yOffset.field_72448_b;
            this.playerPosZ = this.field_70161_v + yOffset.field_72449_c;
            this.field_70153_n.field_70142_S = this.field_70153_n.field_70169_q = this.prevPlayerPosX;
            this.field_70153_n.field_70137_T = this.field_70153_n.field_70167_r = this.prevPlayerPosY;
            this.field_70153_n.field_70136_U = this.field_70153_n.field_70166_s = this.prevPlayerPosZ;
            this.field_70153_n.func_70107_b(this.playerPosX, this.playerPosY, this.playerPosZ);
            RotatedAxes globalLookAxes = this.driveable.axes.findLocalAxesGlobally(this.looking);
            this.playerYaw = -90.0f + globalLookAxes.getYaw();
            this.playerPitch = globalLookAxes.getPitch();
            double dYaw = this.playerYaw - this.prevPlayerYaw;
            if (dYaw > 180.0) {
                this.prevPlayerYaw += 360.0f;
            }
            if (dYaw < -180.0) {
                this.prevPlayerYaw -= 360.0f;
            }
            if (this.field_70153_n instanceof EntityPlayer) {
                this.field_70153_n.field_70126_B = this.prevPlayerYaw;
                this.field_70153_n.field_70127_C = this.prevPlayerPitch;
                this.field_70153_n.field_70177_z = this.playerYaw;
                this.field_70153_n.field_70125_A = this.playerPitch;
            }
            if (this.field_70170_p.field_72995_K) {
                this.playerRoll = -globalLookAxes.getRoll();
            }
        }
    }

    public void func_70043_V() {
        if (this.field_70153_n instanceof EntityPlayer) {
            this.field_70153_n.field_70177_z = this.playerYaw;
            this.field_70153_n.field_70125_A = this.playerPitch;
            this.field_70153_n.field_70126_B = this.prevPlayerYaw;
            this.field_70153_n.field_70127_C = this.prevPlayerPitch;
        }
        this.field_70153_n.field_70142_S = this.field_70153_n.field_70169_q = this.prevPlayerPosX;
        this.field_70153_n.field_70137_T = this.field_70153_n.field_70167_r = this.prevPlayerPosY;
        this.field_70153_n.field_70136_U = this.field_70153_n.field_70166_s = this.prevPlayerPosZ;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected void func_70088_a() {
    }

    public float func_70053_R() {
        return 4.0f;
    }

    protected void func_70037_a(NBTTagCompound tags) {
    }

    protected void func_70014_b(NBTTagCompound tags) {
    }

    public boolean func_70039_c(NBTTagCompound tags) {
        return false;
    }

    public boolean func_98035_c(NBTTagCompound tags) {
        return false;
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
        if (!this.foundDriveable) {
            return;
        }
        this.prevLooking = this.looking.clone();
        if (this.driver) {
            this.driveable.onMouseMoved(deltaX, deltaY);
        }
        if (!(this.driver && FlansModClient.controlModeMouse && this.driveable.hasMouseControlMode())) {
            float lookSpeed = 4.0f;
            float newPitch = this.looking.getPitch() - (float)deltaY / lookSpeed * Minecraft.func_71410_x().field_71474_y.field_74341_c;
            if (newPitch > -this.seatInfo.minPitch) {
                newPitch = -this.seatInfo.minPitch;
            }
            if (newPitch < -this.seatInfo.maxPitch) {
                newPitch = -this.seatInfo.maxPitch;
            }
            float newYaw = this.looking.getYaw() + (float)deltaX / lookSpeed * Minecraft.func_71410_x().field_71474_y.field_74341_c;
            float otherNewYaw = newYaw - 360.0f;
            if (newYaw < 0.0f) {
                otherNewYaw = newYaw + 360.0f;
            }
            if (!(newYaw >= this.seatInfo.minYaw && newYaw <= this.seatInfo.maxYaw || otherNewYaw >= this.seatInfo.minYaw && otherNewYaw <= this.seatInfo.maxYaw)) {
                float otherNewYawDistFromRange;
                float newYawDistFromRange = Math.min(Math.abs(newYaw - this.seatInfo.minYaw), Math.abs(newYaw - this.seatInfo.maxYaw));
                if (newYawDistFromRange <= (otherNewYawDistFromRange = Math.min(Math.abs(otherNewYaw - this.seatInfo.minYaw), Math.abs(otherNewYaw - this.seatInfo.maxYaw)))) {
                    if (newYaw > this.seatInfo.maxYaw) {
                        newYaw = this.seatInfo.maxYaw;
                    }
                    if (newYaw < this.seatInfo.minYaw) {
                        newYaw = this.seatInfo.minYaw;
                    }
                } else {
                    if (otherNewYaw > this.seatInfo.maxYaw) {
                        otherNewYaw = this.seatInfo.maxYaw;
                    }
                    if (otherNewYaw < this.seatInfo.minYaw) {
                        otherNewYaw = this.seatInfo.minYaw;
                    }
                    newYaw = newYaw < 0.0f ? otherNewYaw - 360.0f : otherNewYaw + 360.0f;
                }
            }
            this.looking.setAngles(newYaw, newPitch, 0.0f);
            FlansMod.getPacketHandler().sendToServer(new PacketSeatUpdates(this));
        }
    }

    @Override
    public void updateKeyHeldState(int key, boolean held) {
        if ((!this.field_70170_p.field_72995_K || this.foundDriveable) && this.driver) {
            this.driveable.updateKeyHeldState(key, held);
        }
    }

    @Override
    public boolean pressKey(int key, EntityPlayer player) {
        if (this.field_70170_p.field_72995_K && !this.foundDriveable) {
            return false;
        }
        if (this.driver) {
            return this.driveable.pressKey(key, player);
        }
        if (key == 6) {
            if (this.field_70170_p.field_72995_K) {
                FlansMod.getPacketHandler().sendToServer(new PacketDriveableKey(key));
            } else {
                this.field_70153_n.func_70078_a(null);
            }
            return true;
        }
        if (key == 9) {
            if (this.field_70170_p.field_72995_K) {
                FlansMod.getPacketHandler().sendToServer(new PacketDriveableKey(key));
                Vector3f shootVec = this.driveable.axes.findLocalVectorGlobally(this.looking.getXAxis());
                Vector3f yOffset = this.driveable.axes.findLocalVectorGlobally(new Vector3f(0.0f, (float)player.func_70033_W(), 0.0f));
                for (int i = 0; i < 10; ++i) {
                }
            } else if (this.gunDelay <= 0 && TeamsManager.bulletsEnabled) {
                BulletType bullet;
                GunType gun = this.seatInfo.gunType;
                ItemStack bulletItemStack = this.driveable.getDriveableData().ammo[this.seatInfo.gunnerID];
                if (gun != null && bulletItemStack != null && bulletItemStack.func_77973_b() instanceof ItemBullet && gun.isAmmo(bullet = ((ItemBullet)bulletItemStack.func_77973_b()).type)) {
                    RotatedAxes globalLookAxes = this.driveable.axes.findLocalAxesGlobally(this.looking);
                    Vector3f shootVec = this.driveable.axes.findLocalVectorGlobally(this.looking.getXAxis());
                    Vector3f yOffset = this.driveable.axes.findLocalVectorGlobally(new Vector3f(0.0f, (float)player.func_70042_X(), 0.0f));
                    this.field_70170_p.func_72838_d((Entity)((ItemBullet)bulletItemStack.func_77973_b()).getEntity(this.field_70170_p, Vector3f.add(yOffset, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), null), shootVec, (EntityLivingBase)this.field_70153_n, gun.bulletSpread, gun.damage, 1.0f, bulletItemStack.func_77960_j(), (InfoType)this.driveable.getDriveableType()));
                    if (this.soundDelay <= 0) {
                        PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, gun.shootSound, false);
                        this.soundDelay = gun.shootSoundLength;
                    }
                    int damage = bulletItemStack.func_77960_j();
                    bulletItemStack.func_77964_b(damage + 1);
                    if (damage + 1 == bulletItemStack.func_77958_k()) {
                        bulletItemStack.func_77964_b(0);
                        if (!((EntityPlayer)this.field_70153_n).field_71075_bZ.field_75098_d) {
                            this.driveable.getDriveableData().func_70298_a(3 + this.seatID, 1);
                        }
                    }
                    this.gunDelay = gun.shootDelay;
                }
            }
        }
        return false;
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (this.field_70128_L) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack currentItem = entityplayer.func_71045_bC();
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemTool && ((ItemTool)currentItem.func_77973_b()).type.healDriveables) {
            return true;
        }
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemLead) {
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityLiving && !(this.field_70153_n instanceof EntityPlayer)) {
                EntityLiving mob = (EntityLiving)this.field_70153_n;
                this.field_70153_n.func_70078_a(null);
                mob.func_110162_b((Entity)entityplayer, true);
                return true;
            }
            double checkRange = 10.0;
            List nearbyMobs = this.field_70170_p.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - checkRange), (double)(this.field_70163_u - checkRange), (double)(this.field_70161_v - checkRange), (double)(this.field_70165_t + checkRange), (double)(this.field_70163_u + checkRange), (double)(this.field_70161_v + checkRange)));
            for (Object obj : nearbyMobs) {
                EntityLiving entity = (EntityLiving)obj;
                if (!entity.func_110167_bD() || entity.func_110166_bE() != entityplayer) continue;
                entity.func_70078_a((Entity)this);
                this.looking.setAngles(-entity.field_70177_z, entity.field_70125_A, 0.0f);
                entity.func_110160_i(true, !entityplayer.field_71075_bZ.field_75098_d);
            }
            return true;
        }
        if (this.field_70153_n == null) {
            entityplayer.func_70078_a((Entity)this);
            return true;
        }
        return false;
    }

    @Override
    public Entity getControllingEntity() {
        return this.field_70153_n;
    }

    @Override
    public boolean isDead() {
        return this.field_70128_L;
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        if (this.field_70170_p.field_72995_K && !this.foundDriveable) {
            return null;
        }
        return this.driveable.getPickedResult(target);
    }

    @Override
    public float getPlayerRoll() {
        return this.playerRoll;
    }

    @Override
    public float getCameraDistance() {
        return this.foundDriveable && this.seatID == 0 ? this.driveable.getDriveableType().cameraDistance : 5.0f;
    }

    public boolean func_70097_a(DamageSource source, float f) {
        if (this.field_70170_p.field_72995_K && !this.foundDriveable) {
            return false;
        }
        return this.driveable.func_70097_a(source, f);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.driveableID);
        data.writeInt(this.seatInfo.id);
    }

    public void readSpawnData(ByteBuf data) {
        this.driveableID = data.readInt();
        this.driveable = (EntityDriveable)this.field_70170_p.func_73045_a(this.driveableID);
        this.seatID = data.readInt();
        boolean bl = this.driver = this.seatID == 0;
        if (this.driveable != null) {
            this.seatInfo = this.driveable.getDriveableType().seats[this.seatID];
            this.looking.setAngles((this.seatInfo.minYaw + this.seatInfo.maxYaw) / 2.0f, 0.0f, 0.0f);
            this.prevPlayerPosX = this.field_70165_t = this.driveable.field_70165_t;
            this.playerPosX = this.field_70165_t;
            this.prevPlayerPosY = this.field_70163_u = this.driveable.field_70163_u;
            this.playerPosY = this.field_70163_u;
            this.prevPlayerPosZ = this.field_70161_v = this.driveable.field_70161_v;
            this.playerPosZ = this.field_70161_v;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }
}

