/*
 * Decompiled with CFR 0.152.
 */
package jinngine.collision;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import jinngine.collision.BroadphaseCollisionDetection;
import jinngine.geometry.Geometry;
import jinngine.util.Pair;

public class SAP2
implements BroadphaseCollisionDetection {
    private ArrayList<BroadphaseCollisionDetection.Handler> handlers = new ArrayList();
    private ArrayList<Pair<Geometry>> overlaps = new ArrayList();
    private Map<Pair<Geometry>, Counter> counters = new HashMap<Pair<Geometry>, Counter>();
    private ArrayList<Geometry> geometries = new ArrayList();
    private ArrayList<SweepPoint> axis1 = new ArrayList();
    private ArrayList<SweepPoint> axis2 = new ArrayList();
    private ArrayList<SweepPoint> axis3 = new ArrayList();

    private final void sortAxis(ArrayList<SweepPoint> axis) {
        for (int j = 1; j < axis.size(); ++j) {
            int i;
            SweepPoint keyelement = axis.get(j);
            double key = keyelement.value();
            if (Double.isNaN(key)) {
                throw new IllegalStateException("Geometry has NaN in its bounding box values" + keyelement.geo.getBody().identifier);
            }
            for (i = j - 1; i >= 0 && axis.get(i).value() > key; --i) {
                Pair<Geometry> pair;
                SweepPoint swapper = axis.get(i);
                if (keyelement.begin && !swapper.begin) {
                    pair = new Pair<Geometry>(keyelement.geo, swapper.geo);
                    if (this.counters.containsKey(pair)) {
                        ++this.counters.get(pair).overlaps;
                    } else {
                        Counter counter = new Counter();
                        counter.overlaps = 1;
                        this.counters.put(pair, counter);
                    }
                }
                if (!keyelement.begin && swapper.begin) {
                    pair = new Pair<Geometry>(keyelement.geo, swapper.geo);
                    if (this.counters.containsKey(pair)) {
                        --this.counters.get(pair).overlaps;
                    } else {
                        System.out.println("hmm?");
                    }
                }
                axis.set(i + 1, swapper);
            }
            axis.set(i + 1, keyelement);
        }
    }

    @Override
    public void add(Geometry g) {
        if (this.geometries.contains(g)) {
            throw new IllegalArgumentException("Given geometry already exsist");
        }
        this.geometries.add(g);
        this.axis1.add(new SweepPoint(g, true, 0));
        this.axis1.add(new SweepPoint(g, false, 0));
        this.axis2.add(new SweepPoint(g, true, 1));
        this.axis2.add(new SweepPoint(g, false, 1));
        this.axis3.add(new SweepPoint(g, true, 2));
        this.axis3.add(new SweepPoint(g, false, 2));
    }

    @Override
    public void addHandler(BroadphaseCollisionDetection.Handler h) {
        this.handlers.add(h);
    }

    @Override
    public Set<Pair<Geometry>> getOverlappingPairs() {
        return new HashSet<Pair<Geometry>>(this.overlaps);
    }

    @Override
    public void remove(Geometry g) {
        if (this.geometries.contains(g)) {
            this.geometries.remove(g);
            this.removeSweepPoint(this.axis1, g);
            this.removeSweepPoint(this.axis2, g);
            this.removeSweepPoint(this.axis3, g);
            Iterator<Map.Entry<Pair<Geometry>, Counter>> iter = this.counters.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Pair<Geometry>, Counter> entry = iter.next();
                Counter c = entry.getValue();
                Pair<Geometry> pair = entry.getKey();
                if (pair.getFirst() != g && pair.getSecond() != g) continue;
                if (c.wasOverlapping) {
                    for (BroadphaseCollisionDetection.Handler h : this.handlers) {
                        h.separation(pair);
                    }
                    this.overlaps.remove(pair);
                }
                iter.remove();
            }
        } else {
            throw new IllegalArgumentException("Given geometry does not exist");
        }
    }

    private final void removeSweepPoint(List<SweepPoint> list, Geometry g) {
        ListIterator<SweepPoint> iter = list.listIterator();
        while (iter.hasNext()) {
            SweepPoint p = iter.next();
            if (p.geo != g) continue;
            iter.remove();
        }
    }

    @Override
    public void removeHandler(BroadphaseCollisionDetection.Handler h) {
        this.handlers.remove(h);
    }

    @Override
    public void run() {
        this.sortAxis(this.axis1);
        this.sortAxis(this.axis2);
        this.sortAxis(this.axis3);
        int countingOverlaps = 0;
        Iterator<Map.Entry<Pair<Geometry>, Counter>> iter = this.counters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Pair<Geometry>, Counter> entry = iter.next();
            Counter c = entry.getValue();
            Pair<Geometry> pair = entry.getKey();
            if (c.overlaps == 3) {
                ++countingOverlaps;
            }
            if (c.wasOverlapping) {
                if (c.overlaps < 3) {
                    this.overlaps.remove(pair);
                    c.wasOverlapping = false;
                    for (BroadphaseCollisionDetection.Handler h : this.handlers) {
                        h.separation(pair);
                    }
                }
            } else if (c.overlaps > 2) {
                this.overlaps.add(pair);
                c.wasOverlapping = true;
                for (BroadphaseCollisionDetection.Handler h : this.handlers) {
                    h.overlap(pair);
                }
            }
            if (c.overlaps >= 1) continue;
            iter.remove();
        }
    }

    private final class Counter {
        public boolean wasOverlapping = false;
        public int overlaps;

        private Counter() {
        }
    }

    private final class SweepPoint {
        public final Geometry geo;
        public final boolean begin;
        public final int axis;

        public SweepPoint(Geometry geo, boolean begin, int axis) {
            this.geo = geo;
            this.begin = begin;
            this.axis = axis;
            if (Double.isNaN(this.value())) {
                throw new IllegalStateException("Geometry has a NaN as bounding value");
            }
        }

        public final double value() {
            if (this.begin) {
                return this.geo.getMinBounds().get(this.axis);
            }
            return this.geo.getMaxBounds().get(this.axis);
        }
    }
}

