/*
 * Decompiled with CFR 0.152.
 */
package jinngine.geometry;

import java.util.List;
import jinngine.geometry.Geometry;
import jinngine.geometry.Material;
import jinngine.geometry.SupportMap3;
import jinngine.math.InertiaMatrix;
import jinngine.math.Matrix3;
import jinngine.math.Matrix4;
import jinngine.math.Transforms;
import jinngine.math.Vector3;
import jinngine.physics.Body;

public class Box
implements SupportMap3,
Geometry,
Material {
    private Body body;
    private final Matrix3 localtransform = new Matrix3();
    private final Matrix3 localrotation = new Matrix3();
    private final Vector3 localdisplacement = new Vector3();
    private final Vector3 bounds = new Vector3();
    private double envelope = 0.125;
    private double xs;
    private double ys;
    private double zs;
    private double mass;
    private Object auxiliary;
    private double restitution = 0.7;
    private double friction = 0.5;

    public Box(double x, double y, double z) {
        this.xs = x;
        this.ys = y;
        this.zs = z;
        this.mass = this.xs * this.ys * this.zs;
        this.setLocalTransform(Matrix3.identity(), new Vector3());
    }

    public Box(double x, double y, double z, double posx, double posy, double posz) {
        this.xs = x;
        this.ys = y;
        this.zs = z;
        this.mass = this.xs * this.ys * this.zs;
        this.setLocalTransform(Matrix3.identity(), new Vector3(posx, posy, posz));
    }

    public final void setBoxSideLengths(double xl, double yl, double zl) {
        this.xs = xl;
        this.ys = yl;
        this.zs = zl;
        this.mass = xl * yl * zl;
        if (this.body != null) {
            this.body.finalize();
        }
    }

    @Override
    public Object getAuxiliary() {
        return this.auxiliary;
    }

    @Override
    public void setAuxiliary(Object auxiliary) {
        this.auxiliary = auxiliary;
    }

    @Override
    public Vector3 supportPoint(Vector3 direction) {
        Vector3 v = this.body.state.rotation.multiply(this.localrotation).transpose().multiply(direction);
        double sv1 = v.x < 0.0 ? -0.5 : 0.5;
        double sv2 = v.y < 0.0 ? -0.5 : 0.5;
        double sv3 = v.z < 0.0 ? -0.5 : 0.5;
        return this.body.state.rotation.multiply(this.localtransform.multiply(new Vector3(sv1, sv2, sv3)).add(this.localdisplacement)).add(this.body.state.position);
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    public void setBody(Body b) {
        this.body = b;
    }

    @Override
    public InertiaMatrix getInertialMatrix() {
        InertiaMatrix I = new InertiaMatrix();
        Matrix3.set(I, 0.0833333358168602 * this.mass * (this.ys * this.ys + this.zs * this.zs), 0.0, 0.0, 0.0, 0.0833333358168602 * this.mass * (this.xs * this.xs + this.zs * this.zs), 0.0, 0.0, 0.0, 0.0833333358168602 * this.mass * (this.ys * this.ys + this.xs * this.xs));
        return I;
    }

    @Override
    public double getEnvelope() {
        return this.envelope;
    }

    @Override
    public void setEnvelope(double envelope) {
        this.envelope = envelope;
    }

    @Override
    public void setLocalTransform(Matrix3 rotation, Vector3 displacement) {
        this.localdisplacement.assign(displacement);
        this.localrotation.assign(rotation);
        this.localtransform.assign(this.localrotation.multiply(new Matrix3(new Vector3(this.xs, 0.0, 0.0), new Vector3(0.0, this.ys, 0.0), new Vector3(0.0, 0.0, this.zs))));
        double max = Matrix3.multiply(this.localtransform, new Vector3(0.5, 0.5, 0.5), new Vector3()).norm();
        this.bounds.assign(new Vector3(max, max, max));
    }

    @Override
    public void getLocalTransform(Matrix3 R, Vector3 b) {
        R.assign(this.localrotation);
        b.assign(this.localdisplacement);
    }

    @Override
    public void getLocalTranslation(Vector3 t) {
        t.assign(this.localdisplacement);
    }

    @Override
    public Vector3 getMaxBounds() {
        Matrix3 T = this.body.state.rotation.multiply(this.localrotation).transpose();
        Vector3 vx = new Vector3();
        Vector3 vy = new Vector3();
        Vector3 vz = new Vector3();
        T.getColumnVectors(vx, vy, vz);
        Vector3 px = new Vector3(this.xs * (vx.x < 0.0 ? -0.5 : 0.5), this.ys * (vx.y < 0.0 ? -0.5 : 0.5), this.zs * (vx.z < 0.0 ? -0.5 : 0.5));
        Vector3 py = new Vector3(this.xs * (vy.x < 0.0 ? -0.5 : 0.5), this.ys * (vy.y < 0.0 ? -0.5 : 0.5), this.zs * (vy.z < 0.0 ? -0.5 : 0.5));
        Vector3 pz = new Vector3(this.xs * (vz.x < 0.0 ? -0.5 : 0.5), this.ys * (vz.y < 0.0 ? -0.5 : 0.5), this.zs * (vz.z < 0.0 ? -0.5 : 0.5));
        Matrix3.multiply(this.localrotation, px, px);
        Matrix3.multiply(this.localrotation, py, py);
        Matrix3.multiply(this.localrotation, pz, pz);
        Vector3.add(px, this.localdisplacement);
        Vector3.add(py, this.localdisplacement);
        Vector3.add(pz, this.localdisplacement);
        Matrix3 Tb = this.body.state.rotation;
        Vector3 rx = new Vector3();
        Vector3 ry = new Vector3();
        Vector3 rz = new Vector3();
        Tb.getRowVectors(rx, ry, rz);
        return new Vector3(rx.dot(px) + this.envelope, ry.dot(py) + this.envelope, rz.dot(pz) + this.envelope).add(this.body.state.position);
    }

    @Override
    public Vector3 getMinBounds() {
        Matrix3 T = this.body.state.rotation.multiply(this.localrotation).transpose();
        Vector3 vx = new Vector3();
        Vector3 vy = new Vector3();
        Vector3 vz = new Vector3();
        T.getColumnVectors(vx, vy, vz);
        Vector3.multiply(vx, -1.0);
        Vector3.multiply(vy, -1.0);
        Vector3.multiply(vz, -1.0);
        Vector3 px = new Vector3(this.xs * (vx.x < 0.0 ? -0.5 : 0.5), this.ys * (vx.y < 0.0 ? -0.5 : 0.5), this.zs * (vx.z < 0.0 ? -0.5 : 0.5));
        Vector3 py = new Vector3(this.xs * (vy.x < 0.0 ? -0.5 : 0.5), this.ys * (vy.y < 0.0 ? -0.5 : 0.5), this.zs * (vy.z < 0.0 ? -0.5 : 0.5));
        Vector3 pz = new Vector3(this.xs * (vz.x < 0.0 ? -0.5 : 0.5), this.ys * (vz.y < 0.0 ? -0.5 : 0.5), this.zs * (vz.z < 0.0 ? -0.5 : 0.5));
        Matrix3.multiply(this.localrotation, px, px);
        Matrix3.multiply(this.localrotation, py, py);
        Matrix3.multiply(this.localrotation, pz, pz);
        Vector3.add(px, this.localdisplacement);
        Vector3.add(py, this.localdisplacement);
        Vector3.add(pz, this.localdisplacement);
        Matrix3 Tb = this.body.state.rotation;
        Vector3 rx = new Vector3();
        Vector3 ry = new Vector3();
        Vector3 rz = new Vector3();
        Tb.getRowVectors(rx, ry, rz);
        return new Vector3(rx.dot(px) - this.envelope, ry.dot(py) - this.envelope, rz.dot(pz) - this.envelope).add(this.body.state.position);
    }

    @Override
    public Matrix4 getTransform() {
        return Matrix4.multiply(this.body.getTransform(), Transforms.transformAndTranslate4(this.localtransform, this.localdisplacement), new Matrix4());
    }

    @Override
    public void supportFeature(Vector3 d, double epsilon, List<Vector3> featureList) {
        Vector3 v = this.body.state.rotation.multiply(this.localrotation).transpose().multiply(d);
        int numberOfZeroAxis = 0;
        int[] zeroAxisIndices = new int[3];
        int numberOfNonZeroAxis = 0;
        int[] nonZeroAxisIndices = new int[3];
        if (Math.abs(v.x) < epsilon) {
            zeroAxisIndices[numberOfZeroAxis++] = 0;
        } else {
            nonZeroAxisIndices[numberOfNonZeroAxis++] = 0;
        }
        if (Math.abs(v.y) < epsilon) {
            zeroAxisIndices[numberOfZeroAxis++] = 1;
        } else {
            nonZeroAxisIndices[numberOfNonZeroAxis++] = 1;
        }
        if (Math.abs(v.z) < epsilon) {
            zeroAxisIndices[numberOfZeroAxis++] = 2;
        } else {
            nonZeroAxisIndices[numberOfNonZeroAxis++] = 2;
        }
        if (numberOfZeroAxis == 0) {
            double sv1 = v.x < 0.0 ? -0.5 : 0.5;
            double sv2 = v.y < 0.0 ? -0.5 : 0.5;
            double sv3 = v.z < 0.0 ? -0.5 : 0.5;
            featureList.add(this.body.state.rotation.multiply(this.localtransform.multiply(new Vector3(sv1, sv2, sv3)).add(this.localdisplacement)).add(this.body.state.position));
        } else if (numberOfZeroAxis == 1) {
            Vector3 p1 = new Vector3(v.x < 0.0 ? -0.5 : 0.5, v.y < 0.0 ? -0.5 : 0.5, v.z < 0.0 ? -0.5 : 0.5);
            Vector3 p2 = new Vector3(v.x < 0.0 ? -0.5 : 0.5, v.y < 0.0 ? -0.5 : 0.5, v.z < 0.0 ? -0.5 : 0.5);
            p1.set(zeroAxisIndices[0], 0.5);
            p2.set(zeroAxisIndices[0], -0.5);
            featureList.add(this.body.state.rotation.multiply(this.localtransform.multiply(p1).add(this.localdisplacement)).add(this.body.state.position));
            featureList.add(this.body.state.rotation.multiply(this.localtransform.multiply(p2).add(this.localdisplacement)).add(this.body.state.position));
        } else if (numberOfZeroAxis == 2) {
            Vector3 p1 = new Vector3(v.x < 0.0 ? -0.5 : 0.5, v.y < 0.0 ? -0.5 : 0.5, v.z < 0.0 ? -0.5 : 0.5);
            Vector3 p2 = new Vector3(v.x < 0.0 ? -0.5 : 0.5, v.y < 0.0 ? -0.5 : 0.5, v.z < 0.0 ? -0.5 : 0.5);
            Vector3 p3 = new Vector3(v.x < 0.0 ? -0.5 : 0.5, v.y < 0.0 ? -0.5 : 0.5, v.z < 0.0 ? -0.5 : 0.5);
            Vector3 p4 = new Vector3(v.x < 0.0 ? -0.5 : 0.5, v.y < 0.0 ? -0.5 : 0.5, v.z < 0.0 ? -0.5 : 0.5);
            switch (nonZeroAxisIndices[0]) {
                case 0: {
                    if (v.x > 0.0) {
                        p1.y = 0.5;
                        p1.z = 0.5;
                        p2.y = -0.5;
                        p2.z = 0.5;
                        p3.y = -0.5;
                        p3.z = -0.5;
                        p4.y = 0.5;
                        p4.z = -0.5;
                        break;
                    }
                    p1.y = 0.5;
                    p1.z = 0.5;
                    p2.y = 0.5;
                    p2.z = -0.5;
                    p3.y = -0.5;
                    p3.z = -0.5;
                    p4.y = -0.5;
                    p4.z = 0.5;
                    break;
                }
                case 1: {
                    if (v.y > 0.0) {
                        p1.z = 0.5;
                        p1.x = 0.5;
                        p2.z = -0.5;
                        p2.x = 0.5;
                        p3.z = -0.5;
                        p3.x = -0.5;
                        p4.z = 0.5;
                        p4.x = -0.5;
                        break;
                    }
                    p1.z = 0.5;
                    p1.x = 0.5;
                    p2.z = 0.5;
                    p2.x = -0.5;
                    p3.z = -0.5;
                    p3.x = -0.5;
                    p4.z = -0.5;
                    p4.x = 0.5;
                    break;
                }
                case 2: {
                    if (v.z > 0.0) {
                        p1.x = 0.5;
                        p1.y = 0.5;
                        p2.x = -0.5;
                        p2.y = 0.5;
                        p3.x = -0.5;
                        p3.y = -0.5;
                        p4.x = 0.5;
                        p4.y = -0.5;
                        break;
                    }
                    p1.x = 0.5;
                    p1.y = 0.5;
                    p2.x = 0.5;
                    p2.y = -0.5;
                    p3.x = -0.5;
                    p3.y = -0.5;
                    p4.x = -0.5;
                    p4.y = 0.5;
                }
            }
            featureList.add(this.body.state.rotation.multiply(this.localtransform.multiply(p1).add(this.localdisplacement)).add(this.body.state.position));
            featureList.add(this.body.state.rotation.multiply(this.localtransform.multiply(p2).add(this.localdisplacement)).add(this.body.state.position));
            featureList.add(this.body.state.rotation.multiply(this.localtransform.multiply(p3).add(this.localdisplacement)).add(this.body.state.position));
            featureList.add(this.body.state.rotation.multiply(this.localtransform.multiply(p4).add(this.localdisplacement)).add(this.body.state.position));
        } else if (numberOfZeroAxis == 3) {
            // empty if block
        }
    }

    @Override
    public double getFrictionCoefficient() {
        return this.friction;
    }

    @Override
    public double getRestitution() {
        return this.restitution;
    }

    @Override
    public void setFrictionCoefficient(double f) {
        this.friction = f;
    }

    @Override
    public void setRestitution(double e) {
        this.restitution = e;
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public Vector3 getDimentions() {
        return new Vector3(this.xs, this.ys, this.zs);
    }

    @Override
    public void setLocalScale(Vector3 s) {
        throw new UnsupportedOperationException();
    }
}

