/*
 * Decompiled with CFR 0.152.
 */
package jinngine.geometry.contact;

import java.util.Iterator;
import jinngine.geometry.Box;
import jinngine.geometry.Geometry;
import jinngine.geometry.contact.ContactGenerator;
import jinngine.math.Matrix3;
import jinngine.math.Vector3;
import jinngine.physics.Body;

public class BulletNativeContactGenerator
implements ContactGenerator {
    private final Geometry Sa;
    private final Geometry Sb;
    private int N = 8;
    private ContactGenerator.ContactPoint[] contacts = new ContactGenerator.ContactPoint[this.N];
    private int[] record = new int[8];
    private double envelope = 0.125;

    public BulletNativeContactGenerator(Geometry Sa, Geometry Sb) {
        for (int i = 0; i < this.N; ++i) {
            this.contacts[i] = new ContactGenerator.ContactPoint();
        }
        this.Sa = Sa;
        this.Sb = Sb;
        double[] shapeA = this.pointsFromGeometry(Sa);
        double[] shapeB = this.pointsFromGeometry(Sb);
        this.bulletSetup(this.record, shapeA, shapeA.length / 3, shapeB, shapeB.length / 3);
    }

    private final double[] pointsFromGeometry(Geometry g) {
        if (g instanceof Box) {
            Box b = (Box)g;
            Vector3 dims = b.getDimentions();
            double[] points = new double[]{dims.x * 0.5, dims.y * 0.5, dims.z * 0.5, dims.x * -0.5, dims.y * 0.5, dims.z * 0.5, dims.x * 0.5, dims.y * -0.5, dims.z * 0.5, dims.x * -0.5, dims.y * -0.5, dims.z * 0.5, dims.x * 0.5, dims.y * 0.5, dims.z * -0.5, dims.x * -0.5, dims.y * 0.5, dims.z * -0.5, dims.x * 0.5, dims.y * -0.5, dims.z * -0.5, dims.x * -0.5, dims.y * -0.5, dims.z * -0.5};
            return points;
        }
        return null;
    }

    @Override
    public Iterator<ContactGenerator.ContactPoint> getContacts() {
        return new Iterator<ContactGenerator.ContactPoint>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < BulletNativeContactGenerator.this.N;
            }

            @Override
            public ContactGenerator.ContactPoint next() {
                if (this.i < BulletNativeContactGenerator.this.N) {
                    return BulletNativeContactGenerator.this.contacts[this.i++];
                }
                return null;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public void run() {
        Body A = this.Sa.getBody();
        Body B = this.Sb.getBody();
        int numberOfContacts = 0;
        numberOfContacts = this.bulletRunContactGeneration(this.record, Matrix3.pack(A.state.rotation), Vector3.pack(A.state.position), Matrix3.pack(B.state.rotation), Vector3.pack(B.state.position));
        double[] normals = new double[numberOfContacts * 3];
        double[] paws = new double[numberOfContacts * 3];
        double[] pbws = new double[numberOfContacts * 3];
        double[] dists = new double[numberOfContacts];
        this.bulletGetContactPoints(this.record, normals, paws, pbws, dists);
        int c = 0;
        for (int i = 0; i < numberOfContacts; ++i) {
            if (!(dists[i] < this.envelope)) continue;
            this.contacts[c].b1 = A;
            this.contacts[c].b2 = B;
            this.contacts[c].normal.x = normals[i * 3];
            this.contacts[c].normal.y = normals[i * 3 + 1];
            this.contacts[c].normal.z = normals[i * 3 + 2];
            this.contacts[c].paw.x = paws[i * 3];
            this.contacts[c].paw.y = paws[i * 3 + 1];
            this.contacts[c].paw.z = paws[i * 3 + 2];
            this.contacts[c].pbw.x = pbws[i * 3];
            this.contacts[c].pbw.y = pbws[i * 3 + 1];
            this.contacts[c].pbw.z = pbws[i * 3 + 2];
            this.contacts[c].point.assign(this.contacts[c].paw.add(this.contacts[c].pbw).multiply(0.5));
            this.contacts[c].distance = dists[i];
            this.contacts[c].depth = 0.0625 - dists[i];
            this.contacts[c].restitution = 0.7;
            this.contacts[c].friction = 0.5;
            ++c;
        }
        this.N = c;
    }

    private native void bulletSetup(int[] var1, double[] var2, int var3, double[] var4, int var5);

    private native int bulletRunContactGeneration(int[] var1, double[] var2, double[] var3, double[] var4, double[] var5);

    private native void bulletGetContactPoints(int[] var1, double[] var2, double[] var3, double[] var4, double[] var5);

    private native void bulletCleanup(int[] var1);

    @Override
    public final void remove() {
        this.bulletCleanup(this.record);
    }

    static {
        System.loadLibrary("LinearMath");
        System.loadLibrary("BulletCollision");
        System.loadLibrary("BulletDynamics");
        System.loadLibrary("BulletNativeContactGenerator");
    }
}

