/*
 * Decompiled with CFR 0.152.
 */
package jinngine.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import jinngine.util.ComponentGraph;
import jinngine.util.Pair;

public class HashMapComponentGraph<T, U, V>
implements ComponentGraph<T, U, V> {
    private final Map<Node, Node> allnodes = new HashMap<Node, Node>();
    private final Set<Node> freenodes = new HashSet<Node>();
    private final Map<Node, Set<Node>> edges = new HashMap<Node, Set<Node>>();
    private final Map<Node, Component> component = new HashMap<Node, Component>();
    private final Map<Pair<T>, U> edgeData = new HashMap<Pair<T>, U>();
    private final Map<Component, Set<Node>> componentNodes = new HashMap<Component, Set<Node>>();
    private final Map<Component, Set<Pair<T>>> componentEdges = new HashMap<Component, Set<Pair<T>>>();
    private final ComponentGraph.NodeClassifier<T> nodeClassifier;
    private final ComponentGraph.ComponentHandler<T, V> componenthandler;

    public HashMapComponentGraph(ComponentGraph.NodeClassifier<T> nodeClassifier, ComponentGraph.ComponentHandler<T, V> componentcreator) {
        this.componenthandler = componentcreator;
        this.nodeClassifier = nodeClassifier;
    }

    @Override
    public final void addEdge(Pair<T> pair, U edgeelement) {
        Node t;
        if (this.edgeData.containsKey(pair)) {
            this.edgeData.put(pair, edgeelement);
            return;
        }
        this.edgeData.put(pair, edgeelement);
        Node a = new Node(pair.getFirst());
        if (this.allnodes.containsKey(a)) {
            a = this.allnodes.get(a);
        } else {
            this.allnodes.put(a, a);
            this.freenodes.add(a);
        }
        Node b = new Node(pair.getSecond());
        if (this.allnodes.containsKey(b)) {
            b = this.allnodes.get(b);
        } else {
            this.allnodes.put(b, b);
            this.freenodes.add(b);
        }
        if (this.nodeClassifier.isDelimitor(b.element)) {
            t = a;
            a = b;
            b = t;
        }
        if (!this.edges.containsKey(a)) {
            this.edges.put(a, new HashSet());
        }
        if (!this.edges.containsKey(b)) {
            this.edges.put(b, new HashSet());
        }
        this.edges.get(b).add(a);
        this.edges.get(a).add(b);
        if (!this.nodeClassifier.isDelimitor(b.element)) {
            Component g;
            if (this.nodeClassifier.isDelimitor(a.element)) {
                if (!this.component.containsKey(b)) {
                    g = new Component(this.componenthandler.newComponent());
                    this.component.put(b, g);
                    this.componentNodes.put(g, new HashSet());
                    this.componentNodes.get(g).add(b);
                    this.componenthandler.nodeAddedToComponent(g.element, b.element);
                    this.freenodes.remove(b);
                    this.componentEdges.put(g, new HashSet());
                    this.componentEdges.get(g).add(pair);
                } else {
                    g = this.component.get(b);
                    this.componentEdges.get(g).add(pair);
                }
            } else {
                if (this.component.containsKey(b)) {
                    t = a;
                    a = b;
                    b = t;
                }
                if (this.component.containsKey(b)) {
                    if (this.component.get(a) == this.component.get(b)) {
                        this.componentEdges.get(this.component.get(a)).add(pair);
                    } else {
                        Component ga = this.component.get(a);
                        Component gb = this.component.get(b);
                        this.componenthandler.mergeComponent(ga.element, gb.element);
                        for (Node body : this.componentNodes.get(gb)) {
                            this.component.put(body, ga);
                        }
                        this.componentNodes.get(ga).addAll((Collection<Node>)this.componentNodes.get(gb));
                        this.componentEdges.get(ga).addAll((Collection)this.componentEdges.get(gb));
                        this.componentEdges.get(ga).add(pair);
                        this.componentNodes.remove(gb);
                        this.componentEdges.remove(gb);
                    }
                } else if (this.component.containsKey(a)) {
                    g = this.component.get(a);
                    this.component.put(b, g);
                    this.componentNodes.get(g).add(b);
                    this.componentEdges.get(g).add(pair);
                    this.freenodes.remove(b);
                    this.componenthandler.nodeAddedToComponent(g.element, b.element);
                } else {
                    Component newGroup = new Component(this.componenthandler.newComponent());
                    this.component.put(a, newGroup);
                    this.component.put(b, newGroup);
                    this.componentNodes.put(newGroup, new HashSet());
                    this.componentNodes.get(newGroup).add(a);
                    this.componentNodes.get(newGroup).add(b);
                    this.componenthandler.nodeAddedToComponent(newGroup.element, a.element);
                    this.componenthandler.nodeAddedToComponent(newGroup.element, b.element);
                    this.componentEdges.put(newGroup, new HashSet());
                    this.componentEdges.get(newGroup).add(pair);
                    this.freenodes.remove(a);
                    this.freenodes.remove(b);
                }
            }
        }
        Iterator<Component> groupiter = this.componentNodes.keySet().iterator();
        HashSet<Pair<T>> allpairs = new HashSet<Pair<T>>();
        HashSet<Node> allnodes = new HashSet<Node>();
        while (groupiter.hasNext()) {
            Component g = groupiter.next();
            for (Pair<T> thispair : this.componentEdges.get(g)) {
                if (allpairs.contains(thispair)) {
                    System.out.println("Duplicates!!!!");
                    System.exit(0);
                }
                allpairs.add(thispair);
            }
            for (Node node : this.componentNodes.get(g)) {
                if (allnodes.contains(node)) {
                    System.out.println("Duplicates!!!!");
                    System.exit(0);
                }
                allnodes.add(node);
            }
        }
    }

    @Override
    public final boolean removeEdge(Pair<T> pair) {
        Node t;
        if (!this.edgeData.containsKey(pair)) {
            return false;
        }
        this.edgeData.remove(pair);
        Node a = new Node(pair.getFirst());
        if (this.allnodes.containsKey(a)) {
            a = this.allnodes.get(a);
        } else {
            this.allnodes.put(a, a);
        }
        Node b = new Node(pair.getSecond());
        if (this.allnodes.containsKey(b)) {
            b = this.allnodes.get(b);
        } else {
            this.allnodes.put(b, b);
        }
        if (this.nodeClassifier.isDelimitor(b.element)) {
            t = a;
            a = b;
            b = t;
        }
        this.edges.get(a).remove(b);
        this.edges.get(b).remove(a);
        if (this.edges.get(a).isEmpty()) {
            this.edges.remove(a);
        }
        if (this.edges.get(b).isEmpty()) {
            this.edges.remove(b);
        }
        if (!this.nodeClassifier.isDelimitor(b.element)) {
            if (this.nodeClassifier.isDelimitor(a.element)) {
                if (this.component.containsKey(b)) {
                    Component g = this.component.get(b);
                    if (!this.edges.containsKey(b)) {
                        this.component.remove(b);
                        this.componenthandler.nodeRemovedFromComponent(g.element, b.element);
                        this.freenodes.add(b);
                        Set<Node> s = this.componentNodes.get(g);
                        if (!s.remove(b)) {
                            System.out.println("ALARM");
                            System.exit(0);
                        }
                        if (s.isEmpty()) {
                            this.componentNodes.remove(g);
                        } else {
                            System.out.println("Group isn't empty, why??");
                        }
                    }
                    Set<Pair<T>> sp = this.componentEdges.get(g);
                    sp.remove(pair);
                    if (sp.isEmpty()) {
                        this.componentEdges.remove(g);
                    }
                } else {
                    System.out.println("HashMapComponentGraph.removeEdge(): A connected non-delimiter node was not in a component!");
                    System.exit(0);
                }
            } else {
                Component oldgroup;
                if (this.edges.containsKey(b)) {
                    t = a;
                    a = b;
                    b = t;
                }
                if ((oldgroup = this.component.get(a)) != this.component.get(b)) {
                    System.out.println("Different groups??!");
                    System.exit(0);
                }
                if (this.edges.containsKey(b)) {
                    boolean NONE = false;
                    boolean RED = true;
                    int BLUE = 2;
                    Iterator<Node> i = this.componentNodes.get(oldgroup).iterator();
                    while (i.hasNext()) {
                        i.next().color = 0;
                    }
                    boolean disjoint = true;
                    LinkedList<Node> queue = new LinkedList<Node>();
                    HashSet blueEdges = new HashSet();
                    a.color = 1;
                    b.color = 2;
                    queue.add(a);
                    queue.add(b);
                    block1: while (!queue.isEmpty()) {
                        Node node = (Node)queue.poll();
                        for (Node neighbor : this.edges.get(node)) {
                            if (node.color == 2) {
                                blueEdges.add(new Pair(node.element, neighbor.element));
                            }
                            if (this.nodeClassifier.isDelimitor(neighbor.element)) continue;
                            if (neighbor.color == 0) {
                                neighbor.color = node.color;
                                queue.add(neighbor);
                                continue;
                            }
                            if (neighbor.color == node.color) continue;
                            disjoint = false;
                            continue block1;
                        }
                    }
                    if (disjoint) {
                        Component newgroup = new Component(this.componenthandler.newComponent());
                        HashSet<Node> blues = new HashSet<Node>();
                        for (Node node : this.componentNodes.get(oldgroup)) {
                            if (node.color != 2) continue;
                            blues.add(node);
                            this.component.put(node, newgroup);
                        }
                        if (blues.isEmpty()) {
                            System.out.println("Why was no blue nodes found?");
                            System.exit(0);
                        }
                        this.componentNodes.get(oldgroup).removeAll(blues);
                        this.componentNodes.put(newgroup, blues);
                        this.componentEdges.get(oldgroup).removeAll(blueEdges);
                        this.componentEdges.get(oldgroup).remove(pair);
                        this.componentEdges.put(newgroup, blueEdges);
                    } else {
                        Set<Pair<T>> sp = this.componentEdges.get(oldgroup);
                        sp.remove(pair);
                        if (sp.isEmpty()) {
                            this.componentEdges.remove(oldgroup);
                        }
                    }
                } else if (this.edges.containsKey(a)) {
                    this.component.remove(b);
                    this.componentNodes.get(oldgroup).remove(b);
                    this.freenodes.add(b);
                    this.componenthandler.nodeRemovedFromComponent(oldgroup.element, b.element);
                    if (this.componentNodes.get(oldgroup).isEmpty()) {
                        System.out.println("How can group be empty?");
                        this.componentNodes.remove(oldgroup);
                    }
                    Set<Pair<T>> sp = this.componentEdges.get(oldgroup);
                    sp.remove(pair);
                    if (sp.isEmpty()) {
                        this.componentEdges.remove(oldgroup);
                    }
                } else {
                    this.component.remove(a);
                    this.component.remove(b);
                    this.freenodes.add(a);
                    this.freenodes.add(b);
                    this.componenthandler.nodeRemovedFromComponent(oldgroup.element, a.element);
                    this.componenthandler.nodeRemovedFromComponent(oldgroup.element, b.element);
                    this.componentNodes.get(oldgroup).remove(b);
                    this.componentNodes.get(oldgroup).remove(a);
                    if (this.componentNodes.get(oldgroup).isEmpty()) {
                        this.componentNodes.remove(oldgroup);
                    } else {
                        System.out.println("Hmm still stuff in group but no outgoing edges?" + this.componentNodes.get(oldgroup) + " a and b is " + a + ",    " + b);
                        System.exit(0);
                    }
                    Set<Pair<T>> sp = this.componentEdges.get(oldgroup);
                    sp.remove(pair);
                    if (sp.isEmpty()) {
                        this.componentEdges.remove(oldgroup);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public final U getEdge(Pair<T> pair) {
        if (this.edgeData.containsKey(pair)) {
            return this.edgeData.get(pair);
        }
        return null;
    }

    @Override
    public final Iterator<V> getComponents() {
        return new Iterator<V>(){
            private final Iterator<Component> iter;
            {
                this.iter = HashMapComponentGraph.this.componentEdges.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public V next() {
                return this.iter.next().element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final Iterator<U> getEdgesInComponent(V c) {
        Set<Pair<T>> edges = this.componentEdges.get(new Component(c));
        if (edges == null) {
            return null;
        }
        final Iterator<Pair<T>> i = edges.iterator();
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public U next() {
                if (i.hasNext()) {
                    Pair p = (Pair)i.next();
                    return HashMapComponentGraph.this.edgeData.get(p);
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<T> getNodesInComponent(V c1) {
        Set<Node> nodes = this.componentNodes.get(new Component(c1));
        if (nodes == null) {
            return null;
        }
        final Iterator<Node> i = nodes.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public T next() {
                if (i.hasNext()) {
                    Node p = (Node)i.next();
                    return p.element;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public final void print() {
        System.out.println("Status: " + this.componentNodes.keySet().size() + " components with " + this.component.size() + " bodies, " + this.getNumberOfFreeNodes() + " free ");
        Iterator<Component> groupiter = this.componentNodes.keySet().iterator();
        HashSet<Pair<T>> allpairs = new HashSet<Pair<T>>();
        HashSet<Node> allnodes = new HashSet<Node>();
        while (groupiter.hasNext()) {
            Component g = groupiter.next();
            System.out.println("Group " + g.element + " : " + this.componentEdges.get(g).size() + " pairs, " + this.componentNodes.get(g).size() + " nodes ");
            for (Pair<T> thispair : this.componentEdges.get(g)) {
                if (allpairs.contains(thispair)) {
                    System.out.println("Duplicates!!!!");
                    System.exit(0);
                }
                allpairs.add(thispair);
            }
            for (Node node : this.componentNodes.get(g)) {
                if (allnodes.contains(node)) {
                    System.out.println("Duplicates!!!!");
                    System.exit(0);
                }
                allnodes.add(node);
            }
        }
    }

    @Override
    public int getNumberOfComponents() {
        return this.componentNodes.keySet().size();
    }

    @Override
    public Iterator<T> getConnectedNodes(final T node) {
        return new Iterator<T>(){
            Iterator<Node> i;
            {
                this.i = ((Set)HashMapComponentGraph.this.edges.get(new Node(node))).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public T next() {
                return this.i.next().element;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public void addNode(T nodeelement) {
        Node node = new Node(nodeelement);
        if (this.allnodes.containsKey(node)) {
            System.out.println("HashMapComponentGraph.addNode(): Node is already in graph");
        } else {
            this.allnodes.put(node, node);
            this.freenodes.add(node);
        }
    }

    @Override
    public void removeNode(T nodeelement) {
        Node node = new Node(nodeelement);
        if (this.freenodes.contains(node)) {
            this.freenodes.remove(node);
            this.allnodes.remove(node);
            return;
        }
        ArrayList edgesToRemove = new ArrayList();
        Iterator neighbors = this.getConnectedNodes(node.element);
        while (neighbors.hasNext()) {
            Pair nodepair = new Pair(node.element, neighbors.next());
            edgesToRemove.add(nodepair);
        }
        for (Pair pair : edgesToRemove) {
            this.removeEdge(pair);
        }
        if (this.freenodes.contains(node)) {
            this.freenodes.remove(node);
            this.allnodes.remove(node);
            return;
        }
        System.out.println("HashMapComponentGraph.removeNode(): Node was not free after removing its edges");
    }

    @Override
    public int getNumberOfNodes() {
        return this.allnodes.size();
    }

    @Override
    public int getNumberOfFreeNodes() {
        return this.freenodes.size();
    }

    @Override
    public Iterator<T> getFreeNodes() {
        return new Iterator<T>(){
            Iterator<Node> i;
            {
                this.i = HashMapComponentGraph.this.freenodes.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public T next() {
                return this.i.next().element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<U> getConnectedEdges(final T node) {
        return new Iterator<U>(){
            Iterator<Node> i;
            {
                this.i = ((Set)HashMapComponentGraph.this.edges.get(new Node(node))).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public U next() {
                return HashMapComponentGraph.this.edgeData.get(new Pair<Object>(node, this.i.next().element));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private final class Component {
        private final V element;

        public Component(V element) {
            this.element = element;
        }

        public final int hashCode() {
            return this.element.hashCode();
        }

        public final boolean equals(Object other) {
            return this.element.equals(((Component)other).element);
        }
    }

    private final class Node {
        public final T element;
        public int color;

        public Node(T element) {
            this.element = element;
        }

        public final int hashCode() {
            return this.element.hashCode();
        }

        public final boolean equals(Object other) {
            return this.element.equals(((Node)other).element);
        }
    }
}

