/*
 * Decompiled with CFR 0.152.
 */
package jinngine.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Heap<T> {
    private int size = 0;
    private final List<Node> heap = new ArrayList<Node>();
    private final Comparator<T> comparator;

    public Heap(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public void insert(T element) {
        ++this.size;
        Node node = new Node();
        node.element = element;
        node.position = this.size - 1;
        this.heap.add(node);
        this.decreaseKey(node);
    }

    public final void clear() {
        this.heap.clear();
        this.size = 0;
    }

    public final T top() {
        return this.heap.get((int)0).element;
    }

    public T pop() {
        T returnNode = this.top();
        this.exchange(0, this.size - 1);
        this.heap.remove(this.size - 1);
        --this.size;
        if (this.size > 0) {
            this.minHeapify(this.heap.get(0));
        }
        return returnNode;
    }

    public final int size() {
        return this.size;
    }

    private final boolean decreaseKey(Node node) {
        int index = node.position;
        boolean modified = false;
        while (index > 0 && this.comparator.compare(this.heap.get((int)this.parent((int)index)).element, this.heap.get((int)index).element) >= 0) {
            this.exchange(index, this.parent(index));
            index = this.parent(index);
            modified = true;
        }
        return modified;
    }

    private final void minHeapify(Node node) {
        int index = node.position;
        int left = this.left(index);
        int right = this.right(index);
        int smallest = left < this.size && this.comparator.compare(this.heap.get((int)left).element, this.heap.get((int)index).element) <= 0 ? left : index;
        if (right < this.size && this.comparator.compare(this.heap.get((int)right).element, this.heap.get((int)smallest).element) <= 0) {
            smallest = right;
        }
        if (smallest != index) {
            this.exchange(index, smallest);
            this.minHeapify(this.heap.get(smallest));
        }
    }

    private final void exchange(int index, int index2) {
        Node temp = this.heap.get(index);
        temp.position = index2;
        Node temp2 = this.heap.get(index2);
        temp2.position = index;
        this.heap.set(index, temp2);
        this.heap.set(index2, temp);
    }

    private final int parent(int i) {
        return i / 2;
    }

    private final int left(int i) {
        return 2 * i;
    }

    private final int right(int i) {
        return 2 * i + 1;
    }

    public final Iterator<T> iterator() {
        return new Iterator<T>(){
            private Iterator<Node> iterator;
            {
                this.iterator = Heap.this.heap.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                return this.iterator.next().element;
            }

            @Override
            public void remove() {
            }
        };
    }

    private class Node {
        public T element;
        public int position;

        private Node() {
        }
    }
}

