/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client;

import com.flansmod.client.debug.EntityDebugAABB;
import com.flansmod.common.FlansMod;
import com.flansmod.common.physics.PhysicsHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import jinngine.geometry.Box;
import jinngine.geometry.Geometry;
import jinngine.math.Vector3;
import jinngine.physics.Body;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;

public class PhysicsHandlerClient
extends PhysicsHandler {
    private ArrayList<Chunk> chunksToLoad = new ArrayList();

    @Override
    public void tick() {
        super.tick();
        for (int i = 0; i < this.chunksToLoad.size(); ++i) {
            Chunk chunk = this.chunksToLoad.get(i);
            this.createPhysicsObjectsFromChunk(chunk);
        }
        this.chunksToLoad.clear();
        if (FlansMod.ticker % 200 == 0) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || !FlansMod.DEBUG) {
                return;
            }
            Chunk chunk = world.func_72964_e(player.field_70176_ah, player.field_70164_aj);
            Body body = (Body)this.chunkCollisionObjects.get(chunk);
            if (body == null) {
                return;
            }
            Iterator<Geometry> geometries = body.getGeometries();
            while (geometries.hasNext()) {
                Box box = (Box)geometries.next();
                Vector3 origin = new Vector3();
                box.getLocalTranslation(origin);
                Vector3 lengths = box.getDimentions();
                if (player.func_70011_f(origin.x, origin.y, origin.z) > 20.0) continue;
                world.func_72838_d((Entity)new EntityDebugAABB((World)world, origin, lengths, 400));
            }
        }
    }

    @Override
    @SubscribeEvent
    public void chunkLoaded(ChunkEvent event) {
        Chunk chunk = event.getChunk();
        if (event instanceof ChunkEvent.Load) {
            this.chunksToLoad.add(chunk);
        } else if (event instanceof ChunkEvent.Unload) {
            this.chunkCollisionObjects.remove(chunk);
        }
    }
}

