/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.physics;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import jinngine.geometry.Box;
import jinngine.physics.Body;
import jinngine.physics.DefaultScene;
import jinngine.physics.Scene;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;

public class PhysicsHandler {
    private static final float STEPSIZE = 5.0f;
    protected HashMap<Chunk, Body> chunkCollisionObjects = new HashMap();
    protected Scene physicsScene = new DefaultScene();

    public PhysicsHandler() {
        this.physicsScene.setTimestep(0.05);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public Scene getPhysicsScene() {
        return this.physicsScene;
    }

    public void tick() {
        if (this.physicsScene != null) {
            this.physicsScene.tick();
        }
    }

    @SubscribeEvent
    public void chunkLoaded(ChunkEvent event) {
        Chunk chunk = event.getChunk();
        if (event instanceof ChunkEvent.Load) {
            this.createPhysicsObjectsFromChunk(chunk);
        } else if (event instanceof ChunkEvent.Unload) {
            this.chunkCollisionObjects.remove(chunk);
        }
    }

    protected void createPhysicsObjectsFromChunk(Chunk chunk) {
        ArrayList<Box> boxes = new ArrayList<Box>();
        boolean[][][] doneConverting = new boolean[16][256][16];
        for (int j = 0; j < 256; ++j) {
            for (int i = 0; i < 16; ++i) {
                for (int k = 0; k < 16; ++k) {
                    if (doneConverting[i][j][k]) continue;
                    if (this.opaque(chunk, i, j, k)) {
                        int k1;
                        int y;
                        int i1;
                        int z;
                        int x;
                        for (x = i + 1; x < 16 && this.opaque(chunk, x, j, k); ++x) {
                        }
                        for (z = k + 1; z < 16; ++z) {
                            boolean rowSolid = true;
                            for (i1 = i; i1 < x; ++i1) {
                                if (this.opaque(chunk, i1, j, z)) continue;
                                rowSolid = false;
                            }
                            if (!rowSolid) break;
                        }
                        for (y = j + 1; y < 16; ++y) {
                            boolean slabSolid = true;
                            for (int i12 = i; i12 < x; ++i12) {
                                for (k1 = k; k1 < z; ++k1) {
                                    if (this.opaque(chunk, i12, y, k1)) continue;
                                    slabSolid = false;
                                }
                            }
                            if (!slabSolid) break;
                        }
                        for (i1 = i; i1 < x; ++i1) {
                            for (int j1 = j; j1 < y; ++j1) {
                                for (k1 = k; k1 < z; ++k1) {
                                    doneConverting[i1][j1][k1] = true;
                                }
                            }
                        }
                        Box box = new Box(x - i, y - j, z - k, chunk.field_76635_g * 16 + i, j, chunk.field_76647_h * 16 + k);
                        box.setMass(0.0);
                        boxes.add(box);
                        continue;
                    }
                    doneConverting[i][j][k] = true;
                }
            }
        }
        Body body = new Body("x" + chunk.field_76635_g + "|z" + chunk.field_76647_h, boxes.iterator());
        this.chunkCollisionObjects.put(chunk, body);
    }

    private boolean opaque(Chunk chunk, int x, int y, int z) {
        return chunk.func_150810_a(x, y, z).func_149662_c();
    }
}

