/*
 * Decompiled with CFR 0.152.
 */
package jinngine.geometry.util;

import java.util.List;
import jinngine.collision.GJK;
import jinngine.geometry.SupportMap3;
import jinngine.math.InertiaMatrix;
import jinngine.math.Matrix3;
import jinngine.math.Vector3;

public class MassProperties {
    private final GJK gjk = new GJK();
    private final double masslimit;
    private final SupportMap3 Sa;
    private double totalmass = 0.0;
    private final Vector3 centreofmass = new Vector3();
    private final InertiaMatrix inertia = new InertiaMatrix();

    public MassProperties(SupportMap3 shape, double masslimit) {
        this.Sa = shape;
        this.masslimit = masslimit;
        this.divide(this.Sa.supportPoint((Vector3)new Vector3((double)1.0, (double)0.0, (double)0.0)).x, this.Sa.supportPoint((Vector3)new Vector3((double)-1.0, (double)0.0, (double)0.0)).x, this.Sa.supportPoint((Vector3)new Vector3((double)0.0, (double)1.0, (double)0.0)).y, this.Sa.supportPoint((Vector3)new Vector3((double)0.0, (double)-1.0, (double)0.0)).y, this.Sa.supportPoint((Vector3)new Vector3((double)0.0, (double)0.0, (double)1.0)).z, this.Sa.supportPoint((Vector3)new Vector3((double)0.0, (double)0.0, (double)-1.0)).z, 0);
        Vector3.multiply(this.centreofmass, 1.0 / this.totalmass);
        InertiaMatrix.translate(this.inertia, this.totalmass, this.centreofmass.multiply(-1.0));
    }

    private final void divide(final double xmax, final double xmin, final double ymax, final double ymin, final double zmax, final double zmin, int depth) {
        double xl = Math.abs(xmax - xmin);
        double yl = Math.abs(ymax - ymin);
        double zl = Math.abs(zmax - zmin);
        double localmass = xl * yl * zl;
        SupportMap3 Sb = new SupportMap3(){

            @Override
            public Vector3 supportPoint(Vector3 v) {
                double sv1 = v.x < 0.0 ? xmin : xmax;
                double sv2 = v.y < 0.0 ? ymin : ymax;
                double sv3 = v.z < 0.0 ? zmin : zmax;
                return new Vector3(sv1, sv2, sv3);
            }

            @Override
            public void supportFeature(Vector3 d, double epsilon, List<Vector3> face) {
            }
        };
        Vector3 va = new Vector3();
        Vector3 vb = new Vector3();
        boolean separated = false;
        this.gjk.run(this.Sa, Sb, va, vb, 0.0, 1.0E-7, 32);
        boolean bl = separated = !this.gjk.getState().intersection;
        if (separated) {
            return;
        }
        if (localmass < this.masslimit || this.testInclusion(xmax, xmin, ymax, ymin, zmax, zmin)) {
            this.totalmass += localmass;
            InertiaMatrix localinertia = new InertiaMatrix();
            Matrix3.set(localinertia, 0.0833333358168602 * localmass * (yl * yl + zl * zl), 0.0, 0.0, 0.0, 0.0833333358168602 * localmass * (xl * xl + zl * zl), 0.0, 0.0, 0.0, 0.0833333358168602 * localmass * (yl * yl + xl * xl));
            Vector3 localcentre = new Vector3((xmax + xmin) * 0.5, (ymax + ymin) * 0.5, (zmax + zmin) * 0.5);
            InertiaMatrix.translate(localinertia, localmass, localcentre);
            Matrix3.add(this.inertia, localinertia, this.inertia);
            Vector3.add(this.centreofmass, localcentre.multiply(localmass));
            return;
        }
        this.divide((xmax + xmin) * 0.5, xmin, (ymax + ymin) * 0.5, ymin, (zmax + zmin) * 0.5, zmin, depth + 1);
        this.divide(xmax, (xmax + xmin) * 0.5, (ymax + ymin) * 0.5, ymin, (zmax + zmin) * 0.5, zmin, depth + 1);
        this.divide((xmax + xmin) * 0.5, xmin, ymax, (ymax + ymin) * 0.5, (zmax + zmin) * 0.5, zmin, depth + 1);
        this.divide(xmax, (xmax + xmin) * 0.5, ymax, (ymax + ymin) * 0.5, (zmax + zmin) * 0.5, zmin, depth + 1);
        this.divide((xmax + xmin) * 0.5, xmin, (ymax + ymin) * 0.5, ymin, zmax, (zmax + zmin) * 0.5, depth + 1);
        this.divide(xmax, (xmax + xmin) * 0.5, (ymax + ymin) * 0.5, ymin, zmax, (zmax + zmin) * 0.5, depth + 1);
        this.divide((xmax + xmin) * 0.5, xmin, ymax, (ymax + ymin) * 0.5, zmax, (zmax + zmin) * 0.5, depth + 1);
        this.divide(xmax, (xmax + xmin) * 0.5, ymax, (ymax + ymin) * 0.5, zmax, (zmax + zmin) * 0.5, depth + 1);
    }

    private final boolean testInclusion(double xmax, double xmin, double ymax, double ymin, double zmax, double zmin) {
        Vector3 pa = new Vector3();
        Vector3 pb = new Vector3();
        final Vector3 point = new Vector3();
        SupportMap3 Sb = new SupportMap3(){

            @Override
            public Vector3 supportPoint(Vector3 v) {
                return point;
            }

            @Override
            public void supportFeature(Vector3 d, double epsilon, List<Vector3> face) {
            }
        };
        point.assign(xmax, ymax, zmax);
        this.gjk.run(this.Sa, Sb, pa, pb, 0.0, 1.0E-7, 32);
        if (!this.gjk.getState().intersection) {
            return false;
        }
        point.assign(xmin, ymax, zmax);
        this.gjk.run(this.Sa, Sb, pa, pb, 0.0, 1.0E-7, 32);
        if (!this.gjk.getState().intersection) {
            return false;
        }
        point.assign(xmax, ymin, zmax);
        this.gjk.run(this.Sa, Sb, pa, pb, 0.0, 1.0E-7, 32);
        if (!this.gjk.getState().intersection) {
            return false;
        }
        point.assign(xmin, ymin, zmax);
        this.gjk.run(this.Sa, Sb, pa, pb, 0.0, 1.0E-7, 32);
        if (!this.gjk.getState().intersection) {
            return false;
        }
        point.assign(xmax, ymax, zmin);
        this.gjk.run(this.Sa, Sb, pa, pb, 0.0, 1.0E-7, 32);
        if (!this.gjk.getState().intersection) {
            return false;
        }
        point.assign(xmin, ymax, zmin);
        this.gjk.run(this.Sa, Sb, pa, pb, 0.0, 1.0E-7, 32);
        if (!this.gjk.getState().intersection) {
            return false;
        }
        point.assign(xmax, ymin, zmin);
        this.gjk.run(this.Sa, Sb, pa, pb, 0.0, 1.0E-7, 32);
        if (!this.gjk.getState().intersection) {
            return false;
        }
        point.assign(xmin, ymin, zmin);
        this.gjk.run(this.Sa, Sb, pa, pb, 0.0, 1.0E-7, 32);
        return this.gjk.getState().intersection;
    }

    public Vector3 getCentreOfMass() {
        return this.centreofmass.copy();
    }

    public double getMass() {
        return this.totalmass;
    }

    public Matrix3 getInertiaMatrix() {
        return this.inertia.copy();
    }
}

