/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics.constraint.joint;

import java.util.Iterator;
import java.util.ListIterator;
import jinngine.math.Matrix3;
import jinngine.math.Vector3;
import jinngine.physics.Body;
import jinngine.physics.constraint.Constraint;
import jinngine.physics.constraint.joint.JointAxisController;
import jinngine.physics.solver.Solver;
import jinngine.util.Pair;

public final class HingeJoint
implements Constraint {
    public final Body b1;
    public final Body b2;
    public final Vector3 pi;
    public final Vector3 pj;
    public final Vector3 ni;
    public final Vector3 nj;
    public final Vector3 t2i;
    public final Vector3 t2j;
    public final Vector3 t3i;
    private final JointAxisController controler;
    public double upperLimit = Double.POSITIVE_INFINITY;
    public double lowerLimit = Double.NEGATIVE_INFINITY;
    private double motor = 0.0;
    private double theta = 0.0;
    private double velocity = 0.0;
    private double friction = 0.0;
    private final double shell = 0.05;
    private Solver.NCPConstraint linear1 = new Solver.NCPConstraint();
    private Solver.NCPConstraint linear2 = new Solver.NCPConstraint();
    private Solver.NCPConstraint linear3 = new Solver.NCPConstraint();
    private Solver.NCPConstraint angular1 = new Solver.NCPConstraint();
    private Solver.NCPConstraint angular2 = new Solver.NCPConstraint();
    private Solver.NCPConstraint angular3 = new Solver.NCPConstraint();

    public JointAxisController getHingeControler() {
        return this.controler;
    }

    public HingeJoint(Body b1, Body b2, Vector3 p, Vector3 n) {
        this.b1 = b1;
        this.b2 = b2;
        this.pi = b1.toModel(p);
        this.ni = b1.toModelNoTranslation(n);
        this.pj = b2.toModel(p);
        this.nj = b2.toModelNoTranslation(n);
        Vector3 v1 = n.normalize();
        Vector3 v2 = Vector3.i;
        Vector3 v3 = Vector3.k;
        Vector3 t1 = v1.normalize();
        this.t2i = v2.minus(t1.multiply(t1.dot(v2)));
        this.t2i.print();
        if (this.t2i.abs().lessThan(Vector3.epsilon)) {
            v2 = Vector3.j;
            v3 = Vector3.k;
            this.t2i.assign(v2.minus(t1.multiply(t1.dot(v2))).normalize());
        } else {
            this.t2i.assign(this.t2i.normalize());
        }
        this.t2j = b2.toModelNoTranslation(b1.toWorldNoTranslation(this.t2i));
        this.t2j.print();
        if (v1.cross(v3).abs().lessThan(Vector3.epsilon)) {
            v3 = Vector3.j;
        }
        this.t3i = v3.minus(t1.multiply(t1.dot(v3)).minus(this.t2i.multiply(this.t2i.dot(v3)))).normalize();
        this.t3i.print();
        this.controler = new JointAxisController(){

            @Override
            public double getPosition() {
                return HingeJoint.this.theta;
            }

            @Override
            public void setLimits(double thetaMin, double thetaMax) {
                HingeJoint.this.upperLimit = thetaMax;
                HingeJoint.this.lowerLimit = thetaMin;
            }

            @Override
            public double getVelocity() {
                return HingeJoint.this.velocity;
            }

            @Override
            public void setFrictionMagnitude(double magnitude) {
                HingeJoint.this.friction = magnitude;
            }

            @Override
            public void setMotorForce(double force) {
                HingeJoint.this.motor = force;
            }
        };
    }

    public HingeJoint(Body b1, Body b2, Vector3 pi, Vector3 ni, Vector3 t2i, Vector3 t3i, Vector3 pj, Vector3 nj, Vector3 t2j, double lower, double upper) {
        this.b1 = b1;
        this.b2 = b2;
        this.pi = pi;
        this.ni = ni;
        this.pj = pj;
        this.nj = nj;
        this.upperLimit = upper;
        this.lowerLimit = lower;
        this.t2i = t2i;
        this.t3i = t3i;
        this.t2j = t2j;
        this.controler = new JointAxisController(){

            @Override
            public double getPosition() {
                return HingeJoint.this.theta;
            }

            @Override
            public void setLimits(double thetaMin, double thetaMax) {
                HingeJoint.this.upperLimit = thetaMax;
                HingeJoint.this.lowerLimit = thetaMin;
            }

            @Override
            public double getVelocity() {
                return HingeJoint.this.velocity;
            }

            @Override
            public void setFrictionMagnitude(double magnitude) {
                HingeJoint.this.friction = magnitude;
            }

            @Override
            public void setMotorForce(double force) {
                HingeJoint.this.motor = force;
            }
        };
    }

    @Override
    public final void applyConstraints(ListIterator<Solver.NCPConstraint> iterator, double dt) {
        Vector3 ri = Matrix3.multiply(this.b1.state.rotation, this.pi, new Vector3());
        Vector3 rj = Matrix3.multiply(this.b2.state.rotation, this.pj, new Vector3());
        Vector3 tt2i = Matrix3.multiply(this.b1.state.rotation, this.t2i, new Vector3());
        Vector3 tt2j = Matrix3.multiply(this.b2.state.rotation, this.t2j, new Vector3());
        Vector3 tt3i = Matrix3.multiply(this.b1.state.rotation, this.t3i, new Vector3());
        Vector3 tn1 = Matrix3.multiply(this.b1.state.rotation, this.ni, new Vector3());
        Vector3 tn2 = Matrix3.multiply(this.b2.state.rotation, this.nj, new Vector3());
        Matrix3 Ji = Matrix3.identity().multiply(1.0);
        Matrix3 Jangi = ri.crossProductMatrix3().multiply(-1.0);
        Matrix3 Jj = Matrix3.identity().multiply(-1.0);
        Matrix3 Jangj = rj.crossProductMatrix3().multiply(1.0);
        Matrix3 MiInv = Matrix3.identity().multiply(1.0 / this.b1.state.mass);
        Matrix3 MjInv = Matrix3.identity().multiply(1.0 / this.b2.state.mass);
        Matrix3 Bi = this.b1.isFixed() ? new Matrix3() : MiInv.multiply(Ji.transpose());
        Matrix3 Bangi = this.b1.isFixed() ? new Matrix3() : this.b1.state.inverseinertia.multiply(Jangi.transpose());
        Matrix3 Bj = this.b2.isFixed() ? new Matrix3() : MjInv.multiply(Jj.transpose());
        Matrix3 Bangj = this.b2.isFixed() ? new Matrix3() : this.b2.state.inverseinertia.multiply(Jangj.transpose());
        double Kcor = 1.0;
        Vector3 u = this.b1.state.velocity.add(this.b1.state.omega.cross(ri)).minus(this.b2.state.velocity.add(this.b2.state.omega.cross(rj)));
        Vector3 posError = this.b1.state.position.add(ri).minus(this.b2.state.position).minus(rj).multiply(1.0 / dt);
        Vector3 nerror = tn1.cross(tn2);
        u.assign(u.add(posError.multiply(Kcor)));
        this.linear1.assign(this.b1, this.b2, Bi.column(0), Bangi.column(0), Bj.column(0), Bangj.column(0), Ji.row(0), Jangi.row(0), Jj.row(0), Jangj.row(0), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null, u.x, 0.0);
        this.linear2.assign(this.b1, this.b2, Bi.column(1), Bangi.column(1), Bj.column(1), Bangj.column(1), Ji.row(1), Jangi.row(1), Jj.row(1), Jangj.row(1), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null, u.y, 0.0);
        this.linear3.assign(this.b1, this.b2, Bi.column(2), Bangi.column(2), Bj.column(2), Bangj.column(2), Ji.row(2), Jangi.row(2), Jj.row(2), Jangj.row(2), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null, u.z, 0.0);
        double low = 0.0;
        double high = 0.0;
        double correction = 0.0;
        Vector3 axis = tn1;
        double sign = tt2i.cross(tt2j).dot(tn1) > 0.0 ? 1.0 : -1.0;
        double product = tt2i.dot(tt2j);
        this.theta = -Math.acos(product) * sign;
        double motorHigh = this.motor > 0.0 ? this.motor : 0.0;
        double motorLow = this.motor < 0.0 ? this.motor : 0.0;
        this.velocity = axis.dot(this.b1.state.omega) - axis.dot(this.b2.state.omega);
        double bvalue = 0.0;
        double e = 0.0;
        if (this.theta > this.upperLimit) {
            correction = (this.theta - (this.upperLimit + 0.05)) * (1.0 / dt) * Kcor;
            high = motorHigh;
            low = Double.NEGATIVE_INFINITY;
            bvalue = (1.0 + e) * this.velocity + correction;
        } else if (this.theta < this.lowerLimit) {
            correction = (this.theta - (this.lowerLimit - 0.05)) * (1.0 / dt) * Kcor;
            high = Double.POSITIVE_INFINITY;
            low = motorLow;
            bvalue = (1.0 + e) * this.velocity + correction;
        } else if (this.motor != 0.0) {
            high = motorHigh;
            low = motorLow;
            bvalue = Math.signum(this.motor) > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        } else {
            high = this.friction;
            low = -this.friction;
            bvalue = this.velocity;
        }
        this.angular1.assign(this.b1, this.b2, new Vector3(), this.b1.isFixed() ? new Vector3() : this.b1.state.inverseinertia.multiply(axis), new Vector3(), this.b2.isFixed() ? new Vector3() : this.b2.state.inverseinertia.multiply(axis.multiply(-1.0)), new Vector3(), axis, new Vector3(), axis.multiply(-1.0), low, high, null, bvalue, 0.0);
        this.angular2.assign(this.b1, this.b2, new Vector3(), this.b1.isFixed() ? new Vector3() : this.b1.state.inverseinertia.multiply(tt2i), new Vector3(), this.b2.isFixed() ? new Vector3() : this.b2.state.inverseinertia.multiply(tt2i.multiply(-1.0)), new Vector3(), tt2i, new Vector3(), tt2i.multiply(-1.0), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null, tt2i.dot(this.b1.state.omega) - tt2i.dot(this.b2.state.omega) - Kcor * tt2i.dot(nerror) * (1.0 / dt), 0.0);
        this.angular3.assign(this.b1, this.b2, new Vector3(), this.b1.isFixed() ? new Vector3() : this.b1.state.inverseinertia.multiply(tt3i), new Vector3(), this.b2.isFixed() ? new Vector3() : this.b2.state.inverseinertia.multiply(tt3i.multiply(-1.0)), new Vector3(), tt3i, new Vector3(), tt3i.multiply(-1.0), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null, tt3i.dot(this.b1.state.omega) - tt3i.dot(this.b2.state.omega) - Kcor * tt3i.dot(nerror) * (1.0 / dt), 0.0);
        iterator.add(this.linear1);
        iterator.add(this.linear2);
        iterator.add(this.linear3);
        iterator.add(this.angular1);
        iterator.add(this.angular2);
        iterator.add(this.angular3);
    }

    @Override
    public Pair<Body> getBodies() {
        return new Pair<Body>(this.b1, this.b2);
    }

    @Override
    public final Iterator<Solver.NCPConstraint> getNcpConstraints() {
        return new Iterator<Solver.NCPConstraint>(){
            private int i = 0;

            @Override
            public final boolean hasNext() {
                return this.i < 6;
            }

            @Override
            public final Solver.NCPConstraint next() {
                switch (this.i) {
                    case 0: {
                        ++this.i;
                        return HingeJoint.this.linear1;
                    }
                    case 1: {
                        ++this.i;
                        return HingeJoint.this.linear2;
                    }
                    case 2: {
                        ++this.i;
                        return HingeJoint.this.linear3;
                    }
                    case 3: {
                        ++this.i;
                        return HingeJoint.this.angular1;
                    }
                    case 4: {
                        ++this.i;
                        return HingeJoint.this.angular2;
                    }
                    case 5: {
                        ++this.i;
                        return HingeJoint.this.angular3;
                    }
                }
                return null;
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

