/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.avp.entities.instance;

import com.arisux.avp.AliensVsPredator;
import com.arisux.avp.damagesource.DamageSourceDisc;
import com.arisux.avp.entities.instance.EntityProjectile;
import com.arisux.avp.handler.ItemHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityDisc
extends EntityProjectile {
    public static final double RETURN_STRENGTH = 0.05;
    public static final float MIN_FLOAT_STRENGTH = 0.7f;
    private float soundTimer;
    public float floatStrength;
    public Item thrownItem;

    public EntityDisc(World world) {
        super(world);
        ItemHandler cfr_ignored_0 = AliensVsPredator.instance().items;
        this.thrownItem = ItemHandler.itemDisc;
    }

    public EntityDisc(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public EntityDisc(World world, EntityLivingBase entityliving, ItemStack itemstack, float f) {
        this(world);
        this.shootingEntity = entityliving;
        this.setPickupModeFromEntity(entityliving);
        this.func_70012_b(entityliving.field_70165_t, entityliving.field_70163_u + (double)entityliving.func_70047_e(), entityliving.field_70161_v, entityliving.field_70177_z, entityliving.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.1;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, f, 5.0f);
        this.soundTimer = 0.0f;
        this.floatStrength = Math.min(1.5f, f);
        this.field_70180_af.func_75692_b(29, (Object)Float.floatToRawIntBits(this.floatStrength));
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(29, (Object)Float.floatToRawIntBits(0.0f));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.floatStrength = Float.intBitsToFloat(this.field_70180_af.func_75679_c(29));
        if (!this.inGround) {
            this.floatStrength *= 0.994f;
            if (this.floatStrength < 0.7f) {
                if (this.isCritical()) {
                    this.setCritical(false);
                }
                this.floatStrength = 0.0f;
            }
            float limitedStrength = Math.min(1.0f, this.floatStrength);
            if (!this.beenInGround) {
                this.field_70177_z += 20.0f * this.floatStrength;
            }
            if (!this.beenInGround && this.shootingEntity != null && this.floatStrength > 0.0f) {
                double dx = this.field_70165_t - this.shootingEntity.field_70165_t;
                double dy = this.field_70163_u - this.shootingEntity.field_70163_u - (double)this.shootingEntity.func_70047_e();
                double dz = this.field_70161_v - this.shootingEntity.field_70161_v;
                double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
                this.field_70159_w -= 0.05 * (dx /= d);
                this.field_70181_x -= 0.05 * (dy /= d);
                this.field_70179_y -= 0.05 * (dz /= d);
                this.soundTimer += limitedStrength;
                if (this.soundTimer > 3.0f) {
                    this.field_70170_p.func_72956_a((Entity)this, "random.bow", 0.6f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 2.2f - limitedStrength));
                    this.soundTimer %= 3.0f;
                }
            }
            this.field_70180_af.func_75692_b(29, (Object)Float.floatToRawIntBits(this.floatStrength));
        }
    }

    @Override
    public void onEntityHit(Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.floatStrength >= 0.7f) {
            if (entity != this.shootingEntity) {
                Object damagesource = null;
                DamageSource damagesource1 = this.shootingEntity == null ? DamageSourceDisc.causeSpearDamage(this, this) : DamageSourceDisc.causeSpearDamage(this, this.shootingEntity);
                if (entity.func_70097_a(damagesource1, 5.0f)) {
                    this.playHitSound();
                    if (this.thrownItem.func_77612_l() + 1 <= this.thrownItem.func_77612_l()) {
                        this.func_70016_h(0.2 * this.field_70146_Z.nextDouble() - 0.1, 0.2 * this.field_70146_Z.nextDouble() - 0.1, 0.2 * this.field_70146_Z.nextDouble() - 0.1);
                    }
                } else {
                    this.bounceBack();
                }
            } else if (entity instanceof EntityPlayer) {
                EntityPlayer damagesource = (EntityPlayer)entity;
                ItemStack item = this.getPickupItem();
                if (item == null) {
                    return;
                }
                if (damagesource.field_71075_bZ.field_75098_d || damagesource.field_71071_by.func_70441_a(item)) {
                    this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    this.onItemPickup(damagesource);
                    this.func_70106_y();
                    return;
                }
            }
        }
    }

    @Override
    public void onGroundHit(MovingObjectPosition mop) {
        this.xTile = mop.field_72311_b;
        this.yTile = mop.field_72312_c;
        this.zTile = mop.field_72309_d;
        this.inTile = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
        this.field_70159_w = (float)(mop.field_72307_f.field_72450_a - this.field_70165_t);
        this.field_70181_x = (float)(mop.field_72307_f.field_72448_b - this.field_70163_u);
        this.field_70179_y = (float)(mop.field_72307_f.field_72449_c - this.field_70161_v);
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)f1 * 0.05;
        this.field_70163_u -= this.field_70181_x / (double)f1 * 0.05;
        this.field_70161_v -= this.field_70179_y / (double)f1 * 0.05;
        this.field_70159_w *= (double)(-this.field_70146_Z.nextFloat() * 0.5f);
        this.field_70179_y *= (double)(-this.field_70146_Z.nextFloat() * 0.5f);
        this.field_70181_x = this.field_70146_Z.nextFloat() * 0.1f;
        this.inGround = mop.field_72310_e == 1;
        this.setCritical(false);
        this.beenInGround = true;
        this.floatStrength = 0.0f;
    }

    @Override
    public void playHitSound() {
        this.field_70170_p.func_72956_a((Entity)this, "random.bowhit", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.9f));
    }

    @Override
    public boolean aimRotation() {
        return this.beenInGround || this.floatStrength < 0.7f;
    }

    @Override
    public int getMaxLifetime() {
        return this.pickupMode != 1 && this.pickupMode != 3 ? 1200 : 0;
    }

    @Override
    public boolean canBeCritical() {
        return true;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    public float getGravity() {
        return !this.beenInGround && this.floatStrength >= 0.7f ? 0.0f : 0.05f;
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public void func_70100_b_(EntityPlayer entityplayer) {
        if (!this.field_70170_p.field_72995_K && this.inGround && entityplayer == this.shootingEntity && this.arrowShake <= 0 && entityplayer.field_71071_by.func_70441_a(new ItemStack(ItemHandler.itemDisc, 1))) {
            this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayer.func_71001_a((Entity)this, 1);
            this.func_70106_y();
        }
    }
}

