/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.avp.entities.instance;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public abstract class EntityProjectile
extends Entity
implements IProjectile {
    public static final int NO_PICKUP = 0;
    public static final int PICKUP_ALL = 1;
    public static final int PICKUP_CREATIVE = 2;
    public static final int PICKUP_OWNER = 3;
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected Block inTile = Blocks.field_150350_a;
    protected int inData = 0;
    protected boolean inGround = false;
    public int arrowShake = 0;
    public int pickupMode;
    public Entity shootingEntity;
    protected int ticksInGround;
    protected int ticksInAir = 0;
    public boolean beenInGround;
    protected int extraDamage;
    protected int knockBack;

    public EntityProjectile(World world) {
        super(world);
        this.field_70129_M = 0.0f;
        this.pickupMode = 0;
        this.extraDamage = 0;
        this.knockBack = 0;
        this.func_70105_a(0.5f, 0.5f);
    }

    protected void func_70088_a() {
        if (this.canBeCritical()) {
            this.field_70180_af.func_75682_a(16, (Object)0);
        }
    }

    protected void setPickupModeFromEntity(EntityLivingBase entityliving) {
        if (entityliving instanceof EntityPlayer) {
            if (((EntityPlayer)entityliving).field_71075_bZ.field_75098_d) {
                this.setPickupMode(2);
            }
        } else {
            this.setPickupMode(0);
        }
    }

    public void func_70186_c(double x, double y, double z, float speed, float deviation) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)deviation;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)deviation;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)deviation;
        this.field_70159_w = x *= (double)speed;
        this.field_70181_x = y *= (double)speed;
        this.field_70179_y = z *= (double)speed;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    public void func_70016_h(double d, double d1, double d2) {
        this.field_70159_w = d;
        this.field_70181_x = d1;
        this.field_70179_y = d2;
        if (this.aimRotation() && this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(d * d + d2 * d2));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(d, d2) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(d1, f) * 180.0 / Math.PI);
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70071_h_() {
        Block var16;
        super.func_70071_h_();
        if (this.aimRotation()) {
            float i = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, i) * 180.0 / Math.PI);
        }
        if ((var16 = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile)) != Blocks.field_150350_a) {
            var16.func_149719_a((IBlockAccess)this.field_70170_p, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB vec3d = var16.func_149668_a(this.field_70170_p, this.xTile, this.yTile, this.zTile);
            if (vec3d != null && vec3d.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.inGround = true;
            }
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            Block var18 = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
            int var19 = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
            if (var18 == this.inTile && var19 == this.inData) {
                ++this.ticksInGround;
                int var20 = this.getMaxLifetime();
                if (var20 != 0 && this.ticksInGround >= var20) {
                    this.func_70106_y();
                }
            } else {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            int res;
            ++this.ticksInAir;
            Vec3 var17 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 vec3d1 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition movingobjectposition = this.field_70170_p.func_147447_a(var17, vec3d1, false, true, true);
            var17 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            vec3d1 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (movingobjectposition != null) {
                vec3d1 = Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d = 0.0;
            for (res = 0; res < list.size(); ++res) {
                double d1;
                float i1;
                AxisAlignedBB f6;
                MovingObjectPosition movingobjectposition1;
                Entity grav = (Entity)list.get(res);
                if (!grav.func_70067_L() || grav == this.shootingEntity && this.ticksInAir < 5 || (movingobjectposition1 = (f6 = grav.field_70121_D.func_72314_b((double)(i1 = 0.3f), (double)i1, (double)i1)).func_72327_a(var17, vec3d1)) == null || !((d1 = var17.func_72438_d(movingobjectposition1.field_72307_f)) < d) && d != 0.0) continue;
                entity = grav;
                d = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
            if (movingobjectposition != null) {
                if (movingobjectposition.field_72308_g != null) {
                    this.onEntityHit(movingobjectposition.field_72308_g);
                } else {
                    this.onGroundHit(movingobjectposition);
                }
            }
            if (this.isCritical()) {
                for (res = 0; res < 2; ++res) {
                    this.field_70170_p.func_72869_a("crit", this.field_70165_t + this.field_70159_w * (double)res / 4.0, this.field_70163_u + this.field_70181_x * (double)res / 4.0, this.field_70161_v + this.field_70179_y * (double)res / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            if (this.aimRotation()) {
                float var23 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
                this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var23) * 180.0 / Math.PI);
                while (this.field_70125_A - this.field_70127_C < -180.0f) {
                    this.field_70127_C -= 360.0f;
                }
                while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                    this.field_70127_C += 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B < -180.0f) {
                    this.field_70126_B -= 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                    this.field_70126_B += 360.0f;
                }
                this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
                this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            }
            float var23 = this.getAirResistance();
            float var22 = this.getGravity();
            if (this.func_70090_H()) {
                this.beenInGround = true;
                for (int var21 = 0; var21 < 4; ++var21) {
                    float var24 = 0.25f;
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)var24, this.field_70163_u - this.field_70181_x * (double)var24, this.field_70161_v - this.field_70179_y * (double)var24, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                var23 *= 0.8080808f;
            }
            this.field_70159_w *= (double)var23;
            this.field_70181_x *= (double)var23;
            this.field_70179_y *= (double)var23;
            this.field_70181_x -= (double)var22;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public void onEntityHit(Entity entity) {
        this.bounceBack();
    }

    public void onGroundHit(MovingObjectPosition mop) {
        this.xTile = mop.field_72311_b;
        this.yTile = mop.field_72312_c;
        this.zTile = mop.field_72309_d;
        this.inTile = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
        this.inData = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
        this.field_70159_w = (float)(mop.field_72307_f.field_72450_a - this.field_70165_t);
        this.field_70181_x = (float)(mop.field_72307_f.field_72448_b - this.field_70163_u);
        this.field_70179_y = (float)(mop.field_72307_f.field_72449_c - this.field_70161_v);
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)f1 * 0.05;
        this.field_70163_u -= this.field_70181_x / (double)f1 * 0.05;
        this.field_70161_v -= this.field_70179_y / (double)f1 * 0.05;
        this.inGround = true;
        this.beenInGround = true;
        this.setCritical(false);
        this.arrowShake = this.getMaxArrowShake();
        this.playHitSound();
        if (this.inTile != Blocks.field_150350_a) {
            this.inTile.func_149670_a(this.field_70170_p, this.xTile, this.yTile, this.zTile, (Entity)this);
        }
    }

    protected void bounceBack() {
        this.field_70159_w *= -0.1;
        this.field_70181_x *= -0.1;
        this.field_70179_y *= -0.1;
        this.field_70177_z += 180.0f;
        this.field_70126_B += 180.0f;
        this.ticksInAir = 0;
    }

    public final double getTotalVelocity() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
    }

    public boolean aimRotation() {
        return true;
    }

    public int getMaxLifetime() {
        return 1200;
    }

    public ItemStack getPickupItem() {
        return null;
    }

    public float getAirResistance() {
        return 0.99f;
    }

    public float getGravity() {
        return 0.05f;
    }

    public int getMaxArrowShake() {
        return 7;
    }

    public void playHitSound() {
    }

    public boolean canBeCritical() {
        return false;
    }

    public void setCritical(boolean flag) {
        if (this.canBeCritical()) {
            if (flag) {
                this.field_70180_af.func_75692_b(16, (Object)1);
            } else {
                this.field_70180_af.func_75692_b(16, (Object)0);
            }
        }
    }

    public boolean isCritical() {
        return this.canBeCritical() && this.field_70180_af.func_75683_a(16) != 0;
    }

    public void setExtraDamage(int i) {
        this.extraDamage = i;
    }

    public void setKnockback(int i) {
        this.knockBack = i;
    }

    public void setPickupMode(int i) {
        this.pickupMode = i;
    }

    public int getPickupMode() {
        return this.pickupMode;
    }

    public boolean canPickup(EntityPlayer entityplayer) {
        return this.pickupMode == 1 ? true : (this.pickupMode == 2 ? entityplayer.field_71075_bZ.field_75098_d : (this.pickupMode == 3 ? entityplayer == this.shootingEntity : false));
    }

    public void func_70100_b_(EntityPlayer entityplayer) {
        if (!this.field_70170_p.field_72995_K && this.inGround && this.arrowShake <= 0 && this.canPickup(entityplayer)) {
            ItemStack item = this.getPickupItem();
            if (item == null) {
                return;
            }
            if (this.pickupMode == 2 && entityplayer.field_71075_bZ.field_75098_d || entityplayer.field_71071_by.func_70441_a(item)) {
                this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.onItemPickup(entityplayer);
                this.func_70106_y();
            }
        }
    }

    protected void onItemPickup(EntityPlayer entityplayer) {
        entityplayer.func_71001_a((Entity)this, 1);
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            EntityTracker entityTracker = ((WorldServer)this.field_70170_p).func_73039_n();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74777_a("xTile", (short)this.xTile);
        nbttagcompound.func_74777_a("yTile", (short)this.yTile);
        nbttagcompound.func_74777_a("zTile", (short)this.zTile);
        nbttagcompound.func_74774_a("inData", (byte)this.inData);
        nbttagcompound.func_74774_a("shake", (byte)this.arrowShake);
        nbttagcompound.func_74757_a("inGround", this.inGround);
        nbttagcompound.func_74757_a("beenInGround", this.beenInGround);
        nbttagcompound.func_74774_a("pickup", (byte)this.pickupMode);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        this.xTile = nbttagcompound.func_74765_d("xTile");
        this.yTile = nbttagcompound.func_74765_d("yTile");
        this.zTile = nbttagcompound.func_74765_d("zTile");
        this.inData = nbttagcompound.func_74771_c("inData") & 0xFF;
        this.arrowShake = nbttagcompound.func_74771_c("shake") & 0xFF;
        this.inGround = nbttagcompound.func_74767_n("inGround");
        this.beenInGround = nbttagcompound.func_74767_n("beenInGrond");
        this.pickupMode = nbttagcompound.func_74771_c("pickup");
    }
}

