/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.GuiOverlayer;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.Platform;
import ic2.core.block.EntityDynamite;
import ic2.core.block.EntityIC2Explosive;
import ic2.core.block.OverlayTesr;
import ic2.core.block.RenderBlock;
import ic2.core.block.RenderBlockCrop;
import ic2.core.block.RenderBlockDefault;
import ic2.core.block.RenderBlockFence;
import ic2.core.block.RenderBlockWall;
import ic2.core.block.RenderExplosiveBlock;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.personal.RenderBlockPersonal;
import ic2.core.block.personal.TileEntityPersonalChest;
import ic2.core.block.personal.TileEntityPersonalChestRenderer;
import ic2.core.block.wiring.RenderBlockCable;
import ic2.core.block.wiring.RenderBlockLuminator;
import ic2.core.item.EntityIC2Boat;
import ic2.core.item.RenderIC2Boat;
import ic2.core.item.RenderLiquidCell;
import ic2.core.item.tool.EntityMiningLaser;
import ic2.core.item.tool.EntityParticle;
import ic2.core.item.tool.RenderBillboardEntity;
import ic2.core.item.tool.RenderCrossed;
import ic2.core.network.RpcHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;

@SideOnly(value=Side.CLIENT)
public class PlatformClient
extends Platform {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final Map<String, RenderBlock> renders = new HashMap<String, RenderBlock>();

    public PlatformClient() {
        this.addBlockRenderer("default", new RenderBlockDefault());
        this.addBlockRenderer("cable", new RenderBlockCable());
        this.addBlockRenderer("crop", new RenderBlockCrop());
        this.addBlockRenderer("fence", new RenderBlockFence());
        this.addBlockRenderer("luminator", new RenderBlockLuminator());
        this.addBlockRenderer("personal", new RenderBlockPersonal());
        this.addBlockRenderer("wall", new RenderBlockWall());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlock.class, (TileEntitySpecialRenderer)new OverlayTesr());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPersonalChest.class, (TileEntitySpecialRenderer)new TileEntityPersonalChestRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityIC2Explosive.class, (Render)new RenderExplosiveBlock());
        RenderingRegistry.registerEntityRenderingHandler(EntityMiningLaser.class, (Render)new RenderCrossed(new ResourceLocation("ic2", "textures/models/laser.png")));
        RenderingRegistry.registerEntityRenderingHandler(EntityIC2Boat.class, (Render)new RenderIC2Boat());
        RenderingRegistry.registerEntityRenderingHandler(EntityParticle.class, (Render)new RenderBillboardEntity());
    }

    @Override
    public void registerRenderers() {
        MinecraftForgeClient.registerItemRenderer((Item)Ic2Items.FluidCell.func_77973_b(), (IItemRenderer)new RenderLiquidCell());
    }

    @Override
    public void displayError(String error) {
        FMLLog.severe((String)"%s", (Object[])new Object[]{("IndustrialCraft 2 Error\n\n" + error).replace("\n", System.getProperty("line.separator"))});
        Minecraft.func_71410_x().func_71364_i();
        JOptionPane.showMessageDialog(null, error, "IndustrialCraft 2 Error", 0);
        System.exit(1);
    }

    @Override
    public EntityPlayer getPlayerInstance() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public World getWorld(int dimId) {
        if (this.isSimulating()) {
            return super.getWorld(dimId);
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        return world.field_73011_w.field_76574_g == dimId ? world : null;
    }

    @Override
    public void messagePlayer(EntityPlayer player, String message, Object ... args) {
        if (args.length > 0) {
            this.mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentTranslation(message, (Object[])this.getMessageComponents(args)));
        } else {
            this.mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(message));
        }
    }

    @Override
    public boolean launchGuiClient(EntityPlayer entityPlayer, IHasGui inventory, boolean isAdmin) {
        FMLClientHandler.instance().displayGuiScreen(entityPlayer, inventory.getGui(entityPlayer, isAdmin));
        return true;
    }

    @Override
    public void profilerStartSection(String section) {
        if (this.isRendering()) {
            Minecraft.func_71410_x().field_71424_I.func_76320_a(section);
        } else {
            super.profilerStartSection(section);
        }
    }

    @Override
    public void profilerEndSection() {
        if (this.isRendering()) {
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        } else {
            super.profilerEndSection();
        }
    }

    @Override
    public void profilerEndStartSection(String section) {
        if (this.isRendering()) {
            Minecraft.func_71410_x().field_71424_I.func_76318_c(section);
        } else {
            super.profilerEndStartSection(section);
        }
    }

    @Override
    public File getMinecraftDir() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @Override
    public void playSoundSp(String sound, float f, float g) {
        Minecraft.func_71410_x().field_71441_e.func_72956_a((Entity)this.getPlayerInstance(), sound, f, g);
    }

    @Override
    public int addArmor(String name) {
        return RenderingRegistry.addNewArmourRendererPrefix((String)name);
    }

    @Override
    public int getRenderId(String name) {
        return this.renders.get(name).getRenderId();
    }

    @Override
    public RenderBlock getRender(String name) {
        return this.renders.get(name);
    }

    @Override
    public void onPostInit() {
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamite.class, (Render)new RenderSnowball(Ic2Items.dynamite.func_77973_b()));
        MinecraftForge.EVENT_BUS.register((Object)new GuiOverlayer(Minecraft.func_71410_x()));
        new RpcHandler();
    }

    private void addBlockRenderer(String name, RenderBlock renderer) {
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)renderer);
        this.renders.put(name, renderer);
    }
}

