/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy;

import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.core.IC2;
import ic2.core.energy.CalculationResult;
import ic2.core.energy.EnergyNetLocal;
import ic2.core.energy.GridCalculation;
import ic2.core.energy.Node;
import ic2.core.energy.NodeLink;
import ic2.core.energy.NodeType;
import ic2.core.energy.StructureCache;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.tileentity.TileEntity;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.LinearSolverFactory;

class Grid {
    private static final boolean debugOutput = false;
    private static boolean debug = false;
    private final int uid;
    private final EnergyNetLocal energyNet;
    private final Map<Integer, Node> nodes = new HashMap<Integer, Node>();
    private final Set<Integer> activeSources = new HashSet<Integer>();
    private final Set<Integer> activeSinks = new HashSet<Integer>();
    private final StructureCache cache = new StructureCache();
    private Future<CalculationResult> calculation;

    Grid(EnergyNetLocal energyNet1) {
        this.uid = EnergyNetLocal.getNextGridUid();
        this.energyNet = energyNet1;
        energyNet1.grids.add(this);
    }

    public String toString() {
        return "Grid " + this.uid;
    }

    void add(Node node, Collection<Node> neighbors) {
        this.invalidate();
        this.add(node);
        for (Node neighbor : neighbors) {
            assert (neighbor != node);
            assert (this.nodes.containsKey(neighbor.uid));
            if (debug) {
                for (NodeLink link : node.links) {
                    assert (link.nodeA != neighbor);
                    assert (link.nodeB != neighbor);
                }
                for (NodeLink link : neighbor.links) {
                    assert (link.nodeA != node);
                    assert (link.nodeB != node);
                }
            }
            double loss = (node.getInnerLoss() + neighbor.getInnerLoss()) / 2.0;
            NodeLink link = new NodeLink(node, neighbor, loss);
            node.links.add(link);
            neighbor.links.add(link);
        }
    }

    void remove(Node node) {
        Node neighbor;
        this.invalidate();
        Iterator<NodeLink> it = node.links.iterator();
        while (it.hasNext()) {
            NodeLink link = it.next();
            neighbor = link.getNeighbor(node);
            boolean found = false;
            Iterator<NodeLink> it2 = neighbor.links.iterator();
            while (it2.hasNext()) {
                if (it2.next() != link) continue;
                it2.remove();
                found = true;
                break;
            }
            assert (found);
            if (!neighbor.links.isEmpty() || !neighbor.tile.removeExtraNode(neighbor)) continue;
            it.remove();
            this.nodes.remove(neighbor.uid);
        }
        this.nodes.remove(node.uid);
        if (node.links.isEmpty()) {
            this.energyNet.grids.remove(this);
        } else if (node.links.size() > 1) {
            int i;
            ArrayList nodeTable = new ArrayList();
            for (i = 0; i < node.links.size(); ++i) {
                Node cNode;
                neighbor = node.links.get(i).getNeighbor(node);
                HashSet<Node> connectedNodes = new HashSet<Node>();
                LinkedList<Node> nodesToCheck = new LinkedList<Node>(Arrays.asList(neighbor));
                while ((cNode = (Node)nodesToCheck.poll()) != null) {
                    if (!connectedNodes.add(cNode)) continue;
                    for (NodeLink link : cNode.links) {
                        Node nNode = link.getNeighbor(cNode);
                        if (connectedNodes.contains(nNode)) continue;
                        nodesToCheck.add(nNode);
                    }
                }
                nodeTable.add(connectedNodes);
            }
            assert (nodeTable.size() == node.links.size());
            for (i = 1; i < node.links.size(); ++i) {
                Set connectedNodes = (Set)nodeTable.get(i);
                Node neighbor2 = node.links.get(i).getNeighbor(node);
                assert (connectedNodes.contains(neighbor2));
                boolean found = false;
                for (int j = 0; j < i; ++j) {
                    Set cmpList = (Set)nodeTable.get(j);
                    if (!cmpList.contains(neighbor2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                Grid grid = new Grid(this.energyNet);
                for (Node cNode : connectedNodes) {
                    assert (this.nodes.containsKey(cNode.uid));
                    this.nodes.remove(cNode.uid);
                    grid.add(cNode);
                }
            }
        }
    }

    void merge(Grid grid) {
        assert (this.energyNet.grids.contains(grid));
        this.invalidate();
        for (Node node : grid.nodes.values()) {
            this.add(node);
        }
        this.energyNet.grids.remove(grid);
    }

    void prepareCalculation(Set<IEnergySource> activeSourceTiles) {
        assert (this.calculation == null);
        this.activeSources.clear();
        this.activeSinks.clear();
        for (Node node : this.nodes.values()) {
            assert (node.grid == this);
            switch (node.nodeType) {
                case Source: {
                    node.amount = Math.max(0.0, ((IEnergySource)node.tile.entity).getOfferedEnergy());
                    if (!(node.amount > 0.0)) break;
                    this.activeSources.add(node.uid);
                    break;
                }
                case Sink: {
                    node.amount = Math.max(0.0, ((IEnergySink)node.tile.entity).demandedEnergyUnits());
                    if (!(node.amount > 0.0)) break;
                    this.activeSinks.add(node.uid);
                    break;
                }
                case Conductor: {
                    node.amount = 0.0;
                }
            }
            assert (node.amount >= 0.0);
        }
        if (!this.activeSinks.isEmpty()) {
            Iterator<Object> i$ = this.activeSources.iterator();
            while (i$.hasNext()) {
                int nodeId = (Integer)i$.next();
                activeSourceTiles.add((IEnergySource)this.nodes.get((Object)Integer.valueOf((int)nodeId)).tile.entity);
            }
        }
    }

    void startCalculation() {
        assert (this.calculation == null);
        if (!this.activeSources.isEmpty() && !this.activeSinks.isEmpty()) {
            this.calculation = IC2.getInstance().threadPool.submit(new GridCalculation(this));
        }
    }

    void finishCalculation() {
        if (this.calculation == null) {
            return;
        }
        try {
            CalculationResult result = this.calculation.get();
            for (Map.Entry<TileEntity, Double> entry : result.changes.entrySet()) {
                this.energyNet.addChange(entry.getKey(), entry.getValue());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        this.calculation = null;
    }

    void calculate(Map<TileEntity, Double> changes) {
        for (int nodeId : this.activeSources) {
            Node node = this.nodes.get(nodeId);
            int shareCount = 1;
            for (Node shared : node.tile.nodes) {
                if (shared.uid == nodeId || shared.nodeType != NodeType.Source || shared.grid.activeSinks.isEmpty()) continue;
                assert (shared.grid.activeSources.contains(shared.uid));
                assert (shared.grid != this);
                ++shareCount;
            }
            node.amount /= (double)shareCount;
        }
        StructureCache.Data data = this.calculateDistribution();
        this.calculateEffects(data, changes);
    }

    private void add(Node node) {
        node.grid = this;
        Node prev = this.nodes.put(node.uid, node);
        if (prev != null) {
            throw new IllegalStateException("duplicate node uid, new " + node + ", old " + prev);
        }
    }

    private void invalidate() {
        this.finishCalculation();
        this.cache.clear();
    }

    private StructureCache.Data calculateDistribution() {
        long time = System.nanoTime();
        StructureCache.Data data = this.cache.get(this.activeSources, this.activeSinks);
        if (!data.isInitialized) {
            data.isInitialized = true;
            this.optimize(data);
            Grid.determineEmittingNodes(data);
            int size = data.emittingNodes.size();
            data.networkMatrix = new DenseMatrix64F(size, size);
            data.sourceMatrix = new DenseMatrix64F(size, 1);
            data.resultMatrix = new DenseMatrix64F(size, 1);
            Grid.populateNetworkMatrix(data);
            data.solver = LinearSolverFactory.symmPosDef((int)size);
            if (!data.solver.setA((Matrix64F)data.networkMatrix)) {
                throw new RuntimeException("incompatible matrix");
            }
        }
        this.populateSourceMatrix(data);
        data.solver.solve((Matrix64F)data.sourceMatrix, (Matrix64F)data.resultMatrix);
        return data;
    }

    private void calculateEffects(StructureCache.Data data, Map<TileEntity, Double> changes) {
        long time = System.nanoTime();
        for (Node node : data.optimizedNodes.values()) {
            Node realNode = this.nodes.get(node.uid);
            if (node.nodeType == NodeType.Source || node.nodeType != NodeType.Sink || !this.activeSinks.contains(node.uid)) continue;
            double sum = 0.0;
            block1: for (NodeLink link : node.links) {
                Node neighbor = link.getNeighbor(node);
                if (neighbor == node) continue;
                for (int row = 0; row < data.emittingNodes.size(); ++row) {
                    if (data.emittingNodes.get(row) != neighbor) continue;
                    sum += data.resultMatrix.get(row) / link.loss;
                    continue block1;
                }
            }
            if (changes.containsKey(node.tile.entity)) {
                changes.put(node.tile.entity, changes.get(node.tile.entity) + sum);
                continue;
            }
            changes.put(node.tile.entity, sum);
        }
        time = System.nanoTime() - time;
    }

    private void optimize(StructureCache.Data data) {
        int removed;
        data.optimizedNodes = new HashMap<Integer, Node>();
        for (Node node : this.nodes.values()) {
            if (!(node.amount > 0.0) && node.nodeType != NodeType.Conductor && node.nodeType != NodeType.Source) continue;
            assert (node.nodeType != NodeType.Sink || this.activeSinks.contains(node.uid));
            if ($assertionsDisabled || node.nodeType != NodeType.Source || !this.activeSources.contains(node.uid)) {
                // empty if block
            }
            data.optimizedNodes.put(node.uid, new Node(node));
        }
        for (Node node : data.optimizedNodes.values()) {
            ListIterator<NodeLink> it = node.links.listIterator();
            while (it.hasNext()) {
                NodeLink link = it.next();
                Node neighbor = link.getNeighbor(node.uid);
                if (neighbor.nodeType == NodeType.Sink && this.nodes.get((Object)Integer.valueOf((int)neighbor.uid)).amount <= 0.0) {
                    it.remove();
                    continue;
                }
                if (link.nodeA.uid == node.uid) {
                    link.nodeA = data.optimizedNodes.get(link.nodeA.uid);
                    link.nodeB = data.optimizedNodes.get(link.nodeB.uid);
                    assert (link.nodeA != null && link.nodeB != null);
                    HashSet<Node> newSkippedNodes = new HashSet<Node>();
                    for (Node skippedNode : link.skippedNodes) {
                        newSkippedNodes.add(data.optimizedNodes.get(skippedNode.uid));
                    }
                    link.skippedNodes = newSkippedNodes;
                    continue;
                }
                assert (link.nodeB.uid == node.uid);
                boolean foundReverseLink = false;
                for (NodeLink reverseLink : data.optimizedNodes.get((Object)Integer.valueOf((int)link.nodeA.uid)).links) {
                    assert (reverseLink.nodeA.uid != node.uid);
                    if (reverseLink.nodeB.uid != node.uid) continue;
                    assert (reverseLink.nodeA.uid == link.nodeA.uid);
                    foundReverseLink = true;
                    it.set(reverseLink);
                    break;
                }
                assert (foundReverseLink);
            }
        }
        if (debug) {
            for (Node node : data.optimizedNodes.values()) {
                for (NodeLink link : node.links) {
                    if (!data.optimizedNodes.containsValue(link.nodeA)) {
                        System.out.println("link " + link + " is broken");
                    }
                    assert (data.optimizedNodes.containsValue(link.nodeA));
                    assert (data.optimizedNodes.containsValue(link.nodeB));
                    assert (link.nodeA != link.nodeB);
                }
            }
        }
        do {
            removed = 0;
            Iterator<Node> it = data.optimizedNodes.values().iterator();
            while (it.hasNext()) {
                Iterator<NodeLink> it2;
                Node node = it.next();
                if (node.nodeType != NodeType.Conductor) continue;
                if (node.links.size() < 2) {
                    it.remove();
                    ++removed;
                    for (NodeLink link : node.links) {
                        boolean found = false;
                        Iterator<NodeLink> it22 = link.getNeighbor((Node)node).links.iterator();
                        while (it22.hasNext()) {
                            if (it22.next() != link) continue;
                            found = true;
                            it22.remove();
                            break;
                        }
                        assert (found);
                    }
                    continue;
                }
                if (node.links.size() == 2) {
                    it.remove();
                    ++removed;
                    NodeLink linkA = node.links.get(0);
                    NodeLink linkB = node.links.get(1);
                    Node neighborA = linkA.getNeighbor(node);
                    Node neighborB = linkB.getNeighbor(node);
                    if (neighborA == neighborB) {
                        neighborA.links.remove(linkA);
                        neighborB.links.remove(linkB);
                        continue;
                    }
                    linkA.loss += linkB.loss;
                    linkA.skippedNodes.addAll(linkB.skippedNodes);
                    linkA.skippedNodes.add(node);
                    if (linkA.nodeA == node) {
                        linkA.nodeA = neighborB;
                    } else {
                        linkA.nodeB = neighborB;
                    }
                    assert (linkA.nodeA != linkA.nodeB);
                    assert (linkA.nodeA == neighborA || linkA.nodeB == neighborA);
                    assert (linkA.nodeA == neighborB || linkA.nodeB == neighborB);
                    boolean found = false;
                    it2 = neighborB.links.listIterator();
                    while (it2.hasNext()) {
                        if (it2.next() != linkB) continue;
                        found = true;
                        it2.set(linkA);
                        break;
                    }
                    assert (found);
                    continue;
                }
                int neighborSinkCount = 0;
                int neighborConductorCount = 0;
                for (NodeLink link : node.links) {
                    switch (link.getNeighbor((Node)node).nodeType) {
                        case Source: {
                            break;
                        }
                        case Sink: {
                            ++neighborSinkCount;
                            break;
                        }
                        case Conductor: {
                            ++neighborConductorCount;
                        }
                    }
                }
                if (neighborSinkCount != 0 && neighborConductorCount != 0 || neighborSinkCount != 1 && neighborConductorCount != true) continue;
                it.remove();
                ++removed;
                NodeLink outputLink = null;
                for (NodeLink link : node.links) {
                    Node neighbor = link.getNeighbor(node);
                    if (neighbor.nodeType == NodeType.Sink) {
                        outputLink = link;
                        break;
                    }
                    if (neighbor.nodeType != NodeType.Conductor) continue;
                    outputLink = link;
                    break;
                }
                assert (outputLink != null);
                Node outputNode = outputLink.getNeighbor(node);
                boolean found = false;
                it2 = outputNode.links.iterator();
                while (it2.hasNext()) {
                    if (it2.next() != outputLink) continue;
                    found = true;
                    it2.remove();
                    break;
                }
                assert (found);
                for (NodeLink link : node.links) {
                    if (link == outputLink) continue;
                    if (link.nodeA == node) {
                        link.nodeA = outputNode;
                    } else if (link.nodeB == node) {
                        link.nodeB = outputNode;
                    }
                    link.loss += outputLink.loss;
                    link.skippedNodes.addAll(outputLink.skippedNodes);
                    link.skippedNodes.add(node);
                    outputNode.links.add(link);
                }
            }
        } while (removed > 0);
    }

    private static void determineEmittingNodes(StructureCache.Data data) {
        data.emittingNodes = new ArrayList<Node>();
        boolean index = false;
        for (Node node : data.optimizedNodes.values()) {
            switch (node.nodeType) {
                case Source: {
                    data.emittingNodes.add(node);
                    break;
                }
                case Sink: {
                    break;
                }
                case Conductor: {
                    data.emittingNodes.add(node);
                }
            }
        }
    }

    private static void populateNetworkMatrix(StructureCache.Data data) {
        for (int row = 0; row < data.emittingNodes.size(); ++row) {
            Node node = data.emittingNodes.get(row);
            for (int col = 0; col < data.emittingNodes.size(); ++col) {
                double value = 0.0;
                if (row == col) {
                    for (NodeLink link : node.links) {
                        if (link.getNeighbor(node) == node) continue;
                        value += 1.0 / link.loss;
                    }
                } else {
                    Node possibleNeighbor = data.emittingNodes.get(col);
                    for (NodeLink link : node.links) {
                        Node neighbor = link.getNeighbor(node);
                        if (neighbor == node || neighbor != possibleNeighbor) continue;
                        value -= 1.0 / link.loss;
                    }
                }
                data.networkMatrix.set(row, col, value);
            }
        }
    }

    private void populateSourceMatrix(StructureCache.Data data) {
        for (int row = 0; row < data.emittingNodes.size(); ++row) {
            Node node = data.emittingNodes.get(row);
            double input = 0.0;
            if (node.nodeType == NodeType.Source) {
                Node realNode = this.nodes.get(node.uid);
                input = realNode.amount;
            }
            data.sourceMatrix.set(row, 0, input);
        }
    }

    void dumpNodeInfo(PrintStream ps, Node node) {
        this.finishCalculation();
        ps.println("node " + node + " info:");
        ps.println(node.links.size() + " neighbor links:");
        for (NodeLink link : node.links) {
            ps.println(" " + link.getNeighbor(node) + " " + link.loss + " " + link.skippedNodes);
        }
        StructureCache.Data data = this.cache.get(this.activeSources, this.activeSinks);
        if (!data.isInitialized || data.optimizedNodes == null) {
            ps.println("no optimized data");
        } else if (!data.optimizedNodes.containsKey(node.uid)) {
            ps.println("optimized away");
        } else {
            Node optimizedNode = data.optimizedNodes.get(node.uid);
            ps.println(optimizedNode.links.size() + " optimized neighbor links:");
            for (NodeLink link : optimizedNode.links) {
                ps.println(" " + link.getNeighbor(optimizedNode) + " " + link.loss + " " + link.skippedNodes);
            }
        }
    }

    void dumpMatrix(PrintStream ps) {
        this.finishCalculation();
        ps.println("dumping matrices for " + this);
        StructureCache.Data data = this.cache.get(this.activeSources, this.activeSinks);
        if (!data.isInitialized || data.networkMatrix == null || data.sourceMatrix == null || data.resultMatrix == null) {
            ps.println("matrixes unavailable");
        } else {
            ps.println("emitting node indizes:");
            for (int i = 0; i < data.emittingNodes.size(); ++i) {
                Node node = data.emittingNodes.get(i);
                ps.println(i + " " + node + " (amount=" + this.nodes.get((Object)Integer.valueOf((int)node.uid)).amount + ")");
            }
            ps.println("network matrix:");
            ps.print(data.networkMatrix.toString());
            ps.println("source matrix:");
            ps.print(data.sourceMatrix.toString());
            ps.println("result matrix:");
            ps.print(data.resultMatrix.toString());
        }
    }

    void dumpStats(PrintStream ps) {
        this.finishCalculation();
        ps.println("grid " + this.uid + " info:");
        ps.println(this.nodes.size() + " nodes");
        ps.println("active: " + this.activeSources.size() + " sources -> " + this.activeSinks.size() + " sinks");
        StructureCache.Data data = this.cache.get(this.activeSources, this.activeSinks);
        if (data.isInitialized) {
            if (data.optimizedNodes != null) {
                ps.println(data.optimizedNodes.size() + " nodes after optimization");
            }
            if (data.emittingNodes != null) {
                ps.println(data.emittingNodes.size() + " emitting nodes");
            }
        }
        ps.printf("%d entries in cache, hitrate %.2f%%", this.cache.size(), 100.0 * (double)this.cache.hits / (double)(this.cache.hits + this.cache.misses));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpGraph() {
        this.finishCalculation();
        StructureCache.Data data = this.cache.get(this.activeSources, this.activeSinks);
        for (int i = 0; i < 2 && (i != 1 || data.isInitialized && data.optimizedNodes != null); ++i) {
            OutputStreamWriter out = null;
            try {
                out = new FileWriter("graph_" + this.uid + "_" + (i == 0 ? "raw" : "optimized") + ".txt");
                out.write("graph nodes {\n  overlap=false;\n");
                Collection<Node> nodesToDump = (i == 0 ? this.nodes : data.optimizedNodes).values();
                HashSet<Node> dumpedConnections = new HashSet<Node>();
                for (Node node : nodesToDump) {
                    out.write("  \"" + node + "\";\n");
                    for (NodeLink link : node.links) {
                        Node neighbor = link.getNeighbor(node);
                        if (dumpedConnections.contains(neighbor)) continue;
                        out.write("  \"" + node + "\" -- \"" + neighbor + "\" [label=\"" + link.loss + "\"];\n");
                    }
                    dumpedConnections.add(node);
                }
                out.write("}\n");
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    static {
        if (!$assertionsDisabled) {
            debug = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }
}

