/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.Direction;
import ic2.api.item.ItemWrapper;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMetaData;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import ic2.core.util.AabbUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPoleFence
extends BlockMetaData {
    private static final double halfThickness = 0.125;
    private static final double halfBarThickness = 0.0625;
    private static final double heightBarBottom = 0.375;
    private static final double heightBar = 0.1875;
    private static final double heightBarDistance = 0.375;
    private static final Direction[] directions = new Direction[]{Direction.XN, Direction.XP, Direction.ZN, Direction.ZP};

    public BlockPoleFence(InternalName internalName1) {
        super(internalName1, Material.field_151573_f, ItemBlockIC2.class);
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149777_j);
        Ic2Items.ironFence = new ItemStack((Block)this);
    }

    @Override
    public int getTextureIndex(int meta) {
        return 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean isNormalCube(IBlockAccess world, int i, int j, int k) {
        return false;
    }

    public int func_149645_b() {
        return IC2.platform.getRenderId("fence");
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z, int meta) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, false);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, false);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, true);
    }

    private AxisAlignedBB getCommonBoundingBoxFromPool(World world, int x, int y, int z, boolean selectionBoundingBox) {
        double minX1 = (double)x + 0.5 - 0.125;
        double minY1 = y;
        double minZ1 = (double)z + 0.5 - 0.125;
        double maxX1 = (double)x + 0.5 + 0.125;
        double maxY1 = selectionBoundingBox ? (double)(y + 1) : (double)y + 1.5;
        double maxZ1 = (double)z + 0.5 + 0.125;
        if (world.func_147439_a(x - 1, y, z) == this) {
            minX1 = x;
        }
        if (world.func_147439_a(x + 1, y, z) == this) {
            maxX1 = x + 1;
        }
        if (world.func_147439_a(x, y, z - 1) == this) {
            minZ1 = z;
        }
        if (world.func_147439_a(x, y, z + 1) == this) {
            maxZ1 = z + 1;
        }
        return AxisAlignedBB.func_72332_a().func_72299_a(minX1, minY1, minZ1, maxX1, maxY1, maxZ1);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 origin, Vec3 absDirection) {
        Vec3 direction = Vec3.func_72443_a((double)(absDirection.field_72450_a - origin.field_72450_a), (double)(absDirection.field_72448_b - origin.field_72448_b), (double)(absDirection.field_72449_c - origin.field_72449_c));
        double maxLength = direction.func_72433_c();
        boolean hit = false;
        Vec3 intersection = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Direction intersectingDirection = AabbUtil.getIntersection(origin, direction, AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5 - 0.125, (double)y, (double)z + 0.5 - 0.125, (double)x + 0.5 + 0.125, (double)(y + 1), (double)z + 0.5 + 0.125), intersection);
        if (intersectingDirection != null && intersection.func_72438_d(origin) <= maxLength) {
            hit = true;
        } else {
            block12: for (Direction dir : directions) {
                switch (dir) {
                    case XN: {
                        if (world.func_147439_a(x - 1, y, z) == this) break;
                        continue block12;
                    }
                    case XP: {
                        if (world.func_147439_a(x + 1, y, z) == this) break;
                        continue block12;
                    }
                    case ZN: {
                        if (world.func_147439_a(x, y, z - 1) == this) break;
                        continue block12;
                    }
                    case ZP: {
                        if (world.func_147439_a(x, y, z + 1) == this) break;
                        continue block12;
                    }
                    default: {
                        continue block12;
                    }
                }
                block13: for (int pieceToCheck = 0; pieceToCheck < 2; ++pieceToCheck) {
                    AxisAlignedBB bbox = null;
                    double yMin = (double)y + 0.375 + (double)pieceToCheck * 0.375;
                    double yMax = yMin + 0.1875;
                    switch (dir) {
                        case XN: {
                            bbox = AxisAlignedBB.func_72332_a().func_72299_a((double)x, yMin, (double)z + 0.5 - 0.0625, (double)x + 0.5, yMax, (double)z + 0.5 + 0.0625);
                            break;
                        }
                        case XP: {
                            bbox = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5, yMin, (double)z + 0.5 - 0.0625, (double)x + 1.0, yMax, (double)z + 0.5 + 0.0625);
                            break;
                        }
                        case ZN: {
                            bbox = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5 - 0.0625, yMin, (double)z, (double)x + 0.5 + 0.0625, yMax, (double)z + 0.5);
                            break;
                        }
                        case ZP: {
                            bbox = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5 - 0.0625, yMin, (double)z + 0.5, (double)x + 0.5 + 0.0625, yMax, (double)z + 1.0);
                            break;
                        }
                        default: {
                            continue block13;
                        }
                    }
                    intersectingDirection = AabbUtil.getIntersection(origin, direction, bbox, intersection);
                    if (intersectingDirection == null || !(intersection.func_72438_d(origin) <= maxLength)) continue;
                    hit = true;
                    break;
                }
                if (hit) break;
            }
        }
        if (hit && intersectingDirection != null) {
            return new MovingObjectPosition(x, y, z, intersectingDirection.toSideValue(), intersection);
        }
        return null;
    }

    public boolean isPole(World world, int i, int j, int k) {
        return world.func_147439_a(i - 1, j, k) != this && world.func_147439_a(i + 1, j, k) != this && world.func_147439_a(i, j, k - 1) != this && world.func_147439_a(i, j, k + 1) != this;
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        boolean slow;
        Item item;
        if (this.field_149764_J != Material.field_151573_f || !this.isPole(world, i, j, k) || !(entity instanceof EntityPlayer)) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        boolean powered = meta > 0;
        boolean metalShoes = false;
        EntityPlayer player = (EntityPlayer)entity;
        ItemStack shoes = player.field_71071_by.field_70460_b[0];
        if (shoes != null && ((item = shoes.func_77973_b()) == Items.field_151167_ab || item == Items.field_151151_aj || item == Items.field_151029_X || ItemWrapper.isMetalArmor(shoes, player))) {
            metalShoes = true;
        }
        boolean descending = player.func_70093_af();
        boolean bl = slow = player.field_70181_x >= -0.25 || player.field_70181_x < 1.6;
        if (slow) {
            player.field_70143_R = 0.0f;
        }
        if (!powered || !metalShoes) {
            if (descending && !slow) {
                player.field_70181_x *= 0.9;
            }
        } else {
            world.func_72921_c(i, j, k, meta - 1, 7);
            if (descending) {
                if (!slow) {
                    player.field_70181_x *= 0.8;
                }
            } else {
                player.field_70181_x += 0.075;
                if (player.field_70181_x > 0.0) {
                    player.field_70181_x *= 1.03;
                }
                double maxSpeed = IC2.keyboard.isAltKeyDown(player) ? 0.1 : 1.5;
                player.field_70181_x = Math.min(player.field_70181_x, maxSpeed);
            }
        }
    }
}

