/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.config;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagByte;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.api.wands.WandTriggerRegistry;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigAspects;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.config.ConfigResearch;
import thaumcraft.common.items.armor.RecipesRobeArmorDyes;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.crafting.ArcaneSceptreRecipe;
import thaumcraft.common.lib.crafting.ArcaneWandRecipe;
import thaumcraft.common.lib.crafting.InfusionRunicAugmentRecipe;
import thaumcraft.common.lib.crafting.ShapelessNBTOreRecipe;

public class ConfigRecipes {
    static ItemStack basicWand = new ItemStack(ConfigItems.itemWandCasting);

    public static void init() {
        ((ItemWandCasting)basicWand.func_77973_b()).setCap(basicWand, ConfigItems.WAND_CAP_IRON);
        ((ItemWandCasting)basicWand.func_77973_b()).setRod(basicWand, ConfigItems.WAND_ROD_WOOD);
        ConfigRecipes.initializeSmelting();
        ConfigRecipes.initializeNormalRecipes();
        ConfigRecipes.initializeArcaneRecipes();
        ConfigRecipes.initializeInfusionRecipes();
        ConfigRecipes.initializeInfusionEnchantmentRecipes();
        ConfigRecipes.initializeAlchemyRecipes();
        ConfigRecipes.initializeCompoundRecipes();
        RecipeSorter.register((String)"forge:shapelessorenbt", ShapelessNBTOreRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
    }

    private static void initializeCompoundRecipes() {
        ItemStack empty = new ItemStack(ConfigBlocks.blockHole, 1, 15);
        ConfigResearch.recipes.put("Thaumonomicon", Arrays.asList(new AspectList(), 1, 2, 1, Arrays.asList(basicWand, new ItemStack(Blocks.field_150342_X))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 0, Blocks.field_150342_X, 0);
        ConfigResearch.recipes.put("ArcTable", Arrays.asList(new AspectList(), 1, 2, 1, Arrays.asList(basicWand, new ItemStack(ConfigBlocks.blockTable))));
        ConfigResearch.recipes.put("ResTable", Arrays.asList(new AspectList(), 1, 2, 2, Arrays.asList(null, new ItemStack(ConfigItems.itemInkwell), new ItemStack(ConfigBlocks.blockTable), new ItemStack(ConfigBlocks.blockTable))));
        ConfigResearch.recipes.put("Crucible", Arrays.asList(new AspectList(), 1, 2, 1, Arrays.asList(basicWand, new ItemStack(Items.field_151066_bu))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 1, (Block)Blocks.field_150383_bp, -1);
        ConfigResearch.recipes.put("InfernalFurnace", Arrays.asList(new AspectList().add(Aspect.FIRE, 50).add(Aspect.EARTH, 50), 3, 3, 3, Arrays.asList(new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), empty, new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150353_l), new ItemStack(Blocks.field_150411_aY), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150385_bj))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 2, Blocks.field_150343_Z, -1);
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 2, Blocks.field_150385_bj, -1);
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 2, Blocks.field_150411_aY, -1);
        ConfigResearch.recipes.put("InfusionAltar", Arrays.asList(new AspectList().add(Aspect.FIRE, 25).add(Aspect.EARTH, 25).add(Aspect.ORDER, 25).add(Aspect.AIR, 25).add(Aspect.ENTROPY, 25).add(Aspect.WATER, 25), 3, 3, 3, Arrays.asList(empty, null, empty, null, new ItemStack(ConfigBlocks.blockStoneDevice, 1, 2), null, empty, null, empty, new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), null, new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), null, null, null, new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), null, new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), null, new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), null, new ItemStack(ConfigBlocks.blockStoneDevice, 1, 1), null, new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), null, new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 3, ConfigBlocks.blockStoneDevice, 2);
        ConfigResearch.recipes.put("NodeJar", Arrays.asList(new AspectList().add(Aspect.FIRE, 70).add(Aspect.EARTH, 70).add(Aspect.AIR, 70).add(Aspect.WATER, 70).add(Aspect.ORDER, 70).add(Aspect.ENTROPY, 70), 3, 4, 3, Arrays.asList("slabWood", "slabWood", "slabWood", "slabWood", "slabWood", "slabWood", "slabWood", "slabWood", "slabWood", new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(ConfigBlocks.blockAiry, 1, 5), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 4, Blocks.field_150359_w, -1);
        ConfigResearch.recipes.put("Thaumatorium", Arrays.asList(new AspectList().add(Aspect.FIRE, 15).add(Aspect.ORDER, 30).add(Aspect.WATER, 30), 1, 3, 1, Arrays.asList(new ItemStack(ConfigBlocks.blockMetalDevice, 1, 9), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 9), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 0))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 5, ConfigBlocks.blockMetalDevice, 9);
    }

    private static void initializeAlchemyRecipes() {
        ConfigResearch.recipes.put("Alumentum", ThaumcraftApi.addCrucibleRecipe("ALUMENTUM", new ItemStack(ConfigItems.itemResource, 1, 0), new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.ENERGY, 3).merge(Aspect.FIRE, 3).merge(Aspect.ENTROPY, 3)));
        ConfigResearch.recipes.put("Nitor", ThaumcraftApi.addCrucibleRecipe("NITOR", new ItemStack(ConfigItems.itemResource, 1, 1), "dustGlowstone", new AspectList().merge(Aspect.ENERGY, 3).merge(Aspect.FIRE, 3).merge(Aspect.LIGHT, 3)));
        ConfigResearch.recipes.put("Thaumium", ThaumcraftApi.addCrucibleRecipe("THAUMIUM", new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(Items.field_151042_j), new AspectList().merge(Aspect.MAGIC, 4)));
        ConfigResearch.recipes.put("Tallow", ThaumcraftApi.addCrucibleRecipe("TALLOW", new ItemStack(ConfigItems.itemResource, 1, 4), new ItemStack(Items.field_151078_bh), new AspectList().merge(Aspect.MAGIC, 2)));
        ConfigResearch.recipes.put("AltGunpowder", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.field_151016_H, 2, 0), new ItemStack(Items.field_151016_H), new AspectList().merge(Aspect.FIRE, 4).merge(Aspect.ENTROPY, 4)));
        ConfigResearch.recipes.put("AltSlime", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.field_151123_aH, 2, 0), new ItemStack(Items.field_151123_aH), new AspectList().merge(Aspect.WATER, 2).merge(Aspect.LIFE, 2)));
        ConfigResearch.recipes.put("AltClay", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.field_151119_aD, 2, 0), new ItemStack(Items.field_151119_aD), new AspectList().merge(Aspect.WATER, 1).merge(Aspect.EARTH, 2)));
        ConfigResearch.recipes.put("AltGlowstone", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.field_151114_aO, 2, 0), "dustGlowstone", new AspectList().merge(Aspect.LIGHT, 3).merge(Aspect.SENSES, 1)));
        ConfigResearch.recipes.put("AltInk", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.field_151100_aR, 2, 0), new ItemStack(Items.field_151100_aR, 1, 0), new AspectList().merge(Aspect.WATER, 2).merge(Aspect.SENSES, 2)));
        ConfigResearch.recipes.put("AltWeb", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALMANUFACTURE", new ItemStack(Blocks.field_150321_G), new ItemStack(Items.field_151007_F), new AspectList().merge(Aspect.TRAP, 2).merge(Aspect.CLOTH, 2)));
        ConfigResearch.recipes.put("AltMossyCobble", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALMANUFACTURE", new ItemStack(Blocks.field_150341_Y), new ItemStack(Blocks.field_150347_e), new AspectList().merge(Aspect.PLANT, 2).merge(Aspect.MAGIC, 1)));
        ConfigResearch.recipes.put("AltIce", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALMANUFACTURE", new ItemStack(Blocks.field_150432_aD), new ItemStack(Blocks.field_150433_aE), new AspectList().merge(Aspect.ORDER, 1).merge(Aspect.COLD, 1)));
        ConfigResearch.recipes.put("AltCrackedBrick", ThaumcraftApi.addCrucibleRecipe("ENTROPICPROCESSING", new ItemStack(Blocks.field_150417_aV, 1, 2), new ItemStack(Blocks.field_150417_aV), new AspectList().merge(Aspect.ENTROPY, 2)));
        ConfigResearch.recipes.put("AltGravel", ThaumcraftApi.addCrucibleRecipe("ENTROPICPROCESSING", new ItemStack(Blocks.field_150351_n), new ItemStack(Blocks.field_150347_e), new AspectList().merge(Aspect.ENTROPY, 2)));
        ConfigResearch.recipes.put("AltSand", ThaumcraftApi.addCrucibleRecipe("ENTROPICPROCESSING", new ItemStack(Blocks.field_150354_m), new ItemStack(Blocks.field_150351_n), new AspectList().merge(Aspect.ENTROPY, 2)));
        ConfigResearch.recipes.put("AltBonemeal", ThaumcraftApi.addCrucibleRecipe("ENTROPICPROCESSING", new ItemStack(Items.field_151100_aR, 4, 15), new ItemStack(Items.field_151103_aS), new AspectList().merge(Aspect.ENTROPY, 1)));
        ConfigResearch.recipes.put("PureIron", ThaumcraftApi.addCrucibleRecipe("PUREIRON", new ItemStack(ConfigItems.itemNugget, 1, 16), "oreIron", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        ConfigResearch.recipes.put("PureGold", ThaumcraftApi.addCrucibleRecipe("PUREGOLD", new ItemStack(ConfigItems.itemNugget, 1, 31), "oreGold", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        if (Config.foundCopperIngot) {
            ConfigResearch.recipes.put("PureCopper", ThaumcraftApi.addCrucibleRecipe("PURECOPPER", new ItemStack(ConfigItems.itemNugget, 1, 17), "oreCopper", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        }
        if (Config.foundTinIngot) {
            ConfigResearch.recipes.put("PureTin", ThaumcraftApi.addCrucibleRecipe("PURETIN", new ItemStack(ConfigItems.itemNugget, 1, 18), "oreTin", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        }
        if (Config.foundSilverIngot) {
            ConfigResearch.recipes.put("PureSilver", ThaumcraftApi.addCrucibleRecipe("PURESILVER", new ItemStack(ConfigItems.itemNugget, 1, 19), "oreSilver", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        }
        if (Config.foundLeadIngot) {
            ConfigResearch.recipes.put("PureLead", ThaumcraftApi.addCrucibleRecipe("PURELEAD", new ItemStack(ConfigItems.itemNugget, 1, 20), "oreLead", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        }
        ConfigResearch.recipes.put("TransIron", ThaumcraftApi.addCrucibleRecipe("TRANSIRON", new ItemStack(ConfigItems.itemNugget, 3, 0), "nuggetIron", new AspectList().merge(Aspect.METAL, 2)));
        ConfigResearch.recipes.put("TransGold", ThaumcraftApi.addCrucibleRecipe("TRANSGOLD", new ItemStack(Items.field_151074_bl, 3, 0), new ItemStack(Items.field_151074_bl), new AspectList().merge(Aspect.METAL, 2).merge(Aspect.GREED, 1)));
        if (Config.foundCopperIngot) {
            ConfigResearch.recipes.put("TransCopper", ThaumcraftApi.addCrucibleRecipe("TRANSCOPPER", new ItemStack(ConfigItems.itemNugget, 3, 1), "nuggetCopper", new AspectList().merge(Aspect.METAL, 2).merge(Aspect.EXCHANGE, 1)));
        }
        if (Config.foundTinIngot) {
            ConfigResearch.recipes.put("TransTin", ThaumcraftApi.addCrucibleRecipe("TRANSTIN", new ItemStack(ConfigItems.itemNugget, 3, 2), "nuggetTin", new AspectList().merge(Aspect.METAL, 2).merge(Aspect.CRYSTAL, 1)));
        }
        if (Config.foundSilverIngot) {
            ConfigResearch.recipes.put("TransSilver", ThaumcraftApi.addCrucibleRecipe("TRANSSILVER", new ItemStack(ConfigItems.itemNugget, 3, 3), "nuggetSilver", new AspectList().merge(Aspect.METAL, 2).merge(Aspect.GREED, 1)));
        }
        if (Config.foundLeadIngot) {
            ConfigResearch.recipes.put("TransLead", ThaumcraftApi.addCrucibleRecipe("TRANSLEAD", new ItemStack(ConfigItems.itemNugget, 3, 4), "nuggetLead", new AspectList().merge(Aspect.METAL, 2).merge(Aspect.ORDER, 1)));
        }
        ConfigResearch.recipes.put("EtherealBloom", ThaumcraftApi.addCrucibleRecipe("ETHEREALBLOOM", new ItemStack(ConfigBlocks.blockCustomPlant, 1, 4), new ItemStack(ConfigBlocks.blockCustomPlant, 1, 2), new AspectList().add(Aspect.MAGIC, 16).add(Aspect.PLANT, 16).add(Aspect.HEAL, 16).add(Aspect.TAINT, 8)));
        ConfigResearch.recipes.put("GolemStraw", ThaumcraftApi.addCrucibleRecipe("GOLEMSTRAW", new ItemStack(ConfigItems.itemGolemPlacer, 1, 0), new ItemStack(Blocks.field_150407_cf), new AspectList().add(Aspect.MAN, 4).add(Aspect.MOTION, 4).add(Aspect.SOUL, 4)));
        ConfigResearch.recipes.put("GolemWood", ThaumcraftApi.addCrucibleRecipe("GOLEMWOOD", new ItemStack(ConfigItems.itemGolemPlacer, 1, 1), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0), new AspectList().add(Aspect.MAN, 4).add(Aspect.MOTION, 4).add(Aspect.SOUL, 4)));
        ConfigResearch.recipes.put("GolemTallow", ThaumcraftApi.addCrucibleRecipe("GOLEMTALLOW", new ItemStack(ConfigItems.itemGolemPlacer, 1, 2), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 5), new AspectList().add(Aspect.MAN, 8).add(Aspect.MOTION, 8).add(Aspect.SOUL, 8)));
        ConfigResearch.recipes.put("GolemClay", ThaumcraftApi.addCrucibleRecipe("GOLEMCLAY", new ItemStack(ConfigItems.itemGolemPlacer, 1, 3), new ItemStack(Blocks.field_150336_V), new AspectList().add(Aspect.MAN, 4).add(Aspect.MOTION, 4).add(Aspect.SOUL, 4)));
        ConfigResearch.recipes.put("GolemFlesh", ThaumcraftApi.addCrucibleRecipe("GOLEMFLESH", new ItemStack(ConfigItems.itemGolemPlacer, 1, 4), new ItemStack(ConfigBlocks.blockTaint, 1, 2), new AspectList().add(Aspect.MAN, 8).add(Aspect.MOTION, 8).add(Aspect.SOUL, 8)));
        ConfigResearch.recipes.put("GolemStone", ThaumcraftApi.addCrucibleRecipe("GOLEMSTONE", new ItemStack(ConfigItems.itemGolemPlacer, 1, 5), new ItemStack(Blocks.field_150417_aV), new AspectList().add(Aspect.MAN, 4).add(Aspect.MOTION, 4).add(Aspect.SOUL, 4)));
        ConfigResearch.recipes.put("GolemIron", ThaumcraftApi.addCrucibleRecipe("GOLEMIRON", new ItemStack(ConfigItems.itemGolemPlacer, 1, 6), new ItemStack(Blocks.field_150339_S), new AspectList().add(Aspect.MAN, 4).add(Aspect.MOTION, 4).add(Aspect.SOUL, 4)));
        ConfigResearch.recipes.put("GolemThaumium", ThaumcraftApi.addCrucibleRecipe("GOLEMTHAUMIUM", new ItemStack(ConfigItems.itemGolemPlacer, 1, 7), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 4), new AspectList().add(Aspect.MAN, 8).add(Aspect.MOTION, 8).add(Aspect.SOUL, 8)));
        ConfigResearch.recipes.put("CoreGather", ThaumcraftApi.addCrucibleRecipe("COREGATHER", new ItemStack(ConfigItems.itemGolemCore, 1, 2), new ItemStack(ConfigItems.itemGolemCore, 1, 100), new AspectList().add(Aspect.GREED, 5).add(Aspect.EARTH, 5)));
        ConfigResearch.recipes.put("CoreFill", ThaumcraftApi.addCrucibleRecipe("COREFILL", new ItemStack(ConfigItems.itemGolemCore, 1, 0), new ItemStack(ConfigItems.itemGolemCore, 1, 100), new AspectList().add(Aspect.HUNGER, 5).add(Aspect.VOID, 5)));
        ConfigResearch.recipes.put("CoreEmpty", ThaumcraftApi.addCrucibleRecipe("COREEMPTY", new ItemStack(ConfigItems.itemGolemCore, 1, 1), new ItemStack(ConfigItems.itemGolemCore, 1, 100), new AspectList().add(Aspect.GREED, 5).add(Aspect.VOID, 5)));
        ConfigResearch.recipes.put("CoreHarvest", ThaumcraftApi.addCrucibleRecipe("COREHARVEST", new ItemStack(ConfigItems.itemGolemCore, 1, 3), new ItemStack(ConfigItems.itemGolemCore, 1, 100), new AspectList().add(Aspect.HARVEST, 5).add(Aspect.CROP, 5)));
        ConfigResearch.recipes.put("CoreGuard", ThaumcraftApi.addCrucibleRecipe("COREGUARD", new ItemStack(ConfigItems.itemGolemCore, 1, 4), new ItemStack(ConfigItems.itemGolemCore, 1, 100), new AspectList().add(Aspect.WEAPON, 5).add(Aspect.TRAP, 5)));
        ConfigResearch.recipes.put("CoreButcher", ThaumcraftApi.addCrucibleRecipe("COREBUTCHER", new ItemStack(ConfigItems.itemGolemCore, 1, 9), new ItemStack(ConfigItems.itemGolemCore, 1, 4), new AspectList().add(Aspect.FLESH, 5).add(Aspect.BEAST, 5)));
        ConfigResearch.recipes.put("CoreLiquid", ThaumcraftApi.addCrucibleRecipe("CORELIQUID", new ItemStack(ConfigItems.itemGolemCore, 1, 5), new ItemStack(ConfigItems.itemGolemCore, 1, 100), new AspectList().add(Aspect.WATER, 5).add(Aspect.VOID, 5)));
    }

    private static void initializeArcaneRecipes() {
        ConfigResearch.recipes.put("Salt1", ThaumcraftApi.addShapelessArcaneCraftingRecipe("BASICARTIFACE", new ItemStack(ConfigItems.itemResource, 1, 14), new AspectList().add(Aspect.EARTH, 5).add(Aspect.FIRE, 5).add(Aspect.AIR, 5).add(Aspect.WATER, 5), new ItemStack(ConfigItems.itemWispEssence, 1, 0), new ItemStack(ConfigItems.itemWispEssence, 1, 0), new ItemStack(ConfigItems.itemShard, 1, Short.MAX_VALUE)));
        ConfigResearch.recipes.put("PrimalCharm", ThaumcraftApi.addArcaneCraftingRecipe("BASICARTIFACE", new ItemStack(ConfigItems.itemResource, 1, 15), new AspectList().add(Aspect.EARTH, 25).add(Aspect.FIRE, 25).add(Aspect.AIR, 25).add(Aspect.WATER, 25).add(Aspect.ORDER, 25).add(Aspect.ENTROPY, 25), "123", "ISI", "456", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 14), Character.valueOf('I'), Items.field_151043_k, Character.valueOf('1'), new ItemStack(ConfigItems.itemShard, 1, 0), Character.valueOf('2'), new ItemStack(ConfigItems.itemShard, 1, 1), Character.valueOf('3'), new ItemStack(ConfigItems.itemShard, 1, 2), Character.valueOf('4'), new ItemStack(ConfigItems.itemShard, 1, 3), Character.valueOf('5'), new ItemStack(ConfigItems.itemShard, 1, 4), Character.valueOf('6'), new ItemStack(ConfigItems.itemShard, 1, 5)));
        ConfigResearch.recipes.put("ArcaneDoor", ThaumcraftApi.addArcaneCraftingRecipe("WARDEDARCANA", new ItemStack(ConfigItems.itemArcaneDoor), new AspectList().add(Aspect.WATER, 20).add(Aspect.ORDER, 10).add(Aspect.EARTH, 10).add(Aspect.FIRE, 5), "TDT", "DBD", "TDT", Character.valueOf('T'), new ItemStack(ConfigItems.itemResource, 1, 2), Character.valueOf('B'), new ItemStack(ConfigItems.itemResource, 1, 5), Character.valueOf('D'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6)));
        ConfigResearch.recipes.put("WardedGlass", ThaumcraftApi.addArcaneCraftingRecipe("WARDEDARCANA", new ItemStack(ConfigBlocks.blockCosmeticOpaque, 6, 2), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 10).add(Aspect.EARTH, 5).add(Aspect.FIRE, 5), "GGG", "WBW", "GGG", Character.valueOf('B'), new ItemStack(ConfigItems.itemResource, 1, 5), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w), Character.valueOf('W'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6)));
        ConfigResearch.recipes.put("IronKey", ThaumcraftApi.addArcaneCraftingRecipe("WARDEDARCANA", new ItemStack(ConfigItems.itemKey, 2, 0), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5), "NNI", "N  ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('N'), "nuggetIron"));
        if (Config.wardedStone) {
            ConfigResearch.recipes.put("GoldKey", ThaumcraftApi.addArcaneCraftingRecipe("WARDEDARCANA", new ItemStack(ConfigItems.itemKey, 2, 1), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5), "NNI", "N  ", Character.valueOf('I'), Items.field_151043_k, Character.valueOf('N'), Items.field_151074_bl));
            ConfigResearch.recipes.put("ArcanePressurePlate", ThaumcraftApi.addArcaneCraftingRecipe("WARDEDARCANA", new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 2), new AspectList().add(Aspect.WATER, 20).add(Aspect.ORDER, 10).add(Aspect.FIRE, 5).add(Aspect.EARTH, 10), " B ", "TDT", Character.valueOf('T'), new ItemStack(ConfigItems.itemResource, 1, 2), Character.valueOf('B'), new ItemStack(ConfigItems.itemResource, 1, 5), Character.valueOf('D'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6)));
        }
        ConfigResearch.recipes.put("NodeStabilizer", ThaumcraftApi.addArcaneCraftingRecipe("NODESTABILIZER", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 9), new AspectList().add(Aspect.WATER, 32).add(Aspect.EARTH, 32).add(Aspect.ORDER, 32), " G ", "QPQ", "SNS", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), Character.valueOf('G'), new ItemStack(Items.field_151043_k), Character.valueOf('P'), new ItemStack((Block)Blocks.field_150331_J), Character.valueOf('Q'), new ItemStack(Blocks.field_150371_ca), Character.valueOf('N'), new ItemStack(ConfigItems.itemResource, 1, 1)));
        ConfigResearch.recipes.put("GolemFetter", ThaumcraftApi.addArcaneCraftingRecipe("GOLEMFETTER", new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 9), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ORDER, 5), "SSS", "IRI", "BBB", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('B'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), Character.valueOf('R'), new ItemStack(Blocks.field_150451_bX)));
        ConfigResearch.recipes.put("ArcaneStone1", ThaumcraftApi.addArcaneCraftingRecipe("ARCANESTONE", new ItemStack(ConfigBlocks.blockCosmeticSolid, 9, 6), new AspectList().add(Aspect.EARTH, 1).add(Aspect.FIRE, 1), "SSS", "SCS", "SSS", Character.valueOf('S'), "stone", Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, Short.MAX_VALUE)));
        ConfigResearch.recipes.put("ArcaneStone2", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCosmeticSolid, 4, 7), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6)}));
        ConfigResearch.recipes.put("PaveTravel", ThaumcraftApi.addArcaneCraftingRecipe("PAVETRAVEL", new ItemStack(ConfigBlocks.blockCosmeticSolid, 4, 2), new AspectList().add(Aspect.EARTH, 10).add(Aspect.AIR, 10), "SAS", "SBS", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), Character.valueOf('A'), new ItemStack(ConfigItems.itemShard, 1, 0), Character.valueOf('B'), new ItemStack(ConfigItems.itemShard, 1, 3)));
        ConfigResearch.recipes.put("ArcaneLamp", ThaumcraftApi.addArcaneCraftingRecipe("ARCANELAMP", new ItemStack(ConfigBlocks.blockMetalDevice, 1, 7), new AspectList().add(Aspect.FIRE, 8).add(Aspect.AIR, 8).add(Aspect.WATER, 4).add(Aspect.ENTROPY, 4), " S ", "IAI", " N ", Character.valueOf('A'), new ItemStack(ConfigBlocks.blockCosmeticOpaque, 1, 0), Character.valueOf('S'), new ItemStack((Block)Blocks.field_150453_bW), Character.valueOf('N'), new ItemStack(ConfigItems.itemResource, 1, 1), Character.valueOf('I'), new ItemStack(Items.field_151042_j)));
        ConfigResearch.recipes.put("PaveWard", ThaumcraftApi.addArcaneCraftingRecipe("PAVEWARD", new ItemStack(ConfigBlocks.blockCosmeticSolid, 4, 3), new AspectList().add(Aspect.FIRE, 10).add(Aspect.ORDER, 10), "SAS", "SBS", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), Character.valueOf('A'), new ItemStack(ConfigItems.itemShard, 1, 1), Character.valueOf('B'), new ItemStack(ConfigItems.itemShard, 1, 4)));
        ConfigResearch.recipes.put("Levitator", ThaumcraftApi.addArcaneCraftingRecipe("LEVITATOR", new ItemStack(ConfigBlocks.blockLifter), new AspectList().add(Aspect.AIR, 10).add(Aspect.EARTH, 5), "WEW", "BNB", "WAW", Character.valueOf('W'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), Character.valueOf('E'), new ItemStack(ConfigItems.itemShard, 1, 3), Character.valueOf('A'), new ItemStack(ConfigItems.itemShard, 1, 0), Character.valueOf('N'), new ItemStack(ConfigItems.itemResource, 1, 1), Character.valueOf('B'), Items.field_151042_j));
        ConfigResearch.recipes.put("ArcaneEar", ThaumcraftApi.addArcaneCraftingRecipe("ARCANEEAR", new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 1), new AspectList().add(Aspect.AIR, 10).add(Aspect.ORDER, 10), "GIG", "GBG", "WRW", Character.valueOf('W'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('G'), Items.field_151043_k, Character.valueOf('B'), new ItemStack(ConfigItems.itemResource, 1, 5)));
        if (Config.allowMirrors) {
            ConfigResearch.recipes.put("MirrorGlass", ThaumcraftApi.addShapelessArcaneCraftingRecipe("MIRROR", new ItemStack(ConfigItems.itemResource, 1, 10), new AspectList().add(Aspect.FIRE, 10).add(Aspect.EARTH, 10), new ItemStack(ConfigItems.itemResource, 1, 3), Blocks.field_150410_aZ));
        }
        ConfigResearch.recipes.put("BoneBow", ThaumcraftApi.addArcaneCraftingRecipe("ARCANESTONE", new ItemStack(ConfigItems.itemBowBone), new AspectList().add(Aspect.AIR, 16).add(Aspect.ENTROPY, 32), "SB ", "SEB", "SB ", Character.valueOf('E'), new ItemStack(ConfigItems.itemShard, 1, 5), Character.valueOf('B'), Items.field_151103_aS, Character.valueOf('S'), Items.field_151007_F));
        Aspect[] pa = new Aspect[]{Aspect.AIR, Aspect.FIRE, Aspect.WATER, Aspect.EARTH, Aspect.ORDER, Aspect.ENTROPY};
        for (int a = 0; a < 6; ++a) {
            ConfigResearch.recipes.put("PrimalArrow_" + a, ThaumcraftApi.addArcaneCraftingRecipe("PRIMALARROW", new ItemStack(ConfigItems.itemPrimalArrow, 8, a), new AspectList().add(pa[a], 8), "AAA", "ASA", "AAA", Character.valueOf('A'), Items.field_151032_g, Character.valueOf('S'), new ItemStack(ConfigItems.itemShard, 1, a)));
        }
        ConfigResearch.recipes.put("InfusionMatrix", ThaumcraftApi.addArcaneCraftingRecipe("INFUSION", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 2), new AspectList().add(Aspect.ORDER, 40), "SBS", "BEB", "SBS", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), Character.valueOf('E'), Items.field_151079_bi, Character.valueOf('B'), new ItemStack(ConfigItems.itemShard, 1, Short.MAX_VALUE)));
        ConfigResearch.recipes.put("ArcanePedestal", ThaumcraftApi.addArcaneCraftingRecipe("INFUSION", new ItemStack(ConfigBlocks.blockStoneDevice, 2, 1), new AspectList().add(Aspect.AIR, 5), "SSS", " S ", "SSS", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6)));
        ConfigResearch.recipes.put("WardedJar", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA", new ItemStack(ConfigBlocks.blockJar, 1, 0), new AspectList().add(Aspect.WATER, 1), "GWG", "G G", "GGG", Character.valueOf('W'), "slabWood", Character.valueOf('G'), Blocks.field_150410_aZ));
        ConfigResearch.recipes.put("JarVoid", ThaumcraftApi.addArcaneCraftingRecipe("JARVOID", new ItemStack(ConfigBlocks.blockJar, 1, 3), new AspectList().add(Aspect.WATER, 5).add(Aspect.ENTROPY, 15), "O", "J", "P", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('P'), Items.field_151079_bi, Character.valueOf('J'), new ItemStack(ConfigBlocks.blockJar, 1, 0)));
        ArcaneWandRecipe wr = new ArcaneWandRecipe();
        ThaumcraftApi.getCraftingRecipes().add(wr);
        ArcaneSceptreRecipe sr = new ArcaneSceptreRecipe();
        ThaumcraftApi.getCraftingRecipes().add(sr);
        ConfigResearch.recipes.put("WandCapGold", ThaumcraftApi.addArcaneCraftingRecipe("CAP_gold", new ItemStack(ConfigItems.itemWandCap, 1, 1), new AspectList().add(Aspect.ORDER, WandCap.caps.get("gold").getCraftCost()).add(Aspect.FIRE, WandCap.caps.get("gold").getCraftCost()).add(Aspect.AIR, WandCap.caps.get("gold").getCraftCost()), "NNN", "N N", Character.valueOf('N'), Items.field_151074_bl));
        if (Config.foundCopperIngot) {
            ConfigResearch.recipes.put("WandCapCopper", ThaumcraftApi.addArcaneCraftingRecipe("CAP_copper", new ItemStack(ConfigItems.itemWandCap, 1, 3), new AspectList().add(Aspect.ORDER, WandCap.caps.get("copper").getCraftCost()).add(Aspect.FIRE, WandCap.caps.get("copper").getCraftCost()).add(Aspect.AIR, WandCap.caps.get("copper").getCraftCost()), "NNN", "N N", Character.valueOf('N'), "nuggetCopper"));
        }
        if (Config.foundSilverIngot) {
            ConfigResearch.recipes.put("WandCapSilverInert", ThaumcraftApi.addArcaneCraftingRecipe("CAP_silver", new ItemStack(ConfigItems.itemWandCap, 1, 5), new AspectList().add(Aspect.ORDER, WandCap.caps.get("silver").getCraftCost()).add(Aspect.FIRE, WandCap.caps.get("silver").getCraftCost()).add(Aspect.AIR, WandCap.caps.get("silver").getCraftCost()), "NNN", "N N", Character.valueOf('N'), "nuggetSilver"));
        }
        ConfigResearch.recipes.put("WandCapThaumiumInert", ThaumcraftApi.addArcaneCraftingRecipe("CAP_thaumium", new ItemStack(ConfigItems.itemWandCap, 1, 6), new AspectList().add(Aspect.ORDER, WandCap.caps.get("thaumium").getCraftCost()).add(Aspect.FIRE, WandCap.caps.get("thaumium").getCraftCost()).add(Aspect.AIR, WandCap.caps.get("thaumium").getCraftCost()), "NNN", "N N", Character.valueOf('N'), "nuggetThaumium"));
        ConfigResearch.recipes.put("WandRodGreatwood", ThaumcraftApi.addArcaneCraftingRecipe("ROD_greatwood", new ItemStack(ConfigItems.itemWandRod, 1, 0), new AspectList().add(Aspect.ENTROPY, WandRod.rods.get("greatwood").getCraftCost()), " G", "G ", Character.valueOf('G'), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0)));
        ConfigResearch.recipes.put("WandRodGreatwoodStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_greatwood_staff", new ItemStack(ConfigItems.itemWandRod, 1, 50), new AspectList().add(Aspect.ORDER, WandRod.rods.get("greatwood_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 0)));
        ConfigResearch.recipes.put("WandRodObsidianStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_obsidian_staff", new ItemStack(ConfigItems.itemWandRod, 1, 51), new AspectList().add(Aspect.ORDER, WandRod.rods.get("obsidian_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 1)));
        ConfigResearch.recipes.put("WandRodSilverwoodStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_silverwood_staff", new ItemStack(ConfigItems.itemWandRod, 1, 52), new AspectList().add(Aspect.ORDER, WandRod.rods.get("silverwood_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 2)));
        ConfigResearch.recipes.put("WandRodIceStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_ice_staff", new ItemStack(ConfigItems.itemWandRod, 1, 53), new AspectList().add(Aspect.ORDER, WandRod.rods.get("ice_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 3)));
        ConfigResearch.recipes.put("WandRodQuartzStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_quartz_staff", new ItemStack(ConfigItems.itemWandRod, 1, 54), new AspectList().add(Aspect.ORDER, WandRod.rods.get("quartz_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 4)));
        ConfigResearch.recipes.put("WandRodReedStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_reed_staff", new ItemStack(ConfigItems.itemWandRod, 1, 55), new AspectList().add(Aspect.ORDER, WandRod.rods.get("reed_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 5)));
        ConfigResearch.recipes.put("WandRodBlazeStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_blaze_staff", new ItemStack(ConfigItems.itemWandRod, 1, 56), new AspectList().add(Aspect.ORDER, WandRod.rods.get("blaze_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 6)));
        ConfigResearch.recipes.put("WandRodBoneStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_bone_staff", new ItemStack(ConfigItems.itemWandRod, 1, 57), new AspectList().add(Aspect.ORDER, WandRod.rods.get("bone_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 7)));
        ConfigResearch.recipes.put("FocusFire", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSFIRE", new ItemStack(ConfigItems.itemFocusFire), new AspectList().add(Aspect.FIRE, 20).add(Aspect.ENTROPY, 10), "CQC", "Q#Q", "CQC", Character.valueOf('#'), Items.field_151059_bz, Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 1)));
        ConfigResearch.recipes.put("FocusFrost", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSFROST", new ItemStack(ConfigItems.itemFocusFrost), new AspectList().add(Aspect.WATER, 10).add(Aspect.ORDER, 10).add(Aspect.ENTROPY, 10), "CQC", "Q#Q", "CQC", Character.valueOf('#'), Items.field_151045_i, Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 2)));
        ConfigResearch.recipes.put("FocusShock", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSSHOCK", new ItemStack(ConfigItems.itemFocusShock), new AspectList().add(Aspect.AIR, 10).add(Aspect.ORDER, 10).add(Aspect.ENTROPY, 10), "CQC", "Q#Q", "CQC", Character.valueOf('#'), Items.field_151174_bG, Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 0)));
        ConfigResearch.recipes.put("FocusTrade", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSTRADE", new ItemStack(ConfigItems.itemFocusTrade), new AspectList().add(Aspect.ORDER, 15).add(Aspect.ENTROPY, 15).add(Aspect.EARTH, 10), "CQE", "Q#Q", "CQE", Character.valueOf('#'), new ItemStack(ConfigItems.itemResource, 1, 3), Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 4), Character.valueOf('E'), new ItemStack(ConfigItems.itemShard, 1, 5)));
        ConfigResearch.recipes.put("FocusExcavation", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSEXCAVATION", new ItemStack(ConfigItems.itemFocusExcavation), new AspectList().add(Aspect.EARTH, 20).add(Aspect.ENTROPY, 5).add(Aspect.ORDER, 5), "CQC", "Q#Q", "CQC", Character.valueOf('#'), Items.field_151166_bC, Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 3)));
        ConfigResearch.recipes.put("FocusPrimal", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSPRIMAL", new ItemStack(ConfigItems.itemFocusPrimal), new AspectList().add(Aspect.EARTH, 25).add(Aspect.ENTROPY, 25).add(Aspect.ORDER, 25).add(Aspect.AIR, 25).add(Aspect.FIRE, 25).add(Aspect.WATER, 25), "CQC", "Q#Q", "CQC", Character.valueOf('#'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('C'), Items.field_151045_i));
        ConfigResearch.recipes.put("FocusPouch", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSPOUCH", new ItemStack(ConfigItems.itemFocusPouch), new AspectList().add(Aspect.EARTH, 10).add(Aspect.ORDER, 10).add(Aspect.ENTROPY, 10), "LGL", "LBL", "LLL", Character.valueOf('B'), new ItemStack(ConfigItems.itemBaubleBlanks, 1, 2), Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('G'), Items.field_151043_k));
        ConfigResearch.recipes.put("Deconstructor", ThaumcraftApi.addArcaneCraftingRecipe("DECONSTRUCTOR", new ItemStack(ConfigBlocks.blockTable, 1, 14), new AspectList().add(Aspect.ENTROPY, 20), " S ", "ATP", Character.valueOf('T'), new ItemStack(ConfigBlocks.blockTable, 1, 0), Character.valueOf('S'), new ItemStack(ConfigItems.itemThaumometer), Character.valueOf('P'), new ItemStack(Items.field_151005_D), Character.valueOf('A'), new ItemStack(Items.field_151006_E)));
        ConfigResearch.recipes.put("ArcaneBoreBase", ThaumcraftApi.addArcaneCraftingRecipe("ARCANEBORE", new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 4), new AspectList().add(Aspect.AIR, 10).add(Aspect.ORDER, 10), "WIW", "IDI", "WIW", Character.valueOf('W'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), Character.valueOf('I'), Items.field_151042_j, Character.valueOf('D'), Blocks.field_150367_z));
        ConfigResearch.recipes.put("EnchantedFabric", ThaumcraftApi.addArcaneCraftingRecipe("ENCHFABRIC", new ItemStack(ConfigItems.itemResource, 1, 7), new AspectList().add(Aspect.AIR, 1).add(Aspect.EARTH, 1).add(Aspect.FIRE, 1).add(Aspect.WATER, 1).add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), " S ", "SCS", " S ", Character.valueOf('S'), new ItemStack(Items.field_151007_F, 1, Short.MAX_VALUE), Character.valueOf('C'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)));
        ConfigResearch.recipes.put("RobeChest", ThaumcraftApi.addArcaneCraftingRecipe("ENCHFABRIC", new ItemStack(ConfigItems.itemChestRobe, 1), new AspectList().add(Aspect.AIR, 5), "I I", "III", "III", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 7)));
        ConfigResearch.recipes.put("RobeLegs", ThaumcraftApi.addArcaneCraftingRecipe("ENCHFABRIC", new ItemStack(ConfigItems.itemLegsRobe, 1), new AspectList().add(Aspect.WATER, 5), "III", "I I", "I I", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 7)));
        ConfigResearch.recipes.put("RobeBoots", ThaumcraftApi.addArcaneCraftingRecipe("ENCHFABRIC", new ItemStack(ConfigItems.itemBootsRobe, 1), new AspectList().add(Aspect.EARTH, 3), "I I", "I I", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 7)));
        GameRegistry.addRecipe((IRecipe)new RecipesRobeArmorDyes());
        ConfigResearch.recipes.put("Goggles", ThaumcraftApi.addArcaneCraftingRecipe("GOGGLES", new ItemStack(ConfigItems.itemGoggles), new AspectList().add(Aspect.AIR, 5).add(Aspect.FIRE, 5).add(Aspect.WATER, 5).add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 3).add(Aspect.ORDER, 3), "LGL", "L L", "TGT", Character.valueOf('T'), ConfigItems.itemThaumometer, Character.valueOf('G'), Items.field_151043_k, Character.valueOf('L'), Items.field_151116_aA));
        ConfigResearch.recipes.put("HungryChest", ThaumcraftApi.addArcaneCraftingRecipe("HUNGRYCHEST", new ItemStack(ConfigBlocks.blockChestHungry), new AspectList().add(Aspect.AIR, 5).add(Aspect.ORDER, 3).add(Aspect.ENTROPY, 3), "WTW", "W W", "WWW", Character.valueOf('W'), "plankWood", Character.valueOf('T'), Blocks.field_150415_aT));
        ConfigResearch.recipes.put("GolemBell", ThaumcraftApi.addArcaneCraftingRecipe("GOLEMBELL", new ItemStack(ConfigItems.itemGolemBell), new AspectList().add(Aspect.ORDER, 5), " QQ", " QQ", "S  ", Character.valueOf('S'), "stickWood", Character.valueOf('Q'), Items.field_151128_bU));
        ConfigResearch.recipes.put("CoreBlank", ThaumcraftApi.addArcaneCraftingRecipe("COREGATHER", new ItemStack(ConfigItems.itemGolemCore, 1, 100), new AspectList().add(Aspect.ORDER, 5).add(Aspect.FIRE, 5), " C ", "CNC", " C ", Character.valueOf('C'), Items.field_151118_aC, Character.valueOf('N'), new ItemStack(ConfigItems.itemResource, 1, 1)));
        ConfigResearch.recipes.put("UpgradeAir", ThaumcraftApi.addArcaneCraftingRecipe("UPGRADEAIR", new ItemStack(ConfigItems.itemGolemUpgrade, 1, 0), new AspectList().add(Aspect.AIR, 10), "NNN", "NCN", "NNN", Character.valueOf('N'), Items.field_151074_bl, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 0)));
        ConfigResearch.recipes.put("UpgradeEarth", ThaumcraftApi.addArcaneCraftingRecipe("UPGRADEEARTH", new ItemStack(ConfigItems.itemGolemUpgrade, 1, 1), new AspectList().add(Aspect.EARTH, 10), "NNN", "NCN", "NNN", Character.valueOf('N'), Items.field_151074_bl, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 3)));
        ConfigResearch.recipes.put("UpgradeFire", ThaumcraftApi.addArcaneCraftingRecipe("UPGRADEFIRE", new ItemStack(ConfigItems.itemGolemUpgrade, 1, 2), new AspectList().add(Aspect.FIRE, 10), "NNN", "NCN", "NNN", Character.valueOf('N'), Items.field_151074_bl, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 1)));
        ConfigResearch.recipes.put("UpgradeWater", ThaumcraftApi.addArcaneCraftingRecipe("UPGRADEWATER", new ItemStack(ConfigItems.itemGolemUpgrade, 1, 3), new AspectList().add(Aspect.WATER, 10), "NNN", "NCN", "NNN", Character.valueOf('N'), Items.field_151074_bl, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 2)));
        ConfigResearch.recipes.put("UpgradeOrder", ThaumcraftApi.addArcaneCraftingRecipe("UPGRADEORDER", new ItemStack(ConfigItems.itemGolemUpgrade, 1, 4), new AspectList().add(Aspect.ORDER, 10), "NNN", "NCN", "NNN", Character.valueOf('N'), Items.field_151074_bl, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 4)));
        ConfigResearch.recipes.put("UpgradeEntropy", ThaumcraftApi.addArcaneCraftingRecipe("UPGRADEENTROPY", new ItemStack(ConfigItems.itemGolemUpgrade, 1, 5), new AspectList().add(Aspect.ENTROPY, 10), "NNN", "NCN", "NNN", Character.valueOf('N'), Items.field_151074_bl, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 5)));
        ConfigResearch.recipes.put("TinyHat", ThaumcraftApi.addArcaneCraftingRecipe("TINYHAT", new ItemStack(ConfigItems.itemGolemDecoration, 1, 0), new AspectList().add(Aspect.ORDER, 8).add(Aspect.FIRE, 8), " C ", " G ", "CCC", Character.valueOf('C'), new ItemStack(Blocks.field_150325_L, 1, 15), Character.valueOf('G'), Items.field_151043_k));
        ConfigResearch.recipes.put("TinyFez", ThaumcraftApi.addArcaneCraftingRecipe("TINYFEZ", new ItemStack(ConfigItems.itemGolemDecoration, 1, 3), new AspectList().add(Aspect.WATER, 4).add(Aspect.EARTH, 4), "CCS", "CCS", "  S", Character.valueOf('C'), new ItemStack(Blocks.field_150325_L, 1, 14), Character.valueOf('S'), Items.field_151007_F));
        ConfigResearch.recipes.put("TinyBowtie", ThaumcraftApi.addArcaneCraftingRecipe("TINYBOWTIE", new ItemStack(ConfigItems.itemGolemDecoration, 1, 2), new AspectList().add(Aspect.AIR, 4).add(Aspect.ORDER, 4), "CSC", "C C", Character.valueOf('C'), new ItemStack(Blocks.field_150325_L, 1, 15), Character.valueOf('S'), Items.field_151007_F));
        ConfigResearch.recipes.put("TinyGlasses", ThaumcraftApi.addArcaneCraftingRecipe("TINYGLASSES", new ItemStack(ConfigItems.itemGolemDecoration, 1, 1), new AspectList().add(Aspect.AIR, 4).add(Aspect.WATER, 4), "GIG", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('I'), Items.field_151042_j));
        ConfigResearch.recipes.put("TinyDart", ThaumcraftApi.addArcaneCraftingRecipe("TINYDART", new ItemStack(ConfigItems.itemGolemDecoration, 1, 4), new AspectList().add(Aspect.AIR, 4).add(Aspect.FIRE, 4), "AIA", "ADA", "AIA", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('D'), Blocks.field_150367_z, Character.valueOf('A'), Items.field_151032_g));
        ConfigResearch.recipes.put("TinyVisor", ThaumcraftApi.addArcaneCraftingRecipe("TINYVISOR", new ItemStack(ConfigItems.itemGolemDecoration, 1, 5), new AspectList().add(Aspect.EARTH, 4).add(Aspect.WATER, 4), "IHI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('H'), new ItemStack((Item)Items.field_151028_Y, 1, Short.MAX_VALUE)));
        ConfigResearch.recipes.put("TinyArmor", ThaumcraftApi.addArcaneCraftingRecipe("TINYARMOR", new ItemStack(ConfigItems.itemGolemDecoration, 1, 6), new AspectList().add(Aspect.EARTH, 8), "I I", "IAI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('A'), new ItemStack((Item)Items.field_151030_Z, 1, Short.MAX_VALUE)));
        ConfigResearch.recipes.put("TinyHammer", ThaumcraftApi.addArcaneCraftingRecipe("TINYHAMMER", new ItemStack(ConfigItems.itemGolemDecoration, 1, 7), new AspectList().add(Aspect.EARTH, 4).add(Aspect.FIRE, 4), "III", "III", " I ", Character.valueOf('I'), Items.field_151042_j));
        ConfigResearch.recipes.put("Filter", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA", new ItemStack(ConfigItems.itemResource, 1, 8), new AspectList().add(Aspect.ORDER, 5).add(Aspect.WATER, 5), "GWG", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('W'), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 1)));
        ConfigResearch.recipes.put("AlchemyFurnace", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 0), new AspectList().add(Aspect.FIRE, 5).add(Aspect.WATER, 5), "SCS", "SFS", "SSS", Character.valueOf('C'), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 0), Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6)));
        ConfigResearch.recipes.put("Alembic", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA", new ItemStack(ConfigBlocks.blockMetalDevice, 1, 1), new AspectList().add(Aspect.AIR, 5).add(Aspect.WATER, 5), "FIG", "IBI", "I I", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('G'), Items.field_151043_k, Character.valueOf('F'), new ItemStack(ConfigItems.itemResource, 1, 8), Character.valueOf('L'), new ItemStack(ConfigBlocks.blockMagicalLeaves, 1, 1)));
        ConfigResearch.recipes.put("Bellows", ThaumcraftApi.addArcaneCraftingRecipe("BELLOWS", new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 0), new AspectList().add(Aspect.AIR, 10).add(Aspect.ORDER, 5), "WW ", "LCI", "WW ", Character.valueOf('W'), "plankWood", Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 0), Character.valueOf('I'), Items.field_151042_j, Character.valueOf('L'), Items.field_151116_aA));
        ConfigResearch.recipes.put("Tube", ThaumcraftApi.addArcaneCraftingRecipe("TUBES", new ItemStack(ConfigBlocks.blockTube, 6, 0), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5), " Q ", "IGI", " B ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('B'), Items.field_151043_k, Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('Q'), new ItemStack(ConfigItems.itemResource, 1, 3)));
        ConfigResearch.recipes.put("Resonator", ThaumcraftApi.addArcaneCraftingRecipe("TUBES", new ItemStack(ConfigItems.itemResonator), new AspectList().add(Aspect.WATER, 5).add(Aspect.AIR, 5), "I I", "INI", " S ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('N'), Items.field_151128_bU, Character.valueOf('S'), "stickWood"));
        ConfigResearch.recipes.put("TubeValve", ThaumcraftApi.addArcaneCraftingRecipe("TUBES", new ItemStack(ConfigBlocks.blockTube, 1, 1), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5), "LTG", Character.valueOf('T'), new ItemStack(ConfigBlocks.blockTube, 1, 0), Character.valueOf('L'), Blocks.field_150442_at));
        ConfigResearch.recipes.put("TubeFilter", ThaumcraftApi.addShapelessArcaneCraftingRecipe("TUBEFILTER", new ItemStack(ConfigBlocks.blockTube, 1, 3), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 16), new ItemStack(ConfigBlocks.blockTube, 1, 0), new ItemStack(ConfigItems.itemResource, 1, 8)));
        ConfigResearch.recipes.put("TubeRestrict", ThaumcraftApi.addArcaneCraftingRecipe("TUBEFILTER", new ItemStack(ConfigBlocks.blockTube, 1, 5), new AspectList().add(Aspect.WATER, 5).add(Aspect.EARTH, 16), "PTP", Character.valueOf('T'), new ItemStack(ConfigBlocks.blockTube, 1, 0), Character.valueOf('P'), "stone"));
        ConfigResearch.recipes.put("TubeOneway", ThaumcraftApi.addArcaneCraftingRecipe("TUBEFILTER", new ItemStack(ConfigBlocks.blockTube, 1, 6), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 8).add(Aspect.ENTROPY, 8), "PTP", Character.valueOf('T'), new ItemStack(ConfigBlocks.blockTube, 1, 0), Character.valueOf('P'), "dyeBlue"));
        ConfigResearch.recipes.put("TubeBuffer", ThaumcraftApi.addArcaneCraftingRecipe("CENTRIFUGE", new ItemStack(ConfigBlocks.blockTube, 1, 4), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5), "PTP", "T T", "PTP", Character.valueOf('T'), new ItemStack(ConfigBlocks.blockTube, 1, 0), Character.valueOf('P'), new ItemStack(ConfigItems.itemEssence, 1, 0)));
        ConfigResearch.recipes.put("AlchemicalConstruct", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA", new ItemStack(ConfigBlocks.blockMetalDevice, 1, 9), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5), "VTF", "TWT", "FTV", Character.valueOf('W'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), Character.valueOf('V'), new ItemStack(ConfigBlocks.blockTube, 1, 1), Character.valueOf('T'), new ItemStack(ConfigBlocks.blockTube, 1, 0), Character.valueOf('F'), new ItemStack(ConfigItems.itemResource, 1, 8)));
        ConfigResearch.recipes.put("Centrifuge", ThaumcraftApi.addArcaneCraftingRecipe("CENTRIFUGE", new ItemStack(ConfigBlocks.blockTube, 1, 2), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5).add(Aspect.ENTROPY, 5), " T ", "ACP", " T ", Character.valueOf('T'), new ItemStack(ConfigBlocks.blockTube, 1, 0), Character.valueOf('P'), new ItemStack((Block)Blocks.field_150331_J), Character.valueOf('A'), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 1), Character.valueOf('C'), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 9)));
        ConfigResearch.recipes.put("MnemonicMatrix", ThaumcraftApi.addArcaneCraftingRecipe("THAUMATORIUM", new ItemStack(ConfigBlocks.blockMetalDevice, 1, 12), new AspectList().add(Aspect.FIRE, 5).add(Aspect.WATER, 5).add(Aspect.ORDER, 5), "IAI", "ABA", "IAI", Character.valueOf('B'), new ItemStack(ConfigItems.itemResource, 1, 5), Character.valueOf('A'), new ItemStack(ConfigItems.itemResource, 1, 6), Character.valueOf('I'), new ItemStack(Items.field_151042_j)));
    }

    private static void initializeInfusionEnchantmentRecipes() {
        ConfigResearch.recipes.put("InfEnchRepair", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77331_b[ThaumcraftApi.enchantRepair], 4, new AspectList().add(Aspect.MAGIC, 8).add(Aspect.CRAFT, 10).add(Aspect.ORDER, 10), new ItemStack[]{new ItemStack(Blocks.field_150467_bQ), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnchHaste", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77331_b[ThaumcraftApi.enchantHaste], 3, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.TRAVEL, 8).add(Aspect.FLIGHT, 8), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnchPotency", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77331_b[ThaumcraftApi.enchantPotency], 3, new AspectList().add(Aspect.MAGIC, 8).add(Aspect.ENERGY, 8), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 0), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnchFrugal", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77331_b[ThaumcraftApi.enchantFrugal], 3, new AspectList().add(Aspect.MAGIC, 8).add(Aspect.HUNGER, 8), new ItemStack[]{new ItemStack(Items.field_151054_z), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnchFortune", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77331_b[ThaumcraftApi.enchantWandFortune], 3, new AspectList().add(Aspect.MAGIC, 12).add(Aspect.GREED, 8), new ItemStack[]{new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151045_i), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch0", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77332_c, 1, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.ARMOR, 8), new ItemStack[]{new ItemStack(Items.field_151042_j), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch1", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77329_d, 1, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.ARMOR, 4).add(Aspect.FIRE, 4), new ItemStack[]{new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151064_bs), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch2", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77327_f, 1, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.ARMOR, 4).add(Aspect.ENTROPY, 4), new ItemStack[]{new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151016_H), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch3", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77328_g, 1, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.ARMOR, 4).add(Aspect.FLIGHT, 4), new ItemStack[]{new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151032_g), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch4", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77330_e, 1, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.AIR, 4).add(Aspect.FLIGHT, 4), new ItemStack[]{new ItemStack(Items.field_151008_G), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch5", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77340_h, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.AIR, 8).add(Aspect.WATER, 8), new ItemStack[]{new ItemStack(Items.field_151120_aE), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch6", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77341_i, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.MOTION, 8).add(Aspect.WATER, 8), new ItemStack[]{new ItemStack(Items.field_151120_aE), new ItemStack(Items.field_151123_aH), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch7", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_92091_k, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 8).add(Aspect.PLANT, 8), new ItemStack[]{new ItemStack((Block)Blocks.field_150330_I), new ItemStack(Items.field_151128_bU), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch8", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77338_j, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 8), new ItemStack[]{new ItemStack(Items.field_151040_l), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch9", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77339_k, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 4).add(Aspect.UNDEAD, 4), new ItemStack[]{new ItemStack(Items.field_151040_l), new ItemStack(Items.field_151114_aO), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch10", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77336_l, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 4).add(Aspect.BEAST, 4), new ItemStack[]{new ItemStack(Items.field_151040_l), new ItemStack(ConfigItems.itemResource, 1, 6), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch11", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77337_m, 1, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 3).add(Aspect.MOTION, 3), new ItemStack[]{new ItemStack((Block)Blocks.field_150331_J), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch12", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77334_n, 3, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 4).add(Aspect.FIRE, 8), new ItemStack[]{new ItemStack(Items.field_151040_l), new ItemStack(Items.field_151065_br), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch13", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77335_o, 3, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 4).add(Aspect.GREED, 8), new ItemStack[]{new ItemStack(Items.field_151040_l), new ItemStack(Items.field_151045_i), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch14", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77349_p, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.TOOL, 4).add(Aspect.ORDER, 4), new ItemStack[]{new ItemStack(Items.field_151035_b), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch15", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77348_q, 5, new AspectList().add(Aspect.MAGIC, 16).add(Aspect.TOOL, 16).add(Aspect.ORDER, 16).add(Aspect.HARVEST, 16).add(Aspect.MINE, 16), new ItemStack[]{new ItemStack(Items.field_151035_b), new ItemStack(Blocks.field_150321_G), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch16", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77347_r, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.TOOL, 4).add(Aspect.ORDER, 8), new ItemStack[]{new ItemStack(Items.field_151035_b), new ItemStack(Blocks.field_150343_Z), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch17", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77346_s, 3, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.TOOL, 4).add(Aspect.GREED, 8), new ItemStack[]{new ItemStack(Items.field_151035_b), new ItemStack(Items.field_151045_i), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch18", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77345_t, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 8), new ItemStack[]{new ItemStack((Item)Items.field_151031_f), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch19", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77344_u, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 3).add(Aspect.MOTION, 3), new ItemStack[]{new ItemStack((Block)Blocks.field_150331_J), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch20", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77343_v, 3, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 4).add(Aspect.FIRE, 8), new ItemStack[]{new ItemStack((Item)Items.field_151031_f), new ItemStack(Items.field_151065_br), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch21", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.field_77342_w, 5, new AspectList().add(Aspect.MAGIC, 8).add(Aspect.WEAPON, 16).add(Aspect.VOID, 16).add(Aspect.EXCHANGE, 16), new ItemStack[]{new ItemStack((Item)Items.field_151031_f), new ItemStack(Items.field_151032_g), new ItemStack(ConfigItems.itemResource, 1, 14)}));
    }

    private static void initializeInfusionRecipes() {
        if (Config.foundSilverIngot) {
            ConfigResearch.recipes.put("WandCapSilver", ThaumcraftApi.addInfusionCraftingRecipe("CAP_silver", new ItemStack(ConfigItems.itemWandCap, 1, 4), 4, new AspectList().add(Aspect.ENERGY, WandCap.caps.get("silver").getCraftCost() * 2).add(Aspect.AURA, WandCap.caps.get("silver").getCraftCost()), new ItemStack(ConfigItems.itemWandCap, 1, 5), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        }
        ConfigResearch.recipes.put("WandCapThaumium", ThaumcraftApi.addInfusionCraftingRecipe("CAP_thaumium", new ItemStack(ConfigItems.itemWandCap, 1, 2), 5, new AspectList().add(Aspect.ENERGY, WandCap.caps.get("thaumium").getCraftCost() * 2).add(Aspect.AURA, WandCap.caps.get("thaumium").getCraftCost()), new ItemStack(ConfigItems.itemWandCap, 1, 6), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("WandRodObsidian", ThaumcraftApi.addInfusionCraftingRecipe("ROD_obsidian", new ItemStack(ConfigItems.itemWandRod, 1, 1), 3, new AspectList().add(Aspect.EARTH, WandRod.rods.get("obsidian").getCraftCost() * 2).add(Aspect.MAGIC, WandRod.rods.get("obsidian").getCraftCost()).add(Aspect.DARKNESS, WandRod.rods.get("blaze").getCraftCost()), new ItemStack(Blocks.field_150343_Z), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemShard, 1, 3)}));
        ConfigResearch.recipes.put("WandRodIce", ThaumcraftApi.addInfusionCraftingRecipe("ROD_ice", new ItemStack(ConfigItems.itemWandRod, 1, 3), 3, new AspectList().add(Aspect.WATER, WandRod.rods.get("ice").getCraftCost() * 2).add(Aspect.MAGIC, WandRod.rods.get("ice").getCraftCost()).add(Aspect.COLD, WandRod.rods.get("blaze").getCraftCost()), new ItemStack(Blocks.field_150432_aD), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemShard, 1, 2)}));
        ConfigResearch.recipes.put("WandRodQuartz", ThaumcraftApi.addInfusionCraftingRecipe("ROD_quartz", new ItemStack(ConfigItems.itemWandRod, 1, 4), 3, new AspectList().add(Aspect.ORDER, WandRod.rods.get("quartz").getCraftCost() * 2).add(Aspect.MAGIC, WandRod.rods.get("quartz").getCraftCost()).add(Aspect.CRYSTAL, WandRod.rods.get("blaze").getCraftCost()), new ItemStack(Blocks.field_150371_ca), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemShard, 1, 4)}));
        ConfigResearch.recipes.put("WandRodReed", ThaumcraftApi.addInfusionCraftingRecipe("ROD_reed", new ItemStack(ConfigItems.itemWandRod, 1, 5), 3, new AspectList().add(Aspect.AIR, WandRod.rods.get("reed").getCraftCost() * 2).add(Aspect.MAGIC, WandRod.rods.get("reed").getCraftCost()).add(Aspect.MOTION, WandRod.rods.get("blaze").getCraftCost()), new ItemStack(Items.field_151120_aE), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemShard, 1, 0)}));
        ConfigResearch.recipes.put("WandRodBlaze", ThaumcraftApi.addInfusionCraftingRecipe("ROD_blaze", new ItemStack(ConfigItems.itemWandRod, 1, 6), 3, new AspectList().add(Aspect.FIRE, WandRod.rods.get("blaze").getCraftCost() * 2).add(Aspect.MAGIC, WandRod.rods.get("blaze").getCraftCost()).add(Aspect.BEAST, WandRod.rods.get("blaze").getCraftCost()), new ItemStack(Items.field_151072_bj), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemShard, 1, 1)}));
        ConfigResearch.recipes.put("WandRodBone", ThaumcraftApi.addInfusionCraftingRecipe("ROD_bone", new ItemStack(ConfigItems.itemWandRod, 1, 7), 3, new AspectList().add(Aspect.ENTROPY, WandRod.rods.get("bone").getCraftCost() * 2).add(Aspect.MAGIC, WandRod.rods.get("bone").getCraftCost()).add(Aspect.UNDEAD, WandRod.rods.get("blaze").getCraftCost()), new ItemStack(Items.field_151103_aS), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemShard, 1, 5)}));
        ConfigResearch.recipes.put("WandRodSilverwood", ThaumcraftApi.addInfusionCraftingRecipe("ROD_silverwood", new ItemStack(ConfigItems.itemWandRod, 1, 2), 5, new AspectList().add(Aspect.AIR, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.FIRE, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.WATER, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.EARTH, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.ORDER, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.ENTROPY, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.MAGIC, WandRod.rods.get("silverwood").getCraftCost()), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 1), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 4), new ItemStack(ConfigItems.itemShard, 1, 5)}));
        ConfigResearch.recipes.put("WandRodPrimalStaff", ThaumcraftApi.addInfusionCraftingRecipe("ROD_primal_staff", new ItemStack(ConfigItems.itemWandRod, 1, 100), 8, new AspectList().add(Aspect.AIR, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.FIRE, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.WATER, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.EARTH, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.ORDER, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.ENTROPY, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.MAGIC, WandRod.rods.get("primal_staff").getCraftCost() * 2), new ItemStack(ConfigItems.itemWandRod, 1, 2), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigItems.itemWandRod, 1, 1), new ItemStack(ConfigItems.itemWandRod, 1, 3), new ItemStack(ConfigItems.itemWandRod, 1, 4), new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigItems.itemWandRod, 1, 5), new ItemStack(ConfigItems.itemWandRod, 1, 6), new ItemStack(ConfigItems.itemWandRod, 1, 7)}));
        ConfigResearch.recipes.put("FocusHellbat", ThaumcraftApi.addInfusionCraftingRecipe("FOCUSHELLBAT", new ItemStack(ConfigItems.itemFocusHellbat), 3, new AspectList().add(Aspect.FIRE, 25).add(Aspect.AIR, 15).add(Aspect.BEAST, 15).add(Aspect.ENTROPY, 25), new ItemStack(Items.field_151064_bs), new ItemStack[]{new ItemStack(Items.field_151128_bU), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(Items.field_151128_bU), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(Items.field_151128_bU), new ItemStack(ConfigItems.itemShard, 1, 5)}));
        ConfigResearch.recipes.put("FocusPortableHole", ThaumcraftApi.addInfusionCraftingRecipe("FOCUSPORTABLEHOLE", new ItemStack(ConfigItems.itemFocusPortableHole), 3, new AspectList().add(Aspect.TRAVEL, 25).add(Aspect.ELDRITCH, 10).add(Aspect.EXCHANGE, 10).add(Aspect.ENTROPY, 25), new ItemStack(Items.field_151079_bi), new ItemStack[]{new ItemStack(Items.field_151128_bU), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(Items.field_151128_bU), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(Items.field_151128_bU), new ItemStack(ConfigItems.itemShard, 1, 5)}));
        ConfigResearch.recipes.put("FocusWarding", ThaumcraftApi.addInfusionCraftingRecipe("FOCUSWARDING", new ItemStack(ConfigItems.itemFocusWarding), 4, new AspectList().add(Aspect.EARTH, 25).add(Aspect.ARMOR, 25).add(Aspect.ORDER, 25).add(Aspect.MIND, 10), new ItemStack(Items.field_151156_bN), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(Items.field_151128_bU), new ItemStack(ConfigItems.itemShard, 1, 4), new ItemStack(ConfigItems.itemResource, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(Items.field_151128_bU), new ItemStack(ConfigItems.itemShard, 1, 4)}));
        ConfigResearch.recipes.put("WandPed", ThaumcraftApi.addInfusionCraftingRecipe("WANDPED", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 5), 3, new AspectList().add(Aspect.AURA, 10).add(Aspect.MAGIC, 15).add(Aspect.EXCHANGE, 15), new ItemStack(ConfigBlocks.blockStoneDevice, 1, 1), new ItemStack[]{new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151045_i), new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(Items.field_151045_i)}));
        ConfigResearch.recipes.put("WandPedFocus", ThaumcraftApi.addInfusionCraftingRecipe("WANDPEDFOC", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 8), 4, new AspectList().add(Aspect.ORDER, 10).add(Aspect.MAGIC, 15).add(Aspect.EXCHANGE, 10), new ItemStack(Items.field_151132_bS), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemResource, 1, 8), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemResource, 1, 8), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemResource, 1, 8), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemResource, 1, 8)}));
        ConfigResearch.recipes.put("NodeStabilizerAdv", ThaumcraftApi.addInfusionCraftingRecipe("NODESTABILIZERADV", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 10), 10, new AspectList().add(Aspect.AURA, 32).add(Aspect.MAGIC, 16).add(Aspect.ORDER, 16).add(Aspect.ENERGY, 16), new ItemStack(ConfigBlocks.blockStoneDevice, 1, 9), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(Blocks.field_150451_bX), new ItemStack(ConfigItems.itemResource, 1, 0), new ItemStack(Blocks.field_150451_bX), new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(Blocks.field_150451_bX), new ItemStack(ConfigItems.itemResource, 1, 0), new ItemStack(Blocks.field_150451_bX)}));
        ConfigResearch.recipes.put("JarBrain", ThaumcraftApi.addInfusionCraftingRecipe("JARBRAIN", new ItemStack(ConfigBlocks.blockJar, 1, 1), 4, new AspectList().add(Aspect.MIND, 10).add(Aspect.SENSES, 10).add(Aspect.UNDEAD, 20), new ItemStack(ConfigBlocks.blockJar, 1, 0), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 5), new ItemStack(Items.field_151070_bp), new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151070_bp)}));
        ConfigResearch.recipes.put("AdvancedGolem", ThaumcraftApi.addInfusionCraftingRecipe("ADVANCEDGOLEM", new Object[]{"advanced", new NBTTagByte(1)}, 3, new AspectList().add(Aspect.MIND, 8).add(Aspect.SENSES, 8).add(Aspect.LIFE, 8), new ItemStack(ConfigItems.itemGolemPlacer, 1, Short.MAX_VALUE), new ItemStack[]{new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151114_aO), new ItemStack(Items.field_151016_H), new ItemStack(ConfigBlocks.blockJar, 1, 0), new ItemStack(ConfigItems.itemResource, 1, 5)}));
        ConfigResearch.recipes.put("HoverHarness", ThaumcraftApi.addInfusionCraftingRecipe("HOVERHARNESS", new ItemStack(ConfigItems.itemHoverHarness), 6, new AspectList().add(Aspect.FLIGHT, 32).add(Aspect.ENERGY, 32).add(Aspect.MECHANISM, 32).add(Aspect.TRAVEL, 16), new ItemStack((Item)Items.field_151027_R), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), new ItemStack(Items.field_151132_bS), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151042_j)}));
        ConfigResearch.recipes.put("HoverGirdle", ThaumcraftApi.addInfusionCraftingRecipe("HOVERGIRDLE", new ItemStack(ConfigItems.itemGirdleHover), 8, new AspectList().add(Aspect.FLIGHT, 16).add(Aspect.ENERGY, 32).add(Aspect.AIR, 32).add(Aspect.TRAVEL, 16), new ItemStack(ConfigItems.itemBaubleBlanks, 1, 2), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151043_k), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151043_k)}));
        ConfigResearch.recipes.put("VisAmulet", ThaumcraftApi.addInfusionCraftingRecipe("VISAMULET", new ItemStack(ConfigItems.itemAmuletVis, 1, 1), 6, new AspectList().add(Aspect.AURA, 24).add(Aspect.ENERGY, 64).add(Aspect.MAGIC, 64).add(Aspect.VOID, 24), new ItemStack(ConfigItems.itemBaubleBlanks, 1, 0), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigBlocks.blockCrystal, 1, 6), new ItemStack(ConfigBlocks.blockCrystal, 1, 6), new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigBlocks.blockCrystal, 1, 6), new ItemStack(ConfigBlocks.blockCrystal, 1, 6)}));
        ConfigResearch.recipes.put("RunicAmulet", ThaumcraftApi.addInfusionCraftingRecipe("RUNICARMOR", new ItemStack(ConfigItems.itemAmuletRunic, 1, 0), 4, new AspectList().add(Aspect.ARMOR, 20).add(Aspect.MAGIC, 35).add(Aspect.ENERGY, 35), new ItemStack(ConfigItems.itemBaubleBlanks, 1, 0), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigItems.itemResource, 1, 6), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemInkwell)}));
        ConfigResearch.recipes.put("RunicAmuletEmergency", ThaumcraftApi.addInfusionCraftingRecipe("RUNICEMERGENCY", new ItemStack(ConfigItems.itemAmuletRunic, 1, 1), 7, new AspectList().add(Aspect.ARMOR, 20).add(Aspect.MAGIC, 35).add(Aspect.EARTH, 32).add(Aspect.VOID, 32), new ItemStack(ConfigItems.itemAmuletRunic, 1, 0), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack((Item)Items.field_151068_bn, 1, 8233), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 3)}));
        ConfigResearch.recipes.put("RunicRing", ThaumcraftApi.addInfusionCraftingRecipe("RUNICARMOR", new ItemStack(ConfigItems.itemRingRunic, 1, 1), 3, new AspectList().add(Aspect.ARMOR, 10).add(Aspect.MAGIC, 25).add(Aspect.ENERGY, 25), new ItemStack(ConfigItems.itemBaubleBlanks, 1, 1), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigItems.itemResource, 1, 6), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemInkwell)}));
        ConfigResearch.recipes.put("RunicRingCharged", ThaumcraftApi.addInfusionCraftingRecipe("RUNICCHARGED", new ItemStack(ConfigItems.itemRingRunic, 1, 2), 6, new AspectList().add(Aspect.ARMOR, 16).add(Aspect.MAGIC, 16).add(Aspect.ENERGY, 64), new ItemStack(ConfigItems.itemRingRunic, 1, 1), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack((Item)Items.field_151068_bn, 1, 8226), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(ConfigItems.itemShard, 1, 1)}));
        ConfigResearch.recipes.put("RunicRingHealing", ThaumcraftApi.addInfusionCraftingRecipe("RUNICHEALING", new ItemStack(ConfigItems.itemRingRunic, 1, 3), 6, new AspectList().add(Aspect.ARMOR, 16).add(Aspect.MAGIC, 16).add(Aspect.WATER, 32).add(Aspect.HEAL, 32), new ItemStack(ConfigItems.itemRingRunic, 1, 1), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack((Item)Items.field_151068_bn, 1, 8257), new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack(ConfigItems.itemShard, 1, 2)}));
        ConfigResearch.recipes.put("RunicGirdle", ThaumcraftApi.addInfusionCraftingRecipe("RUNICARMOR", new ItemStack(ConfigItems.itemGirdleRunic, 1, 0), 4, new AspectList().add(Aspect.ARMOR, 30).add(Aspect.MAGIC, 50).add(Aspect.ENERGY, 50), new ItemStack(ConfigItems.itemBaubleBlanks, 1, 2), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigItems.itemResource, 1, 6), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemInkwell)}));
        ConfigResearch.recipes.put("RunicGirdleKinetic", ThaumcraftApi.addInfusionCraftingRecipe("RUNICKINETIC", new ItemStack(ConfigItems.itemGirdleRunic, 1, 1), 7, new AspectList().add(Aspect.ARMOR, 33).add(Aspect.MAGIC, 55).add(Aspect.AIR, 64), new ItemStack(ConfigItems.itemGirdleRunic, 1, 0), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack((Item)Items.field_151068_bn, 1, 16428), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 0)}));
        InfusionRunicAugmentRecipe ra = new InfusionRunicAugmentRecipe();
        ThaumcraftApi.getCraftingRecipes().add(ra);
        if (Config.allowMirrors) {
            ConfigResearch.recipes.put("Mirror", ThaumcraftApi.addInfusionCraftingRecipe("MIRROR", new ItemStack(ConfigBlocks.blockMirror, 1, 0), 6, new AspectList().add(Aspect.TRAVEL, 8).add(Aspect.DARKNESS, 8).add(Aspect.EXCHANGE, 8), new ItemStack(ConfigItems.itemResource, 1, 10), new ItemStack[]{new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151079_bi)}));
            ConfigResearch.recipes.put("MirrorHand", ThaumcraftApi.addInfusionCraftingRecipe("MIRRORHAND", new ItemStack(ConfigItems.itemHandMirror), 8, new AspectList().add(Aspect.TOOL, 16).add(Aspect.TRAVEL, 16), new ItemStack(ConfigBlocks.blockMirror, 1, 0), new ItemStack[]{new ItemStack(Items.field_151055_y), new ItemStack(Items.field_151111_aL), new ItemStack((Item)Items.field_151148_bJ)}));
            ConfigResearch.recipes.put("MirrorEssentia", ThaumcraftApi.addInfusionCraftingRecipe("MIRRORESSENTIA", new ItemStack(ConfigBlocks.blockMirror, 1, 6), 7, new AspectList().add(Aspect.TRAVEL, 8).add(Aspect.WATER, 8).add(Aspect.EXCHANGE, 8), new ItemStack(ConfigItems.itemResource, 1, 10), new ItemStack[]{new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151079_bi)}));
        }
        ConfigResearch.recipes.put("ElementalAxe", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALAXE", new ItemStack(ConfigItems.itemAxeElemental), 1, new AspectList().add(Aspect.WATER, 16).add(Aspect.TREE, 8), new ItemStack(ConfigItems.itemAxeThaumium), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack(Items.field_151045_i), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0)}));
        ConfigResearch.recipes.put("ElementalPick", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALPICK", new ItemStack(ConfigItems.itemPickElemental), 1, new AspectList().add(Aspect.FIRE, 8).add(Aspect.MINE, 8).add(Aspect.SENSES, 8), new ItemStack(ConfigItems.itemPickThaumium), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(Items.field_151045_i), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0)}));
        ConfigResearch.recipes.put("ElementalSword", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALSWORD", new ItemStack(ConfigItems.itemSwordElemental), 1, new AspectList().add(Aspect.AIR, 8).add(Aspect.MOTION, 8).add(Aspect.ENERGY, 8), new ItemStack(ConfigItems.itemSwordThaumium), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(Items.field_151045_i), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0)}));
        ConfigResearch.recipes.put("ElementalShovel", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALSHOVEL", new ItemStack(ConfigItems.itemShovelElemental), 1, new AspectList().add(Aspect.EARTH, 16).add(Aspect.CRAFT, 8), new ItemStack(ConfigItems.itemShovelThaumium), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(Items.field_151045_i), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0)}));
        ConfigResearch.recipes.put("ElementalHoe", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALHOE", new ItemStack(ConfigItems.itemHoeElemental), 1, new AspectList().add(Aspect.HARVEST, 8).add(Aspect.PLANT, 8).add(Aspect.EARTH, 8), new ItemStack(ConfigItems.itemHoeThaumium), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 4), new ItemStack(ConfigItems.itemShard, 1, 5), new ItemStack(Items.field_151045_i), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0)}));
        ConfigResearch.recipes.put("BootsTraveller", ThaumcraftApi.addInfusionCraftingRecipe("BOOTSTRAVELLER", new ItemStack(ConfigItems.itemBootsTraveller), 1, new AspectList().add(Aspect.FLIGHT, 25).add(Aspect.TRAVEL, 25), new ItemStack((Item)Items.field_151021_T), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE)}));
        ConfigResearch.recipes.put("CoreAlchemy", ThaumcraftApi.addInfusionCraftingRecipe("COREALCHEMY", new ItemStack(ConfigItems.itemGolemCore, 1, 6), 2, new AspectList().add(Aspect.MAGIC, 15).add(Aspect.WATER, 15).add(Aspect.MOTION, 15), new ItemStack(ConfigItems.itemGolemCore, 1, 5), new ItemStack[]{new ItemStack(ConfigBlocks.blockJar, 1, 0), new ItemStack((Item)Items.field_151068_bn), new ItemStack((Item)Items.field_151068_bn), new ItemStack((Item)Items.field_151068_bn)}));
        ConfigResearch.recipes.put("CoreSorting", ThaumcraftApi.addInfusionCraftingRecipe("CORESORTING", new ItemStack(ConfigItems.itemGolemCore, 1, 10), 3, new AspectList().add(Aspect.VOID, 16).add(Aspect.EXCHANGE, 16).add(Aspect.HUNGER, 16).add(Aspect.GREED, 16), new ItemStack(ConfigItems.itemResource, 1, 5), new ItemStack[]{new ItemStack(ConfigItems.itemGolemCore, 1, 0), new ItemStack(Items.field_151132_bS), new ItemStack(ConfigItems.itemGolemCore, 1, 1), new ItemStack(Items.field_151121_aF)}));
        ConfigResearch.recipes.put("CoreLumber", ThaumcraftApi.addInfusionCraftingRecipe("CORELUMBER", new ItemStack(ConfigItems.itemGolemCore, 1, 7), 2, new AspectList().add(Aspect.TOOL, 16).add(Aspect.TREE, 16).add(Aspect.HARVEST, 16), new ItemStack(ConfigItems.itemGolemCore, 1, 3), new ItemStack[]{new ItemStack(ConfigItems.itemAxeElemental), new ItemStack(Items.field_151036_c), new ItemStack(Items.field_151036_c), new ItemStack(Items.field_151036_c)}));
        ConfigResearch.recipes.put("CoreFishing", ThaumcraftApi.addInfusionCraftingRecipe("COREFISHING", new ItemStack(ConfigItems.itemGolemCore, 1, 11), 3, new AspectList().add(Aspect.WATER, 16).add(Aspect.HARVEST, 16).add(Aspect.BEAST, 16), new ItemStack(ConfigItems.itemGolemCore, 1, 3), new ItemStack[]{new ItemStack((Item)Items.field_151112_aM), new ItemStack(Items.field_151115_aP, 1, 0), new ItemStack(Items.field_151115_aP, 1, 3), new ItemStack(Items.field_151115_aP, 1, 1)}));
        ConfigResearch.recipes.put("CoreUse", ThaumcraftApi.addInfusionCraftingRecipe("COREUSE", new ItemStack(ConfigItems.itemGolemCore, 1, 8), 3, new AspectList().add(Aspect.TOOL, 20).add(Aspect.MECHANISM, 20).add(Aspect.MAN, 20), new ItemStack(ConfigItems.itemGolemCore, 1, 1), new ItemStack[]{new ItemStack(Items.field_151132_bS), new ItemStack(Items.field_151033_d), new ItemStack((Item)Items.field_151097_aZ), new ItemStack(Blocks.field_150442_at)}));
        ConfigResearch.recipes.put("ArcaneBore", ThaumcraftApi.addInfusionCraftingRecipe("ARCANEBORE", new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 5), 4, new AspectList().add(Aspect.ENERGY, 16).add(Aspect.MINE, 32).add(Aspect.MECHANISM, 32).add(Aspect.VOID, 16).add(Aspect.MOTION, 16), new ItemStack((Block)Blocks.field_150331_J), new ItemStack[]{new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151046_w), new ItemStack(Items.field_151047_v), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 3)}));
        ConfigResearch.recipes.put("TravelTrunk", ThaumcraftApi.addInfusionCraftingRecipe("TRAVELTRUNK", new ItemStack(ConfigItems.itemTrunkSpawner), 3, new AspectList().add(Aspect.MOTION, 4).add(Aspect.SOUL, 4).add(Aspect.TRAVEL, 4).add(Aspect.VOID, 16), new ItemStack(ConfigBlocks.blockChestHungry), new ItemStack[]{new ItemStack(Items.field_151042_j), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), new ItemStack(ConfigItems.itemGolemPlacer, 1, 1), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6)}));
        ConfigResearch.recipes.put("LampGrowth", ThaumcraftApi.addInfusionCraftingRecipe("LAMPGROWTH", new ItemStack(ConfigBlocks.blockMetalDevice, 1, 8), 4, new AspectList().add(Aspect.PLANT, 16).add(Aspect.LIGHT, 8).add(Aspect.LIFE, 16), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 7), new ItemStack[]{new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151100_aR, 1, 15), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151100_aR, 1, 15), new ItemStack(ConfigItems.itemShard, 1, 3)}));
        ConfigResearch.recipes.put("LampFertility", ThaumcraftApi.addInfusionCraftingRecipe("LAMPFERTILITY", new ItemStack(ConfigBlocks.blockMetalDevice, 1, 13), 4, new AspectList().add(Aspect.BEAST, 16).add(Aspect.LIFE, 16).add(Aspect.LIGHT, 8), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 7), new ItemStack[]{new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151015_O), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151172_bF), new ItemStack(ConfigItems.itemShard, 1, 1)}));
    }

    private static void initializeNormalRecipes() {
        int a;
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ConfigItems.itemNugget, 9, 0), new Object[]{"#", Character.valueOf('#'), Items.field_151042_j});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ConfigItems.itemNugget, 9, 6), new Object[]{"#", Character.valueOf('#'), new ItemStack(ConfigItems.itemResource, 1, 2)});
        ConfigRecipes.oreDictRecipe(new ItemStack(Items.field_151042_j), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ConfigItems.itemNugget, 1, 0)});
        ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemResource, 1, 2), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ConfigItems.itemNugget, 9, 6)});
        ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemResource, 1, 3), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ConfigItems.itemNugget, 1, 5)});
        ConfigResearch.recipes.put("MundaneAmulet", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemBaubleBlanks, 1, 0), new Object[]{" S ", "S S", " I ", Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('I'), new ItemStack(Items.field_151043_k)}));
        ConfigResearch.recipes.put("MundaneRing", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemBaubleBlanks, 1, 1), new Object[]{" N ", "N N", " N ", Character.valueOf('N'), new ItemStack(Items.field_151074_bl)}));
        ConfigResearch.recipes.put("MundaneBelt", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemBaubleBlanks, 1, 2), new Object[]{" L ", "L L", " I ", Character.valueOf('L'), new ItemStack(Items.field_151116_aA), Character.valueOf('I'), new ItemStack(Items.field_151043_k)}));
        ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemTripleMeatTreat), new Object[]{Items.field_151102_aT, Items.field_151054_z, ConfigItems.itemNuggetBeef, ConfigItems.itemNuggetChicken, ConfigItems.itemNuggetPork});
        ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemTripleMeatTreat), new Object[]{Items.field_151102_aT, Items.field_151054_z, ConfigItems.itemNuggetBeef, ConfigItems.itemNuggetChicken, ConfigItems.itemNuggetFish});
        ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemTripleMeatTreat), new Object[]{Items.field_151102_aT, Items.field_151054_z, ConfigItems.itemNuggetBeef, ConfigItems.itemNuggetFish, ConfigItems.itemNuggetPork});
        ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemTripleMeatTreat), new Object[]{Items.field_151102_aT, Items.field_151054_z, ConfigItems.itemNuggetFish, ConfigItems.itemNuggetChicken, ConfigItems.itemNuggetPork});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ConfigItems.itemResource, 1, 3), new Object[]{"#", Character.valueOf('#'), new ItemStack(ConfigBlocks.blockCustomPlant, 1, 2)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(Items.field_151065_br), new Object[]{"#", Character.valueOf('#'), new ItemStack(ConfigBlocks.blockCustomPlant, 1, 3)});
        ConfigResearch.recipes.put("JarLabel", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemResource, 4, 13), new Object[]{"dyeBlack", Items.field_151123_aH, Items.field_151121_aF, Items.field_151121_aF, Items.field_151121_aF, Items.field_151121_aF}));
        int count = 0;
        for (Aspect aspect : Aspect.aspects.values()) {
            ItemStack essence = new ItemStack(ConfigItems.itemEssence, 1, 1);
            ((IEssentiaContainerItem)essence.func_77973_b()).setAspects(essence, new AspectList().add(aspect, 8));
            ItemStack output = new ItemStack(ConfigItems.itemResource, 1, 13);
            ((IEssentiaContainerItem)output.func_77973_b()).setAspects(output, new AspectList().add(aspect, 0));
            ConfigResearch.recipes.put("JarLabel" + count, ConfigRecipes.shapelessNBTOreRecipe(output, new Object[]{new ItemStack(ConfigItems.itemResource, 1, 13), essence}));
            ++count;
        }
        ItemStack input = new ItemStack(ConfigItems.itemResource, 1, 13);
        ((IEssentiaContainerItem)input.func_77973_b()).setAspects(input, new AspectList().add(Aspect.WATER, 1));
        ConfigResearch.recipes.put("JarLabelNull", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemResource, 1, 13), new Object[]{input}));
        ConfigResearch.recipes.put("WandBasic", ConfigRecipes.oreDictRecipe(basicWand, new Object[]{"  I", " S ", "I  ", Character.valueOf('I'), new ItemStack(ConfigItems.itemWandCap, 1, 0), Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("WandCapIron", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemWandCap, 1, 0), new Object[]{"NNN", "N N", Character.valueOf('N'), "nuggetIron"}));
        ConfigResearch.recipes.put("KnowFrag", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigItems.itemResearchNotes, 1, 42), (Object[])new Object[]{"KKK", "KKK", "KKK", Character.valueOf('K'), new ItemStack(ConfigItems.itemResource, 1, 9)}));
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigItems.itemResource, 9, 9), (Object[])new Object[]{"K", Character.valueOf('K'), new ItemStack(ConfigItems.itemResearchNotes, 1, 24)});
        ConfigResearch.recipes.put("PlankGreatwood", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockWoodenDevice, 4, 6), (Object[])new Object[]{"W", Character.valueOf('W'), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0)}));
        ConfigResearch.recipes.put("PlankSilverwood", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockWoodenDevice, 4, 7), (Object[])new Object[]{"W", Character.valueOf('W'), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 1)}));
        ConfigResearch.recipes.put("BlockFlesh", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockTaint, 1, 2), (Object[])new Object[]{"KKK", "KKK", "KKK", Character.valueOf('K'), Items.field_151078_bh}));
        ConfigResearch.recipes.put("BlockThaumium", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 4), (Object[])new Object[]{"KKK", "KKK", "KKK", Character.valueOf('K'), new ItemStack(ConfigItems.itemResource, 1, 2)}));
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigItems.itemResource, 9, 2), (Object[])new Object[]{"K", Character.valueOf('K'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 4)});
        ConfigResearch.recipes.put("BlockTallow", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 5), (Object[])new Object[]{"KKK", "KKK", "KKK", Character.valueOf('K'), new ItemStack(ConfigItems.itemResource, 1, 4)}));
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigItems.itemResource, 9, 4), (Object[])new Object[]{"K", Character.valueOf('K'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 5)});
        for (a = 0; a < 6; ++a) {
            ConfigResearch.recipes.put("Clusters" + a, ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigBlocks.blockCrystal, 1, a), new Object[]{new ItemStack(ConfigItems.itemShard, 1, a), new ItemStack(ConfigItems.itemShard, 1, a), new ItemStack(ConfigItems.itemShard, 1, a), new ItemStack(ConfigItems.itemShard, 1, a), new ItemStack(ConfigItems.itemShard, 1, a), new ItemStack(ConfigItems.itemShard, 1, a)}));
        }
        ConfigResearch.recipes.put("Clusters6", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigBlocks.blockCrystal, 1, 6), new Object[]{new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 4), new ItemStack(ConfigItems.itemShard, 1, 5)}));
        GameRegistry.addRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCosmeticOpaque, 1, 0), (Object[])new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(ConfigItems.itemResource, 1, 6)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCosmeticOpaque, 4, 1), (Object[])new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(ConfigBlocks.blockCosmeticOpaque, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCosmeticSolid, 4, 1), (Object[])new Object[]{"##", "##", Character.valueOf('#'), Blocks.field_150343_Z});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ConfigItems.itemResource, 4, 6), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(ConfigBlocks.blockCosmeticOpaque, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ConfigItems.itemResource, 4, 6), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(ConfigBlocks.blockCosmeticOpaque, 1, 1)});
        ConfigResearch.recipes.put("Grate", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockMetalDevice, 1, 5), (Object[])new Object[]{"#", "T", Character.valueOf('#'), new ItemStack(Blocks.field_150411_aY), Character.valueOf('T'), new ItemStack(Blocks.field_150415_aT)}));
        ConfigResearch.recipes.put("Phial", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigItems.itemEssence, 8, 0), (Object[])new Object[]{" C ", "G G", " G ", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('C'), Items.field_151119_aD}));
        ConfigResearch.recipes.put("Table", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigBlocks.blockTable, 1, 0), new Object[]{"SSS", "W W", Character.valueOf('S'), "slabWood", Character.valueOf('W'), "plankWood"}));
        ConfigResearch.recipes.put("Scribe1", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemInkwell), new Object[]{new ItemStack(ConfigItems.itemEssence, 1, 0), Items.field_151008_G, "dyeBlack"}));
        ConfigResearch.recipes.put("Scribe2", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemInkwell), new Object[]{Items.field_151069_bo, Items.field_151008_G, "dyeBlack"}));
        ConfigResearch.recipes.put("Scribe3", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemInkwell), new Object[]{new ItemStack(ConfigItems.itemInkwell, 1, Short.MAX_VALUE), "dyeBlack"}));
        ConfigResearch.recipes.put("Thaumometer", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemThaumometer), new Object[]{" 1 ", "IGI", " 1 ", Character.valueOf('I'), Items.field_151043_k, Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('1'), new ItemStack(ConfigItems.itemShard, 1, Short.MAX_VALUE)}));
        ConfigResearch.recipes.put("ThaumiumHelm", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigItems.itemHelmetThaumium, 1), (Object[])new Object[]{"III", "I I", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 2)}));
        ConfigResearch.recipes.put("ThaumiumChest", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigItems.itemChestThaumium, 1), (Object[])new Object[]{"I I", "III", "III", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 2)}));
        ConfigResearch.recipes.put("ThaumiumLegs", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigItems.itemLegsThaumium, 1), (Object[])new Object[]{"III", "I I", "I I", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 2)}));
        ConfigResearch.recipes.put("ThaumiumBoots", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigItems.itemBootsThaumium, 1), (Object[])new Object[]{"I I", "I I", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 2)}));
        ConfigResearch.recipes.put("ThaumiumShovel", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemShovelThaumium, 1), new Object[]{"I", "S", "S", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 2), Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("ThaumiumPick", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemPickThaumium, 1), new Object[]{"III", " S ", " S ", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 2), Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("ThaumiumAxe", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemAxeThaumium, 1), new Object[]{"II", "SI", "S ", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 2), Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("ThaumiumHoe", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemHoeThaumium, 1), new Object[]{"II", "S ", "S ", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 2), Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("ThaumiumSword", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemSwordThaumium, 1), new Object[]{"I", "I", "S", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 2), Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("TallowCandle", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCandle, 3, 0), (Object[])new Object[]{" S ", " T ", " T ", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('T'), new ItemStack(ConfigItems.itemResource, 1, 4)}));
        for (a = 1; a < 16; ++a) {
            ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigBlocks.blockCandle, 1, a), new Object[]{ConfigAspects.dyes[15 - a], new ItemStack(ConfigBlocks.blockCandle, 1, 0)});
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCandle, 1, 0), (Object[])new Object[]{new ItemStack(Items.field_151100_aR, 1, 15), new ItemStack(ConfigBlocks.blockCandle, 1, Short.MAX_VALUE)});
    }

    private static void initializeSmelting() {
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(ConfigBlocks.blockCustomOre, 1, 0), new ItemStack(ConfigItems.itemResource, 1, 3), 1.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(ConfigBlocks.blockCustomOre, 1, 7), new ItemStack(ConfigItems.itemResource, 1, 6), 1.0f);
        GameRegistry.addSmelting((Block)ConfigBlocks.blockMagicalLog, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(ConfigItems.itemNugget, 1, 16), new ItemStack(Items.field_151042_j, 2, 0), 1.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(ConfigItems.itemNugget, 1, 21), new ItemStack(ConfigItems.itemResource, 2, 3), 1.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(ConfigItems.itemNugget, 1, 31), new ItemStack(Items.field_151043_k, 2, 0), 1.0f);
        ThaumcraftApi.addSmeltingBonus("oreGold", new ItemStack(Items.field_151074_bl, 0, 0));
        ThaumcraftApi.addSmeltingBonus("oreIron", new ItemStack(ConfigItems.itemNugget, 0, 0));
        ThaumcraftApi.addSmeltingBonus("oreCinnabar", new ItemStack(ConfigItems.itemNugget, 0, 5));
        ThaumcraftApi.addSmeltingBonus("oreCopper", new ItemStack(ConfigItems.itemNugget, 0, 1));
        ThaumcraftApi.addSmeltingBonus("oreTin", new ItemStack(ConfigItems.itemNugget, 0, 2));
        ThaumcraftApi.addSmeltingBonus("oreSilver", new ItemStack(ConfigItems.itemNugget, 0, 3));
        ThaumcraftApi.addSmeltingBonus("oreLead", new ItemStack(ConfigItems.itemNugget, 0, 4));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ConfigItems.itemNugget, 1, 31), new ItemStack(Items.field_151074_bl, 0, 0));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ConfigItems.itemNugget, 1, 16), new ItemStack(ConfigItems.itemNugget, 0, 0));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ConfigItems.itemNugget, 1, 21), new ItemStack(ConfigItems.itemNugget, 0, 5));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ConfigItems.itemNugget, 1, 17), new ItemStack(ConfigItems.itemNugget, 0, 1));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ConfigItems.itemNugget, 1, 18), new ItemStack(ConfigItems.itemNugget, 0, 2));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ConfigItems.itemNugget, 1, 19), new ItemStack(ConfigItems.itemNugget, 0, 3));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ConfigItems.itemNugget, 1, 20), new ItemStack(ConfigItems.itemNugget, 0, 4));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_151076_bf), new ItemStack(ConfigItems.itemNuggetChicken));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_151082_bd), new ItemStack(ConfigItems.itemNuggetBeef));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_151147_al), new ItemStack(ConfigItems.itemNuggetPork));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE), new ItemStack(ConfigItems.itemNuggetFish));
    }

    static IRecipe oreDictRecipe(ItemStack res, Object[] params) {
        ShapedOreRecipe rec = new ShapedOreRecipe(res, params);
        CraftingManager.func_77594_a().func_77592_b().add(rec);
        return rec;
    }

    static IRecipe shapelessOreDictRecipe(ItemStack res, Object[] params) {
        ShapelessOreRecipe rec = new ShapelessOreRecipe(res, params);
        CraftingManager.func_77594_a().func_77592_b().add(rec);
        return rec;
    }

    static IRecipe shapelessNBTOreRecipe(ItemStack res, Object[] params) {
        ShapelessNBTOreRecipe rec = new ShapelessNBTOreRecipe(res, params);
        CraftingManager.func_77594_a().func_77592_b().add(rec);
        return rec;
    }
}

