/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.IWandFocus;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.Utils;

public class ItemFocusExcavation
extends ItemFocusBasic {
    private static final AspectList cost = new AspectList().add(Aspect.EARTH, 15);
    static HashMap<String, Long> soundDelay = new HashMap();
    static HashMap<String, Object> beam = new HashMap();
    static HashMap<String, Float> breakcount = new HashMap();
    static HashMap<String, Integer> lastX = new HashMap();
    static HashMap<String, Integer> lastY = new HashMap();
    static HashMap<String, Integer> lastZ = new HashMap();

    public ItemFocusExcavation() {
        this.func_77637_a(Thaumcraft.tabTC);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("thaumcraft:focus_excavation");
    }

    @Override
    public String getSortingHelper(ItemStack itemstack) {
        return "BE" + super.getSortingHelper(itemstack);
    }

    @Override
    public int getFocusColor() {
        return 409606;
    }

    @Override
    public AspectList getVisCost() {
        return cost;
    }

    @Override
    public boolean isVisCostPerTick() {
        return true;
    }

    @Override
    public ItemStack onFocusRightClick(ItemStack itemstack, World world, EntityPlayer p, MovingObjectPosition mop) {
        p.func_71008_a(itemstack, Integer.MAX_VALUE);
        return itemstack;
    }

    @Override
    public void onUsingFocusTick(ItemStack stack, EntityPlayer p, int count) {
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        if (!wand.consumeAllVis(stack, p, this.getVisCost(), false, false)) {
            p.func_71034_by();
            return;
        }
        String pp = "R" + p.func_70005_c_();
        if (!p.field_70170_p.field_72995_K) {
            pp = "S" + p.func_70005_c_();
        }
        if (soundDelay.get(pp) == null) {
            soundDelay.put(pp, 0L);
        }
        if (breakcount.get(pp) == null) {
            breakcount.put(pp, Float.valueOf(0.0f));
        }
        if (lastX.get(pp) == null) {
            lastX.put(pp, 0);
        }
        if (lastY.get(pp) == null) {
            lastY.put(pp, 0);
        }
        if (lastZ.get(pp) == null) {
            lastZ.put(pp, 0);
        }
        MovingObjectPosition mop = Utils.getTargetBlock(p.field_70170_p, (Entity)p, false);
        Vec3 v = p.func_70040_Z();
        double tx = p.field_70165_t + v.field_72450_a * 10.0;
        double ty = p.field_70163_u + v.field_72448_b * 10.0;
        double tz = p.field_70161_v + v.field_72449_c * 10.0;
        int impact = 0;
        if (mop != null) {
            tx = mop.field_72307_f.field_72450_a;
            ty = mop.field_72307_f.field_72448_b;
            tz = mop.field_72307_f.field_72449_c;
            impact = 5;
            if (!p.field_70170_p.field_72995_K && soundDelay.get(pp) < System.currentTimeMillis()) {
                p.field_70170_p.func_72908_a(tx, ty, tz, "thaumcraft:rumble", 0.3f, 1.0f);
                soundDelay.put(pp, System.currentTimeMillis() + 1200L);
            }
        } else {
            soundDelay.put(pp, 0L);
        }
        if (p.field_70170_p.field_72995_K) {
            beam.put(pp, Thaumcraft.proxy.beamCont(p.field_70170_p, p, tx, ty, tz, 2, 65382, false, impact > 0 ? 2.0f : 0.0f, beam.get(pp), impact));
        }
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Block bi = p.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            int md = p.field_70170_p.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            float hardness = bi.func_149712_f(p.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) / bi.func_149737_a(p, p.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) / 100.0f;
            if (hardness >= 0.0f) {
                int pot = wand.getFocusPotency(stack);
                float speed = 0.05f + (float)pot * 0.075f;
                if (bi.func_149688_o() == Material.field_151576_e || bi.func_149688_o() == Material.field_151577_b || bi.func_149688_o() == Material.field_151578_c || bi.func_149688_o() == Material.field_151595_p) {
                    speed = 0.25f + (float)pot * 0.125f;
                }
                if (bi == Blocks.field_150343_Z) {
                    speed = 30.0f + (float)(pot * 3);
                }
                if (lastX.get(pp) == mop.field_72311_b && lastY.get(pp) == mop.field_72312_c && lastZ.get(pp) == mop.field_72309_d) {
                    float bc = breakcount.get(pp).floatValue();
                    if (p.field_70170_p.field_72995_K && bc > 0.0f && bi != Blocks.field_150350_a) {
                        int progress = (int)(bc / hardness * 9.0f);
                        Thaumcraft.proxy.excavateFX(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, p, Block.func_149682_b((Block)bi), md, progress);
                    }
                    if (p.field_70170_p.field_72995_K) {
                        if (bc >= hardness) {
                            p.field_70170_p.func_72926_e(2001, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, Block.func_149682_b((Block)bi) + (md << 12));
                            breakcount.put(pp, Float.valueOf(0.0f));
                        } else {
                            breakcount.put(pp, Float.valueOf(bc + speed));
                        }
                    } else if (bc >= hardness && wand.consumeAllVis(stack, p, this.getVisCost(), true, false)) {
                        BlockEvent.BreakEvent event;
                        WorldSettings.GameType gt = WorldSettings.GameType.SURVIVAL;
                        if (p.field_71075_bZ.field_75099_e) {
                            if (p.field_71075_bZ.field_75098_d) {
                                gt = WorldSettings.GameType.CREATIVE;
                            }
                        } else {
                            gt = WorldSettings.GameType.ADVENTURE;
                        }
                        if (!(event = ForgeHooks.onBlockBreakEvent((World)p.field_70170_p, (WorldSettings.GameType)gt, (EntityPlayerMP)((EntityPlayerMP)p), (int)mop.field_72311_b, (int)mop.field_72312_c, (int)mop.field_72309_d)).isCanceled()) {
                            int fortune = wand.getFocusTreasure(stack);
                            bi.func_149697_b(p.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, md, fortune);
                            p.field_70170_p.func_147468_f(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                        }
                        lastX.put(pp, Integer.MAX_VALUE);
                        lastY.put(pp, Integer.MAX_VALUE);
                        lastZ.put(pp, Integer.MAX_VALUE);
                        breakcount.put(pp, Float.valueOf(0.0f));
                    } else {
                        breakcount.put(pp, Float.valueOf(bc + speed));
                    }
                } else {
                    lastX.put(pp, mop.field_72311_b);
                    lastY.put(pp, mop.field_72312_c);
                    lastZ.put(pp, mop.field_72309_d);
                    breakcount.put(pp, Float.valueOf(0.0f));
                }
            }
        } else {
            lastX.put(pp, Integer.MAX_VALUE);
            lastY.put(pp, Integer.MAX_VALUE);
            lastZ.put(pp, Integer.MAX_VALUE);
            breakcount.put(pp, Float.valueOf(0.0f));
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer p, int count) {
        String pp = "R" + p.func_70005_c_();
        if (!p.field_70170_p.field_72995_K) {
            pp = "S" + p.func_70005_c_();
        }
        if (soundDelay.get(pp) == null) {
            soundDelay.put(pp, 0L);
        }
        if (breakcount.get(pp) == null) {
            breakcount.put(pp, Float.valueOf(0.0f));
        }
        if (lastX.get(pp) == null) {
            lastX.put(pp, 0);
        }
        if (lastY.get(pp) == null) {
            lastY.put(pp, 0);
        }
        if (lastZ.get(pp) == null) {
            lastZ.put(pp, 0);
        }
        beam.put(pp, null);
        lastX.put(pp, Integer.MAX_VALUE);
        lastY.put(pp, Integer.MAX_VALUE);
        lastZ.put(pp, Integer.MAX_VALUE);
        breakcount.put(pp, Float.valueOf(0.0f));
    }

    @Override
    public IWandFocus.WandFocusAnimation getAnimation() {
        return IWandFocus.WandFocusAnimation.CHARGE;
    }

    @Override
    public boolean acceptsEnchant(int id) {
        return id == ThaumcraftApi.enchantFrugal || id == ThaumcraftApi.enchantPotency || id == ThaumcraftApi.enchantWandFortune;
    }
}

