/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S25PacketBlockBreakAnim;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.BonemealEvent;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.equipment.ItemElementalAxe;
import thaumcraft.common.lib.network.misc.PacketBiomeChange;

public class Utils {
    public static HashMap<List<Integer>, ItemStack> specialMiningResult = new HashMap();
    public static HashMap<List<Integer>, Float> specialMiningChance = new HashMap();
    public static final String[] colorNames = new String[]{"White", "Orange", "Magenta", "Light Blue", "Yellow", "Lime", "Pink", "Gray", "Light Gray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
    public static final int[] colors = new int[]{0xF0F0F0, 15435844, 12801229, 6719955, 14602026, 4312372, 14188952, 0x434343, 0xA0A0A0, 2651799, 8073150, 2437522, 5320730, 3887386, 11743532, 0x1E1B1B};
    static int lastx = 0;
    static int lasty = 0;
    static int lastz = 0;
    static double lastdistance = 0.0;
    static HashMap<Integer, ArrayList[]> blockEventCache = new HashMap();

    public static boolean isChunkLoaded(World world, int x, int z) {
        int xx = x / 16;
        int zz = z / 16;
        return world.func_72863_F().func_73149_a(xx, zz);
    }

    public static boolean useBonemealAtLoc(World world, EntityPlayer player, int x, int y, int z) {
        IGrowable igrowable;
        Block block = world.func_147439_a(x, y, z);
        BonemealEvent event = new BonemealEvent(player, world, block, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            return true;
        }
        if (block instanceof IGrowable && (igrowable = (IGrowable)block).func_149851_a(world, x, y, z, world.field_72995_K)) {
            if (!world.field_72995_K && igrowable.func_149852_a(world, world.field_73012_v, x, y, z)) {
                igrowable.func_149853_b(world, world.field_73012_v, x, y, z);
            }
            return true;
        }
        return false;
    }

    public static boolean hasColor(byte[] colors) {
        for (byte col : colors) {
            if (col < 0) continue;
            return true;
        }
        return false;
    }

    public static Entity getPointedEntity(World world, EntityPlayer entityplayer, double minrange, double range, float padding) {
        return Utils.getPointedEntity(world, entityplayer, minrange, range, padding, false);
    }

    public static Entity getPointedEntity(World world, EntityPlayer entityplayer, double minrange, double range, float padding, boolean nonCollide) {
        Entity pointedEntity = null;
        double d = range;
        Vec3 vec3d = Vec3.field_82592_a.func_72345_a(entityplayer.field_70165_t, entityplayer.field_70163_u + (double)entityplayer.func_70047_e(), entityplayer.field_70161_v);
        Vec3 vec3d1 = entityplayer.func_70040_Z();
        Vec3 vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d);
        float f1 = padding;
        List list = world.func_72839_b((Entity)entityplayer, entityplayer.field_70121_D.func_72321_a(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d).func_72314_b((double)f1, (double)f1, (double)f1));
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d3;
            Entity entity = (Entity)list.get(i);
            if ((double)entity.func_70032_d((Entity)entityplayer) < minrange || !entity.func_70067_L() && !nonCollide || world.func_147447_a(world.func_82732_R().func_72345_a(entityplayer.field_70165_t, entityplayer.field_70163_u + (double)entityplayer.func_70047_e(), entityplayer.field_70161_v), world.func_82732_R().func_72345_a(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), false, true, false) != null) continue;
            float f2 = Math.max(0.8f, entity.func_70111_Y());
            AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b((double)f2, (double)f2, (double)f2);
            MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(vec3d, vec3d2);
            if (axisalignedbb.func_72318_a(vec3d)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                pointedEntity = entity;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3d.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
            pointedEntity = entity;
            d2 = d3;
        }
        return pointedEntity;
    }

    public static Entity getPointedEntity(World world, EntityPlayer entityplayer, double range, Class<?> clazz) {
        Entity pointedEntity = null;
        double d = range;
        Vec3 vec3d = Vec3.field_82592_a.func_72345_a(entityplayer.field_70165_t, entityplayer.field_70163_u + (double)entityplayer.func_70047_e(), entityplayer.field_70161_v);
        Vec3 vec3d1 = entityplayer.func_70040_Z();
        Vec3 vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d);
        float f1 = 1.1f;
        List list = world.func_72839_b((Entity)entityplayer, entityplayer.field_70121_D.func_72321_a(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d).func_72314_b((double)f1, (double)f1, (double)f1));
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d3;
            Entity entity = (Entity)list.get(i);
            if (!entity.func_70067_L() || world.func_147447_a(world.func_82732_R().func_72345_a(entityplayer.field_70165_t, entityplayer.field_70163_u + (double)entityplayer.func_70047_e(), entityplayer.field_70161_v), world.func_82732_R().func_72345_a(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), false, true, false) != null || clazz.isInstance(entity)) continue;
            float f2 = Math.max(0.8f, entity.func_70111_Y());
            AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b((double)f2, (double)f2, (double)f2);
            MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(vec3d, vec3d2);
            if (axisalignedbb.func_72318_a(vec3d)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                pointedEntity = entity;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3d.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
            pointedEntity = entity;
            d2 = d3;
        }
        return pointedEntity;
    }

    public static boolean isBlockTouchingOnSide(IBlockAccess world, int x, int y, int z, Block id, int md, int side) {
        if (side > 3 && world.func_147439_a(x, y, z + 1) == id && world.func_72805_g(x, y, z + 1) == md || side > 3 && world.func_147439_a(x, y, z - 1) == id && world.func_72805_g(x, y, z - 1) == md || side > 1 && side < 4 && world.func_147439_a(x + 1, y, z) == id && world.func_72805_g(x + 1, y, z) == md || side > 1 && side < 4 && world.func_147439_a(x - 1, y, z) == id && world.func_72805_g(x - 1, y, z) == md || side > 1 && world.func_147439_a(x, y + 1, z) == id && world.func_72805_g(x, y + 1, z) == md || side > 1 && world.func_147439_a(x, y - 1, z) == id && world.func_72805_g(x, y - 1, z) == md) {
            return true;
        }
        if (side > 3 && world.func_147439_a(x, y + 1, z + 1) == id && world.func_72805_g(x, y + 1, z + 1) == md || side > 3 && world.func_147439_a(x, y + 1, z - 1) == id && world.func_72805_g(x, y + 1, z - 1) == md || side > 1 && side < 4 && world.func_147439_a(x + 1, y + 1, z) == id && world.func_72805_g(x + 1, y + 1, z) == md || side > 1 && side < 4 && world.func_147439_a(x - 1, y + 1, z) == id && world.func_72805_g(x - 1, y + 1, z) == md) {
            return true;
        }
        if (side > 3 && world.func_147439_a(x, y - 1, z + 1) == id && world.func_72805_g(x, y - 1, z + 1) == md || side > 3 && world.func_147439_a(x, y - 1, z - 1) == id && world.func_72805_g(x, y - 1, z - 1) == md || side > 1 && side < 4 && world.func_147439_a(x + 1, y - 1, z) == id && world.func_72805_g(x + 1, y - 1, z) == md || side > 1 && side < 4 && world.func_147439_a(x - 1, y - 1, z) == id && world.func_72805_g(x - 1, y - 1, z) == md) {
            return true;
        }
        switch (side) {
            case 0: {
                if (world.func_147439_a(x, y - 1, z) != id || world.func_72805_g(x, y - 1, z) != md) break;
                return true;
            }
            case 1: {
                if (world.func_147439_a(x, y + 1, z) != id || world.func_72805_g(x, y + 1, z) != md) break;
                return true;
            }
        }
        return false;
    }

    public static boolean isBlockTouching(IBlockAccess world, int x, int y, int z, Block id, int md) {
        return world.func_147439_a(x, y, z + 1) == id && world.func_72805_g(x, y, z + 1) == md || world.func_147439_a(x, y, z - 1) == id && world.func_72805_g(x, y, z - 1) == md || world.func_147439_a(x + 1, y, z) == id && world.func_72805_g(x + 1, y, z) == md || world.func_147439_a(x - 1, y, z) == id && world.func_72805_g(x - 1, y, z) == md || world.func_147439_a(x, y + 1, z) == id && world.func_72805_g(x, y + 1, z) == md || world.func_147439_a(x, y - 1, z) == id && world.func_72805_g(x, y - 1, z) == md;
    }

    public static boolean isBlockTouching(IBlockAccess world, int x, int y, int z, Block id) {
        return world.func_147439_a(x, y, z + 1) == id || world.func_147439_a(x, y, z - 1) == id || world.func_147439_a(x + 1, y, z) == id || world.func_147439_a(x - 1, y, z) == id || world.func_147439_a(x, y + 1, z) == id || world.func_147439_a(x, y - 1, z) == id;
    }

    public static boolean isBlockExposed(World world, int x, int y, int z) {
        return !world.func_147439_a(x, y, z + 1).func_149662_c() || !world.func_147439_a(x, y, z - 1).func_149662_c() || !world.func_147439_a(x + 1, y, z).func_149662_c() || !world.func_147439_a(x - 1, y, z).func_149662_c() || !world.func_147439_a(x, y + 1, z).func_149662_c() || !world.func_147439_a(x, y - 1, z).func_149662_c();
    }

    public static boolean isAdjacentToSolidBlock(World world, int x, int y, int z) {
        for (int a = 0; a < 6; ++a) {
            ForgeDirection d = ForgeDirection.getOrientation((int)a);
            if (!world.isSideSolid(x + d.offsetX, y + d.offsetY, z + d.offsetZ, d.getOpposite())) continue;
            return true;
        }
        return false;
    }

    public static int getFirstUncoveredY(World world, int par1, int par2) {
        int var3 = 5;
        while (!world.func_147437_c(par1, var3 + 1, par2)) {
            ++var3;
        }
        return var3;
    }

    public static boolean isBlockAdjacentToAtleast(IBlockAccess world, int x, int y, int z, Block id, int md, int amount) {
        int count = 0;
        for (int xx = -1; xx <= 1; ++xx) {
            for (int yy = -1; yy <= 1; ++yy) {
                for (int zz = -1; zz <= 1; ++zz) {
                    if (xx == 0 && yy == 0 && zz == 0 || world.func_147439_a(x + xx, y + yy, z + zz) != id || world.func_72805_g(x + xx, y + yy, z + zz) != md) continue;
                    ++count;
                }
            }
        }
        return count >= amount;
    }

    public static List<EntityItem> getContentsOfBlock(World world, int x, int y, int z) {
        List list = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0)));
        return list;
    }

    public static boolean isEETransmutionItem(Item item) {
        try {
            String itemClass = "com.pahimar.ee3.item.ITransmutationStone";
            Class<?> ee = Class.forName(itemClass);
            if (ee.isAssignableFrom(item.getClass())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static int getFirstUncoveredBlockHeight(World world, int par1, int par2) {
        int var3;
        for (var3 = 10; !world.func_147437_c(par1, var3 + 1, par2) || var3 > 250; ++var3) {
        }
        return var3;
    }

    public static boolean canEntityBeSeen(Entity entity, TileEntity te) {
        return te.func_145831_w().func_72901_a(Vec3.func_72443_a((double)((double)te.field_145851_c + 0.5), (double)((double)te.field_145848_d + 1.25), (double)((double)te.field_145849_e + 0.5)), Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v), false) == null;
    }

    public static boolean canEntityBeSeen(Entity entity, Entity entity2) {
        return entity.field_70170_p.func_72901_a(Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v), Vec3.func_72443_a((double)entity2.field_70165_t, (double)entity2.field_70163_u, (double)entity2.field_70161_v), false) == null;
    }

    public static MovingObjectPosition getTargetBlock(World world, Entity entity, boolean par3) {
        float var4 = 1.0f;
        float var5 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * var4;
        float var6 = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * var4;
        double var7 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)var4;
        double var9 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)var4 + 1.62 - (double)entity.field_70129_M;
        double var11 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)var4;
        Vec3 var13 = world.func_82732_R().func_72345_a(var7, var9, var11);
        float var14 = MathHelper.func_76134_b((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var15 = MathHelper.func_76126_a((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var16 = -MathHelper.func_76134_b((float)(-var5 * ((float)Math.PI / 180)));
        float var17 = MathHelper.func_76126_a((float)(-var5 * ((float)Math.PI / 180)));
        float var18 = var15 * var16;
        float var20 = var14 * var16;
        double var21 = 10.0;
        Vec3 var23 = var13.func_72441_c((double)var18 * var21, (double)var17 * var21, (double)var20 * var21);
        return world.func_147447_a(var13, var23, par3, !par3, false);
    }

    public static MovingObjectPosition getTargetBlock(World world, double x, double y, double z, float yaw, float pitch, boolean par3, double range) {
        Vec3 var13 = world.func_82732_R().func_72345_a(x, y, z);
        float var14 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float var15 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float var16 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float var17 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float var18 = var15 * var16;
        float var20 = var14 * var16;
        double var21 = range;
        Vec3 var23 = var13.func_72441_c((double)var18 * var21, (double)var17 * var21, (double)var20 * var21);
        return world.func_147447_a(var13, var23, par3, !par3, false);
    }

    public static void addSpecialMiningResult(ItemStack in, ItemStack out, float chance) {
        specialMiningResult.put(Arrays.asList(Item.func_150891_b((Item)in.func_77973_b()), in.func_77960_j()), out);
        specialMiningChance.put(Arrays.asList(Item.func_150891_b((Item)in.func_77973_b()), in.func_77960_j()), Float.valueOf(chance));
    }

    public static ItemStack findSpecialMiningResult(ItemStack is, float chance, Random rand) {
        ItemStack dropped = is.func_77946_l();
        float r = rand.nextFloat();
        List<Integer> ik = Arrays.asList(Item.func_150891_b((Item)is.func_77973_b()), is.func_77960_j());
        if (specialMiningResult.containsKey(ik) && r <= chance * specialMiningChance.get(ik).floatValue()) {
            dropped = specialMiningResult.get(ik).func_77946_l();
            dropped.field_77994_a *= is.field_77994_a;
        }
        return dropped;
    }

    public static float clamp_float(float par0, float par1, float par2) {
        return par0 < par1 ? par1 : (par0 > par2 ? par2 : par0);
    }

    public static void setBiomeAt(World world, int x, int z, BiomeGenBase biome) {
        if (biome == null) {
            return;
        }
        Chunk chunk = world.func_72938_d(x, z);
        byte[] array = chunk.func_76605_m();
        array[(z & 0xF) << 4 | x & 0xF] = (byte)(biome.field_76756_M & 0xFF);
        chunk.func_76616_a(array);
        if (!world.field_72995_K) {
            Thaumcraft.packetPipeline.sendToAllAround(new PacketBiomeChange(x, z, (short)biome.field_76756_M), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)world.func_72976_f(x, z), (double)z, 32.0));
        }
    }

    public static boolean isWoodLog(IBlockAccess world, int x, int y, int z) {
        Block bi = world.func_147439_a(x, y, z);
        int md = world.func_72805_g(x, y, z);
        if (bi == Blocks.field_150350_a) {
            return false;
        }
        if (bi.canSustainLeaves(world, x, y, z)) {
            return true;
        }
        return ItemElementalAxe.oreDictLogs.contains(Arrays.asList(bi, md));
    }

    public static boolean breakFurthestBlock(World world, int x, int y, int z, Block block, EntityPlayer player) {
        lastx = x;
        lasty = y;
        lastz = z;
        lastdistance = 0.0;
        Utils.findBlocks(world, x, y, z, block);
        boolean worked = Utils.harvestBlock(world, player, lastx, lasty, lastz);
        if (worked) {
            for (int xx = -3; xx <= 3; ++xx) {
                for (int yy = -3; yy <= 3; ++yy) {
                    for (int zz = -3; zz <= 3; ++zz) {
                        world.func_147464_a(lastx + xx, lasty + yy, lastz + zz, world.func_147439_a(lastx + xx, lasty + yy, lastz + zz), 150 + world.field_73012_v.nextInt(150));
                    }
                }
            }
        }
        return worked;
    }

    private static void findBlocks(World world, int x, int y, int z, Block block) {
        boolean count = false;
        for (int xx = -2; xx <= 2; ++xx) {
            for (int yy = 2; yy >= -2; --yy) {
                for (int zz = -2; zz <= 2; ++zz) {
                    double zd;
                    double yd;
                    double xd;
                    double d;
                    if (Math.abs(lastx + xx - x) > 24) {
                        return;
                    }
                    if (Math.abs(lasty + yy - y) > 48) {
                        return;
                    }
                    if (Math.abs(lastz + zz - z) > 24) {
                        return;
                    }
                    if (world.func_147439_a(lastx + xx, lasty + yy, lastz + zz) != block || !Utils.isWoodLog((IBlockAccess)world, lastx + xx, lasty + yy, lastz + zz) || !(block.func_149712_f(world, lastx + xx, lasty + yy, lastz + zz) >= 0.0f) || !((d = (xd = (double)(lastx + xx - x)) * xd + (yd = (double)(lasty + yy - y)) * yd + (zd = (double)(lastz + zz - z)) * zd) > lastdistance)) continue;
                    lastdistance = d;
                    lastx += xx;
                    lasty += yy;
                    lastz += zz;
                    Utils.findBlocks(world, x, y, z, block);
                    return;
                }
            }
        }
    }

    public static boolean harvestBlock(World world, EntityPlayer player, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int i1 = world.func_72805_g(x, y, z);
        if (block.func_149712_f(world, x, y, z) < 0.0f) {
            return false;
        }
        world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (i1 << 12));
        boolean flag = false;
        if (player.field_71075_bZ.field_75098_d) {
            flag = Utils.removeBlock(world, x, y, z, player);
        } else {
            boolean flag1 = false;
            if (block != null) {
                flag1 = block.canHarvestBlock(player, i1);
            }
            if ((flag = Utils.removeBlock(world, x, y, z, player)) && flag1) {
                block.func_149636_a(world, player, x, y, z, i1);
            }
        }
        return true;
    }

    private static boolean removeBlock(World world, int par1, int par2, int par3, EntityPlayer player) {
        boolean flag;
        Block block = world.func_147439_a(par1, par2, par3);
        int l = world.func_72805_g(par1, par2, par3);
        if (block != null) {
            block.func_149681_a(world, par1, par2, par3, l, player);
        }
        boolean bl = flag = block != null && block.removedByPlayer(world, player, par1, par2, par3);
        if (block != null && flag) {
            block.func_149664_b(world, par1, par2, par3, l);
        }
        return flag;
    }

    public static void destroyBlockPartially(World world, int par1, int par2, int par3, int par4, int par5) {
        for (EntityPlayerMP entityplayermp : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            double d2;
            double d1;
            double d0;
            if (entityplayermp == null || entityplayermp.field_70170_p != MinecraftServer.func_71276_C().func_130014_f_() || entityplayermp.func_145782_y() == par1 || !((d0 = (double)par2 - entityplayermp.field_70165_t) * d0 + (d1 = (double)par3 - entityplayermp.field_70163_u) * d1 + (d2 = (double)par4 - entityplayermp.field_70161_v) * d2 < 1024.0)) continue;
            entityplayermp.field_71135_a.func_147359_a((Packet)new S25PacketBlockBreakAnim(par1, par2, par3, par4, par5));
        }
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(World par1World, EntityPlayer par2EntityPlayer, boolean par3) {
        float f = 1.0f;
        float f1 = par2EntityPlayer.field_70127_C + (par2EntityPlayer.field_70125_A - par2EntityPlayer.field_70127_C) * f;
        float f2 = par2EntityPlayer.field_70126_B + (par2EntityPlayer.field_70177_z - par2EntityPlayer.field_70126_B) * f;
        double d0 = par2EntityPlayer.field_70169_q + (par2EntityPlayer.field_70165_t - par2EntityPlayer.field_70169_q) * (double)f;
        double d1 = par2EntityPlayer.field_70167_r + (par2EntityPlayer.field_70163_u - par2EntityPlayer.field_70167_r) * (double)f + (double)(par1World.field_72995_K ? par2EntityPlayer.func_70047_e() - par2EntityPlayer.getDefaultEyeHeight() : par2EntityPlayer.func_70047_e());
        double d2 = par2EntityPlayer.field_70166_s + (par2EntityPlayer.field_70161_v - par2EntityPlayer.field_70166_s) * (double)f;
        Vec3 vec3 = par1World.func_82732_R().func_72345_a(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (par2EntityPlayer instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)par2EntityPlayer).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return par1World.func_147447_a(vec3, vec31, par3, !par3, false);
    }

    public static ItemStack createStackedBlock(Block block, int md) {
        ItemStack dropped = null;
        try {
            Method m = ReflectionHelper.findMethod(Block.class, (Object)block, (String[])new String[]{"createStackedBlock", "j", "func_149644_j"}, (Class[])new Class[]{Integer.TYPE});
            dropped = (ItemStack)m.invoke((Object)block, md);
        }
        catch (Exception e) {
            Thaumcraft.log.warn("Could not invoke net.minecraft.block.Block method createStackedBlock");
        }
        return dropped;
    }

    public static void setRecentlyHit(EntityLivingBase ent, int hit) {
        try {
            ObfuscationReflectionHelper.setPrivateValue(EntityLivingBase.class, (Object)ent, (Object)hit, (String[])new String[]{"recentlyHit", "aT", "field_70718_bc"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getRecentlyHit(EntityLivingBase ent) {
        try {
            return (Integer)ReflectionHelper.getPrivateValue(EntityLivingBase.class, (Object)ent, (String[])new String[]{"recentlyHit", "aT", "field_70718_bc"});
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void resetFloatCounter(EntityPlayerMP player) {
        try {
            ObfuscationReflectionHelper.setPrivateValue(NetHandlerPlayServer.class, (Object)player.field_71135_a, (Object)0, (String[])new String[]{"floatingTickCount", "f", "field_147365_f"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ArrayList[] getBlockEventList(WorldServer world) {
        if (!blockEventCache.containsKey(world.field_73011_w.field_76574_g)) {
            try {
                blockEventCache.put(world.field_73011_w.field_76574_g, (ArrayList[])ReflectionHelper.getPrivateValue(WorldServer.class, (Object)world, (String[])new String[]{"field_147490_S", "S", "field_147490_S"}));
            }
            catch (Exception e) {
                return null;
            }
        }
        return blockEventCache.get(world.field_73011_w.field_76574_g);
    }

    public static boolean getBit(int value, int bit) {
        return (value & 1 << bit) != 0;
    }

    public static int setBit(int value, int bit) {
        return value | 1 << bit;
    }

    public static int clearBit(int value, int bit) {
        return value & ~(1 << bit);
    }

    public static int toggleBit(int value, int bit) {
        return value ^ 1 << bit;
    }

    public static byte pack(boolean[] vals) {
        byte result = 0;
        for (boolean bit : vals) {
            result = (byte)(result << 1 | (bit ? 1 : 0) & 1);
        }
        return result;
    }

    public static boolean[] unpack(byte val) {
        boolean[] result = new boolean[8];
        for (int i = 0; i < 8; ++i) {
            result[i] = (byte)(val >> 7 - i & 1) == 1;
        }
        return result;
    }

    public static Object getNBTDataFromId(NBTTagCompound nbt, byte id, String key) {
        switch (id) {
            case 1: {
                return nbt.func_74771_c(key);
            }
            case 2: {
                return nbt.func_74765_d(key);
            }
            case 3: {
                return nbt.func_74762_e(key);
            }
            case 4: {
                return nbt.func_74763_f(key);
            }
            case 5: {
                return Float.valueOf(nbt.func_74760_g(key));
            }
            case 6: {
                return nbt.func_74769_h(key);
            }
            case 7: {
                return nbt.func_74770_j(key);
            }
            case 8: {
                return nbt.func_74779_i(key);
            }
            case 9: {
                return nbt.func_150295_c(key, 10);
            }
            case 10: {
                return nbt.func_74781_a(key);
            }
            case 11: {
                return nbt.func_74759_k(key);
            }
        }
        return null;
    }

    public static ArrayList<Entity> getEntitiesInRange(World world, double x, double y, double z, Entity entity, Class clazz, double range) {
        ArrayList<Entity> out = new ArrayList<Entity>();
        List list = world.func_72872_a(clazz, AxisAlignedBB.func_72332_a().func_72299_a(x, y, z, x, y, z).func_72314_b(range, range, range));
        if (list.size() > 0) {
            for (Object e : list) {
                Entity ent = (Entity)e;
                if (entity != null && entity.func_145782_y() == ent.func_145782_y()) continue;
                out.add(ent);
            }
        }
        return out;
    }
}

